/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process.reportprocess;

import com.fr.base.FRContext;
import com.fr.base.fservice.FServicePrivilegeProvider;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.web.core.process.ProcessUtils;
import com.fr.web.core.process.reportprocess.IssueControl;
import com.fr.web.core.process.reportprocess.ProcessElement;
import com.fr.web.core.process.reportprocess.ProcessLog;
import com.fr.web.core.process.reportprocess.ProcessTask;
import com.fr.web.core.process.reportprocess.ProcessTaskImpl;
import com.fr.web.core.process.reportprocess.ProcessToastChecker;
import com.fr.web.core.process.reportprocess.ReportProcess;
import com.fr.web.core.process.reportprocess.dao.ProcessLogDAO;
import com.fr.web.core.process.reportprocess.dao.ProcessTaskDAO;
import com.fr.web.core.process.reportprocess.dao.ProcessTaskImplDAO;
import com.fr.web.core.process.reportprocess.dao.ReportProcessDAO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessManager {
    public static Map<Long, ProcessTaskImpl> REPORT_PROCESS_TABLE = new HashMap<Long, ProcessTaskImpl>(64);
    public static Map<Long, Timer> ISSUE_TIMER_TABLE = new HashMap<Long, Timer>(64);
    public static boolean cacheTask = true;
    public static final int CACHE_TASK_LIMIT = 1000;
    public static boolean initialized = false;
    public static final int TASK_ID_EXPEND = 1000000;
    public static final String START_TIME = "startTime";
    public static final String ONLY_ONCE = "onlyOnce";
    public static final long END_TIME = 157680000000L;

    public static void init() {
        if (initialized) {
            return;
        }
        ProcessManager.initTask();
        ProcessManager.initTaskImpl();
        ProcessManager.initOnComplete();
        initialized = true;
    }

    private static void initTask() {
        try {
            List<ProcessTask> list = ProcessTaskDAO.getInstance().listByFieldValue("issueOver", false);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ProcessTask processTask = list.get(i2);
                processTask.onResume();
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    private static void initTaskImpl() {
        try {
            List<ProcessTaskImpl> list = ProcessTaskImplDAO.getInstance().listByFieldValue("state", 4, 1);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ProcessTaskImpl processTaskImpl = list.get(i2);
                ProcessManager.addTask(processTaskImpl);
                processTaskImpl.onResume();
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    private static void initOnComplete() {
        try {
            ProcessManager.initToast();
            initialized = true;
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    private static void initToast() {
        ProcessUtils.P().addToastChecker(ProcessToastChecker.getInstance());
    }

    public static ProcessTaskImpl getTask(long l2) {
        ProcessTaskImpl processTaskImpl = REPORT_PROCESS_TABLE.get(l2);
        if (processTaskImpl != null) {
            return processTaskImpl;
        }
        try {
            return ProcessTaskImplDAO.getInstance().findByID(l2);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
            return null;
        }
    }

    public static void addTask(ProcessTaskImpl processTaskImpl) {
        if (cacheTask) {
            REPORT_PROCESS_TABLE.put(processTaskImpl.getId(), processTaskImpl);
        }
        if (REPORT_PROCESS_TABLE.size() > 1000) {
            REPORT_PROCESS_TABLE.clear();
            cacheTask = false;
        }
    }

    public static void removeTask(long l2) {
        REPORT_PROCESS_TABLE.remove(l2);
    }

    public static List<ProcessTaskImpl> getActiveTaskFromDB() {
        try {
            return ProcessTaskImplDAO.getInstance().listByFieldValue("state", 4, 1);
        }
        catch (Exception exception) {
            return new ArrayList<ProcessTaskImpl>();
        }
    }

    public static void issue(String string, ProcessTask processTask) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string2 = jSONObject.getString(START_TIME);
            Boolean bl = jSONObject.getBoolean(ONLY_ONCE);
            if (!(string == null || StringUtils.isEmpty(string2) && bl.booleanValue())) {
                IssueControl issueControl = new IssueControl(jSONObject);
                issueControl.issueTask(processTask);
            } else {
                processTask.issue();
                processTask.makeIssueOver();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void registerIssue(long l2, Timer timer) {
        Timer timer2 = ISSUE_TIMER_TABLE.get(l2);
        if (timer2 != null) {
            timer2.cancel();
        }
        ISSUE_TIMER_TABLE.put(l2, timer);
    }

    public static void clearIssue(long l2) {
        ISSUE_TIMER_TABLE.remove(l2);
    }

    public static JSONArray getAllReportProcess(boolean bl, long l2, String string, String string2, boolean bl2) throws Exception {
        return ProcessManager.getAllProcessOrTask(true, bl, l2, l2, string, string2, bl2);
    }

    private static boolean matchWord(ProcessElement processElement, String string) {
        return string == null || string.length() == 0 || processElement.getName().contains(string) || ProcessUtils.getUserName(processElement.getCreatorId()).contains(string) || ProcessUtils.getUserDepartmentName(processElement.getCreatorId()).contains(string);
    }

    private static boolean matchWord(ProcessTaskImpl processTaskImpl, String string) {
        return string == null || string.length() == 0 || processTaskImpl.getName().contains(string) || ProcessUtils.getUserName(processTaskImpl.getCreatorId()).contains(string) || processTaskImpl.getAllSenderStr(true).contains(string) || ProcessManager.getTaskStateName(processTaskImpl.getState()).contains(string);
    }

    public static JSONArray getAllReportProcess(boolean bl, long l2, long l3, long l4, String string, Date date, Date date2, String string2, boolean bl2) throws Exception {
        return ProcessManager.getAllProcessOrTask(true, bl, l2, l3, l4, string, date, date2, string2, bl2);
    }

    private static void addGroupInfo(List<String> list, List<Object> list2, List<Integer> list3, String string, Object object, Integer n2) {
        list.add(string);
        list2.add(object);
        list3.add(n2);
    }

    public static Map<Long, Boolean> getLockedProcessMap() throws Exception {
        return ProcessManager.getLockedProcessOrTask(true);
    }

    public static Map<Long, Boolean> getLockedTaskMap() throws Exception {
        return ProcessManager.getLockedProcessOrTask(false);
    }

    public static Map<Long, Boolean> getLockedProcessOrTask(boolean bl) {
        HashMap<Long, Boolean> hashMap = new HashMap<Long, Boolean>();
        if (cacheTask) {
            for (Long l2 : REPORT_PROCESS_TABLE.keySet()) {
                if (REPORT_PROCESS_TABLE.get(l2).isClosed()) continue;
                if (bl) {
                    hashMap.put(REPORT_PROCESS_TABLE.get(l2).getProcessId(), Boolean.TRUE);
                    continue;
                }
                hashMap.put(REPORT_PROCESS_TABLE.get(l2).getTaskId(), Boolean.TRUE);
            }
        } else {
            List<ProcessTaskImpl> list = ProcessManager.getActiveTaskFromDB();
            for (ProcessTaskImpl processTaskImpl : list) {
                if (processTaskImpl.isClosed()) continue;
                if (bl) {
                    hashMap.put(processTaskImpl.getProcessId(), Boolean.TRUE);
                    continue;
                }
                hashMap.put(processTaskImpl.getTaskId(), Boolean.TRUE);
            }
        }
        return hashMap;
    }

    public static JSONArray getAllTask(boolean bl, long l2, String string, String string2, boolean bl2) throws Exception {
        return ProcessManager.getAllProcessOrTask(false, bl, l2, l2, string, string2, bl2);
    }

    public static JSONArray getAllTask(boolean bl, long l2, long l3, long l4, String string, Date date, Date date2, String string2, boolean bl2) throws Exception {
        return ProcessManager.getAllProcessOrTask(false, bl, l2, l3, l4, string, date, date2, string2, bl2);
    }

    private static JSONArray getAllProcessOrTask(boolean bl, boolean bl2, long l2, long l3, String string, String string2, boolean bl3) throws Exception {
        Object object;
        List<ProcessTask> list;
        boolean bl4;
        JSONArray jSONArray = new JSONArray();
        Map<Long, Boolean> map = bl ? ProcessManager.getLockedProcessMap() : ProcessManager.getLockedTaskMap();
        String string3 = "createTime";
        boolean bl5 = bl4 = ComparatorUtils.equals(string2, "createTime") && bl3;
        if (bl2) {
            list = bl ? ReportProcessDAO.getInstance().listByFieldsAndSort(null, null, null, string3, bl4) : ProcessTaskDAO.getInstance().listByFieldsAndSort(null, null, null, string3, bl4);
        } else {
            String[] stringArray = new String[]{"creatorId"};
            object = new Object[]{l3};
            int[] nArray = new int[]{0};
            list = bl ? ReportProcessDAO.getInstance().listByFieldsAndSort(stringArray, (Object[])object, nArray, string3, bl3) : ProcessTaskDAO.getInstance().listByFieldsAndSort(stringArray, (Object[])object, nArray, string3, bl3);
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object = list.get(i2);
            if (ProcessManager.matchWord((ProcessElement)object, string)) continue;
            list.remove(i2);
            --i2;
        }
        ProcessManager.sortAndPut(jSONArray, list, map, l2, l3, string2, bl3);
        return jSONArray;
    }

    private static JSONArray getAllProcessOrTask(boolean bl, boolean bl2, long l2, long l3, long l4, String string, Date date, Date date2, String string2, boolean bl3) throws Exception {
        JSONArray jSONArray = new JSONArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        if (l3 >= 0L) {
            ProcessManager.addGroupInfo(arrayList, arrayList2, arrayList3, "creatorId", l3, 0);
        }
        if (date != null) {
            ProcessManager.addGroupInfo(arrayList, arrayList2, arrayList3, "createTime", date, 2);
        }
        if (date2 != null) {
            ProcessManager.addGroupInfo(arrayList, arrayList2, arrayList3, "createTime", date2, 4);
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        Object[] objectArray = arrayList2.toArray(new Object[arrayList2.size()]);
        int[] nArray = ArrayUtils.toPrimitive(arrayList3.toArray(new Integer[arrayList3.size()]));
        String string3 = "createTime";
        boolean bl4 = ComparatorUtils.equals(string2, "createTime") && bl3;
        List<ProcessTask> list = bl ? ReportProcessDAO.getInstance().listByFieldsAndSort(stringArray, objectArray, nArray, string3, bl4) : ProcessTaskDAO.getInstance().listByFieldsAndSort(stringArray, objectArray, nArray, string3, bl4);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ProcessElement processElement = list.get(i2);
            if (l4 >= 0L && !ArrayUtils.contains(ProcessUtils.getUserDepartmentIds(processElement.getCreatorId()), l4)) {
                list.remove(i2);
                --i2;
            }
            if (string == null || processElement.getName().contains(string)) continue;
            list.remove(i2);
            --i2;
        }
        ProcessManager.sortAndPut(jSONArray, list, ProcessManager.getLockedProcessMap(), l2, l3, string2, bl3);
        return jSONArray;
    }

    private static void sortAndPut(JSONArray jSONArray, List list, Map<Long, Boolean> map, final long l2, long l3, String string, final boolean bl) throws Exception {
        if (ComparatorUtils.equals(string, "creatorName")) {
            Collections.sort(list, new Comparator(){

                public int compare(Object object, Object object2) {
                    int n2 = ProcessUtils.getUserName(((ProcessElement)object).getCreatorId()).compareTo(ProcessUtils.getUserName(((ProcessElement)object2).getCreatorId()));
                    return bl ? n2 : n2 * -1;
                }
            });
        } else if (ComparatorUtils.equals(string, "department")) {
            Collections.sort(list, new Comparator(){

                public int compare(Object object, Object object2) {
                    int n2 = ProcessUtils.getUserDepartmentName(((ProcessElement)object).getCreatorId()).compareTo(ProcessUtils.getUserDepartmentName(((ProcessElement)object2).getCreatorId()));
                    return bl ? n2 : n2 * -1;
                }
            });
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                long l22;
                long l3 = ((ProcessElement)object).getCreatorId();
                if (l3 == (l22 = ((ProcessElement)object2).getCreatorId())) {
                    return 0;
                }
                if (l3 == l2) {
                    return -1;
                }
                if (l22 == l2) {
                    return 1;
                }
                return 0;
            }
        });
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ProcessElement processElement = (ProcessElement)list.get(i2);
            JSONObject jSONObject = processElement.createJSONObject();
            jSONObject.put("isSelfCreate", processElement.getCreatorId() == l2);
            jSONObject.put("isLocked", map.get(processElement.getId()) != null);
            jSONArray.put(jSONObject);
        }
    }

    public static JSONArray getAllTaskImpl(int n2, long l2, String string, String string2, boolean bl) throws Exception {
        if (n2 == 2) {
            return ProcessManager.getAllToDoTaskImpl(l2, string, string2, bl);
        }
        boolean bl2 = n2 == 0;
        JSONArray jSONArray = new JSONArray();
        String string3 = "sendTime";
        boolean bl3 = ComparatorUtils.equals(string2, "sendTime") && bl;
        List<ProcessTaskImpl> list = ProcessTaskImplDAO.getInstance().listAndSort(string3, bl3);
        HashSet<Long> hashSet = new HashSet<Long>();
        Iterator<ProcessTaskImpl> iterator = list.iterator();
        while (iterator.hasNext()) {
            ProcessTaskImpl processTaskImpl = iterator.next();
            long l3 = processTaskImpl.getTaskId();
            if (ProcessManager.notMatchTask(processTaskImpl, l2, bl2, string) || ProcessManager.findRepeat(hashSet, l3, processTaskImpl)) {
                iterator.remove();
                continue;
            }
            hashSet.add(l3);
        }
        ProcessManager.sortAndPutTaskImpl(jSONArray, list, l2, string2, bl, false);
        return jSONArray;
    }

    private static boolean findRepeat(HashSet<Long> hashSet, long l2, ProcessTaskImpl processTaskImpl) {
        return hashSet.contains(l2) && processTaskImpl.isNeedAllComplete();
    }

    private static boolean notMatchTask(ProcessTaskImpl processTaskImpl, long l2, boolean bl, String string) throws Exception {
        return l2 != -999L && !processTaskImpl.isRelatedWith(l2) || !ProcessManager.matchWord(processTaskImpl, string) || !bl && !processTaskImpl.isCompletedBy(l2);
    }

    private static JSONArray getAllToDoTaskImpl(long l2, String string, String string2, boolean bl) throws Exception {
        JSONArray jSONArray = new JSONArray();
        String string3 = "sendTime";
        boolean bl2 = ComparatorUtils.equals(string2, "sendTime") && bl;
        List<ProcessTaskImpl> list = ProcessTaskImplDAO.getInstance().listByFieldsAndSort(new String[]{"state"}, new Object[]{4}, new int[]{1}, string3, bl2);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ProcessTaskImpl processTaskImpl = list.get(i2);
            if (ProcessManager.matchWord(processTaskImpl, string) && processTaskImpl.isUnderTakeBy(l2)) continue;
            list.remove(i2);
            --i2;
        }
        ProcessManager.sortAndPutTaskImpl(jSONArray, list, l2, string2, bl, true);
        return jSONArray;
    }

    public static JSONArray getAllTaskImpl(int n2, long l2, long l3, long l4, String string, Date date, Date date2, Date date3, Date date4, int n3, int n4, String string2, boolean bl) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        if (n2 == 2) {
            ProcessManager.addGroupInfo(arrayList, arrayList2, arrayList3, "state", 4, 1);
        }
        if (date != null) {
            ProcessManager.addGroupInfo(arrayList, arrayList2, arrayList3, "sendTime", date, 2);
        }
        if (date2 != null) {
            ProcessManager.addGroupInfo(arrayList, arrayList2, arrayList3, "sendTime", date2, 4);
        }
        if (n3 >= 0) {
            ProcessManager.addGroupInfo(arrayList, arrayList2, arrayList3, "state", n3, 0);
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        Object[] objectArray = arrayList2.toArray(new Object[arrayList2.size()]);
        int[] nArray = ArrayUtils.toPrimitive(arrayList3.toArray(new Integer[arrayList3.size()]));
        List<ProcessTaskImpl> list = ProcessTaskImplDAO.getInstance().listByFieldsAndSort(stringArray, objectArray, nArray, string2, bl);
        if (l4 != -1L) {
            Iterator<ProcessTaskImpl> iterator = list.iterator();
            while (iterator.hasNext()) {
                ProcessTaskImpl processTaskImpl = iterator.next();
                String string3 = processTaskImpl.getAllSender(true).toString();
                if (string3.indexOf(ProcessUtils.getUserNameById(l4)) >= 0) continue;
                iterator.remove();
            }
        }
        return ProcessManager.filterTaskImpl(list, l3, string, date3, date4, n4, l2, n2, string2, bl);
    }

    private static JSONArray filterTaskImpl(List<ProcessTaskImpl> list, long l2, String string, Date date, Date date2, int n2, long l3, int n3, String string2, boolean bl) throws Exception {
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ProcessTask processTask;
            ProcessTaskImpl processTaskImpl = list.get(i2);
            if (!ProcessManager.notMatchTask(processTaskImpl, processTask = ProcessTaskDAO.getInstance().findByID(processTaskImpl.getTaskId()), l2, l3, string, n3, n2, date, date2)) continue;
            list.remove(i2);
            --i2;
        }
        ProcessManager.sortAndPutTaskImpl(jSONArray, list, l3, string2, bl, false);
        return jSONArray;
    }

    private static boolean notMatchTask(ProcessTaskImpl processTaskImpl, ProcessTask processTask, long l2, long l3, String string, int n2, int n3, Date date, Date date2) throws Exception {
        return l2 >= 0L && processTask.getCreatorId() != l2 || string != null && !processTask.getName().contains(string) || !ProcessManager.matchDeadLine(processTaskImpl, date, date2) || n3 >= 0 && processTaskImpl.getCurrentOperator().charAt(n3) != '1' || l3 != -999L && !processTaskImpl.isRelatedWith(l3) || n2 == 1 && !processTaskImpl.isCompletedBy(l3) || n2 == 2 && !processTaskImpl.isUnderTakeBy(l3);
    }

    private static boolean matchDeadLine(ProcessTaskImpl processTaskImpl, Date date, Date date2) {
        return processTaskImpl.getDeadLine() == null || (date == null || processTaskImpl.getDeadLine().after(date)) && (date2 == null || processTaskImpl.getDeadLine().before(date2));
    }

    private static void sortAndPutTaskImpl(JSONArray jSONArray, List<ProcessTaskImpl> list, long l2, String string, final boolean bl, boolean bl2) throws Exception {
        if (ComparatorUtils.equals(string, "creatorName")) {
            Collections.sort(list, new Comparator<ProcessTaskImpl>(){

                @Override
                public int compare(ProcessTaskImpl processTaskImpl, ProcessTaskImpl processTaskImpl2) {
                    int n2 = ProcessUtils.getUserName(processTaskImpl.getCreatorId()).compareTo(ProcessUtils.getUserName(processTaskImpl2.getCreatorId()));
                    return bl ? n2 : n2 * -1;
                }
            });
        } else if (ComparatorUtils.equals(string, "sender")) {
            Collections.sort(list, new Comparator<ProcessTaskImpl>(){

                @Override
                public int compare(ProcessTaskImpl processTaskImpl, ProcessTaskImpl processTaskImpl2) {
                    int n2 = processTaskImpl.getAllSenderStr(true).compareTo(processTaskImpl2.getAllSenderStr(true));
                    return bl ? n2 : n2 * -1;
                }
            });
        } else if (ComparatorUtils.equals(string, "deadLine")) {
            Collections.sort(list, new Comparator<ProcessTaskImpl>(){

                @Override
                public int compare(ProcessTaskImpl processTaskImpl, ProcessTaskImpl processTaskImpl2) {
                    int n2 = processTaskImpl.getDeadLine() == null ? 0 : processTaskImpl.getDeadLine().compareTo(processTaskImpl2.getDeadLine());
                    return bl ? n2 : n2 * -1;
                }
            });
        } else if (ComparatorUtils.equals(string, "stateName")) {
            Collections.sort(list, new Comparator<ProcessTaskImpl>(){

                @Override
                public int compare(ProcessTaskImpl processTaskImpl, ProcessTaskImpl processTaskImpl2) {
                    int n2 = processTaskImpl.getStateName().compareTo(processTaskImpl2.getStateName());
                    return bl ? n2 : n2 * -1;
                }
            });
        } else if (ComparatorUtils.equals(string, "taskOpt")) {
            Collections.sort(list, new Comparator<ProcessTaskImpl>(){

                @Override
                public int compare(ProcessTaskImpl processTaskImpl, ProcessTaskImpl processTaskImpl2) {
                    int n2 = processTaskImpl.getCurrentOperatorName().compareTo(processTaskImpl2.getCurrentOperatorName());
                    return bl ? n2 : n2 * -1;
                }
            });
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ProcessTaskImpl processTaskImpl = list.get(i2);
            JSONObject jSONObject = processTaskImpl.createJSONObject(l2);
            jSONObject.put("isTodo", bl2 || processTaskImpl.isUnderTakeBy(l2));
            jSONArray.put(jSONObject);
        }
    }

    public static List<String> getUserOps(long l2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ProcessUtils.getUserNameById(l2));
        FServicePrivilegeProvider fServicePrivilegeProvider = ProcessUtils.P();
        long[] lArray = fServicePrivilegeProvider.getCompanyRolesByUserId(l2);
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            arrayList.add("1_" + lArray[i2]);
        }
        long[] lArray2 = fServicePrivilegeProvider.getCustomRolesByUserId(l2);
        for (int i3 = 0; i3 < lArray2.length; ++i3) {
            arrayList.add("2_" + lArray2[i3]);
        }
        return arrayList;
    }

    public static Date getDefaultEndTime() {
        Date date = new Date();
        date.setTime(date.getTime() + 157680000000L);
        return date;
    }

    public static void checkAlert(long l2) {
        ProcessManager.startToastCheck(l2);
    }

    public static void checkRemind(long l2) {
        ProcessManager.startToastCheck(l2);
    }

    private static void startToastCheck(long l2) {
        ProcessUtils.P().startToastCheck(l2);
    }

    public static void log(String string) {
        ProcessManager.log(null, string);
    }

    public static void log(String string, String string2) {
        ProcessManager.log(string, null, null, string2);
    }

    public static void log(long l2, ProcessTaskImpl processTaskImpl, String string) {
        ProcessManager.log(l2, processTaskImpl.getProcessId(), processTaskImpl.getTaskId(), string);
    }

    public static void log(long l2, String string, String string2, String string3) {
        ProcessManager.log(ProcessUtils.getUserName(l2), string, string2, string3);
    }

    public static void log(long l2, long l3, String string, String string2) {
        ProcessManager.log(ProcessUtils.getUserName(l2), ProcessManager.getProcessName(l3), string, string2);
    }

    public static void log(long l2, long l3, long l4, String string) {
        ProcessManager.log(ProcessUtils.getUserName(l2), ProcessManager.getProcessName(l3), ProcessManager.getTaskName(l4), string);
    }

    public static void log(String string, String string2, String string3, String string4) {
        ProcessLog processLog = new ProcessLog(string, string2, string3, string4);
        try {
            long l2 = ProcessLogDAO.getInstance().save(processLog);
            if (l2 <= 0L) {
                FRContext.getLogger().info("error on process log");
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    public static void error(String string) {
        ProcessManager.error(null, null, null, string);
    }

    public static void error(long l2, ProcessTaskImpl processTaskImpl, String string) {
        ProcessManager.log(l2, processTaskImpl.getProcessId(), processTaskImpl.getTaskId(), string);
    }

    public static void error(long l2, String string, String string2, String string3) {
        ProcessManager.error(ProcessUtils.getUserName(l2), string, string2, string3);
    }

    public static void error(String string, String string2, String string3, String string4) {
        try {
            ProcessManager.log(string, string2, string3, string4);
            FRContext.getLogger().getRecordManager().recordErrorInfo(string2, (short)11, null, string4, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getTaskStateName(int n2) {
        switch (n2) {
            case 0: {
                return Inter.getLocText("RP_To_Report");
            }
            case 1: {
                return Inter.getLocText("RP_To_Check");
            }
            case 2: {
                return Inter.getLocText("RP_Pass");
            }
            case 3: {
                return Inter.getLocText("RP_Rollback");
            }
            case 5: {
                return Inter.getLocText("RP_Overtime");
            }
            case 4: {
                return Inter.getLocText("Closed");
            }
        }
        return "";
    }

    public static String getTaskAuthorityName(int n2) {
        switch (n2) {
            case 0: {
                return Inter.getLocText("RP_Report");
            }
            case 1: {
                return Inter.getLocText("RP_Review");
            }
            case 2: {
                return Inter.getLocText("RP_Deliver");
            }
            case 3: {
                return Inter.getLocText("Close");
            }
            case 4: {
                return Inter.getLocText("Face_View");
            }
            case 5: {
                return Inter.getLocText("Note");
            }
            case 6: {
                return Inter.getLocText("RP_Process_View");
            }
            case 7: {
                return Inter.getLocText("Save");
            }
            case 8: {
                return Inter.getLocText("RP_Pass");
            }
            case 9: {
                return Inter.getLocText("RP_Rollback");
            }
            case 10: {
                return Inter.getLocText("RP_Report");
            }
        }
        return "";
    }

    public static String getTaskAuthorityName(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        String string2 = "";
        int n2 = Math.min(5, string.length());
        for (int i2 = 0; i2 <= n2; ++i2) {
            if (string.charAt(i2) == '1') {
                string2 = string2 + ProcessManager.getTaskAuthorityName(i2);
            }
            string2 = string2 + " ";
        }
        if (bl) {
            string2 = string2 + Inter.getLocText("Offline");
        }
        return string2;
    }

    public static int getStateByAuthority(String string) {
        if (string == null || string.length() <= 5) {
            return -1;
        }
        if (string.charAt(0) == '1') {
            return 0;
        }
        if (string.charAt(1) == '1') {
            return 1;
        }
        return -1;
    }

    public static String getProcessName(long l2) {
        try {
            ReportProcess reportProcess = ReportProcessDAO.getInstance().findByID(l2);
            return reportProcess.getName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getTaskName(long l2) {
        try {
            ProcessTask processTask = ProcessTaskDAO.getInstance().findByID(l2);
            return processTask.getName();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

