/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process.reportprocess;

import com.fr.base.FRContext;
import com.fr.general.DateUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.web.core.process.reportprocess.ProcessManager;
import com.fr.web.core.process.reportprocess.ProcessTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class IssueControl {
    public static final String START_TIME = "startTime";
    public static final String ONLY_ONCE = "onlyOnce";
    public static final String FREQUENCY = "frequency";
    public static final String EXECUTE_MINUTE = "executeMinute";
    public static final String EXECUTE_HOUR = "executeHour";
    public static final String EXECUTE_DAY = "executeDay";
    public static final String EVERY_DAY = "everyDay";
    public static final String WEEK_DAY = "weekDay";
    public static final String MONTH_DAY = "monthDay";
    public static final String EXECUTE_MONTH = "executeMonth";
    public static final String END_TIME = "endTime";
    private Date startTime = null;
    private boolean onlyOnce = true;
    private int execute_minute = 0;
    private int execute_hour = 0;
    private boolean every_day;
    private int[] week_day;
    private int[] month_day;
    private int[] execute_month;
    private Date endTime = null;
    private JSONObject jo;
    private boolean lazyActed = false;

    public IssueControl() {
    }

    public IssueControl(JSONObject jSONObject) {
        this.jo = jSONObject;
        this.parseJSON(jSONObject);
    }

    public void parseJSON(JSONObject jSONObject) {
        try {
            Date date = DateUtils.string2Date(jSONObject.optString(START_TIME), true);
            if (date != null) {
                this.startTime = date;
            }
            this.onlyOnce = jSONObject.optBoolean(ONLY_ONCE, true);
            date = DateUtils.string2Date(jSONObject.optString(END_TIME), true);
            if (date != null) {
                this.endTime = date;
            }
            if (!this.onlyOnce) {
                JSONObject jSONObject2 = jSONObject.optJSONObject(FREQUENCY);
                if (jSONObject2 == null) {
                    return;
                }
                this.execute_minute = jSONObject2.optInt(EXECUTE_MINUTE, 0);
                this.execute_hour = jSONObject2.optInt(EXECUTE_HOUR, 0);
                this.parseExecuteDay(jSONObject2);
                JSONArray jSONArray = jSONObject2.optJSONArray(EXECUTE_MONTH);
                if (jSONArray != null) {
                    this.execute_month = new int[jSONArray.length()];
                    for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                        this.execute_month[i2] = jSONArray.getInt(i2) - 1;
                    }
                    Arrays.sort(this.execute_month);
                }
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error("error on init IssueControl!");
        }
    }

    private void parseExecuteDay(JSONObject jSONObject) {
        try {
            JSONObject jSONObject2 = jSONObject.optJSONObject(EXECUTE_DAY);
            if (jSONObject2 != null) {
                if (jSONObject2.has(EVERY_DAY)) {
                    this.every_day = true;
                } else if (jSONObject2.has(WEEK_DAY)) {
                    JSONArray jSONArray = jSONObject2.getJSONArray(WEEK_DAY);
                    this.week_day = new int[jSONArray.length()];
                    for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                        this.week_day[i2] = jSONArray.getInt(i2);
                    }
                } else if (jSONObject2.has(MONTH_DAY)) {
                    JSONArray jSONArray = jSONObject2.getJSONArray(MONTH_DAY);
                    this.month_day = new int[jSONArray.length()];
                    for (int i3 = 0; i3 < jSONArray.length(); ++i3) {
                        this.month_day[i3] = jSONArray.getInt(i3);
                    }
                }
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error("error on init IssueControl!");
        }
    }

    public void issueTask(final ProcessTask processTask) {
        long l2;
        if (this.startTime == null) {
            this.startTime = processTask.getCreateTime();
        }
        if (this.endTime == null) {
            this.endTime = ProcessManager.getDefaultEndTime();
        }
        if (this.endTime.before(this.startTime)) {
            return;
        }
        if (this.endTime.before(new Date())) {
            processTask.makeIssueOver();
            return;
        }
        if (!this.lazyActed && (l2 = new Date().getTime() - this.startTime.getTime()) >= 0L && l2 < this.lazyTimeMil()) {
            this.lazyActed = true;
            this.doIssue(processTask);
            return;
        }
        Date date = this.nextDate();
        if (date != null) {
            Timer timer = new Timer();
            ProcessManager.registerIssue(processTask.getId(), timer);
            timer.schedule(new TimerTask(){

                public void run() {
                    IssueControl.this.doIssue(processTask);
                }
            }, date);
        }
    }

    private void doIssue(ProcessTask processTask) {
        try {
            processTask.issue();
            if (this.onlyOnce) {
                processTask.makeIssueOver();
                return;
            }
            this.issueTask(processTask);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("error on issue task!");
        }
    }

    private Date nextDate() {
        Date date;
        int n2;
        int n3;
        Calendar calendar = Calendar.getInstance();
        Date date2 = new Date();
        calendar.setTime(date2);
        int n4 = calendar.get(1);
        int n5 = calendar.get(2);
        this.lazyActed = true;
        if (this.startTime.after(date2)) {
            return this.startTime;
        }
        if (this.execute_month == null) {
            return null;
        }
        for (n3 = 0; n3 < this.execute_month.length; ++n3) {
            n2 = this.execute_month[n3];
            if (n2 < n5 || (date = this.findDateInMonth(n4, n2, date2)) == null) continue;
            return date;
        }
        for (n3 = 0; n3 < this.execute_month.length; ++n3) {
            n2 = this.execute_month[n3];
            if (n2 >= n5) {
                return null;
            }
            date = this.findDateInMonth(n4 + 1, n2, date2);
            if (date == null) continue;
            return date;
        }
        return null;
    }

    private Date findDateInMonth(int n2, int n3, Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 23);
        int[] nArray = this.getDaysInMonth(n2, n3);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            calendar.set(1, n2);
            calendar.set(2, n3);
            calendar.set(5, nArray[i2]);
            calendar.set(11, this.execute_hour);
            calendar.set(12, this.execute_minute);
            if (!calendar.getTime().after(date)) continue;
            return calendar.getTime();
        }
        return null;
    }

    private int[] getDaysInMonth(int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(0L);
        calendar.set(n2, n3, 1);
        int n4 = DateUtils.getMonthMaxDays(n2, n3);
        if (this.every_day) {
            int[] nArray = new int[n4];
            for (int i2 = 1; i2 <= n4; ++i2) {
                nArray[i2 - 1] = i2;
            }
            return nArray;
        }
        if (this.week_day != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i3 = 1; i3 <= n4; ++i3) {
                calendar.set(n2, n3, i3 + 1);
                if (ArrayUtils.indexOf(this.week_day, calendar.get(7) - 1) == -1) continue;
                arrayList.add(i3);
            }
            int[] nArray = new int[arrayList.size()];
            for (int i4 = 0; i4 < arrayList.size(); ++i4) {
                nArray[i4] = (Integer)arrayList.get(i4);
            }
            return nArray;
        }
        if (this.month_day != null) {
            return this.month_day;
        }
        return new int[0];
    }

    private long lazyTimeMil() {
        return 120000L;
    }

    public String toString() {
        if (this.jo != null) {
            return this.jo.toString();
        }
        return "";
    }
}

