/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process;

import com.fr.base.fservice.FServicePrivilegeProvider;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.stable.bridge.StableFactory;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;

public class ProcessUtils {
    private static FServicePrivilegeProvider P = null;

    public static FServicePrivilegeProvider P() {
        if (P == null) {
            P = (FServicePrivilegeProvider)StableFactory.createNewObject("FServicePrivilege");
        }
        return P;
    }

    public static long getCurrentUserId(HttpServletRequest httpServletRequest) {
        return ProcessUtils.P().getCurrentUserID(httpServletRequest);
    }

    public static String getUserEmail(long l2) {
        JSONObject jSONObject = ProcessUtils.P().getUserInfoById(l2);
        if (jSONObject.has("email")) {
            return jSONObject.optString("email");
        }
        return "";
    }

    public static String getUserName(long l2) {
        return ProcessUtils.getUserName(l2, true);
    }

    public static String getUserName(long l2, boolean bl) {
        if (ProcessUtils.isRoot(l2)) {
            return "admin";
        }
        JSONObject jSONObject = ProcessUtils.P().getUserInfoById(l2);
        return bl ? jSONObject.optString("realname") + "(" + jSONObject.optString("username") + ")" : jSONObject.optString("username");
    }

    public static String getUserNameById(String string) {
        try {
            return ProcessUtils.getUserNameById(Long.valueOf(string));
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String getUserNameById(long l2) {
        if (ProcessUtils.isRoot(l2)) {
            return "admin";
        }
        JSONObject jSONObject = ProcessUtils.P().getUserInfoById(l2);
        return jSONObject.optString("username");
    }

    public static String getCompanyRoleName(long l2) {
        JSONObject jSONObject = ProcessUtils.P().getCompanyRoleInfoById(l2);
        return jSONObject.optString("departmentname") + jSONObject.optString("postname");
    }

    public static String getCustomRoleName(long l2) {
        JSONObject jSONObject = ProcessUtils.P().getCustomRoleInfoById(l2);
        return jSONObject.optString("text");
    }

    public static JSONArray getUserDepartmentInfo(long l2) {
        if (ProcessUtils.isRoot(l2)) {
            return new JSONArray();
        }
        long[] lArray = ProcessUtils.P().getCompanyRolesByUserId(l2);
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            jSONArray.put(ProcessUtils.P().getCompanyRoleInfoById(lArray[i2]));
        }
        return jSONArray;
    }

    public static String getUserDepartmentName(long l2) {
        if (ProcessUtils.isRoot(l2)) {
            return "admin";
        }
        long[] lArray = ProcessUtils.P().getCompanyRolesByUserId(l2);
        String string = "";
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            JSONObject jSONObject = ProcessUtils.P().getCompanyRoleInfoById(lArray[i2]);
            string = string + jSONObject.optString("departmentname");
            if (i2 >= lArray.length - 1) continue;
            string = string + ",";
        }
        return string;
    }

    public static long[] getUserDepartmentIds(long l2) {
        if (ProcessUtils.isRoot(l2)) {
            return new long[0];
        }
        long[] lArray = ProcessUtils.P().getCompanyRolesByUserId(l2);
        long[] lArray2 = new long[]{};
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            JSONObject jSONObject = ProcessUtils.P().getCompanyRoleInfoById(lArray[i2]);
            lArray2 = ArrayUtils.add(lArray2, ProcessUtils.getIdFromStr(jSONObject.optString("departmentid")));
        }
        return lArray2;
    }

    public static String[] unique(String[] stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (linkedList.contains(stringArray[i2])) continue;
            linkedList.add(stringArray[i2]);
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static long[] unique(long[] lArray) {
        LinkedList<Long> linkedList = new LinkedList<Long>();
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (linkedList.contains(lArray[i2])) continue;
            linkedList.add(lArray[i2]);
        }
        return ArrayUtils.toPrimitive(linkedList.toArray(new Long[linkedList.size()]));
    }

    public static long getIdFromStr(String string) {
        return ProcessUtils.getIdFromStr(string, -1L);
    }

    public static long getIdFromStr(String string, long l2) {
        try {
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            long l3 = ProcessUtils.P().getUserIdByName(string);
            return l3 == -1L ? l2 : l3;
        }
    }

    public static int getIntFromStr(String string) {
        return ProcessUtils.getIntFromStr(string, -1);
    }

    public static int getIntFromStr(String string, int n2) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public static boolean invalidUser(long l2) {
        return l2 < 0L && l2 != -999L;
    }

    public static boolean isRoot(long l2) {
        return l2 == -999L;
    }
}

