/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.chwriter;

import com.fr.base.FRContext;
import com.fr.base.Style;
import com.fr.cache.list.IntList;
import com.fr.form.ui.Widget;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.cell.AnalyCellElement;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.WidgetAttrElem;
import com.fr.report.core.box.BoxElement;
import com.fr.report.core.box.BoxElementBox;
import com.fr.report.web.button.form.TreeNodeToogleButton;
import com.fr.script.Calculator;
import com.fr.stable.CodeUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.ListMap;
import com.fr.stable.StringUtils;
import com.fr.stable.html.Tag;
import com.fr.stable.html.TextHtml;
import com.fr.stable.web.Repository;
import com.fr.web.RepositoryHelper;
import com.fr.web.core.chwriter.HtmlWriteCellBox;
import com.fr.web.core.chwriter.UneditableCellWriter;
import java.util.ArrayList;
import java.util.List;

public class ViewCellWriter
extends UneditableCellWriter {
    private boolean analysis;
    private ListMap treeNodeMap;

    public ViewCellWriter(Repository repository, int n2, ReportSettingsProvider reportSettingsProvider, boolean bl) {
        super(repository, n2, reportSettingsProvider, false);
        this.analysis = bl;
        this.treeNodeMap = new ListMap();
    }

    protected Widget getWidgetOfCell(CellElement cellElement) {
        return ((WidgetAttrElem)((Object)cellElement)).getWidget();
    }

    public boolean mayHideTailRows() {
        return true;
    }

    public boolean skipValueWrapper(CellElement cellElement) {
        return this.getWidgetOfCell(cellElement) != null && !this.getWidgetOfCell(cellElement).isEditor();
    }

    protected void processWidget(CellElement cellElement, Widget widget, Object object, ColumnRow columnRow, Calculator calculator) {
        if (widget instanceof TreeNodeToogleButton) {
            this.dealWithTreeNodeButton(cellElement, object, calculator);
            return;
        }
        if (widget != null && !widget.isEditor()) {
            try {
                this.resTag.attr("widget", this.widget2Config(widget, object, columnRow, cellElement, 0, null, calculator));
                this.resTag.attr("widgetWidth", this.cellWidth + "");
                this.resTag.attr("widgetHeight", this.cellHeight + "");
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
        }
    }

    public boolean needToDealWithTreeNodeButton(CellElement cellElement) {
        AnalyCellElement analyCellElement = (AnalyCellElement)cellElement;
        Widget widget = analyCellElement.getWidget();
        return this.analysis && widget != null && (widget instanceof TreeNodeToogleButton || widget.isChartRelated());
    }

    protected void dealWithTreeNodeButton(CellElement cellElement, Object object, Calculator calculator) {
        AnalyCellElement analyCellElement = (AnalyCellElement)cellElement;
        Widget widget = analyCellElement.getWidget();
        BoxElementBox boxElementBox = analyCellElement.getBoxElement().getBEB();
        ColumnRow columnRow = ColumnRow.valueOf(boxElementBox.getColumnIndex(), boxElementBox.getRowIndex());
        if (this.analysis && widget instanceof TreeNodeToogleButton) {
            object = this.getDisplayValue(cellElement, object);
            this.resTag.attr("width", this.cellWidth + "");
            this.resTag.attr("height", this.cellHeight + "");
            ArrayList<CEAndTag> arrayList = (ArrayList<CEAndTag>)this.treeNodeMap.get(columnRow);
            if (arrayList == null) {
                arrayList = new ArrayList<CEAndTag>();
                this.treeNodeMap.put(columnRow, arrayList);
            }
            arrayList.add(new CEAndTag(analyCellElement, this.resTag, object));
            Tag tag = new Tag("span");
            tag.cls("x-text x-treenode-unexpand").css("cursor", "pointer").attr("onclick", "javascript:FR.TreeNode.initNode(this);").sub(new TextHtml(CodeUtils.htmlEncode(Style.valueToText(object, cellElement.getStyle().getFormat()))));
            if (this.resTag.getSubHtmlList() != null && this.resTag.getSubHtmlList().size() > 0) {
                ((Tag)this.resTag.getSubHtmlList().get(0)).sub(tag);
            } else {
                this.resTag.sub(tag);
            }
            if (!this.hasChild((TreeNodeToogleButton)analyCellElement.getWidget())) {
                this.resTag.cls("no-child");
            }
            this.dealWithTreeNodeSonList((TreeNodeToogleButton)analyCellElement.getWidget());
        } else if (this.analysis && widget != null && widget.isChartRelated()) {
            String string = widget.getWidgetName();
            if (object == null && StringUtils.isNotBlank(string) && RepositoryHelper.getSessionIDInfor(this.repo).getParameterValue(string) != null) {
                object = RepositoryHelper.getSessionIDInfor(this.repo).getParameterValue(string);
            }
            try {
                this.resTag.attr("width", String.valueOf(this.cellWidth));
                this.resTag.attr("height", String.valueOf(this.cellHeight));
                this.resTag.attr("widget", this.widget2Config(widget, object, columnRow, cellElement, this.reportIndex, null, calculator));
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage(), jSONException);
            }
        }
    }

    protected void anyElse(HtmlWriteCellBox htmlWriteCellBox) {
        if (this.analysis) {
            BoxElement boxElement;
            AnalyCellElement analyCellElement = (AnalyCellElement)htmlWriteCellBox.getCell();
            int n2 = analyCellElement.getAnalysisType();
            if (n2 > 0) {
                this.resTag.attr("at", n2 + "").attr("ast", analyCellElement.getSortType() + "");
            }
            if ((boxElement = analyCellElement.getBoxElement()) != null) {
                BoxElementBox boxElementBox = boxElement.getBEB();
                this.resTag.attr("cef", ColumnRow.valueOf(boxElementBox.getColumnIndex(), boxElementBox.getRowIndex()).toString());
            }
        }
    }

    protected Object getDisplayValue(CellElement cellElement, Object object) {
        return ((AnalyCellElement)cellElement).getShowValue();
    }

    public void dealWithAllTreeNodeRelation(Calculator calculator) {
        for (int i2 = 0; i2 < this.treeNodeMap.size(); ++i2) {
            List list = (List)this.treeNodeMap.getByIndex(i2);
            AnalyCellElement analyCellElement = ((CEAndTag)list.get(0)).ce;
            TreeNodeToogleButton treeNodeToogleButton = (TreeNodeToogleButton)analyCellElement.getWidget();
            IntList intList = treeNodeToogleButton.getRelativeIndexList();
            BoxElementBox boxElementBox = analyCellElement.getBoxElement().getBEB();
            int n2 = -1;
            boolean bl = true;
            if (intList != null && intList.size() > 0) {
                if (intList.get(0) == -1) {
                    bl = true;
                    n2 = this.getLevel(boxElementBox, bl, 0);
                } else {
                    bl = false;
                    n2 = this.getLevel(boxElementBox, bl, 0);
                }
            }
            if (n2 <= 0) continue;
            for (int i3 = 0; i3 < list.size(); ++i3) {
                CEAndTag cEAndTag = (CEAndTag)list.get(i3);
                analyCellElement = cEAndTag.ce;
                AnalyCellElement analyCellElement2 = this.getLevelCell(analyCellElement, n2, bl);
                intList = ((TreeNodeToogleButton)analyCellElement2.getWidget()).getRelativeIndexList();
                IntList intList2 = ((TreeNodeToogleButton)analyCellElement.getWidget()).getRelativeIndexList();
                ((TreeNodeToogleButton)analyCellElement2.getWidget()).setRelativeIndexList(this.removeSonIdx(intList, intList2));
                cEAndTag.parCe = analyCellElement2;
            }
        }
        this.pushTreeAttr(calculator);
        this.treeNodeMap.clear();
    }

    private void pushTreeAttr(Calculator calculator) {
        for (int i2 = 0; i2 < this.treeNodeMap.size(); ++i2) {
            List list = (List)this.treeNodeMap.getByIndex(i2);
            for (int i3 = 0; i3 < list.size(); ++i3) {
                CEAndTag cEAndTag = (CEAndTag)list.get(i3);
                AnalyCellElement analyCellElement = cEAndTag.ce;
                try {
                    cEAndTag.tag.attr("tree", this.treeNode2Config(analyCellElement.getWidget(), cEAndTag.parCe, cEAndTag.value, ColumnRow.valueOf(analyCellElement.getColumn(), analyCellElement.getRow()), analyCellElement, this.reportIndex, null, calculator));
                    continue;
                }
                catch (JSONException jSONException) {
                    FRContext.getLogger().error(jSONException.getMessage(), jSONException);
                }
            }
        }
    }

    private String treeNode2Config(Widget widget, AnalyCellElement analyCellElement, Object object, ColumnRow columnRow, CellElement cellElement, int n2, String string, Calculator calculator) throws JSONException {
        JSONObject jSONObject = widget.createJSONConfig(this.repo, calculator);
        jSONObject.put("value", widget.value2Config(object, this.repo.getCalculator()));
        jSONObject.put("sessionID", RepositoryHelper.getSessionIDInfor(this.repo).getSessionID());
        jSONObject.put("location", ColumnRow.valueOf(columnRow.getColumn(), columnRow.getRow()));
        jSONObject.put("reportIndex", n2);
        jSONObject.put("needInit", false);
        if (analyCellElement != null) {
            jSONObject.put("parNode", ColumnRow.valueOf(analyCellElement.getColumn(), analyCellElement.getRow()));
        } else {
            jSONObject.put("parNode", "null");
        }
        return jSONObject.toString();
    }

    private IntList removeSonIdx(IntList intList, IntList intList2) {
        if (intList2 == null || intList2.size() == 0 || intList == null || intList.size() == 0) {
            return intList;
        }
        int n2 = 1;
        for (int i2 = 1; i2 < intList2.size() && n2 < intList.size(); ++i2) {
            if (intList.get(n2) == -1 || intList2.get(i2) > intList.get(n2)) {
                --i2;
                ++n2;
                continue;
            }
            if (intList2.get(i2) != intList.get(n2)) continue;
            intList.set(n2, -1);
            ++n2;
        }
        IntList intList3 = new IntList();
        intList3.add(intList.get(0));
        for (int i3 = 1; i3 < intList.size(); ++i3) {
            if (intList.get(i3) < 0) continue;
            intList3.add(intList.get(i3));
        }
        return intList3;
    }

    private AnalyCellElement getLevelCell(AnalyCellElement analyCellElement, int n2, boolean bl) {
        for (int i2 = 0; i2 < n2; ++i2) {
            analyCellElement = (AnalyCellElement)(bl ? analyCellElement.getLeftNE() : analyCellElement.getUpNE());
        }
        return analyCellElement;
    }

    private int getLevel(BoxElementBox boxElementBox, boolean bl, int n2) {
        BoxElementBox boxElementBox2 = bl ? boxElementBox.getLeftParBEB() : boxElementBox.getUpParBEB();
        if (boxElementBox2 != null) {
            ++n2;
            if (this.treeNodeMap.get(ColumnRow.valueOf(boxElementBox2.getColumnIndex(), boxElementBox2.getRowIndex())) != null) {
                return n2;
            }
            return this.getLevel(boxElementBox2, bl, n2);
        }
        return -1;
    }

    private static class CEAndTag {
        private AnalyCellElement ce;
        private Tag tag;
        private Object value;
        private AnalyCellElement parCe = null;

        CEAndTag(AnalyCellElement analyCellElement, Tag tag, Object object) {
            this.ce = analyCellElement;
            this.tag = tag;
            this.value = object;
        }
    }
}

