/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.ParameterMapNameSpace;
import com.fr.cache.Attachment;
import com.fr.data.TableDataSource;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.general.LogDuaration;
import com.fr.general.privilege.PrivilegeConstants;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.script.CalculatorMap;
import com.fr.stable.script.AbstractNameSpace;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.NameSpace;
import com.fr.stable.web.SessionProvider;
import com.fr.web.core.A.yA;
import com.fr.web.core.SessionDealWith;
import com.fr.web.utils.WebUtils;
import java.awt.Image;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class SessionIDInfor
implements SessionProvider,
Serializable,
LogDuaration {
    protected long lastTime;
    protected final long startTime = System.currentTimeMillis();
    protected String sessionID;
    protected String remoteAddress;
    protected String bookPath;
    protected Map attributeMap = new HashMap(2);
    protected CalculatorMap parameterMap4Execute;
    private static final long SESSION_TIMEOUT = 1800000L;
    protected List imageList = new ArrayList();
    protected String webTitle = null;
    protected Map resolvedParameterMap4Exe = null;

    public void updateTime() {
        this.lastTime = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() - this.lastTime > 1800000L;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String string) {
        this.sessionID = string;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public Calculator createSessionCalculator(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Calculator calculator = Calculator.createCalculator();
        calculator.pushNameSpace(ParameterMapNameSpace.create(this.getParameterMap4Execute()));
        calculator.setAttribute(TableDataSource.class, this.getTableDataSource());
        return calculator;
    }

    public abstract TableDataSource getTableDataSource();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getParameterMap4Execute() {
        SessionIDInfor sessionIDInfor = this;
        synchronized (sessionIDInfor) {
            Map map = this.getParameterMap4Execute4Consisent();
            if (map == null) {
                return null;
            }
            Set set = map.entrySet();
            Iterator iterator = set.iterator();
            CalculatorMap calculatorMap = CalculatorMap.createEmptyMap();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                calculatorMap.put(entry.getKey(), entry.getValue());
            }
            return calculatorMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getParameterMap4Execute4Consisent() {
        SessionIDInfor sessionIDInfor = this;
        synchronized (sessionIDInfor) {
            if (this.resolvedParameterMap4Exe == null) {
                return WebUtils.dealWithExecuteParamMap(this.parameterMap4Execute);
            }
            return this.resolvedParameterMap4Exe;
        }
    }

    public Object getParameterValue(String string) {
        if (this.parameterMap4Execute == null) {
            return null;
        }
        return this.parameterMap4Execute.get(string);
    }

    public void setAttribute(String string, Object object) {
        this.attributeMap.put(string, object);
    }

    public Object getAttribute(String string) {
        return this.attributeMap.get(string);
    }

    public Object removeAttribute(String string) {
        return this.attributeMap.remove(string);
    }

    public String addImage(Image image) {
        Attachment attachment = yA.P().A(image);
        this.imageList.add(attachment.getID());
        return attachment.getID();
    }

    public void addImageID(String string) {
        this.imageList.add(string);
    }

    public void clearImagesAndChartMap() {
    }

    protected abstract Object resolveVariable(Object var1, CalculatorProvider var2);

    public static NameSpace asNameSpace(String string) {
        return new SessionIDInforNameSpace(string);
    }

    public Map duarationParameters() {
        String string = null;
        String string2 = null;
        String string3 = null;
        string = this.getRemoteAddress();
        if (ComparatorUtils.equals(string, "0:0:0:0:0:0:0:1") || ComparatorUtils.equals(string, "127.0.0.1")) {
            string = "localhost";
        }
        if (this.getParameterValue("fr_username") == null) {
            string2 = PrivilegeConstants.USER_UNLOGIN;
            string3 = PrivilegeConstants.ROLE_UNKNOWN;
        } else {
            string2 = (String)this.getParameterValue("fr_username");
            string3 = this.getUserRoleString();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ip", string);
        hashMap.put("username", string2);
        hashMap.put("userrole", string3);
        return hashMap;
    }

    private String getUserRoleString() {
        FArray fArray;
        Object object = this.getParameterValue("fr_authority");
        Object object2 = this.getParameterValue("fr_userposition");
        if (object == null && object2 == null) {
            return PrivilegeConstants.ROLE_UNDEFINED;
        }
        FArray fArray2 = new FArray();
        if (object instanceof FArray) {
            fArray = (FArray)object;
            fArray2.add(fArray);
        } else if (object != null) {
            fArray2.add((String)object);
        }
        if (object2 instanceof FArray) {
            fArray = (FArray)object2;
            for (int i2 = 0; i2 < fArray.length(); ++i2) {
                JSONObject jSONObject = (JSONObject)fArray.elementAt(i2);
                try {
                    fArray2.add(jSONObject.getString("departments") + "-" + jSONObject.getString("jobTitle"));
                    continue;
                }
                catch (JSONException jSONException) {
                    FRLogger.getLogger().info(jSONException.getMessage());
                }
            }
        } else if (object2 != null) {
            fArray2.add((String)object2);
        }
        if (fArray2.length() > 0) {
            return fArray2.toString();
        }
        return PrivilegeConstants.ROLE_UNDEFINED;
    }

    public abstract File exportTemplateAsImage(HttpServletRequest var1);

    private static final class SessionIDInforNameSpace
    extends AbstractNameSpace {
        SessionIDInfor info;

        SessionIDInforNameSpace(String string) {
            this.info = SessionDealWith.getSessionIDInfor(string);
        }

        public Object getVariable(Object object, CalculatorProvider calculatorProvider) {
            if (this.info == null) {
                return null;
            }
            if (object instanceof String) {
                String string = (String)object;
                if (ComparatorUtils.equals("sessionID", string)) {
                    return this.info.getSessionID();
                }
                Object object2 = this.info.getParameterValue(string);
                if (object2 != null) {
                    return object2;
                }
                if (string.startsWith("$")) {
                    string = string.substring(1).toUpperCase();
                }
                if ((object2 = this.info.getParameterValue(string)) != null) {
                    return object2;
                }
            }
            return this.info.resolveVariable(object, calculatorProvider);
        }
    }
}

