/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.file.ClusterConfigManager;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.html.Tag;
import com.fr.stable.html.TextHtml;
import com.fr.stable.web.SessionProvider;
import com.fr.stable.web.Weblet;
import com.fr.web.NoPrivilegeException;
import com.fr.web.WebletException;
import com.fr.web.core.A.aB;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.factory.WebletFactory;
import com.fr.web.utils.WebUtils;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionDealWith {
    public static Timer SESSION_DEAL_WITH_TIMER = null;
    private static boolean registed = false;
    private static Random sessionIDRandom = null;
    private static int MAXADDRESS_COUNT = 2;
    private static final long __INIT_TIME__ = System.currentTimeMillis();
    private static final Object SESSION_ID_MAP_LOCK;
    private static Map sessionIDMap;
    private static final Object ADDRESS_MANAGER_LOCK;
    private static ConcurrentHashMap addressManager;

    private SessionDealWith() {
    }

    private static void authenticateLicense() {
        StableUtils.retryLicLock();
        byte[] byArray = StableUtils.getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            StableUtils.decode(byArray, byteArrayOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
            if (jSONObject.getLong("DEADLINE") > Calendar.getInstance().getTimeInMillis()) {
                registed = true;
                int n2 = 0;
                if (jSONObject.has("CONCURRENCY")) {
                    n2 = jSONObject.getInt("CONCURRENCY");
                }
                MAXADDRESS_COUNT = n2 <= 0 ? Integer.MAX_VALUE : n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getOrGenerateSessionIDWithCheckRegister(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "sessionID");
        if (string == null) {
            string = SessionDealWith.generateSessionIDWithCheckRegister(httpServletRequest, httpServletResponse);
        }
        return string;
    }

    public static String generateSessionIDWithCheckRegister(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Weblet weblet;
        if (SessionDealWith.generateSessionID_isPromptRegisted(httpServletRequest)) {
            weblet = WebletFactory.createEmbeddedWeblet("/com/fr/web/tpl/lic.frm");
        } else {
            try {
                weblet = WebletFactory.createWebletByRequest(httpServletRequest, httpServletResponse);
            }
            catch (NoPrivilegeException noPrivilegeException) {
                return null;
            }
        }
        return SessionDealWith.generateSessionID(httpServletRequest, httpServletResponse, weblet);
    }

    public static String generateSessionID(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Weblet weblet) throws Exception {
        if (weblet == null) {
            throw new WebletException("Need to specify parameter \"reportlet\" or \"resultlet\" or \"formllet\".");
        }
        String string = WebUtils.getIpAddr(httpServletRequest);
        Map map = WebUtils.parameters4SessionIDInforContainMPCache(httpServletRequest);
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "op");
        if ((string2 == null || weblet.isSessionOccupy()) && SessionDealWith.generateSessionID_dealWithOverFlow(httpServletRequest, httpServletResponse, string)) {
            return null;
        }
        SessionProvider sessionProvider = null;
        if (weblet != null) {
            sessionProvider = weblet.createSessionIDInfor(httpServletRequest, string, map);
        }
        return SessionDealWith.generateSessionID_addSessionIDInfor(sessionProvider, string, weblet);
    }

    private static String generateSessionID_addSessionIDInfor(SessionProvider sessionProvider, String string, Weblet weblet) throws Exception {
        String string2 = SessionDealWith.addSessionIDInfor(sessionProvider);
        if (weblet.isSessionOccupy()) {
            HashSet<String> hashSet = new HashSet<String>();
            Set set = addressManager.putIfAbsent(string, hashSet);
            hashSet = set == null ? hashSet : set;
            hashSet.add(string2);
        }
        return string2;
    }

    private static boolean generateSessionID_dealWithOverFlow(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if (SessionDealWith.isAddressOverFlow(string)) {
            try {
                FRContext.getLogger().error(Inter.getLocText("NS_register_ipFull"));
                WebUtils.getPageWhenOverflow(httpServletResponse, addressManager.keySet());
                return true;
            }
            catch (Exception exception) {
                throw new Exception(Inter.getLocText("EX-IP_Address_Overflow"));
            }
        }
        return false;
    }

    private static boolean isAddressOverFlow(String string) {
        return MAXADDRESS_COUNT < addressManager.size() && (StringUtils.isBlank(string) || !addressManager.containsKey(string));
    }

    public static boolean generateSessionID_isPromptRegisted(HttpServletRequest httpServletRequest) {
        if (SessionDealWith.generateSessionID_checkReg(httpServletRequest)) {
            return false;
        }
        return Math.random() * 10.0 <= (double)((System.currentTimeMillis() - __INIT_TIME__) / 3600000L / 24L + 1L);
    }

    private static boolean generateSessionID_checkReg(HttpServletRequest httpServletRequest) {
        return registed || SessionDealWith.isLocalHost(httpServletRequest);
    }

    public static void writeRegistrationDiv(HttpServletRequest httpServletRequest, PrintWriter printWriter) {
        if (!SessionDealWith.generateSessionID_checkReg(httpServletRequest)) {
            Tag tag = new Tag("div");
            tag.css("left", "2px");
            tag.css("bottom", "36px");
            tag.css("font", "normal bolder 10pt Arial");
            tag.css("position", "absolute");
            tag.sub(new TextHtml("<a href='http://www.finereporthelp.com/help/9/11.html' target='_blank'>" + Inter.getLocText("Registration-Please_Purchase") + "</a>"));
            tag.writeHtml(printWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String addSessionIDInfor(SessionProvider sessionProvider) throws Exception {
        String string = null;
        Object object = SESSION_ID_MAP_LOCK;
        synchronized (object) {
            if (sessionProvider != null) {
                string = SessionDealWith.randomSessionID();
                while (sessionIDMap.containsKey(string)) {
                    string = SessionDealWith.randomSessionID();
                }
                sessionIDMap.put(string, sessionProvider);
                Calculator.putThreadSavedNameSpace(SessionIDInfor.asNameSpace(string));
                sessionProvider.setSessionID(string);
            }
        }
        return string;
    }

    private static boolean isLocalHost(HttpServletRequest httpServletRequest) {
        String string = WebUtils.getIpAddr(httpServletRequest);
        return WebUtils.isLocalHost(string);
    }

    private static String randomSessionID() {
        if (sessionIDRandom == null) {
            sessionIDRandom = new Random();
        }
        String string = String.valueOf(sessionIDRandom.nextInt(100000));
        if (ClusterConfigManager.getInstance().isUseCluster()) {
            string = aB.E(string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeSession(Object object) {
        FRContext.getLogger().info(Inter.getLocText("LOG-Close_Session") + ":" + object);
        SessionIDInfor sessionIDInfor = null;
        Object object2 = SESSION_ID_MAP_LOCK;
        synchronized (object2) {
            sessionIDInfor = (SessionIDInfor)sessionIDMap.remove(object);
        }
        if (sessionIDInfor != null) {
            sessionIDInfor.release();
            object2 = sessionIDInfor.getRemoteAddress();
            Object object3 = ADDRESS_MANAGER_LOCK;
            synchronized (object3) {
                Set set = (Set)addressManager.get(object2);
                if (set != null) {
                    set.remove(object);
                }
                if (set == null || set.size() == 0) {
                    addressManager.remove(object2);
                }
            }
        }
    }

    public static void writeSessionTimeout(HttpServletResponse httpServletResponse) throws Exception {
        WebUtils.dealWithTemplate("/com/fr/web/core/session.html", httpServletResponse);
    }

    public static void responseSessionID(String string, HttpServletResponse httpServletResponse) throws Exception {
        if (string != null && !SessionDealWith.hasSessionID(string)) {
            string = null;
        }
        if (string != null) {
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            printWriter.write(string);
            printWriter.flush();
            printWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSessionID(String string) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        SessionIDInfor sessionIDInfor = null;
        Object object = SESSION_ID_MAP_LOCK;
        synchronized (object) {
            sessionIDInfor = (SessionIDInfor)sessionIDMap.get(string);
        }
        if (sessionIDInfor != null) {
            sessionIDInfor.updateTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionIDInfor getSessionIDInfor(String string) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        Object object = SESSION_ID_MAP_LOCK;
        synchronized (object) {
            return (SessionIDInfor)sessionIDMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasSessionID(String string) {
        Object object = SESSION_ID_MAP_LOCK;
        synchronized (object) {
            return sessionIDMap.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void viewSessions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONArray jSONArray = new JSONArray();
        Object object = SESSION_ID_MAP_LOCK;
        synchronized (object) {
            for (SessionIDInfor sessionIDInfor : sessionIDMap.values()) {
                jSONArray.put(new JSONObject().put("startTime", new Date(sessionIDInfor.getStartTime()).toLocaleString()).put("name", sessionIDInfor.getWebTitle()).put("ip", sessionIDInfor.getRemoteAddress()).put("user", sessionIDInfor.getParameterValue("fr_username")));
            }
        }
        object = WebUtils.createPrintWriter(httpServletResponse);
        ((PrintWriter)object).print(jSONArray);
        ((PrintWriter)object).flush();
        ((PrintWriter)object).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getVisitInforFromSession() throws JSONException {
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        Object object = SESSION_ID_MAP_LOCK;
        synchronized (object) {
            for (SessionIDInfor sessionIDInfor : sessionIDMap.values()) {
                arrayList.add(new JSONObject().put("startTime", new Date(sessionIDInfor.getStartTime()).toLocaleString()).put("name", sessionIDInfor.getWebTitle()).put("ip", sessionIDInfor.getRemoteAddress()).put("user", sessionIDInfor.getParameterValue("fr_username") == null ? Inter.getLocText(new String[]{"Not_Logged_In", "User"}) : sessionIDInfor.getParameterValue("fr_username")));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeTimeoutSessions() {
        Object object = SESSION_ID_MAP_LOCK;
        synchronized (object) {
            if (sessionIDMap == null) {
                return;
            }
            SessionIDInfor[] sessionIDInforArray = sessionIDMap.values().toArray(new SessionIDInfor[0]);
            for (int i2 = 0; i2 < sessionIDInforArray.length; ++i2) {
                final SessionIDInfor sessionIDInfor = sessionIDInforArray[i2];
                if (!sessionIDInfor.isTimeout()) continue;
                new Thread(new Runnable(){

                    public void run() {
                        SessionDealWith.closeSession(sessionIDInfor.getSessionID());
                    }
                }).start();
            }
        }
    }

    public static void setSessionIDRandom(Random random) {
        sessionIDRandom = random;
    }

    static {
        SessionDealWith.authenticateLicense();
        SESSION_DEAL_WITH_TIMER = new Timer();
        SESSION_DEAL_WITH_TIMER.schedule(new TimerTask(){

            public void run() {
                if (ConfigManager.getInstance().isLicUseLock()) {
                    SessionDealWith.authenticateLicense();
                }
                SessionDealWith.removeTimeoutSessions();
            }
        }, ConfigManager.getInstance().getSessionDeadCheckTime(), ConfigManager.getInstance().getSessionDeadCheckTime());
        SESSION_ID_MAP_LOCK = new Object();
        sessionIDMap = new Hashtable();
        ADDRESS_MANAGER_LOCK = new Object();
        addressManager = new ConcurrentHashMap();
    }
}

