/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.xml;

import com.fr.stable.Consts;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLEncodeUtils;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.LinkedList;

public class XMLPrintWriter {
    public static final String XML_ENCODER = "UTF-8";
    protected static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    protected static final String NEW_LINE = "\n";
    private boolean rootPrinted;
    private LinkedList tagChain = new LinkedList();
    private boolean isLastTagOpened = false;
    private PrintWriter writer;
    private boolean debug = false;
    private boolean wellFormatted = true;

    public static XMLPrintWriter create(OutputStream outputStream) {
        return XMLPrintWriter.create(outputStream, true);
    }

    public static XMLPrintWriter create(OutputStream outputStream, boolean bl) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, XML_ENCODER));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        }
        return XMLPrintWriter.create(printWriter, bl);
    }

    public static XMLPrintWriter create(Writer writer) {
        return XMLPrintWriter.create(writer, true);
    }

    public static XMLPrintWriter create(Writer writer, boolean bl) {
        return XMLPrintWriter.create(new PrintWriter(writer), bl);
    }

    public static XMLPrintWriter create(PrintWriter printWriter) {
        return XMLPrintWriter.create(printWriter, true);
    }

    public static XMLPrintWriter create(PrintWriter printWriter, boolean bl) {
        return new XMLPrintWriter(printWriter, bl);
    }

    private XMLPrintWriter(PrintWriter printWriter, boolean bl) {
        this.writer = printWriter;
        this.wellFormatted = bl;
    }

    private void export(String string) {
        this.writer.print(string);
    }

    public XMLPrintWriter startTAG(String string) {
        if (!this.rootPrinted) {
            return this.startRoot(string);
        }
        this.closeLastTagOfChain();
        this.export("<" + string);
        this.tagChain.add(string);
        this.isLastTagOpened = true;
        return this;
    }

    private XMLPrintWriter startRoot(String string) {
        this.export(XML_HEADER);
        if (this.wellFormatted) {
            this.export(NEW_LINE);
        }
        this.rootPrinted = true;
        this.startTAG(string).attr("xmlVersion", 20140501L).attr("releaseVersion", Consts.RELEASE_VERSION);
        return this;
    }

    public XMLPrintWriter textNode(String string) {
        this.closeLastTagOfChain();
        this.export(StableUtils.join(new String[]{"<![CDATA[", XMLEncodeUtils.cdataEncode(string), "]]>"}));
        return this;
    }

    private void closeLastTagOfChain() {
        if (this.isLastTagOpened) {
            this.export(">");
            if (this.wellFormatted) {
                this.export(NEW_LINE);
            }
            this.isLastTagOpened = false;
        }
    }

    public XMLPrintWriter attr(String string, long l2) {
        return this.attr(string, String.valueOf(l2));
    }

    public XMLPrintWriter attr(String string, boolean bl) {
        return this.attr(string, String.valueOf(bl));
    }

    public XMLPrintWriter attr(String string, int n2) {
        return this.attr(string, String.valueOf(n2));
    }

    public XMLPrintWriter attr(String string, float f2) {
        return this.attr(string, String.valueOf(f2));
    }

    public XMLPrintWriter attr(String string, double d2) {
        return this.attr(string, String.valueOf(d2));
    }

    public XMLPrintWriter attr(String string, String string2) {
        if (string2 == null) {
            return this;
        }
        this.export(StableUtils.join(new String[]{" ", string, "=\"", StableXMLUtils.xmlAttrEncode(string2), "\""}));
        return this;
    }

    public XMLPrintWriter end() {
        String string = (String)this.tagChain.removeLast();
        if (this.isLastTagOpened) {
            this.export("/>");
            if (this.wellFormatted) {
                this.export(NEW_LINE);
            }
        } else {
            this.export("</" + string + ">");
            if (this.wellFormatted) {
                this.export(NEW_LINE);
            }
        }
        this.isLastTagOpened = false;
        return this;
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        if (!this.tagChain.isEmpty()) {
            Object[] objectArray = this.tagChain.toArray(new String[this.tagChain.size()]);
            throw new RuntimeException(StableUtils.join(new String[]{StableUtils.join(objectArray, ","), objectArray.length > 1 ? "are" : "is", "not closed."}, " "));
        }
        this.writer.close();
    }
}

