/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.xml;

import com.fr.stable.xml.XMLEncodeUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

public class FRFile
implements XMLable {
    public static final String XML_TAG = "FRF";
    private String type;
    private String filename;
    private byte[] bytes;

    public FRFile(String string, String string2, byte[] byArray) {
        this.type = string;
        this.filename = string2;
        this.bytes = byArray == null ? new byte[]{} : byArray;
    }

    public String getType() {
        return this.type;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getFileName() {
        return this.filename;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.type = xMLableReader.getAttrAsString("t", null);
            this.filename = xMLableReader.getAttrAsString("fn", null);
        } else if (xMLableReader.isChildNode()) {
            this.bytes = XMLEncodeUtils.decodeStringAsBytes(xMLableReader.getElementValue());
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.type != null) {
            xMLPrintWriter.attr("t", this.type);
        }
        if (this.filename != null) {
            xMLPrintWriter.attr("fn", this.filename);
        }
        xMLPrintWriter.textNode(XMLEncodeUtils.encodeBytesAsString(this.bytes));
        xMLPrintWriter.startTAG(XML_TAG);
    }

    public Object clone() throws CloneNotSupportedException {
        FRFile fRFile = (FRFile)super.clone();
        fRFile.bytes = (byte[])this.bytes.clone();
        return fRFile;
    }
}

