/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.unit;

import com.fr.stable.FCloneable;
import com.fr.stable.unit.FU;
import java.io.Serializable;
import java.math.BigDecimal;

public abstract class UNIT
implements FCloneable,
Serializable {
    public static final int PT_PER_INCH = 72;
    public static final FU ZERO = FU.ZERO;
    private final long fu;

    protected UNIT(long l2) {
        this.fu = l2;
    }

    protected UNIT(float f2) {
        BigDecimal bigDecimal = new BigDecimal("" + f2);
        long l2 = bigDecimal.multiply(this.getScaleNumber()).longValue();
        this.fu = l2 * this.getMoreFUScale();
    }

    protected abstract BigDecimal getScaleNumber();

    protected abstract long getMoreFUScale();

    public int toPixI(int n2) {
        return (int)(this.fu * (long)n2 / 36576L / 100L);
    }

    public static int toPixI(long l2, int n2) {
        return (int)(l2 * (long)n2 / 36576L / 100L);
    }

    public float toPixF(int n2) {
        return (float)(this.fu * (long)n2) / 100.0f / 36576.0f;
    }

    public double toPixD(int n2) {
        return (double)(this.fu * (long)n2) / 100.0 / 36576.0;
    }

    public long toFU() {
        return this.fu;
    }

    public boolean less_than_zero() {
        return this.fu < 0L;
    }

    public boolean equal_zero() {
        return this.fu == 0L;
    }

    public boolean more_than_zero() {
        return this.fu > 0L;
    }

    public boolean more_than_or_equal_zero() {
        return this.fu >= 0L;
    }

    public boolean less_than_or_equal_zero() {
        return this.fu <= 0L;
    }

    public boolean not_equal_zero() {
        return this.fu != 0L;
    }

    public float toCMValue4Scale2() {
        return (float)(this.fu / 14400L) / 100.0f;
    }

    public float toINCHValue4Scale3() {
        return (float)(this.fu * 10L / 36576L) / 1000.0f;
    }

    public float toMMValue4Scale2() {
        return (float)(this.fu / 1440L) / 100.0f;
    }

    public float toPTValue4Scale2() {
        return (float)(this.fu / 508L) / 100.0f;
    }

    public boolean equals(Object object) {
        return object instanceof UNIT && ((UNIT)object).fu == this.fu;
    }

    public FU add(UNIT uNIT) {
        if (uNIT == null) {
            return FU.getInstance(this.fu);
        }
        return FU.getInstance(this.fu + uNIT.toFU());
    }

    public FU subtract(UNIT uNIT) {
        if (uNIT != null) {
            return FU.getInstance(this.fu - uNIT.toFU());
        }
        return FU.getInstance(this.fu);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static UNIT max(UNIT uNIT, UNIT uNIT2) {
        if (uNIT == null || uNIT2 == null) {
            if (uNIT == null) {
                return uNIT2;
            }
            return uNIT;
        }
        if (uNIT.toFU() > uNIT2.toFU()) {
            return uNIT;
        }
        return uNIT2;
    }

    public static UNIT min(UNIT uNIT, UNIT uNIT2) {
        if (uNIT == null || uNIT2 == null) {
            if (uNIT == null) {
                return uNIT2;
            }
            return uNIT;
        }
        if (uNIT.toFU() > uNIT2.toFU()) {
            return uNIT2;
        }
        return uNIT;
    }

    public String toString() {
        return this.getClass().getName() + "[fu=" + this.fu + "]";
    }
}

