/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.image4j.codec.ico;

import com.fr.stable.image4j.codec.bmp.BMPDecoder;
import com.fr.stable.image4j.codec.bmp.ColorEntry;
import com.fr.stable.image4j.codec.bmp.InfoHeader;
import com.fr.stable.image4j.codec.ico.ICOImage;
import com.fr.stable.image4j.codec.ico.IconEntry;
import com.fr.stable.image4j.io.LittleEndianInputStream;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ICODecoder {
    private static final int PNG_MAGIC = -1991225785;
    private static final int PNG_MAGIC_LE = 1196314761;
    private static final int PNG_MAGIC2 = 218765834;
    private static final int PNG_MAGIC2_LE = 169478669;

    private ICODecoder() {
    }

    public static List read(File file) throws IOException {
        return ICODecoder.read(new FileInputStream(file));
    }

    public static List readExt(File file) throws IOException {
        return ICODecoder.readExt(new FileInputStream(file));
    }

    public static List read(InputStream inputStream) throws IOException {
        List list = ICODecoder.readExt(inputStream);
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>(list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ICOImage iCOImage = (ICOImage)list.get(i2);
            BufferedImage bufferedImage = iCOImage.getImage();
            arrayList.add(bufferedImage);
        }
        return arrayList;
    }

    public static List readExt(InputStream inputStream) throws IOException {
        int n2;
        LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(inputStream);
        short s2 = littleEndianInputStream.readShortLE();
        short s3 = littleEndianInputStream.readShortLE();
        int n3 = littleEndianInputStream.readShortLE();
        IconEntry[] iconEntryArray = new IconEntry[n3];
        for (n2 = 0; n2 < n3; n2 = (short)(n2 + 1)) {
            iconEntryArray[n2] = new IconEntry(littleEndianInputStream);
        }
        n2 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>(n3);
        try {
            for (n2 = 0; n2 < n3; ++n2) {
                Object object;
                Object object2;
                Object object3;
                ColorEntry[] colorEntryArray;
                Object object4;
                Object object5;
                Object object6;
                int n4 = littleEndianInputStream.readIntLE();
                if (n4 == 40) {
                    int n5;
                    int n6;
                    int n7;
                    InfoHeader infoHeader = BMPDecoder.readInfoHeader(littleEndianInputStream, n4);
                    object6 = new InfoHeader(infoHeader);
                    ((InfoHeader)object6).iHeight = infoHeader.iHeight / 2;
                    object5 = new InfoHeader(infoHeader);
                    object5.iHeight = ((InfoHeader)object6).iHeight;
                    ((InfoHeader)object6).sBitCount = 1;
                    ((InfoHeader)object6).iNumColors = 2;
                    BufferedImage bufferedImage = BMPDecoder.read((InfoHeader)object5, littleEndianInputStream);
                    object4 = new BufferedImage(object5.iWidth, object5.iHeight, 2);
                    colorEntryArray = new ColorEntry[]{new ColorEntry(255, 255, 255, 255), new ColorEntry(0, 0, 0, 0)};
                    if (infoHeader.sBitCount == 32) {
                        int n8 = iconEntryArray[n2].iSizeInBytes;
                        int n9 = infoHeader.iSize;
                        int n10 = object5.iWidth * object5.iHeight * 4;
                        int n11 = n8 - n9 - n10;
                        int n12 = littleEndianInputStream.skipBytes(n11);
                        n7 = n11;
                        while (n12 < n7) {
                            if (n12 < 0) {
                                throw new IOException("Failed to read [skip]");
                            }
                            n7 = n11 - n12;
                            n12 = littleEndianInputStream.skipBytes(n7);
                        }
                        object3 = bufferedImage.getRaster();
                        WritableRaster writableRaster = bufferedImage.getAlphaRaster();
                        WritableRaster writableRaster2 = ((BufferedImage)object4).getRaster();
                        WritableRaster writableRaster3 = ((BufferedImage)object4).getAlphaRaster();
                        for (n6 = object5.iHeight - 1; n6 >= 0; --n6) {
                            for (n5 = 0; n5 < object5.iWidth; ++n5) {
                                int n13 = ((Raster)object3).getSample(n5, n6, 0);
                                int n14 = ((Raster)object3).getSample(n5, n6, 1);
                                int n15 = ((Raster)object3).getSample(n5, n6, 2);
                                int n16 = writableRaster.getSample(n5, n6, 0);
                                writableRaster2.setSample(n5, n6, 0, n13);
                                writableRaster2.setSample(n5, n6, 1, n14);
                                writableRaster2.setSample(n5, n6, 2, n15);
                                writableRaster3.setSample(n5, n6, 0, n16);
                            }
                        }
                    } else {
                        object2 = BMPDecoder.read((InfoHeader)object6, littleEndianInputStream, colorEntryArray);
                        object = bufferedImage.getRaster();
                        WritableRaster writableRaster = ((BufferedImage)object4).getRaster();
                        WritableRaster writableRaster4 = ((BufferedImage)object4).getAlphaRaster();
                        WritableRaster writableRaster5 = ((BufferedImage)object2).getRaster();
                        for (n7 = 0; n7 < object5.iHeight; ++n7) {
                            for (int i2 = 0; i2 < object5.iWidth; ++i2) {
                                n6 = bufferedImage.getRGB(i2, n7);
                                int n17 = n6 >> 16 & 0xFF;
                                int n18 = n6 >> 8 & 0xFF;
                                int n19 = n6 & 0xFF;
                                writableRaster.setSample(i2, n7, 0, n17);
                                writableRaster.setSample(i2, n7, 1, n18);
                                writableRaster.setSample(i2, n7, 2, n19);
                                n5 = ((BufferedImage)object2).getRGB(i2, n7);
                                writableRaster4.setSample(i2, n7, 0, n5);
                            }
                        }
                    }
                    object2 = iconEntryArray[n2];
                    object = new ICOImage((BufferedImage)object4, infoHeader, (IconEntry)object2);
                    ((ICOImage)object).setPngCompressed(false);
                    ((ICOImage)object).setIconIndex(n2);
                    arrayList.add(object);
                    continue;
                }
                if (n4 == 1196314761) {
                    int n20 = littleEndianInputStream.readIntLE();
                    if (n20 != 169478669) {
                        throw new IOException("Unrecognized icon format for image #" + n2);
                    }
                    object6 = iconEntryArray[n2];
                    object5 = new byte[((IconEntry)object6).iSizeInBytes - 8];
                    int n21 = littleEndianInputStream.read((byte[])object5);
                    if (n21 != ((byte[])object5).length) {
                        throw new IOException("Unable to read image #" + n2 + " - incomplete PNG compressed data");
                    }
                    object4 = new ByteArrayOutputStream();
                    colorEntryArray = new DataOutputStream((OutputStream)object4);
                    colorEntryArray.writeInt(-1991225785);
                    colorEntryArray.writeInt(218765834);
                    colorEntryArray.write((byte[])object5);
                    object2 = ((ByteArrayOutputStream)object4).toByteArray();
                    object = new ByteArrayInputStream((byte[])object2);
                    ImageInputStream imageInputStream = ImageIO.createImageInputStream(object);
                    ImageReader imageReader = ICODecoder.getPNGImageReader();
                    imageReader.setInput(imageInputStream);
                    BufferedImage bufferedImage = imageReader.read(0);
                    IconEntry iconEntry = iconEntryArray[n2];
                    object3 = new ICOImage(bufferedImage, null, iconEntry);
                    ((ICOImage)object3).setPngCompressed(true);
                    ((ICOImage)object3).setIconIndex(n2);
                    arrayList.add(object3);
                    continue;
                }
                throw new IOException("Unrecognized icon format for image #" + n2);
            }
        }
        catch (IOException iOException) {
            throw new IOException("Failed to read image # " + n2);
        }
        return arrayList;
    }

    private static ImageReader getPNGImageReader() {
        ImageReader imageReader = null;
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("png");
        if (iterator.hasNext()) {
            imageReader = iterator.next();
        }
        return imageReader;
    }
}

