/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import com.fr.stable.ListSet;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ListMap
implements Map,
Cloneable,
Serializable {
    private static final int TYPE_KEY_SET = 0;
    private static final int TYPE_ENTRY_SET = 1;
    private static final int TYPE_VALUES = 2;
    private HashMap m_map = null;
    private ListSet m_list = null;
    private transient Set m_keySet = null;
    private transient Set m_entrySet = null;
    private transient Collection m_values = null;

    public ListMap() {
        this.m_map = new HashMap();
        this.m_list = new ListSet();
    }

    public ListMap(int n2) {
        this.m_map = new HashMap(n2);
        this.m_list = new ListSet(n2);
    }

    public ListMap(int n2, float f2) {
        this.m_map = new HashMap(n2, f2);
        this.m_list = new ListSet(n2);
    }

    public ListMap(Map map) {
        if (map == null) {
            this.m_map = new HashMap();
            this.m_list = new ListSet();
        } else {
            this.m_map = new HashMap(map);
            this.m_list = new ListSet(map.keySet());
        }
    }

    public Object put(Object object, Object object2) {
        return this.put(-1, object, object2);
    }

    public Object remove(Object object) {
        this.m_list.remove(object);
        return this.m_map.remove(object);
    }

    public Set keySet() {
        if (this.m_keySet == null) {
            this.m_keySet = new KeySet();
        }
        return this.m_keySet;
    }

    public void clear() {
        this.m_list.clear();
        this.m_map.clear();
    }

    public Collection values() {
        if (this.m_values == null) {
            this.m_values = new Values();
        }
        return this.m_values;
    }

    public int hashCode() {
        return this.m_map.hashCode();
    }

    public boolean containsKey(Object object) {
        return this.m_map.containsKey(object);
    }

    public int size() {
        return this.m_map.size();
    }

    public Set entrySet() {
        if (this.m_entrySet == null) {
            this.m_entrySet = new EntrySet();
        }
        return this.m_entrySet;
    }

    public boolean containsValue(Object object) {
        return this.m_map.containsValue(object);
    }

    public void putAll(Map map) {
        if (map != null) {
            this.m_map.putAll(map);
            this.m_list.addAll((Collection)map.keySet());
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof ListMap) {
            ListMap listMap = (ListMap)object;
            bl = this.m_map.equals(listMap.m_map);
        }
        return bl;
    }

    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    public Object get(Object object) {
        return this.m_map.get(object);
    }

    public Object put(int n2, Object object, Object object2) {
        Object object3;
        if (n2 != -1) {
            object3 = this.m_list.get(n2);
            this.m_map.remove(object3);
            this.m_list.remove(n2);
        }
        object3 = this.m_map.put(object, object2);
        if (n2 == -1) {
            this.m_list.add(object);
        } else {
            this.m_list.add(n2, object);
        }
        return object3;
    }

    public Object getByIndex(int n2) {
        return this.get(this.m_list.get(n2));
    }

    public Object getKeyByIndex(int n2) {
        return this.m_list.get(n2);
    }

    public Object remove(int n2) {
        return this.remove(this.m_list.get(n2));
    }

    public int indexOf(Object object) {
        return this.m_list.indexOf(object);
    }

    public Object clone() throws CloneNotSupportedException {
        ListMap listMap = (ListMap)super.clone();
        if (this.m_map != null) {
            listMap.m_map = (HashMap)this.m_map.clone();
        }
        if (this.m_list != null) {
            listMap.m_list = (ListSet)this.m_list.clone();
        }
        listMap.m_keySet = null;
        listMap.m_entrySet = null;
        listMap.m_values = null;
        return listMap;
    }

    private Iterator getIterator(int n2) {
        return new ListMapIterator(n2);
    }

    private Map.Entry getEntry(Object object, Object object2) {
        return new ListMapEntry(object, object2);
    }

    private abstract class EmbSet
    extends AbstractSet {
        private EmbSet() {
        }

        public int size() {
            return ListMap.this.size();
        }

        public void clear() {
            ListMap.this.clear();
        }
    }

    private class ListMapEntry
    implements Map.Entry {
        Object m_key = null;
        Object m_value = null;

        private ListMapEntry(Object object, Object object2) {
            this.m_key = object;
            this.m_value = object2;
        }

        public Object getKey() {
            return this.m_key;
        }

        public int hashCode() {
            return (this.m_key == null ? 0 : this.m_key.hashCode()) + (this.m_value == null ? 0 : this.m_value.hashCode());
        }

        public Object getValue() {
            return this.m_value;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof ListMapEntry) {
                ListMapEntry listMapEntry = (ListMapEntry)object;
                bl = (this.getKey() == null ? listMapEntry.getKey() == null : this.getKey().equals(listMapEntry.getKey())) && (this.getValue() == null ? listMapEntry.getValue() == null : this.getValue().equals(listMapEntry.getValue()));
            }
            return bl;
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public int size() {
            return ListMap.this.size();
        }

        public boolean contains(Object object) {
            return ListMap.this.containsValue(object);
        }

        public void clear() {
            ListMap.this.clear();
        }

        public Iterator iterator() {
            return ListMap.this.getIterator(2);
        }
    }

    private class EntrySet
    extends EmbSet {
        private EntrySet() {
        }

        public boolean contains(Object object) {
            Map.Entry entry;
            Object k2;
            boolean bl = false;
            if (object != null && object instanceof Map.Entry && ListMap.this.containsKey(k2 = (entry = (Map.Entry)object).getKey())) {
                Object object2 = ListMap.this.get(k2);
                Object v2 = entry.getValue();
                bl = object2 == null ? v2 == null : object2.equals(v2);
            }
            return bl;
        }

        public boolean remove(Object object) {
            boolean bl = false;
            if (object != null && object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k2 = entry.getKey();
                int n2 = this.size();
                ListMap.this.remove(k2);
                bl = n2 != this.size();
            }
            return bl;
        }

        public Iterator iterator() {
            return ListMap.this.getIterator(1);
        }
    }

    private class KeySet
    extends EmbSet {
        private KeySet() {
        }

        public boolean contains(Object object) {
            return ListMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            int n2 = this.size();
            ListMap.this.remove(object);
            return this.size() != n2;
        }

        public Iterator iterator() {
            return ListMap.this.getIterator(0);
        }
    }

    private class ListMapIterator
    implements Iterator {
        private Iterator m_iterator = null;
        private int m_type;
        private Object m_lastReturned = null;

        private ListMapIterator(int n2) {
            this.m_type = n2;
            this.m_iterator = ListMap.this.m_list.iterator();
        }

        public boolean hasNext() {
            return this.m_iterator.hasNext();
        }

        public Object next() {
            this.m_lastReturned = this.m_iterator.next();
            Object object = null;
            switch (this.m_type) {
                case 0: {
                    object = this.m_lastReturned;
                    break;
                }
                case 1: {
                    Object object2 = ListMap.this.get(this.m_lastReturned);
                    object = ListMap.this.getEntry(this.m_lastReturned, object2);
                    break;
                }
                case 2: {
                    object = ListMap.this.get(this.m_lastReturned);
                }
            }
            return object;
        }

        public void remove() {
            this.m_iterator.remove();
            ListMap.this.remove(this.m_lastReturned);
        }
    }
}

