/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import com.fr.stable.ColumnRowRelated;
import com.fr.stable.StableUtils;
import java.io.Serializable;

public class ColumnRow
implements Serializable,
Cloneable,
ColumnRowRelated {
    public final int column;
    public final int row;
    public static final ColumnRow ERROR = new ColumnRow(-1, -1);

    public static ColumnRow valueOf(int n2, int n3) {
        if (n2 >= 0 && n2 < 5 && n3 >= 0 && n3 < 10) {
            return ColumnRowCache.cache[n2][n3];
        }
        return new ColumnRow(n2, n3);
    }

    public static ColumnRow valueOf(String string) {
        ColumnRow columnRow = ERROR;
        if (string == null) {
            return columnRow;
        }
        if (!(string = string.trim()).matches("^[a-zA-Z]+[1-9]\\d*$")) {
            return columnRow;
        }
        try {
            columnRow = ColumnRow.valueOf(StableUtils.convertABCToInt(string.replaceAll("\\d", "")) - 1, Integer.parseInt(string.replaceAll("[a-zA-Z]", "")) - 1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return columnRow;
    }

    public static boolean validate(ColumnRow columnRow) {
        return columnRow != null && columnRow.getColumn() >= 0 && columnRow.getRow() >= 0;
    }

    protected ColumnRow(int n2, int n3) {
        this.column = n2;
        this.row = n3;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public ColumnRow[] getRelatedColumnRows() {
        return new ColumnRow[]{this};
    }

    public String toString() {
        return StableUtils.convertIntToABC(this.column + 1) + (this.row + 1);
    }

    public String stateDescription() {
        return this.toString() + "_value_state";
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * n2 + this.column;
        n2 = 37 * n2 + this.row;
        return n2;
    }

    public boolean equals(Object object) {
        return object instanceof ColumnRow && ((ColumnRow)object).row == this.row && ((ColumnRow)object).column == this.column;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static class ColumnRowCache {
        static final ColumnRow[][] cache = new ColumnRow[5][10];

        private ColumnRowCache() {
        }

        static {
            for (int i2 = 0; i2 < cache.length; ++i2) {
                int n2 = cache[i2].length;
                for (int i3 = 0; i3 < n2; ++i3) {
                    ColumnRowCache.cache[i2][i3] = new ColumnRow(i2, i3);
                }
            }
        }
    }
}

