/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import com.fr.stable.ArrayUtils;

public class BooleanUtils {
    private BooleanUtils() {
    }

    public static Boolean negate(Boolean bl) {
        if (bl == null) {
            return null;
        }
        return bl != false ? Boolean.FALSE : Boolean.TRUE;
    }

    public static boolean isTrue(Boolean bl) {
        if (bl == null) {
            return false;
        }
        return bl != false;
    }

    public static boolean isNotTrue(Boolean bl) {
        return !BooleanUtils.isTrue(bl);
    }

    public static boolean isFalse(Boolean bl) {
        if (bl == null) {
            return false;
        }
        return bl == false;
    }

    public static boolean isNotFalse(Boolean bl) {
        return !BooleanUtils.isFalse(bl);
    }

    public static Boolean toBooleanObject(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean toBoolean(Boolean bl) {
        if (bl == null) {
            return false;
        }
        return bl != false;
    }

    public static boolean toBooleanDefaultIfNull(Boolean bl, boolean bl2) {
        if (bl == null) {
            return bl2;
        }
        return bl != false;
    }

    public static boolean toBoolean(int n2) {
        return n2 != 0;
    }

    public static Boolean toBooleanObject(int n2) {
        return n2 == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static Boolean toBooleanObject(Integer n2) {
        if (n2 == null) {
            return null;
        }
        return n2 == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static boolean toBoolean(int n2, int n3, int n4) {
        if (n2 == n3) {
            return true;
        }
        if (n2 == n4) {
            return false;
        }
        throw new IllegalArgumentException("The Integer did not match either specified value");
    }

    public static boolean toBoolean(Integer n2, Integer n3, Integer n4) {
        if (n2 == null) {
            if (n3 == null) {
                return true;
            }
            if (n4 == null) {
                return false;
            }
        } else {
            if (n2.equals(n3)) {
                return true;
            }
            if (n2.equals(n4)) {
                return false;
            }
        }
        throw new IllegalArgumentException("The Integer did not match either specified value");
    }

    public static Boolean toBooleanObject(int n2, int n3, int n4, int n5) {
        if (n2 == n3) {
            return Boolean.TRUE;
        }
        if (n2 == n4) {
            return Boolean.FALSE;
        }
        if (n2 == n5) {
            return null;
        }
        throw new IllegalArgumentException("The Integer did not match any specified value");
    }

    public static Boolean toBooleanObject(Integer n2, Integer n3, Integer n4, Integer n5) {
        if (n2 == null) {
            if (n3 == null) {
                return Boolean.TRUE;
            }
            if (n4 == null) {
                return Boolean.FALSE;
            }
            if (n5 == null) {
                return null;
            }
        } else {
            if (n2.equals(n3)) {
                return Boolean.TRUE;
            }
            if (n2.equals(n4)) {
                return Boolean.FALSE;
            }
            if (n2.equals(n5)) {
                return null;
            }
        }
        throw new IllegalArgumentException("The Integer did not match any specified value");
    }

    public static int toInteger(boolean bl) {
        return bl ? 1 : 0;
    }

    public static int toInteger(boolean bl, int n2, int n3) {
        return bl ? n2 : n3;
    }

    public static int toInteger(Boolean bl, int n2, int n3, int n4) {
        if (bl == null) {
            return n4;
        }
        return bl != false ? n2 : n3;
    }

    public static Integer toIntegerObject(boolean bl, Integer n2, Integer n3) {
        return bl ? n2 : n3;
    }

    public static Integer toIntegerObject(Boolean bl, Integer n2, Integer n3, Integer n4) {
        if (bl == null) {
            return n4;
        }
        return bl != false ? n2 : n3;
    }

    public static Boolean toBooleanObject(String string) {
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        if ("on".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("off".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        if ("yes".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("no".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static Boolean toBooleanObject(String string, String string2, String string3, String string4) {
        if (string == null) {
            if (string2 == null) {
                return Boolean.TRUE;
            }
            if (string3 == null) {
                return Boolean.FALSE;
            }
            if (string4 == null) {
                return null;
            }
        } else {
            if (string.equals(string2)) {
                return Boolean.TRUE;
            }
            if (string.equals(string3)) {
                return Boolean.FALSE;
            }
            if (string.equals(string4)) {
                return null;
            }
        }
        throw new IllegalArgumentException("The String did not match any specified value");
    }

    public static boolean toBoolean(String string) {
        if ("true".equals(string)) {
            return true;
        }
        if (string == null) {
            return false;
        }
        switch (string.length()) {
            case 2: {
                char c2 = string.charAt(0);
                char c3 = string.charAt(1);
                return !(c2 != 'o' && c2 != 'O' || c3 != 'n' && c3 != 'N');
            }
            case 3: {
                char c4 = string.charAt(0);
                if (c4 == 'y') {
                    return !(string.charAt(1) != 'e' && string.charAt(1) != 'E' || string.charAt(2) != 's' && string.charAt(2) != 'S');
                }
                if (c4 == 'Y') {
                    return !(string.charAt(1) != 'E' && string.charAt(1) != 'e' || string.charAt(2) != 'S' && string.charAt(2) != 's');
                }
                return false;
            }
            case 4: {
                char c5 = string.charAt(0);
                if (c5 == 't') {
                    return !(string.charAt(1) != 'r' && string.charAt(1) != 'R' || string.charAt(2) != 'u' && string.charAt(2) != 'U' || string.charAt(3) != 'e' && string.charAt(3) != 'E');
                }
                if (c5 != 'T') break;
                return !(string.charAt(1) != 'R' && string.charAt(1) != 'r' || string.charAt(2) != 'U' && string.charAt(2) != 'u' || string.charAt(3) != 'E' && string.charAt(3) != 'e');
            }
        }
        return false;
    }

    public static boolean toBoolean(String string, String string2, String string3) {
        if (string == null) {
            if (string2 == null) {
                return true;
            }
            if (string3 == null) {
                return false;
            }
        } else {
            if (string.equals(string2)) {
                return true;
            }
            if (string.equals(string3)) {
                return false;
            }
        }
        throw new IllegalArgumentException("The String did not match either specified value");
    }

    public static String toStringTrueFalse(Boolean bl) {
        return BooleanUtils.toString(bl, "true", "false", null);
    }

    public static String toStringOnOff(Boolean bl) {
        return BooleanUtils.toString(bl, "on", "off", null);
    }

    public static String toStringYesNo(Boolean bl) {
        return BooleanUtils.toString(bl, "yes", "no", null);
    }

    public static String toString(Boolean bl, String string, String string2, String string3) {
        if (bl == null) {
            return string3;
        }
        return bl != false ? string : string2;
    }

    public static String toStringTrueFalse(boolean bl) {
        return BooleanUtils.toString(bl, "true", "false");
    }

    public static String toStringOnOff(boolean bl) {
        return BooleanUtils.toString(bl, "on", "off");
    }

    public static String toStringYesNo(boolean bl) {
        return BooleanUtils.toString(bl, "yes", "no");
    }

    public static String toString(boolean bl, String string, String string2) {
        return bl ? string : string2;
    }

    public static boolean xor(boolean[] blArray) {
        if (blArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (blArray.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        int n2 = 0;
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (!blArray[i2]) continue;
            if (n2 < 1) {
                ++n2;
                continue;
            }
            return false;
        }
        return n2 == 1;
    }

    public static Boolean xor(Boolean[] booleanArray) {
        if (booleanArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (booleanArray.length == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        boolean[] blArray = null;
        try {
            blArray = ArrayUtils.toPrimitive(booleanArray);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("The array must not contain any null elements");
        }
        return BooleanUtils.xor(blArray) ? Boolean.TRUE : Boolean.FALSE;
    }
}

