/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import com.fr.stable.BooleanUtils;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class ArrayUtils {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    public static final int INDEX_NOT_FOUND = -1;

    private ArrayUtils() {
    }

    public static Map toMap(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>((int)((double)objectArray.length * 1.5));
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object[] objectArray2;
            Object object = objectArray[i2];
            if (object instanceof Map.Entry) {
                objectArray2 = (Object[])object;
                hashMap.put(objectArray2.getKey(), objectArray2.getValue());
                continue;
            }
            if (object instanceof Object[]) {
                objectArray2 = (Object[])object;
                if (objectArray2.length < 2) {
                    throw new IllegalArgumentException("Array element " + i2 + ", '" + object + "', has a length less than 2");
                }
                hashMap.put(objectArray2[0], objectArray2[1]);
                continue;
            }
            throw new IllegalArgumentException("Array element " + i2 + ", '" + object + "', is neither of type Map.Entry nor an Array");
        }
        return hashMap;
    }

    public static Object[] clone(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        return (Object[])objectArray.clone();
    }

    public static long[] clone(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        return (long[])lArray.clone();
    }

    public static int[] clone(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        return (int[])nArray.clone();
    }

    public static short[] clone(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        return (short[])sArray.clone();
    }

    public static char[] clone(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        return (char[])cArray.clone();
    }

    public static byte[] clone(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return (byte[])byArray.clone();
    }

    public static double[] clone(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        return (double[])dArray.clone();
    }

    public static float[] clone(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        return (float[])fArray.clone();
    }

    public static boolean[] clone(boolean[] blArray) {
        if (blArray == null) {
            return null;
        }
        return (boolean[])blArray.clone();
    }

    public static Object[] subarray(Object[] objectArray, int n2, int n3) {
        if (objectArray == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > objectArray.length) {
            n3 = objectArray.length;
        }
        int n4 = n3 - n2;
        Class<?> clazz = objectArray.getClass().getComponentType();
        if (n4 <= 0) {
            return (Object[])Array.newInstance(clazz, 0);
        }
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, n4);
        System.arraycopy(objectArray, n2, objectArray2, 0, n4);
        return objectArray2;
    }

    public static long[] subarray(long[] lArray, int n2, int n3) {
        int n4;
        if (lArray == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > lArray.length) {
            n3 = lArray.length;
        }
        if ((n4 = n3 - n2) <= 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] lArray2 = new long[n4];
        System.arraycopy(lArray, n2, lArray2, 0, n4);
        return lArray2;
    }

    public static int[] subarray(int[] nArray, int n2, int n3) {
        int n4;
        if (nArray == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > nArray.length) {
            n3 = nArray.length;
        }
        if ((n4 = n3 - n2) <= 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, n2, nArray2, 0, n4);
        return nArray2;
    }

    public static short[] subarray(short[] sArray, int n2, int n3) {
        int n4;
        if (sArray == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > sArray.length) {
            n3 = sArray.length;
        }
        if ((n4 = n3 - n2) <= 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] sArray2 = new short[n4];
        System.arraycopy(sArray, n2, sArray2, 0, n4);
        return sArray2;
    }

    public static char[] subarray(char[] cArray, int n2, int n3) {
        int n4;
        if (cArray == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > cArray.length) {
            n3 = cArray.length;
        }
        if ((n4 = n3 - n2) <= 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] cArray2 = new char[n4];
        System.arraycopy(cArray, n2, cArray2, 0, n4);
        return cArray2;
    }

    public static byte[] subarray(byte[] byArray, int n2, int n3) {
        int n4;
        if (byArray == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > byArray.length) {
            n3 = byArray.length;
        }
        if ((n4 = n3 - n2) <= 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n2, byArray2, 0, n4);
        return byArray2;
    }

    public static double[] subarray(double[] dArray, int n2, int n3) {
        int n4;
        if (dArray == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > dArray.length) {
            n3 = dArray.length;
        }
        if ((n4 = n3 - n2) <= 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] dArray2 = new double[n4];
        System.arraycopy(dArray, n2, dArray2, 0, n4);
        return dArray2;
    }

    public static float[] subarray(float[] fArray, int n2, int n3) {
        int n4;
        if (fArray == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > fArray.length) {
            n3 = fArray.length;
        }
        if ((n4 = n3 - n2) <= 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] fArray2 = new float[n4];
        System.arraycopy(fArray, n2, fArray2, 0, n4);
        return fArray2;
    }

    public static boolean[] subarray(boolean[] blArray, int n2, int n3) {
        int n4;
        if (blArray == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > blArray.length) {
            n3 = blArray.length;
        }
        if ((n4 = n3 - n2) <= 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] blArray2 = new boolean[n4];
        System.arraycopy(blArray, n2, blArray2, 0, n4);
        return blArray2;
    }

    public static boolean isSameLength(Object[] objectArray, Object[] objectArray2) {
        return !(objectArray == null && objectArray2 != null && objectArray2.length > 0 || objectArray2 == null && objectArray != null && objectArray.length > 0) && (objectArray == null || objectArray2 == null || objectArray.length == objectArray2.length);
    }

    public static boolean isSameArray(int[] nArray, int[] nArray2) {
        int n2;
        int n3 = nArray == null ? 0 : nArray.length;
        int n4 = n2 = nArray2 == null ? 0 : nArray2.length;
        if (n3 != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] == nArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static int getLength(Object object) {
        if (object == null) {
            return 0;
        }
        return Array.getLength(object);
    }

    public static boolean isSameType(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        return object.getClass().getName().equals(object2.getClass().getName());
    }

    public static void reverse(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        int n2 = 0;
        for (int i2 = objectArray.length - 1; i2 > n2; --i2, ++n2) {
            Object object = objectArray[i2];
            objectArray[i2] = objectArray[n2];
            objectArray[n2] = object;
        }
    }

    public static void reverse(long[] lArray) {
        if (lArray == null) {
            return;
        }
        int n2 = 0;
        for (int i2 = lArray.length - 1; i2 > n2; --i2, ++n2) {
            long l2 = lArray[i2];
            lArray[i2] = lArray[n2];
            lArray[n2] = l2;
        }
    }

    public static void reverse(int[] nArray) {
        if (nArray == null) {
            return;
        }
        int n2 = 0;
        for (int i2 = nArray.length - 1; i2 > n2; --i2, ++n2) {
            int n3 = nArray[i2];
            nArray[i2] = nArray[n2];
            nArray[n2] = n3;
        }
    }

    public static void reverse(short[] sArray) {
        if (sArray == null) {
            return;
        }
        int n2 = 0;
        for (int i2 = sArray.length - 1; i2 > n2; --i2, ++n2) {
            short s2 = sArray[i2];
            sArray[i2] = sArray[n2];
            sArray[n2] = s2;
        }
    }

    public static void reverse(char[] cArray) {
        if (cArray == null) {
            return;
        }
        int n2 = 0;
        for (int i2 = cArray.length - 1; i2 > n2; --i2, ++n2) {
            char c2 = cArray[i2];
            cArray[i2] = cArray[n2];
            cArray[n2] = c2;
        }
    }

    public static void reverse(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int n2 = 0;
        for (int i2 = byArray.length - 1; i2 > n2; --i2, ++n2) {
            byte by = byArray[i2];
            byArray[i2] = byArray[n2];
            byArray[n2] = by;
        }
    }

    public static void reverse(double[] dArray) {
        if (dArray == null) {
            return;
        }
        int n2 = 0;
        for (int i2 = dArray.length - 1; i2 > n2; --i2, ++n2) {
            double d2 = dArray[i2];
            dArray[i2] = dArray[n2];
            dArray[n2] = d2;
        }
    }

    public static void reverse(float[] fArray) {
        if (fArray == null) {
            return;
        }
        int n2 = 0;
        for (int i2 = fArray.length - 1; i2 > n2; --i2, ++n2) {
            float f2 = fArray[i2];
            fArray[i2] = fArray[n2];
            fArray[n2] = f2;
        }
    }

    public static void reverse(boolean[] blArray) {
        if (blArray == null) {
            return;
        }
        int n2 = 0;
        for (int i2 = blArray.length - 1; i2 > n2; --i2, ++n2) {
            boolean bl = blArray[i2];
            blArray[i2] = blArray[n2];
            blArray[n2] = bl;
        }
    }

    public static int indexOf(Object[] objectArray, Object object) {
        return ArrayUtils.indexOf(objectArray, object, 0);
    }

    public static int indexOf(Object[] objectArray, Object object, int n2) {
        if (objectArray == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (object == null) {
            for (int i2 = n2; i2 < objectArray.length; ++i2) {
                if (objectArray[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = n2; i3 < objectArray.length; ++i3) {
                if (!object.equals(objectArray[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public static int lastIndexOf(Object[] objectArray, Object object) {
        return ArrayUtils.lastIndexOf(objectArray, object, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(Object[] objectArray, Object object, int n2) {
        if (objectArray == null) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= objectArray.length) {
            n2 = objectArray.length - 1;
        }
        if (object == null) {
            for (int i2 = n2; i2 >= 0; --i2) {
                if (objectArray[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = n2; i3 >= 0; --i3) {
                if (!object.equals(objectArray[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public static boolean contains(Object[] objectArray, Object object) {
        return ArrayUtils.indexOf(objectArray, object) != -1;
    }

    public static int indexOf(long[] lArray, long l2) {
        return ArrayUtils.indexOf(lArray, l2, 0);
    }

    public static int indexOf(long[] lArray, long l2, int n2) {
        if (lArray == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        for (int i2 = n2; i2 < lArray.length; ++i2) {
            if (l2 != lArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(long[] lArray, long l2) {
        return ArrayUtils.lastIndexOf(lArray, l2, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(long[] lArray, long l2, int n2) {
        if (lArray == null) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= lArray.length) {
            n2 = lArray.length - 1;
        }
        for (int i2 = n2; i2 >= 0; --i2) {
            if (l2 != lArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static boolean contains(long[] lArray, long l2) {
        return ArrayUtils.indexOf(lArray, l2) != -1;
    }

    public static int indexOf(int[] nArray, int n2) {
        return ArrayUtils.indexOf(nArray, n2, 0);
    }

    public static int indexOf(int[] nArray, int n2, int n3) {
        if (nArray == null) {
            return -1;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        for (int i2 = n3; i2 < nArray.length; ++i2) {
            if (n2 != nArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(int[] nArray, int n2) {
        return ArrayUtils.lastIndexOf(nArray, n2, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(int[] nArray, int n2, int n3) {
        if (nArray == null) {
            return -1;
        }
        if (n3 < 0) {
            return -1;
        }
        if (n3 >= nArray.length) {
            n3 = nArray.length - 1;
        }
        for (int i2 = n3; i2 >= 0; --i2) {
            if (n2 != nArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static boolean contains(int[] nArray, int n2) {
        return ArrayUtils.indexOf(nArray, n2) != -1;
    }

    public static int indexOf(short[] sArray, short s2) {
        return ArrayUtils.indexOf(sArray, s2, 0);
    }

    public static int indexOf(short[] sArray, short s2, int n2) {
        if (sArray == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        for (int i2 = n2; i2 < sArray.length; ++i2) {
            if (s2 != sArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(short[] sArray, short s2) {
        return ArrayUtils.lastIndexOf(sArray, s2, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(short[] sArray, short s2, int n2) {
        if (sArray == null) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= sArray.length) {
            n2 = sArray.length - 1;
        }
        for (int i2 = n2; i2 >= 0; --i2) {
            if (s2 != sArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static boolean contains(short[] sArray, short s2) {
        return ArrayUtils.indexOf(sArray, s2) != -1;
    }

    public static int indexOf(char[] cArray, char c2) {
        return ArrayUtils.indexOf(cArray, c2, 0);
    }

    public static int indexOf(char[] cArray, char c2, int n2) {
        if (cArray == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        for (int i2 = n2; i2 < cArray.length; ++i2) {
            if (c2 != cArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(char[] cArray, char c2) {
        return ArrayUtils.lastIndexOf(cArray, c2, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(char[] cArray, char c2, int n2) {
        if (cArray == null) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= cArray.length) {
            n2 = cArray.length - 1;
        }
        for (int i2 = n2; i2 >= 0; --i2) {
            if (c2 != cArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static boolean contains(char[] cArray, char c2) {
        return ArrayUtils.indexOf(cArray, c2) != -1;
    }

    public static int indexOf(byte[] byArray, byte by) {
        return ArrayUtils.indexOf(byArray, by, 0);
    }

    public static int indexOf(byte[] byArray, byte by, int n2) {
        if (byArray == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        for (int i2 = n2; i2 < byArray.length; ++i2) {
            if (by != byArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] byArray, byte by) {
        return ArrayUtils.lastIndexOf(byArray, by, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(byte[] byArray, byte by, int n2) {
        if (byArray == null) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= byArray.length) {
            n2 = byArray.length - 1;
        }
        for (int i2 = n2; i2 >= 0; --i2) {
            if (by != byArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static boolean contains(byte[] byArray, byte by) {
        return ArrayUtils.indexOf(byArray, by) != -1;
    }

    public static int indexOf(double[] dArray, double d2) {
        return ArrayUtils.indexOf(dArray, d2, 0);
    }

    public static int indexOf(double[] dArray, double d2, double d3) {
        return ArrayUtils.indexOf(dArray, d2, 0, d3);
    }

    public static int indexOf(double[] dArray, double d2, int n2) {
        if (ArrayUtils.isEmpty(dArray)) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        for (int i2 = n2; i2 < dArray.length; ++i2) {
            if (d2 != dArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(double[] dArray, double d2, int n2, double d3) {
        if (ArrayUtils.isEmpty(dArray)) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        double d4 = d2 - d3;
        double d5 = d2 + d3;
        for (int i2 = n2; i2 < dArray.length; ++i2) {
            if (!(dArray[i2] >= d4) || !(dArray[i2] <= d5)) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(double[] dArray, double d2) {
        return ArrayUtils.lastIndexOf(dArray, d2, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(double[] dArray, double d2, double d3) {
        return ArrayUtils.lastIndexOf(dArray, d2, Integer.MAX_VALUE, d3);
    }

    public static int lastIndexOf(double[] dArray, double d2, int n2) {
        if (ArrayUtils.isEmpty(dArray)) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= dArray.length) {
            n2 = dArray.length - 1;
        }
        for (int i2 = n2; i2 >= 0; --i2) {
            if (d2 != dArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(double[] dArray, double d2, int n2, double d3) {
        if (ArrayUtils.isEmpty(dArray)) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= dArray.length) {
            n2 = dArray.length - 1;
        }
        double d4 = d2 - d3;
        double d5 = d2 + d3;
        for (int i2 = n2; i2 >= 0; --i2) {
            if (!(dArray[i2] >= d4) || !(dArray[i2] <= d5)) continue;
            return i2;
        }
        return -1;
    }

    public static boolean contains(double[] dArray, double d2) {
        return ArrayUtils.indexOf(dArray, d2) != -1;
    }

    public static boolean contains(double[] dArray, double d2, double d3) {
        return ArrayUtils.indexOf(dArray, d2, 0, d3) != -1;
    }

    public static int indexOf(float[] fArray, float f2) {
        return ArrayUtils.indexOf(fArray, f2, 0);
    }

    public static int indexOf(float[] fArray, float f2, int n2) {
        if (ArrayUtils.isEmpty(fArray)) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        for (int i2 = n2; i2 < fArray.length; ++i2) {
            if (f2 != fArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(float[] fArray, float f2) {
        return ArrayUtils.lastIndexOf(fArray, f2, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(float[] fArray, float f2, int n2) {
        if (ArrayUtils.isEmpty(fArray)) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= fArray.length) {
            n2 = fArray.length - 1;
        }
        for (int i2 = n2; i2 >= 0; --i2) {
            if (f2 != fArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static boolean contains(float[] fArray, float f2) {
        return ArrayUtils.indexOf(fArray, f2) != -1;
    }

    public static int indexOf(boolean[] blArray, boolean bl) {
        return ArrayUtils.indexOf(blArray, bl, 0);
    }

    public static int indexOf(boolean[] blArray, boolean bl, int n2) {
        if (ArrayUtils.isEmpty(blArray)) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        for (int i2 = n2; i2 < blArray.length; ++i2) {
            if (bl != blArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] blArray, boolean bl) {
        return ArrayUtils.lastIndexOf(blArray, bl, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(boolean[] blArray, boolean bl, int n2) {
        if (ArrayUtils.isEmpty(blArray)) {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= blArray.length) {
            n2 = blArray.length - 1;
        }
        for (int i2 = n2; i2 >= 0; --i2) {
            if (bl != blArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static boolean contains(boolean[] blArray, boolean bl) {
        return ArrayUtils.indexOf(blArray, bl) != -1;
    }

    public static char[] toPrimitive(Character[] characterArray) {
        if (characterArray == null) {
            return null;
        }
        if (characterArray.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] cArray = new char[characterArray.length];
        for (int i2 = 0; i2 < characterArray.length; ++i2) {
            cArray[i2] = characterArray[i2].charValue();
        }
        return cArray;
    }

    public static char[] toPrimitive(Character[] characterArray, char c2) {
        if (characterArray == null) {
            return null;
        }
        if (characterArray.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] cArray = new char[characterArray.length];
        for (int i2 = 0; i2 < characterArray.length; ++i2) {
            Character c3 = characterArray[i2];
            cArray[i2] = c3 == null ? c2 : c3.charValue();
        }
        return cArray;
    }

    public static Character[] toObject(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        if (cArray.length == 0) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] characterArray = new Character[cArray.length];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            characterArray[i2] = new Character(cArray[i2]);
        }
        return characterArray;
    }

    public static long[] toPrimitive(Long[] longArray) {
        if (longArray == null) {
            return null;
        }
        if (longArray.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] lArray = new long[longArray.length];
        for (int i2 = 0; i2 < longArray.length; ++i2) {
            lArray[i2] = longArray[i2];
        }
        return lArray;
    }

    public static long[] toPrimitive(Long[] longArray, long l2) {
        if (longArray == null) {
            return null;
        }
        if (longArray.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] lArray = new long[longArray.length];
        for (int i2 = 0; i2 < longArray.length; ++i2) {
            Long l3 = longArray[i2];
            lArray[i2] = l3 == null ? l2 : l3;
        }
        return lArray;
    }

    public static Long[] toObject(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        if (lArray.length == 0) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] longArray = new Long[lArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            longArray[i2] = new Long(lArray[i2]);
        }
        return longArray;
    }

    public static int[] toPrimitive(Integer[] integerArray) {
        if (integerArray == null) {
            return null;
        }
        if (integerArray.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] nArray = new int[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            nArray[i2] = integerArray[i2];
        }
        return nArray;
    }

    public static int[] toPrimitive(Integer[] integerArray, int n2) {
        if (integerArray == null) {
            return null;
        }
        if (integerArray.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] nArray = new int[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            Integer n3 = integerArray[i2];
            nArray[i2] = n3 == null ? n2 : n3;
        }
        return nArray;
    }

    public static Integer[] toObject(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        if (nArray.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] integerArray = new Integer[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            integerArray[i2] = new Integer(nArray[i2]);
        }
        return integerArray;
    }

    public static short[] toPrimitive(Short[] shortArray) {
        if (shortArray == null) {
            return null;
        }
        if (shortArray.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] sArray = new short[shortArray.length];
        for (int i2 = 0; i2 < shortArray.length; ++i2) {
            sArray[i2] = shortArray[i2];
        }
        return sArray;
    }

    public static short[] toPrimitive(Short[] shortArray, short s2) {
        if (shortArray == null) {
            return null;
        }
        if (shortArray.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] sArray = new short[shortArray.length];
        for (int i2 = 0; i2 < shortArray.length; ++i2) {
            Short s3 = shortArray[i2];
            sArray[i2] = s3 == null ? s2 : s3;
        }
        return sArray;
    }

    public static Short[] toObject(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        if (sArray.length == 0) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        Short[] shortArray = new Short[sArray.length];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            shortArray[i2] = new Short(sArray[i2]);
        }
        return shortArray;
    }

    public static byte[] toPrimitive(Byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        if (byteArray.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[byteArray.length];
        for (int i2 = 0; i2 < byteArray.length; ++i2) {
            byArray[i2] = byteArray[i2];
        }
        return byArray;
    }

    public static byte[] toPrimitive(Byte[] byteArray, byte by) {
        if (byteArray == null) {
            return null;
        }
        if (byteArray.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[byteArray.length];
        for (int i2 = 0; i2 < byteArray.length; ++i2) {
            Byte by2 = byteArray[i2];
            byArray[i2] = by2 == null ? by : by2;
        }
        return byArray;
    }

    public static Byte[] toObject(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] byteArray = new Byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byteArray[i2] = new Byte(byArray[i2]);
        }
        return byteArray;
    }

    public static double[] toPrimitive(Double[] doubleArray) {
        if (doubleArray == null) {
            return null;
        }
        if (doubleArray.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] dArray = new double[doubleArray.length];
        for (int i2 = 0; i2 < doubleArray.length; ++i2) {
            dArray[i2] = doubleArray[i2];
        }
        return dArray;
    }

    public static double[] toPrimitive(Double[] doubleArray, double d2) {
        if (doubleArray == null) {
            return null;
        }
        if (doubleArray.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] dArray = new double[doubleArray.length];
        for (int i2 = 0; i2 < doubleArray.length; ++i2) {
            Double d3 = doubleArray[i2];
            dArray[i2] = d3 == null ? d2 : d3;
        }
        return dArray;
    }

    public static Double[] toObject(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        if (dArray.length == 0) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] doubleArray = new Double[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            doubleArray[i2] = new Double(dArray[i2]);
        }
        return doubleArray;
    }

    public static float[] toPrimitive(Float[] floatArray) {
        if (floatArray == null) {
            return null;
        }
        if (floatArray.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] fArray = new float[floatArray.length];
        for (int i2 = 0; i2 < floatArray.length; ++i2) {
            fArray[i2] = floatArray[i2].floatValue();
        }
        return fArray;
    }

    public static float[] toPrimitive(Float[] floatArray, float f2) {
        if (floatArray == null) {
            return null;
        }
        if (floatArray.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] fArray = new float[floatArray.length];
        for (int i2 = 0; i2 < floatArray.length; ++i2) {
            Float f3 = floatArray[i2];
            fArray[i2] = f3 == null ? f2 : f3.floatValue();
        }
        return fArray;
    }

    public static Float[] toObject(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        if (fArray.length == 0) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        Float[] floatArray = new Float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            floatArray[i2] = new Float(fArray[i2]);
        }
        return floatArray;
    }

    public static boolean[] toPrimitive(Boolean[] booleanArray) {
        if (booleanArray == null) {
            return null;
        }
        if (booleanArray.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] blArray = new boolean[booleanArray.length];
        for (int i2 = 0; i2 < booleanArray.length; ++i2) {
            blArray[i2] = booleanArray[i2];
        }
        return blArray;
    }

    public static boolean[] toPrimitive(Boolean[] booleanArray, boolean bl) {
        if (booleanArray == null) {
            return null;
        }
        if (booleanArray.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] blArray = new boolean[booleanArray.length];
        for (int i2 = 0; i2 < booleanArray.length; ++i2) {
            Boolean bl2 = booleanArray[i2];
            blArray[i2] = bl2 == null ? bl : bl2;
        }
        return blArray;
    }

    public static Boolean[] toObject(boolean[] blArray) {
        if (blArray == null) {
            return null;
        }
        if (blArray.length == 0) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] booleanArray = new Boolean[blArray.length];
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            booleanArray[i2] = blArray[i2] ? Boolean.TRUE : Boolean.FALSE;
        }
        return booleanArray;
    }

    public static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    public static boolean isNotEmpty(Object[] objectArray) {
        return !ArrayUtils.isEmpty(objectArray);
    }

    public static boolean isEmpty(Object[][] objectArray) {
        boolean bl = true;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (ArrayUtils.isEmpty(objectArray[i2])) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean isEmpty(long[] lArray) {
        return lArray == null || lArray.length == 0;
    }

    public static boolean isEmpty(int[] nArray) {
        return nArray == null || nArray.length == 0;
    }

    public static boolean isEmpty(short[] sArray) {
        return sArray == null || sArray.length == 0;
    }

    public static boolean isEmpty(char[] cArray) {
        return cArray == null || cArray.length == 0;
    }

    public static boolean isEmpty(byte[] byArray) {
        return byArray == null || byArray.length == 0;
    }

    public static boolean isEmpty(double[] dArray) {
        return dArray == null || dArray.length == 0;
    }

    public static boolean isEmpty(float[] fArray) {
        return fArray == null || fArray.length == 0;
    }

    public static boolean isEmpty(boolean[] blArray) {
        return blArray == null || blArray.length == 0;
    }

    public static Object[] addAll(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return ArrayUtils.clone(objectArray2);
        }
        if (objectArray2 == null) {
            return ArrayUtils.clone(objectArray);
        }
        Object[] objectArray3 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), objectArray.length + objectArray2.length);
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
        return objectArray3;
    }

    public static boolean[] addAll(boolean[] blArray, boolean[] blArray2) {
        if (blArray == null) {
            return ArrayUtils.clone(blArray2);
        }
        if (blArray2 == null) {
            return ArrayUtils.clone(blArray);
        }
        boolean[] blArray3 = new boolean[blArray.length + blArray2.length];
        System.arraycopy(blArray, 0, blArray3, 0, blArray.length);
        System.arraycopy(blArray2, 0, blArray3, blArray.length, blArray2.length);
        return blArray3;
    }

    public static char[] addAll(char[] cArray, char[] cArray2) {
        if (cArray == null) {
            return ArrayUtils.clone(cArray2);
        }
        if (cArray2 == null) {
            return ArrayUtils.clone(cArray);
        }
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        System.arraycopy(cArray2, 0, cArray3, cArray.length, cArray2.length);
        return cArray3;
    }

    public static byte[] addAll(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return ArrayUtils.clone(byArray2);
        }
        if (byArray2 == null) {
            return ArrayUtils.clone(byArray);
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static short[] addAll(short[] sArray, short[] sArray2) {
        if (sArray == null) {
            return ArrayUtils.clone(sArray2);
        }
        if (sArray2 == null) {
            return ArrayUtils.clone(sArray);
        }
        short[] sArray3 = new short[sArray.length + sArray2.length];
        System.arraycopy(sArray, 0, sArray3, 0, sArray.length);
        System.arraycopy(sArray2, 0, sArray3, sArray.length, sArray2.length);
        return sArray3;
    }

    public static int[] addAll(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            return ArrayUtils.clone(nArray2);
        }
        if (nArray2 == null) {
            return ArrayUtils.clone(nArray);
        }
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    public static long[] addAll(long[] lArray, long[] lArray2) {
        if (lArray == null) {
            return ArrayUtils.clone(lArray2);
        }
        if (lArray2 == null) {
            return ArrayUtils.clone(lArray);
        }
        long[] lArray3 = new long[lArray.length + lArray2.length];
        System.arraycopy(lArray, 0, lArray3, 0, lArray.length);
        System.arraycopy(lArray2, 0, lArray3, lArray.length, lArray2.length);
        return lArray3;
    }

    public static float[] addAll(float[] fArray, float[] fArray2) {
        if (fArray == null) {
            return ArrayUtils.clone(fArray2);
        }
        if (fArray2 == null) {
            return ArrayUtils.clone(fArray);
        }
        float[] fArray3 = new float[fArray.length + fArray2.length];
        System.arraycopy(fArray, 0, fArray3, 0, fArray.length);
        System.arraycopy(fArray2, 0, fArray3, fArray.length, fArray2.length);
        return fArray3;
    }

    public static double[] addAll(double[] dArray, double[] dArray2) {
        if (dArray == null) {
            return ArrayUtils.clone(dArray2);
        }
        if (dArray2 == null) {
            return ArrayUtils.clone(dArray);
        }
        double[] dArray3 = new double[dArray.length + dArray2.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray2, 0, dArray3, dArray.length, dArray2.length);
        return dArray3;
    }

    public static Object[] add(Object[] objectArray, Object object) {
        Class<Object> clazz = objectArray != null ? objectArray.getClass() : (object != null ? object.getClass() : Object.class);
        Object[] objectArray2 = (Object[])ArrayUtils.copyArrayGrow1(objectArray, clazz);
        objectArray2[objectArray2.length - 1] = object;
        return objectArray2;
    }

    public static boolean[] add(boolean[] blArray, boolean bl) {
        boolean[] blArray2 = (boolean[])ArrayUtils.copyArrayGrow1(blArray, Boolean.TYPE);
        blArray2[blArray2.length - 1] = bl;
        return blArray2;
    }

    public static byte[] add(byte[] byArray, byte by) {
        byte[] byArray2 = (byte[])ArrayUtils.copyArrayGrow1(byArray, Byte.TYPE);
        byArray2[byArray2.length - 1] = by;
        return byArray2;
    }

    public static char[] add(char[] cArray, char c2) {
        char[] cArray2 = (char[])ArrayUtils.copyArrayGrow1(cArray, Character.TYPE);
        cArray2[cArray2.length - 1] = c2;
        return cArray2;
    }

    public static double[] add(double[] dArray, double d2) {
        double[] dArray2 = (double[])ArrayUtils.copyArrayGrow1(dArray, Double.TYPE);
        dArray2[dArray2.length - 1] = d2;
        return dArray2;
    }

    public static float[] add(float[] fArray, float f2) {
        float[] fArray2 = (float[])ArrayUtils.copyArrayGrow1(fArray, Float.TYPE);
        fArray2[fArray2.length - 1] = f2;
        return fArray2;
    }

    public static int[] add(int[] nArray, int n2) {
        int[] nArray2 = (int[])ArrayUtils.copyArrayGrow1(nArray, Integer.TYPE);
        nArray2[nArray2.length - 1] = n2;
        return nArray2;
    }

    public static long[] add(long[] lArray, long l2) {
        long[] lArray2 = (long[])ArrayUtils.copyArrayGrow1(lArray, Long.TYPE);
        lArray2[lArray2.length - 1] = l2;
        return lArray2;
    }

    public static short[] add(short[] sArray, short s2) {
        short[] sArray2 = (short[])ArrayUtils.copyArrayGrow1(sArray, Short.TYPE);
        sArray2[sArray2.length - 1] = s2;
        return sArray2;
    }

    private static Object copyArrayGrow1(Object object, Class clazz) {
        if (object != null) {
            int n2 = Array.getLength(object);
            Object object2 = Array.newInstance(object.getClass().getComponentType(), n2 + 1);
            System.arraycopy(object, 0, object2, 0, n2);
            return object2;
        }
        return Array.newInstance(clazz, 1);
    }

    public static Object[] add(Object[] objectArray, int n2, Object object) {
        Class<?> clazz = null;
        if (objectArray != null) {
            clazz = objectArray.getClass().getComponentType();
        } else if (object != null) {
            clazz = object.getClass();
        } else {
            return new Object[]{null};
        }
        return (Object[])ArrayUtils.add(objectArray, n2, object, clazz);
    }

    public static boolean[] add(boolean[] blArray, int n2, boolean bl) {
        return (boolean[])ArrayUtils.add(blArray, n2, BooleanUtils.toBooleanObject(bl), Boolean.TYPE);
    }

    public static char[] add(char[] cArray, int n2, char c2) {
        return (char[])ArrayUtils.add(cArray, n2, new Character(c2), Character.TYPE);
    }

    public static byte[] add(byte[] byArray, int n2, byte by) {
        return (byte[])ArrayUtils.add(byArray, n2, new Byte(by), Byte.TYPE);
    }

    public static short[] add(short[] sArray, int n2, short s2) {
        return (short[])ArrayUtils.add(sArray, n2, new Short(s2), Short.TYPE);
    }

    public static int[] add(int[] nArray, int n2, int n3) {
        return (int[])ArrayUtils.add(nArray, n2, new Integer(n3), Integer.TYPE);
    }

    public static long[] add(long[] lArray, int n2, long l2) {
        return (long[])ArrayUtils.add(lArray, n2, new Long(l2), Long.TYPE);
    }

    public static float[] add(float[] fArray, int n2, float f2) {
        return (float[])ArrayUtils.add(fArray, n2, new Float(f2), Float.TYPE);
    }

    public static double[] add(double[] dArray, int n2, double d2) {
        return (double[])ArrayUtils.add(dArray, n2, new Double(d2), Double.TYPE);
    }

    private static Object add(Object object, int n2, Object object2, Class clazz) {
        if (object == null) {
            if (n2 != 0) {
                throw new IndexOutOfBoundsException("Index: " + n2 + ", Length: 0");
            }
            Object object3 = Array.newInstance(clazz, 1);
            Array.set(object3, 0, object2);
            return object3;
        }
        int n3 = Array.getLength(object);
        if (n2 > n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Length: " + n3);
        }
        Object object4 = Array.newInstance(clazz, n3 + 1);
        System.arraycopy(object, 0, object4, 0, n2);
        Array.set(object4, n2, object2);
        if (n2 < n3) {
            System.arraycopy(object, n2, object4, n2 + 1, n3 - n2);
        }
        return object4;
    }

    public static Object[] remove(Object[] objectArray, int n2) {
        return (Object[])ArrayUtils.remove((Object)objectArray, n2);
    }

    public static Object[] removeElement(Object[] objectArray, Object object) {
        int n2 = ArrayUtils.indexOf(objectArray, object);
        if (n2 == -1) {
            return ArrayUtils.clone(objectArray);
        }
        return ArrayUtils.remove(objectArray, n2);
    }

    public static boolean[] remove(boolean[] blArray, int n2) {
        return (boolean[])ArrayUtils.remove((Object)blArray, n2);
    }

    public static boolean[] removeElement(boolean[] blArray, boolean bl) {
        int n2 = ArrayUtils.indexOf(blArray, bl);
        if (n2 == -1) {
            return ArrayUtils.clone(blArray);
        }
        return ArrayUtils.remove(blArray, n2);
    }

    public static byte[] remove(byte[] byArray, int n2) {
        return (byte[])ArrayUtils.remove((Object)byArray, n2);
    }

    public static byte[] removeElement(byte[] byArray, byte by) {
        int n2 = ArrayUtils.indexOf(byArray, by);
        if (n2 == -1) {
            return ArrayUtils.clone(byArray);
        }
        return ArrayUtils.remove(byArray, n2);
    }

    public static char[] remove(char[] cArray, int n2) {
        return (char[])ArrayUtils.remove((Object)cArray, n2);
    }

    public static char[] removeElement(char[] cArray, char c2) {
        int n2 = ArrayUtils.indexOf(cArray, c2);
        if (n2 == -1) {
            return ArrayUtils.clone(cArray);
        }
        return ArrayUtils.remove(cArray, n2);
    }

    public static double[] remove(double[] dArray, int n2) {
        return (double[])ArrayUtils.remove((Object)dArray, n2);
    }

    public static double[] removeElement(double[] dArray, double d2) {
        int n2 = ArrayUtils.indexOf(dArray, d2);
        if (n2 == -1) {
            return ArrayUtils.clone(dArray);
        }
        return ArrayUtils.remove(dArray, n2);
    }

    public static float[] remove(float[] fArray, int n2) {
        return (float[])ArrayUtils.remove((Object)fArray, n2);
    }

    public static float[] removeElement(float[] fArray, float f2) {
        int n2 = ArrayUtils.indexOf(fArray, f2);
        if (n2 == -1) {
            return ArrayUtils.clone(fArray);
        }
        return ArrayUtils.remove(fArray, n2);
    }

    public static int[] remove(int[] nArray, int n2) {
        return (int[])ArrayUtils.remove((Object)nArray, n2);
    }

    public static int[] removeElement(int[] nArray, int n2) {
        int n3 = ArrayUtils.indexOf(nArray, n2);
        if (n3 == -1) {
            return ArrayUtils.clone(nArray);
        }
        return ArrayUtils.remove(nArray, n3);
    }

    public static long[] remove(long[] lArray, int n2) {
        return (long[])ArrayUtils.remove((Object)lArray, n2);
    }

    public static long[] removeElement(long[] lArray, long l2) {
        int n2 = ArrayUtils.indexOf(lArray, l2);
        if (n2 == -1) {
            return ArrayUtils.clone(lArray);
        }
        return ArrayUtils.remove(lArray, n2);
    }

    public static short[] remove(short[] sArray, int n2) {
        return (short[])ArrayUtils.remove((Object)sArray, n2);
    }

    public static short[] removeElement(short[] sArray, short s2) {
        int n2 = ArrayUtils.indexOf(sArray, s2);
        if (n2 == -1) {
            return ArrayUtils.clone(sArray);
        }
        return ArrayUtils.remove(sArray, n2);
    }

    private static Object remove(Object object, int n2) {
        int n3 = ArrayUtils.getLength(object);
        if (n2 < 0 || n2 >= n3) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Length: " + n3);
        }
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n3 - 1);
        System.arraycopy(object, 0, object2, 0, n2);
        if (n2 < n3 - 1) {
            System.arraycopy(object, n2 + 1, object2, n2, n3 - n2 - 1);
        }
        return object2;
    }
}

