/*
 * Decompiled with CFR 0.152.
 */
package com.fr.script;

import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.general.PageCalObj;
import com.fr.parser.FRLexer;
import com.fr.parser.FRParser;
import com.fr.script.Variable;
import com.fr.stable.ColumnRow;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.CalculatorProviderContext;
import com.fr.stable.script.ColumnRowHunter;
import com.fr.stable.script.ColumnRowRange;
import com.fr.stable.script.Expression;
import com.fr.stable.script.Function;
import com.fr.stable.script.NameSpace;
import com.fr.stable.script.Node;
import com.fr.stable.script.Tiny;
import com.fr.stable.script.TinyHunter;
import com.fr.third.antlr.ANTLRException;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Calculator
implements CalculatorProvider,
Serializable,
Cloneable {
    private static final Object COLUMNROW = new Object();
    private static ThreadLocal savedVariables = new ThreadLocal();
    private static ThreadLocal savedSessionNameSpace = new ThreadLocal();
    private NameSpaceChain globalNameSpace = new NameSpaceChain();
    private Map parsedExpression = new ConcurrentHashMap();
    private Map attributes = new ConcurrentHashMap();
    public static final Object CONNECTIONS_KEY = new Object();

    private Calculator() {
    }

    public static Calculator createCalculator() {
        Calculator calculator = new Calculator();
        calculator.pushNameSpace(StableFactory.getDefaultNameSpace());
        return calculator;
    }

    public ColumnRow getCurrentColumnRow() {
        return (ColumnRow)this.attributes.get(COLUMNROW);
    }

    public void setCurrentColumnRow(ColumnRow columnRow) {
        this.attributes.put(COLUMNROW, columnRow);
    }

    public static void putThreadSavedNameSpace(NameSpace nameSpace) {
        savedSessionNameSpace.set(nameSpace);
    }

    public static void setThreadSavedParameter(String string, Object object) {
        HashMap<String, Object> hashMap = (HashMap<String, Object>)savedVariables.get();
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
            savedVariables.set(hashMap);
        }
        hashMap.put(string, object);
    }

    public static void clearThreadSavedParameter() {
        savedVariables.set(null);
    }

    public static Object getSavedVariables() {
        return savedVariables.get();
    }

    public static Object getSavedSessionNameSpace() {
        return savedSessionNameSpace.get();
    }

    public static ParameterProvider[] processParameters(CalculatorProvider calculatorProvider, ParameterProvider[] parameterProviderArray) {
        if (parameterProviderArray == null) {
            return new ParameterProvider[0];
        }
        ParameterProvider[] parameterProviderArray2 = new ParameterProvider[parameterProviderArray.length];
        for (int i2 = 0; i2 < parameterProviderArray.length; ++i2) {
            parameterProviderArray2[i2] = parameterProviderArray[i2];
            if (parameterProviderArray2[i2] == null) continue;
            Object object = calculatorProvider == null ? null : calculatorProvider.resolveVariable(parameterProviderArray2[i2].getName());
            try {
                parameterProviderArray2[i2] = (ParameterProvider)parameterProviderArray2[i2].clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            }
            if (object == null) continue;
            parameterProviderArray2[i2].setCalculateValue(object);
        }
        return parameterProviderArray2;
    }

    public void setAttribute(Object object, Object object2) {
        if (object2 == null) {
            this.attributes.remove(object);
        } else {
            this.attributes.put(object, object2);
        }
    }

    public Object setNewAttribute(Object object, Object object2) {
        Object object3 = this.getAttribute(object);
        if (object2 == null) {
            this.removeAttribute(object);
        } else {
            this.setAttribute(object, object2);
        }
        return object3;
    }

    public Object getAttribute(Object object) {
        return this.attributes.get(object);
    }

    public void removeAttribute(Object object) {
        this.attributes.remove(object);
    }

    public void set(String string, Object object) {
        this.globalNameSpace.set(string, object);
    }

    public void remove(String string) {
        this.globalNameSpace.remove(string);
    }

    public void pushNameSpace(NameSpace nameSpace) {
        this.globalNameSpace.namespaceList.addFirst(nameSpace);
    }

    public boolean removeNameSpace(NameSpace nameSpace) {
        return this.globalNameSpace.namespaceList.remove(nameSpace);
    }

    public Object resolveVariable(Object object) {
        Object object2 = this.resolveVariableInCE(object);
        if (object2 == null) {
            return null;
        }
        return CalculatorProviderContext.getValueConverter().result2Value(object2);
    }

    public Object resolveVariableInCE(Object object) {
        return this.globalNameSpace.getVariable(object, this);
    }

    public Function resolveMethod(Object object) {
        return this.globalNameSpace.getMethod(object, this);
    }

    public Object resolveRelateCellElements(ColumnRow columnRow) {
        return this.globalNameSpace.getRelateCellElements(columnRow, this);
    }

    public Expression parse(Object object) throws ANTLRException {
        if (object instanceof Expression) {
            return (Expression)object;
        }
        return this.parse(GeneralUtils.objectToString(object));
    }

    public Expression parse(String string) throws ANTLRException {
        Expression expression;
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).startsWith("=")) {
            string = string.substring(1);
        }
        if ((expression = (Expression)this.parsedExpression.get(string)) == null) {
            StringReader stringReader = new StringReader(string);
            FRLexer fRLexer = new FRLexer(stringReader);
            FRParser fRParser = new FRParser(fRLexer);
            if (StringUtils.isNotEmpty(string)) {
                expression = fRParser.parse();
            }
            if (expression != null) {
                this.parsedExpression.put(string, expression);
            }
        }
        return expression;
    }

    public Object evalValue(String string) throws UtilEvalError {
        Object object = this.eval(string);
        if (object == null) {
            return null;
        }
        object = CalculatorProviderContext.getValueConverter().result2Value(object);
        return object;
    }

    public Object evalValue(FormulaProvider formulaProvider) throws UtilEvalError {
        Object object = this.eval(formulaProvider);
        if (object == null) {
            return null;
        }
        object = CalculatorProviderContext.getValueConverter().result2Value(object);
        return object;
    }

    public Object evalValue(Node node) throws UtilEvalError {
        Object object = this.eval(node);
        if (object == null) {
            return null;
        }
        object = CalculatorProviderContext.getValueConverter().result2Value(object);
        return object;
    }

    public Object eval(String string) throws UtilEvalError {
        Object object;
        try {
            object = this.evalString(string);
        }
        catch (UtilEvalError utilEvalError) {
            utilEvalError.addFormulaContent(string.toString());
            throw utilEvalError;
        }
        return object;
    }

    public Object eval(FormulaProvider formulaProvider) throws UtilEvalError {
        Object object;
        try {
            object = this.evalString(formulaProvider.getContent());
        }
        catch (UtilEvalError utilEvalError) {
            utilEvalError.addFormulaContent(formulaProvider.toString());
            throw utilEvalError;
        }
        return object;
    }

    public Object eval(Node node) throws UtilEvalError {
        Object object;
        try {
            object = node.eval(this);
        }
        catch (UtilEvalError utilEvalError) {
            utilEvalError.addFormulaContent(node.toString());
            throw utilEvalError;
        }
        return object;
    }

    private Object evalString(String string) throws UtilEvalError {
        Expression expression = null;
        if (string != null) {
            try {
                expression = this.parse(string);
            }
            catch (ANTLRException aNTLRException) {
                if (string.indexOf(" ") != -1) {
                    string = string.replaceAll(" ", "");
                    try {
                        expression = this.parse(string);
                    }
                    catch (ANTLRException aNTLRException2) {
                        // empty catch block
                    }
                    return expression == null ? Primitive.NULL : expression.eval(this);
                }
                if (this.getAttribute(ColumnRow.class) != null) {
                    StringBuffer stringBuffer = new StringBuffer().append(Inter.getLocText("Error_Cell")).append(":").append(this.getAttribute(ColumnRow.class)).append(Inter.getLocText("Error_Statement_Is")).append("\"").append(string).append('\"').append('\n').append(aNTLRException.getMessage());
                    FRLogger.getLogger().error(stringBuffer.toString(), aNTLRException);
                }
                FRLogger.getLogger().error(Inter.getLocText("Error_Statement_Is") + "\"" + string + "\"", aNTLRException);
            }
        }
        if (expression == null) {
            return null;
        }
        if (expression.delay4PageCal()) {
            return PageCalObj.MARK;
        }
        return expression.eval(this);
    }

    public static ColumnRowRange[] relatedColumnRowRangeArray(String string) throws ANTLRException {
        Expression expression = new Calculator().parse(string);
        if (expression == null) {
            return new ColumnRowRange[0];
        }
        ColumnRowHunter columnRowHunter = new ColumnRowHunter();
        expression.traversal4Tiny(columnRowHunter);
        return columnRowHunter.getColumnRowRangeBooty();
    }

    public static String[] relatedParameters(String string) throws ANTLRException {
        Expression expression = new Calculator().parse(string);
        if (expression == null) {
            return new String[0];
        }
        ParameterHunter parameterHunter = new ParameterHunter();
        expression.traversal4Tiny(parameterHunter);
        return parameterHunter.getParameterBooty();
    }

    public void putConnection(String string, Connection connection) {
        HashMap<String, Connection> hashMap = (HashMap<String, Connection>)this.getAttribute(CONNECTIONS_KEY);
        if (hashMap == null) {
            hashMap = new HashMap<String, Connection>();
            this.setAttribute(CONNECTIONS_KEY, hashMap);
        }
        hashMap.put(string, connection);
    }

    public Connection getConnection(String string) {
        Map map = (Map)this.getAttribute(CONNECTIONS_KEY);
        if (map == null) {
            return null;
        }
        return (Connection)map.get(string);
    }

    public void removeConnection(String string) {
        Map map = (Map)this.getAttribute(CONNECTIONS_KEY);
        if (map == null) {
            return;
        }
        map.remove(string);
    }

    public String exStatement(ColumnRow columnRow, String string) {
        this.setAttribute(ColumnRow.class, columnRow);
        Expression expression = null;
        try {
            expression = this.parse(string);
        }
        catch (ANTLRException aNTLRException) {
            if (this.getAttribute(ColumnRow.class) != null) {
                StringBuffer stringBuffer = new StringBuffer().append("Error Cell: ").append(this.getAttribute(ColumnRow.class)).append(" and statement is \"").append(string).append('\"').append('\n').append(aNTLRException.getMessage());
                FRLogger.getLogger().error(stringBuffer.toString(), aNTLRException);
            }
            FRLogger.getLogger().error("error statement is \"" + string + "\"", aNTLRException);
        }
        return expression == null ? string : expression.exString(this);
    }

    public String onAddDeleteColumnOrRow(String string, int n2, int n3, int n4, int n5) {
        Expression expression = null;
        try {
            expression = this.parse(string);
        }
        catch (ANTLRException aNTLRException) {
            if ((ColumnRow)this.getAttribute(ColumnRow.class) != null) {
                StringBuffer stringBuffer = new StringBuffer().append("Error Cell: ").append(this.getAttribute(ColumnRow.class)).append(" and statement is \"").append(string).append('\"').append('\n').append(aNTLRException.getMessage());
                FRLogger.getLogger().error(stringBuffer.toString(), aNTLRException);
            }
            FRLogger.getLogger().error("error statement is \"" + string + "\"", aNTLRException);
        }
        return expression == null ? string : expression.getExpression(n2, n3, n4, n5, true);
    }

    public LinkedList getNameSpaceList() {
        return this.globalNameSpace.namespaceList;
    }

    protected static class NameSpaceChain
    implements NameSpace {
        private Map variables = new HashMap();
        private LinkedList namespaceList = new LinkedList();

        protected NameSpaceChain() {
        }

        public Function getMethod(Object object, CalculatorProvider calculatorProvider) {
            Function function = null;
            int n2 = this.namespaceList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                function = ((NameSpace)this.namespaceList.get(i2)).getMethod(object, calculatorProvider);
                if (function == null) continue;
                return function;
            }
            return null;
        }

        public void remove(String string) {
            this.variables.remove(string);
        }

        public Object getRelateCellElements(ColumnRow columnRow, CalculatorProvider calculatorProvider) {
            Object object = null;
            int n2 = this.namespaceList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                object = ((NameSpace)this.namespaceList.get(i2)).getRelateCellElements(columnRow, calculatorProvider);
                if (object == null) continue;
                return object;
            }
            return object;
        }

        public Object getVariable(Object object, CalculatorProvider calculatorProvider) {
            if (object == null) {
                return null;
            }
            Object object2 = null;
            if (!this.variables.isEmpty() && (object2 = this.unwrapVariable((Variable)this.variables.get(object.toString().toUpperCase()))) != null) {
                return object2;
            }
            int n2 = this.namespaceList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                object2 = ((NameSpace)this.namespaceList.get(i2)).getVariable(object, calculatorProvider);
                if (object2 == null) continue;
                return object2;
            }
            return null;
        }

        private Object unwrapVariable(Variable variable) {
            return variable == null ? null : variable.getValue();
        }

        private void set(Object object, Object object2) {
            Variable variable;
            if (object == null) {
                return;
            }
            object = object.toString().toUpperCase();
            if (object2 == null) {
                object2 = Primitive.NULL;
            }
            if ((variable = (Variable)this.variables.get(object)) != null) {
                variable.setValue(object2);
            } else {
                this.variables.put(object, new Variable(object2));
            }
        }
    }

    private static class ParameterHunter
    extends TinyHunter {
        private List parameterList = new ArrayList();

        private ParameterHunter() {
        }

        public String[] getParameterBooty() {
            return this.parameterList.toArray(new String[this.parameterList.size()]);
        }

        public void hunter4Tiny(Tiny tiny) {
            String string = tiny.getStatement();
            if (StringUtils.isNotBlank(string) && string.startsWith("$") && !this.parameterList.contains(string)) {
                this.parameterList.add(string);
            }
        }
    }
}

