/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.util;

import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.Parameter;
import com.fr.base.TableData;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.impl.TableColumn;
import com.fr.file.DatasourceManager;
import com.fr.general.DateUtils;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.general.data.DataModel;
import com.fr.schedule.output.FileRepository;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ListMap;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleUtils {
    private static FRLogger log = FRLogger.getLogger();

    public static void calculatorParameters(Parameter[] parameterArray, List<Map> list, List<Parameter> list2) {
        ListMap listMap = new ListMap();
        List<Map> list3 = new ArrayList<Map>();
        ArrayList arrayList = new ArrayList();
        list3.add(listMap);
        ListMap listMap2 = new ListMap();
        for (Parameter parameter : parameterArray) {
            Object object = parameter.getValue();
            if (object instanceof TableColumn) {
                TableColumn tableColumn = (TableColumn)object;
                ScheduleUtils.processTableColumn(tableColumn, listMap2, parameter);
                continue;
            }
            if (object instanceof Formula) {
                listMap.put(parameter.getName(), object);
                continue;
            }
            int n2 = list3.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                list3.get(i2).put(parameter.getName(), parameter.getValue());
            }
        }
        for (String string : listMap2.keySet()) {
            list3 = ScheduleUtils.processTdName(string, list3, listMap2);
        }
        list.addAll(list3);
        list2.addAll(arrayList);
    }

    private static void processTableColumn(TableColumn tableColumn, Map map, Parameter parameter) {
        if (map.containsKey(tableColumn.getTableDataName())) {
            List list = (List)map.get(tableColumn.getTableDataName());
            list.add(parameter);
        } else {
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
            map.put(tableColumn.getTableDataName(), arrayList);
            arrayList.add(parameter);
        }
    }

    private static List<Map> processFArray(Parameter parameter, Object object, List<Map> list, List<Parameter> list2) {
        try {
            list2.add(new Parameter(parameter.getName(), object));
            ArrayList<ListMap> arrayList = new ArrayList<ListMap>();
            FArray fArray = (FArray)object;
            int n2 = fArray.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                ListMap listMap = new ListMap();
                listMap.put(parameter.getName(), fArray.elementAt(i2));
                arrayList.add(listMap);
            }
            return ScheduleUtils.cartesian(list, arrayList);
        }
        catch (Exception exception) {
            ScheduleLogUtils.error(exception);
            return new ArrayList<Map>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static List<Map> processTdName(String string, List<Map> list, Map map) {
        DataModel dataModel = null;
        TableData tableData = DataCoreUtils.getClonedTableData(DatasourceManager.getInstance(), string);
        List list2 = (List)map.get(string);
        dataModel = tableData.createDataModel(null);
        ArrayList<ListMap> arrayList = new ArrayList<ListMap>();
        int n2 = dataModel.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ListMap listMap = new ListMap();
            int n3 = list2.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                Parameter parameter = (Parameter)list2.get(i3);
                int n4 = ((TableColumn)parameter.getValue()).getColumnIndex();
                listMap.put(parameter.getName(), dataModel.getValueAt(i2, n4));
            }
            arrayList.add(listMap);
        }
        List list3 = ScheduleUtils.cartesian(list, arrayList);
        Object var15_16 = null;
        try {
            dataModel.release();
        }
        catch (Exception exception) {
            ScheduleLogUtils.error(exception);
        }
        return list3;
        catch (Exception exception) {
            try {
                ScheduleLogUtils.error(exception);
                Object var15_17 = null;
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                try {
                    dataModel.release();
                }
                catch (Exception exception2) {
                    ScheduleLogUtils.error(exception2);
                }
                throw throwable;
            }
            try {
                dataModel.release();
            }
            catch (Exception exception3) {
                ScheduleLogUtils.error(exception3);
            }
        }
        return new ArrayList<Map>();
    }

    public static List cartesian(List list, List list2) {
        ArrayList<ListMap> arrayList = new ArrayList<ListMap>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                ListMap listMap = new ListMap();
                listMap.putAll((Map)list.get(i2));
                listMap.putAll((Map)list2.get(i3));
                arrayList.add(listMap);
            }
        }
        return arrayList;
    }

    public static String getScheduleSavaPath(String string, String string2, String string3) {
        if (FRContext.getCurrentEnv() != null) {
            return new StringBuffer().append(FRContext.getCurrentEnv().getPath()).append(File.separator).append("schedule").append(File.separator).append(string2).append(File.separator).append(string3).append(File.separator).toString();
        }
        return "";
    }

    public static File createDirectoryFromTaskNameAndActionName(String string, String string2) {
        return new File(StableUtils.pathJoin(new String[]{FRContext.getCurrentEnv().getPath(), "schedule", string, string2}));
    }

    private static List generateTriggerTimes(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = new File(FRContext.getCurrentEnv().getPath() + File.separator + "schedule" + File.separator + string).listFiles();
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String[] stringArray = fileArray[i2].list();
            int n3 = stringArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                arrayList.add(fileArray[i2].getName() + " " + stringArray[i3].substring(0, 2) + ":" + stringArray[i3].substring(2, stringArray[i3].length()));
            }
        }
        return arrayList;
    }

    public static File getScheduleSavaPathFile(String[] stringArray) {
        if (ArrayUtils.isEmpty(stringArray)) {
            return null;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        if (FRContext.getCurrentEnv() != null && StringUtils.isNotBlank(string) && StringUtils.isNotBlank(string3)) {
            String string4 = new StringBuffer().append(FRContext.getCurrentEnv().getPath()).append(File.separator).append("schedule").append(File.separator).append(string).append(File.separator).append(string2).append(File.separator).toString();
            if (StringUtils.isNotEmpty(string3)) {
                return new File(new StringBuffer().append(string4).append(string3).append(File.separator).toString());
            }
            File file = new File(string4);
            if (file.exists()) {
                return file.listFiles()[0];
            }
        }
        return null;
    }

    public static File getScheduleSavaPathFile(Map map) {
        String string = ((String)map.get("task")).replaceAll("\"", "");
        String string2 = ((String)map.get("triggerTime")).replaceAll("\"", "");
        String[] stringArray = string2.trim().split("\\s+");
        if (stringArray.length < 2) {
            stringArray = new String[]{stringArray[0], ""};
        }
        stringArray[1] = stringArray[1].replaceAll(":", "");
        if (stringArray[1].length() > 4) {
            stringArray[1] = stringArray[1].substring(0, 4);
        }
        String[] stringArray2 = new String[3];
        stringArray2[0] = string;
        System.arraycopy(stringArray, 0, stringArray2, 1, 2);
        return ScheduleUtils.getScheduleSavaPathFile(stringArray2);
    }

    public static Map getParaMap(Map map) {
        HashMap hashMap = new HashMap();
        for (String string : map.keySet()) {
            if (string.equalsIgnoreCase("task") || string.equalsIgnoreCase("triggerTime") || string.equalsIgnoreCase("action")) continue;
            hashMap.put(string, map.get(string));
        }
        return hashMap;
    }

    public static File getTaskTimeDirFile(FileRepository fileRepository, String string, Date date) {
        String string2 = DateUtils.TIMEFORMAT2.format(date);
        return new File(fileRepository.getTaskDirFile(string + File.separator + DateUtils.DATEFORMAT2.format(date)), string2);
    }

    private Date getTaskTimeByDir(String string) {
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        String[] stringArray = string.split("\\\\");
        if (stringArray.length < 3) {
            stringArray = string.split("/");
        }
        if (stringArray.length > 2) {
            try {
                Date date = DateUtils.DATEFORMAT2.parse(stringArray[stringArray.length - 3]);
                Date date2 = DateUtils.TIMEFORMAT2.parse(stringArray[stringArray.length - 2]);
                date.setHours(date2.getHours());
                date.setMinutes(date2.getMinutes());
                return date;
            }
            catch (ParseException parseException) {
                ScheduleLogUtils.error(parseException);
                return null;
            }
        }
        return null;
    }

    public static String createOutputReportName(String string, int n2, String[] stringArray) {
        if (stringArray.length < 1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append("_");
        stringBuilder.append("[");
        int n3 = stringArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuilder.append(stringArray[i2]).append("_").append(n2);
            if (i2 >= n3 - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

