/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.entry;

import com.fr.fs.schedule.ScheduleContext;
import com.fr.fs.schedule.job.AnalyReportletJob;
import com.fr.fs.schedule.job.ViewReportletJob;
import com.fr.fs.schedule.job.WriteReportletJob;
import com.fr.fs.schedule.trigger.ITrigger;
import com.fr.fs.schedule.trigger.OnceITrigger;
import com.fr.fs.schedule.trigger.TriggerFactory;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.schedule.output.ScheduledOutput;
import com.fr.schedule.task.ItriggerTask;
import com.fr.schedule.task.ScheduleTask;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.schedule.util.TaskConfig;
import com.fr.third.org.quartz.JobDetail;
import com.fr.third.org.quartz.Scheduler;
import com.fr.third.org.quartz.SchedulerException;
import com.fr.third.org.quartz.Trigger;
import com.fr.web.platform.TransmitParameters;
import java.util.Date;
import java.util.List;

public class EntryManager {
    private static FRLogger log = FRLogger.getLogger();

    public static JSONArray getTasks(long l2) {
        JSONArray jSONArray = new JSONArray();
        List list = ScheduleContext.createDAOSession().listByFieldValue(ScheduleTask.class, "groupId", new Long(l2));
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ScheduleTask scheduleTask = (ScheduleTask)list.get(i2);
            try {
                JSONObject jSONObject = scheduleTask.createJSONConfig();
                jSONArray.put(jSONObject);
                continue;
            }
            catch (JSONException jSONException) {
                ScheduleLogUtils.error(jSONException);
            }
        }
        return jSONArray;
    }

    public static JSONArray getAllTasks() {
        JSONArray jSONArray = new JSONArray();
        List list = ScheduleContext.createDAOSession().list(ScheduleTask.class);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ScheduleTask scheduleTask = (ScheduleTask)list.get(i2);
            try {
                JSONObject jSONObject = scheduleTask.createJSONConfig();
                jSONArray.put(jSONObject);
                continue;
            }
            catch (JSONException jSONException) {
                ScheduleLogUtils.error(jSONException);
            }
        }
        return jSONArray;
    }

    public static ITrigger parseITrigger(JSONObject jSONObject) {
        ITrigger iTrigger = null;
        try {
            String string = jSONObject.getString("recurrenceType");
            iTrigger = TriggerFactory.createTriggerByName(string).analyzeJSON(jSONObject);
        }
        catch (JSONException jSONException) {
            ScheduleLogUtils.error(jSONException);
        }
        return iTrigger;
    }

    public static ScheduleTask addOrUpdateTask(JSONObject jSONObject) {
        try {
            ScheduleTask scheduleTask = jSONObject.has("id") ? EntryManager.updateTask(jSONObject) : EntryManager.addTask(jSONObject);
            return scheduleTask;
        }
        catch (Exception exception) {
            ScheduleLogUtils.error(exception);
            return null;
        }
    }

    public static ScheduleTask updateTask(JSONObject jSONObject) {
        try {
            Object object;
            String string = jSONObject.getString("name");
            String string2 = jSONObject.getString("repeatTime");
            String string3 = jSONObject.getString("repeatTimes");
            String string4 = jSONObject.getString("executeFormula");
            String string5 = jSONObject.getString("executeClass");
            int n2 = jSONObject.getInt("executeType");
            ITrigger iTrigger = EntryManager.parseITrigger(jSONObject.getJSONObject("iTrigger"));
            String string6 = jSONObject.getString("reportletPath");
            int n3 = jSONObject.getInt("showType");
            JSONArray jSONArray = jSONObject.getJSONArray("transmitParameters");
            TransmitParameters transmitParameters = TransmitParameters.parseJSON(jSONArray);
            ScheduledOutput scheduledOutput = null;
            if (jSONObject.has("scheduledOutput")) {
                object = jSONObject.getJSONObject("scheduledOutput");
                scheduledOutput = ScheduledOutput.analyzeJSON((JSONObject)object);
            }
            object = null;
            ITrigger iTrigger2 = null;
            object = (ScheduleTask)ScheduleContext.createDAOSession().load(ScheduleTask.class, jSONObject.getLong("id"));
            iTrigger2 = ((ItriggerTask)object).getITrigger();
            ((ItriggerTask)object).setName(string);
            ((ItriggerTask)object).setITrigger(iTrigger);
            ((ItriggerTask)object).setCounts(0);
            ((ItriggerTask)object).setTaskParameters(transmitParameters);
            ((ScheduleTask)object).setReportletPath(string6);
            ((ScheduleTask)object).setShowType(n3);
            ((ScheduleTask)object).setScheduledOutput(scheduledOutput);
            ((ItriggerTask)object).setRepeatTime(string2);
            ((ItriggerTask)object).setRepeatTimes(string3);
            ((ScheduleTask)object).setExecuteType(n2);
            ((ScheduleTask)object).setExecuteFormula(string4);
            ((ScheduleTask)object).setExecuteClass(string5);
            ScheduleContext.createDAOSession().saveOrUpdate(object);
            EntryManager.scheduleTask((ScheduleTask)object, false, iTrigger2);
            return object;
        }
        catch (JSONException jSONException) {
            ScheduleLogUtils.error(jSONException);
            return null;
        }
    }

    public static ScheduleTask addTask(JSONObject jSONObject) {
        try {
            Object object;
            String string = jSONObject.getString("name");
            String string2 = jSONObject.getString("repeatTime");
            String string3 = jSONObject.getString("repeatTimes");
            String string4 = jSONObject.getString("executeFormula");
            String string5 = jSONObject.getString("executeClass");
            int n2 = jSONObject.getInt("executeType");
            ITrigger iTrigger = EntryManager.parseITrigger(jSONObject.getJSONObject("iTrigger"));
            String string6 = jSONObject.getString("reportletPath");
            int n3 = jSONObject.getInt("showType");
            JSONArray jSONArray = jSONObject.getJSONArray("transmitParameters");
            TransmitParameters transmitParameters = TransmitParameters.parseJSON(jSONArray);
            ScheduledOutput scheduledOutput = null;
            if (jSONObject.has("scheduledOutput")) {
                object = jSONObject.getJSONObject("scheduledOutput");
                scheduledOutput = ScheduledOutput.analyzeJSON((JSONObject)object);
            }
            ITrigger iTrigger2 = null;
            TaskConfig taskConfig = new TaskConfig();
            taskConfig.setName(string);
            taskConfig.setDescription("");
            taskConfig.setiTrigger(iTrigger);
            taskConfig.setTaskParameters(transmitParameters);
            taskConfig.setScheduledOutput(scheduledOutput);
            taskConfig.setReportletPath(string6);
            taskConfig.setShowType(n3);
            taskConfig.setRepeatTime(string2);
            taskConfig.setRepeatTimes(string3);
            taskConfig.setExecuteType(n2);
            taskConfig.setExecuteFormula(string4);
            taskConfig.setExecuteClass(string5);
            object = new ScheduleTask(taskConfig);
            ScheduleContext.createDAOSession().saveOrUpdate(object);
            EntryManager.scheduleTask((ScheduleTask)object, false, iTrigger2);
            return object;
        }
        catch (JSONException jSONException) {
            ScheduleLogUtils.error(jSONException);
            return null;
        }
    }

    public static void scheduleTask(ScheduleTask scheduleTask, boolean bl, ITrigger iTrigger) {
        JobDetail jobDetail = new JobDetail(scheduleTask.getName(), scheduleTask.getReportletPath(), EntryManager.getReportJobClass(scheduleTask.getShowType()));
        Object object = ScheduleContext.createDAOSession().load(ScheduleTask.class, scheduleTask.getId());
        if (object == null && bl) {
            return;
        }
        if (bl) {
            jobDetail.setName(jobDetail.getName() + Math.random() * 10000.0);
        }
        jobDetail.setDescription(scheduleTask.getDescription());
        jobDetail.getJobDataMap().put("__task__", scheduleTask.getId());
        jobDetail.getJobDataMap().put("__reportletpath__", scheduleTask.getReportletPath());
        if (bl) {
            jobDetail.getJobDataMap().put((Object)"__restarttask__", (Object)scheduleTask);
        }
        ITrigger iTrigger2 = scheduleTask.getITrigger();
        Trigger trigger = iTrigger2.createTrigger();
        if (bl) {
            trigger.setName(trigger.getName() + "_Restart_" + Math.random());
        }
        trigger.setJobName(jobDetail.getName());
        trigger.setJobGroup(jobDetail.getGroup());
        Scheduler scheduler = ScheduleContext.getScheduler();
        try {
            Trigger[] triggerArray = scheduler.getTriggersOfJob(jobDetail.getName(), jobDetail.getGroup());
            if (triggerArray.length > 0 && iTrigger != null) {
                scheduler.rescheduleJob(iTrigger.createTrigger().getName(), iTrigger.createTrigger().getGroup(), trigger);
            } else {
                scheduler.scheduleJob(jobDetail, trigger);
            }
        }
        catch (SchedulerException schedulerException) {
            ScheduleLogUtils.error(schedulerException);
        }
    }

    public static void reStartTask(ScheduleTask scheduleTask, long l2) {
        scheduleTask.setCounts(scheduleTask.getCounts() + 1);
        ScheduleTask scheduleTask2 = null;
        try {
            scheduleTask2 = scheduleTask.clone4Exe();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            log.error(cloneNotSupportedException.getMessage());
        }
        if (scheduleTask2.getCounts() > Integer.parseInt(scheduleTask.getRepeatTimes()) || Integer.parseInt(scheduleTask.getRepeatTimes()) == 0) {
            return;
        }
        OnceITrigger onceITrigger = new OnceITrigger();
        onceITrigger.setStartType(2L);
        onceITrigger.setId(scheduleTask.getITrigger().getId());
        onceITrigger.setStartTime(new Date(new Date().getTime() + l2));
        scheduleTask2.setITrigger(onceITrigger);
        EntryManager.scheduleTask(scheduleTask2, true, onceITrigger);
    }

    public static void delTasks(String string) {
        String[] stringArray = string.split(",");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            long l2 = Long.parseLong(stringArray[i2]);
            Object object = ScheduleContext.createDAOSession().load(ScheduleTask.class, l2);
            EntryManager.deleteTask((ScheduleTask)object);
        }
    }

    private static void deleteTask(ScheduleTask scheduleTask) {
        Scheduler scheduler = ScheduleContext.getScheduler();
        try {
            scheduler.deleteJob(scheduleTask.getName(), scheduleTask.getReportletPath());
        }
        catch (SchedulerException schedulerException) {
            ScheduleLogUtils.error(schedulerException);
        }
        ScheduleContext.createDAOSession().delete(scheduleTask);
    }

    private static Class getReportJobClass(int n2) {
        switch (n2) {
            case 0: {
                return WriteReportletJob.class;
            }
            case 1: {
                return ViewReportletJob.class;
            }
            case 2: {
                return AnalyReportletJob.class;
            }
        }
        return ViewReportletJob.class;
    }

    public static int stateJob(long l2) {
        int n2 = -1;
        Scheduler scheduler = ScheduleContext.getScheduler();
        ScheduleTask scheduleTask = (ScheduleTask)ScheduleContext.createDAOSession().load(ScheduleTask.class, l2);
        try {
            Trigger[] triggerArray = scheduler.getTriggersOfJob(scheduleTask.getName(), scheduleTask.getReportletPath());
            if (triggerArray.length > 0) {
                Trigger trigger = triggerArray[0];
                n2 = scheduler.getTriggerState(trigger.getName(), trigger.getGroup());
                if (n2 == 0) {
                    scheduler.pauseJob(trigger.getJobName(), trigger.getJobGroup());
                } else {
                    scheduler.resumeJob(trigger.getJobName(), trigger.getJobGroup());
                }
                n2 = scheduler.getTriggerState(trigger.getName(), trigger.getGroup());
            }
        }
        catch (SchedulerException schedulerException) {
            ScheduleLogUtils.error(schedulerException);
        }
        return n2;
    }
}

