/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule;

import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.Column;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.RelationFCMapper;
import com.fr.fs.AbstractFSPlate;
import com.fr.fs.control.dao.tabledata.TableDataDAOControl;
import com.fr.fs.dao.EntryDAO;
import com.fr.fs.dao.FSDAOManager;
import com.fr.fs.dao.ReportletEntryDAO;
import com.fr.fs.dao.properties.ScheduleDAOProperties;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.fs.schedule.ScheduleLinkOutput;
import com.fr.fs.schedule.entry.ReportletEntry;
import com.fr.fs.schedule.trigger.CalendarITrigger;
import com.fr.fs.schedule.trigger.CronExpressionITrigger;
import com.fr.fs.schedule.trigger.OnceITrigger;
import com.fr.fs.schedule.trigger.SimpleITrigger;
import com.fr.general.FRLogger;
import com.fr.general.VT4FR;
import com.fr.report.module.EngineModuleFactory;
import com.fr.schedule.ScheduleSearch;
import com.fr.schedule.output.ClassOutputFileAction;
import com.fr.schedule.output.EmailNotification;
import com.fr.schedule.output.FTPTransmission;
import com.fr.schedule.output.FileActionList;
import com.fr.schedule.output.PrintRWorkbookAction;
import com.fr.schedule.output.ScheduledOutput;
import com.fr.schedule.task.SAPSynTask;
import com.fr.schedule.task.ScheduleTask;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.schedule.web.SAPTransferTimerService;
import com.fr.schedule.web.ScheduleReportletGenerator;
import com.fr.schedule.web.ScheduleService;
import com.fr.schedule.web.TimerService;
import com.fr.stable.fun.Service;
import com.fr.third.org.quartz.SchedulerException;
import com.fr.web.platform.entry.FileEntry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulePlate
extends AbstractFSPlate {
    private static FRLogger log = FRLogger.getLogger();
    public static ObjectTableMapper[] scheduleTableMappers = new ObjectTableMapper[]{ScheduleTask.OBJECT_MAPPER, ScheduledOutput.OBJECT_MAPPER, FileActionList.OBJECT_MAPPER, EmailNotification.OBJECT_MAPPER, FTPTransmission.OBJECT_MAPPER, PrintRWorkbookAction.OBJECT_MAPPER, ClassOutputFileAction.OBJECT_MAPPER, OnceITrigger.OBJECT_MAPPER, SimpleITrigger.OBJECT_MAPPER, CalendarITrigger.OBJECT_MAPPER, CronExpressionITrigger.OBJECT_MAPPER, ScheduleLinkOutput.OBJECT_MAPPER, ReportletEntry.TABLE_MAPPER, FileEntry.TABLE_MAPPER, SAPSynTask.OBJECT_MAPPER};

    @Override
    public void initData() {
        EngineModuleFactory.registerReportletGenerator(ScheduleReportletGenerator.getInstance());
        EngineModuleFactory.registerTemplateWorkBookSearch(ScheduleSearch.getInstance());
    }

    @Override
    public Service[] service4Register() {
        return new Service[]{new ScheduleService(), new TimerService(), new SAPTransferTimerService()};
    }

    @Override
    public ObjectTableMapper[] mappers4Register() {
        ScheduleDAOProperties scheduleDAOProperties = ScheduleDAOProperties.getInstance();
        for (int i2 = 0; i2 < scheduleTableMappers.length; ++i2) {
            scheduleDAOProperties.addTableMapper(scheduleTableMappers[i2]);
        }
        return scheduleDAOProperties.getAllObjTableMappers();
    }

    @Override
    public Class getRelationClass() {
        return null;
    }

    @Override
    public TableDataDAOControl.ColumnColumn[] getTableDataColumns() {
        return new TableDataDAOControl.ColumnColumn[0];
    }

    @Override
    public FieldColumnMapper[] columnMappers4Company() {
        return null;
    }

    @Override
    public FieldColumnMapper[] columnMappers4Custom() {
        return null;
    }

    @Override
    public RelationFCMapper getRelationFCMapper4Custom() {
        return null;
    }

    @Override
    public RelationFCMapper getRelationFCMapper4Company() {
        return null;
    }

    @Override
    public Object createPrivilegeObject(long l2) {
        return null;
    }

    @Override
    public List getAllPrivilegesID() {
        return null;
    }

    @Override
    public List<EntryDAO> getEntryDaoAccess() {
        return null;
    }

    @Override
    public void release() {
        if (ScheduleContext.getScheduler() != null) {
            try {
                ScheduleContext.getScheduler().shutdown();
            }
            catch (SchedulerException schedulerException) {
                log.error(schedulerException.getMessage());
            }
            ScheduleContext.setScheduler(null);
            System.out.println("FineReport Scheduler has been shutdown successfully!");
        }
    }

    @Override
    public void refreshManager() {
        try {
            Connection connection = ScheduleDAOProperties.getInstance().createDataBaseConnection().createConnection();
            if (VT4FR.SCHEDULE.support()) {
                this.dealWithScheduleTable(connection);
            }
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            log.error(exception.getMessage());
        }
    }

    private void dealWithScheduleTable(Connection connection) {
        List<Column> list;
        if (!this.findColumnInTable("fr_schedule_output", "isCreateCPRByUsername", connection)) {
            list = this.getColumns4ScheduledOutputTable();
            this.addColumns4NewConnection(list, "fr_schedule_output");
        }
        if (!this.findColumnInTable("fr_schedule_task", "executeType", connection)) {
            list = this.getColumns4ExecuteCondition();
            this.addColumns4NewConnection(list, "fr_schedule_task");
        }
        if (!this.findColumnInTable("fr_schedule_task", "groupid", connection)) {
            return;
        }
        list = this.getColumns4ScheduleTaskTable();
        this.addColumns4NewConnection(list, "fr_schedule_task");
        this.dealWithScheduleTaskTable(connection);
    }

    private void dealWithScheduleTaskTable(Connection connection) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Table table = new Table("fr_schedule_task");
        Select select = new Select(table, DialectFactory.generateDialect(connection));
        try {
            preparedStatement = select.createPreparedStatement(connection);
        }
        catch (SQLException sQLException) {
            return;
        }
        try {
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            return;
        }
        try {
            while (resultSet.next()) {
                long l2 = resultSet.getLong("groupId");
                long l3 = resultSet.getLong("id");
                ReportletEntry reportletEntry = ReportletEntryDAO.getInstance().findByID(l2);
                if (reportletEntry == null) continue;
                ScheduleTask scheduleTask = (ScheduleTask)ScheduleContext.createDAOSession().load(ScheduleTask.class, l3);
                scheduleTask.setReportletPath(reportletEntry.getWebletPath());
                scheduleTask.setShowType(reportletEntry.getShowType());
                scheduleTask.setTaskParameters(reportletEntry.getTransmitParameters());
                ScheduleContext.createDAOSession().saveOrUpdate(scheduleTask);
            }
            this.deleteScheduleTaskTableColumn4NewConnection();
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(preparedStatement);
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            log.log(Level.WARNING, exception.getMessage());
        }
    }

    private boolean findColumnInTable(String string, String string2, Connection connection) {
        PreparedStatement preparedStatement;
        Table table = new Table(string);
        Select select = new Select(table, DialectFactory.generateDialect(connection));
        try {
            preparedStatement = select.createPreparedStatement(connection);
        }
        catch (SQLException sQLException) {
            return false;
        }
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            for (int i2 = 1; i2 <= n2; ++i2) {
                if (!string2.equalsIgnoreCase(resultSetMetaData.getColumnName(i2))) continue;
                return true;
            }
        }
        catch (SQLException sQLException) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addColumns4NewConnection(List<Column> list, String string) {
        Connection connection = null;
        String string2 = string;
        try {
            try {
                connection = ScheduleDAOProperties.getInstance().createDataBaseConnection().createConnection();
                connection.setAutoCommit(false);
                Dialect dialect = DialectFactory.generateDialect(connection);
                for (Column column : list) {
                    FSDAOManager.addTableColumn(connection, dialect, column, string2);
                }
                connection.commit();
            }
            catch (Exception exception) {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                log.error("Add" + string2 + "Column Action Failed!");
                ScheduleLogUtils.error(exception);
                Object var9_11 = null;
                DBUtils.closeConnection(connection);
                return;
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            DBUtils.closeConnection(connection);
            throw throwable;
        }
        DBUtils.closeConnection(connection);
    }

    private List<Column> getColumns4ExecuteCondition() {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        arrayList.add(new Column("executeType", 4, new ColumnSize(5)));
        arrayList.add(new Column("executeFormula", 12, new ColumnSize(255)));
        arrayList.add(new Column("executeClass", 12, new ColumnSize(255)));
        return arrayList;
    }

    private List<Column> getColumns4ScheduledOutputTable() {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        arrayList.add(new Column("isCreateCPRByUsername", 16, new ColumnSize(20)));
        arrayList.add(new Column("isSendEmailByUsername", 16, new ColumnSize(20)));
        arrayList.add(new Column("usernames", 12, new ColumnSize(2047)));
        return arrayList;
    }

    private List<Column> getColumns4ScheduleTaskTable() {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        arrayList.add(new Column("reportletPath", 12, new ColumnSize(255)));
        arrayList.add(new Column("showType", 4, new ColumnSize(5)));
        arrayList.add(new Column("transmitParameters", 12, new ColumnSize(1023)));
        arrayList.add(new Column("repeatTime", 12, new ColumnSize(20)));
        arrayList.add(new Column("repeatTimes", 12, new ColumnSize(20)));
        arrayList.add(new Column("counts", 4, new ColumnSize(5)));
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteScheduleTaskTableColumn4NewConnection() {
        Connection connection = null;
        String string = "fr_schedule_task";
        try {
            try {
                connection = ScheduleDAOProperties.getInstance().createDataBaseConnection().createConnection();
                connection.setAutoCommit(false);
                String string2 = "alter table " + string + " drop column groupid";
                Statement statement = connection.createStatement();
                statement.execute(string2);
                connection.commit();
            }
            catch (Exception exception) {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                log.error("Drop" + string + "Column Action Failed!");
                ScheduleLogUtils.error(exception);
                Object var6_8 = null;
                DBUtils.closeConnection(connection);
                return;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            DBUtils.closeConnection(connection);
            throw throwable;
        }
        DBUtils.closeConnection(connection);
    }

    @Override
    public boolean isSupport() {
        return VT4FR.SCHEDULE.support();
    }

    @Override
    public boolean needPrivilege() {
        return false;
    }
}

