/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.write;

import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.ParameterMapNameSpace;
import com.fr.data.TableDataSource;
import com.fr.data.Verifier;
import com.fr.data.core.db.DBUtils;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.general.RegistEditionException;
import com.fr.general.VT4FR;
import com.fr.report.report.WriteECReport;
import com.fr.report.write.BuiltInSQLSubmiter;
import com.fr.report.write.CompatibleClassSubmiter;
import com.fr.report.write.FreeSQLSubmiter;
import com.fr.report.write.Submiter;
import com.fr.report.write.ValueVerifier;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.A.YB;
import com.fr.write.DBManipulation;
import com.fr.write.DMLReport;
import com.fr.write.ReportWriteAttrProvider;
import com.fr.write.WriteException;
import com.fr.write.WriteSubmitException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReportWriteAttr
implements XMLable,
ReportWriteAttrProvider {
    public static final String ERROR_PREFIX = Inter.getLocText("Data_Submit_Error") + "\n";
    private List submiterNameList = new ArrayList();
    private List submiterList = new ArrayList();
    private List verifierList = new ArrayList();
    private List verifierNameList = new ArrayList();

    public int getSubmiterCount() {
        return this.submiterList.size();
    }

    public Submiter getSubmiter(int n2) {
        return (Submiter)this.submiterList.get(n2);
    }

    public void addSubmiter(Submiter submiter) {
        this.submiterList.add(submiter);
        this.submiterNameList.add("");
    }

    public void addSubmiter(String string, Submiter submiter) {
        this.submiterList.add(submiter);
        this.submiterNameList.add(string);
    }

    public void clearSubmiters() {
        this.submiterList.clear();
        this.submiterNameList.clear();
    }

    public String getSubmiterNameList(int n2) {
        return (String)this.submiterNameList.get(n2);
    }

    public void addVerifier(Verifier verifier) {
        this.verifierList.add(verifier);
        this.verifierNameList.add("");
    }

    public void addVerifier(String string, Verifier verifier) {
        this.verifierList.add(verifier);
        this.verifierNameList.add(string);
    }

    public void removeVerifier(int n2) {
        this.verifierList.remove(n2);
        this.verifierNameList.remove(n2);
    }

    public int getVerifierCount() {
        return this.verifierList.size();
    }

    public int getValueVerifierCount() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.verifierList.size(); ++i2) {
            if (!(this.getVerifier(i2) instanceof ValueVerifier)) continue;
            ++n2;
        }
        return n2;
    }

    public Verifier getVerifier(int n2) {
        return (Verifier)this.verifierList.get(n2);
    }

    public String getVerifierNameList(int n2) {
        return (String)this.verifierNameList.get(n2);
    }

    public void clearVerifiers() {
        this.verifierList.clear();
        this.verifierNameList.clear();
    }

    public void clearVerifiers(boolean bl) {
        int n2 = 0;
        int n3 = this.verifierList.size();
        while (n2 < n3 && n2 < this.verifierList.size()) {
            if (this.needToRemove(bl, this.verifierList.get(n2))) {
                this.verifierList.remove(n2);
                this.verifierNameList.remove(n2);
                continue;
            }
            ++n2;
        }
    }

    private boolean needToRemove(boolean bl, Object object) {
        return bl && object instanceof ValueVerifier || !bl && !(object instanceof ValueVerifier);
    }

    public void submit(WriteECReport writeECReport, TableDataSource tableDataSource, Map map) throws WriteException {
        this.submit(writeECReport, tableDataSource, map, false, new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(WriteECReport writeECReport, TableDataSource tableDataSource, Map map, boolean bl, Map map2) throws WriteSubmitException {
        Object v2 = map.get(YB.O);
        if (v2 != null) {
            ((YB)v2).A(this.submiterList.size());
        }
        if (!this.submiterList.isEmpty()) {
            HashMap hashMap = new HashMap();
            try {
                int n2 = this.submiterList.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (v2 != null) {
                        ((YB)v2).D(i2);
                    }
                    if (!VT4FR.ADVANCED_ONLINE_WRITE.support() && i2 > 0) {
                        throw new RegistEditionException(VT4FR.ADVANCED_ONLINE_WRITE);
                    }
                    Submiter submiter = (Submiter)this.submiterList.get(i2);
                    try {
                        this.dealWithConn(submiter, bl, map2, hashMap, writeECReport, tableDataSource, map);
                        submiter.execute(writeECReport, tableDataSource, map);
                        continue;
                    }
                    catch (Exception exception) {
                        if (!bl) {
                            Iterator iterator = hashMap.entrySet().iterator();
                            while (iterator.hasNext()) {
                                DBUtils.rollback((Connection)iterator.next().getValue());
                            }
                        }
                        throw new WriteSubmitException(ERROR_PREFIX + exception.getMessage(), exception).setBuiltinFail(submiter.isBuiltin());
                    }
                }
            }
            finally {
                this.dealWithCommitFinally(bl, hashMap);
            }
        } else {
            FRContext.getLogger().info("No Sumbitter defined!");
        }
    }

    private void dealWithConn(Submiter submiter, boolean bl, Map map, Map map2, WriteECReport writeECReport, TableDataSource tableDataSource, Map map3) throws WriteException {
        Connection connection = null;
        if (submiter instanceof BuiltInSQLSubmiter) {
            Calculator calculator = Calculator.createCalculator();
            calculator.setAttribute(DMLReport.class, writeECReport);
            calculator.setAttribute(TableDataSource.class, tableDataSource);
            calculator.pushNameSpace(ParameterMapNameSpace.create(map3));
            DBManipulation dBManipulation = ((BuiltInSQLSubmiter)submiter).getDBManipulation();
            if (dBManipulation.getDmlConfig() != null) {
                String string = dBManipulation.getDBName(calculator);
                NameDatabaseConnection nameDatabaseConnection = new NameDatabaseConnection(string);
                connection = (Connection)map2.get(string);
                if (connection == null && bl) {
                    connection = (Connection)map.get(string);
                }
                if (connection == null) {
                    try {
                        connection = nameDatabaseConnection.createConnection();
                        map2.put(string, connection);
                        map.put(string, connection);
                    }
                    catch (Exception exception) {
                        throw new WriteException(Inter.getLocText("Utils-Can_not_create_connection") + ":" + dBManipulation.getDBName() + "\n" + exception.getMessage(), exception);
                    }
                }
            }
        } else if (submiter instanceof FreeSQLSubmiter) {
            String string = ((FreeSQLSubmiter)submiter).getDBName();
            NameDatabaseConnection nameDatabaseConnection = new NameDatabaseConnection(string);
            connection = (Connection)map2.get(string);
            if (connection == null && bl) {
                connection = (Connection)map.get(string);
            }
            if (connection == null) {
                try {
                    connection = nameDatabaseConnection.createConnection();
                    map2.put(((FreeSQLSubmiter)submiter).getDBName(), connection);
                    map.put(((FreeSQLSubmiter)submiter).getDBName(), connection);
                }
                catch (Exception exception) {
                    DBUtils.rollback(connection);
                    throw new WriteException("can't connect to Database: " + ((FreeSQLSubmiter)submiter).getDBName() + "\n" + exception.getMessage(), exception);
                }
            }
        }
        submiter.setConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealWithCommitFinally(boolean bl, Map map) throws WriteSubmitException {
        if (!bl) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Connection connection = (Connection)entry.getValue();
                try {
                    if (connection == null || connection.isClosed()) continue;
                    try {
                        if (connection.getAutoCommit()) continue;
                        connection.commit();
                    }
                    catch (SQLException sQLException) {
                        DBUtils.rollback(connection);
                        while (iterator.hasNext()) {
                            Connection connection2 = (Connection)iterator.next().getValue();
                            DBUtils.rollback(connection2);
                            DBUtils.closeConnection(connection2);
                        }
                        throw new WriteSubmitException("Could not commit to Database : " + entry.getKey() + "\n" + sQLException.getMessage(), sQLException);
                    }
                }
                catch (SQLException sQLException) {
                    FRContext.getLogger().error(sQLException.getMessage(), sQLException);
                }
                finally {
                    DBUtils.closeConnection(connection);
                }
            }
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            String string2 = null;
            if (ComparatorUtils.equals("Submiter", string)) {
                this.readSubmitter(xMLableReader, string2);
            } else if (ComparatorUtils.equals("Verifier", string)) {
                this.readVerifier(xMLableReader, string2);
            } else {
                this.readXMLWithOldTag(xMLableReader, string2, string);
            }
        }
    }

    private void readVerifier(XMLableReader xMLableReader, String string) {
        String string2 = null;
        string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            string2 = string;
        }
        String string3 = null;
        string = xMLableReader.getAttrAsString("name", null);
        if (string != null) {
            string3 = string;
        }
        if (string2 != null && string3 != null) {
            Verifier verifier = null;
            if (string2.endsWith("VV")) {
                verifier = new ValueVerifier();
            } else {
                try {
                    verifier = (Verifier)GeneralUtils.classForName(string2).newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().errorWithServerLevel("Load class with name: " + string, exception);
                }
            }
            xMLableReader.readXMLObject(verifier);
            this.addVerifier(string3, verifier);
        }
    }

    private void readSubmitter(XMLableReader xMLableReader, String string) {
        String string2 = null;
        string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            string2 = string;
        }
        String string3 = null;
        string = xMLableReader.getAttrAsString("name", null);
        if (string != null) {
            string3 = string;
        }
        if (string2 != null && string3 != null) {
            Submiter submiter = null;
            if (string2.endsWith(".BuiltInSQLSubmiter")) {
                submiter = new BuiltInSQLSubmiter();
            } else if (string2.endsWith(".FreeSQLSubmiter")) {
                submiter = new FreeSQLSubmiter();
            } else if (string2.endsWith(".ClassSubmiter")) {
                submiter = new CompatibleClassSubmiter();
            } else {
                try {
                    submiter = (Submiter)GeneralUtils.classForName(string2).newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().errorWithServerLevel("Load class with name: " + string, exception);
                }
            }
            xMLableReader.readXMLObject(submiter);
            this.addSubmiter(string3, submiter);
        }
    }

    private void readXMLWithOldTag(XMLableReader xMLableReader, String string, String string2) {
        if ("ValueVerifier".equals(string2)) {
            String[] stringArray;
            ValueVerifier valueVerifier = new ValueVerifier();
            valueVerifier.setType(xMLableReader.getAttrAsInt("type", 0));
            string = xMLableReader.getElementValue();
            if (string != null && (stringArray = StableUtils.splitString(string, ",,.,,")) != null && stringArray.length == 2) {
                valueVerifier.setFormula(new Formula(stringArray[0]));
                valueVerifier.setMessage(stringArray[1]);
            }
        } else if ("VV".equals(string2)) {
            this.addVerifier((ValueVerifier)xMLableReader.readXMLObject(new ValueVerifier()));
        } else if ("WriteSQLAttr".equals(string2) || "InsertAttr".equals(string2)) {
            BuiltInSQLSubmiter builtInSQLSubmiter = new BuiltInSQLSubmiter();
            builtInSQLSubmiter.readOldXML(xMLableReader);
            this.addSubmiter(builtInSQLSubmiter);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n2;
        xMLPrintWriter.startTAG("ReportWriteAttr");
        int n3 = this.getSubmiterCount();
        for (n2 = 0; n2 < n3; ++n2) {
            Submiter submiter = this.getSubmiter(n2);
            xMLPrintWriter.startTAG("Submiter").attr("class", submiter.getClass().getName()).attr("name", this.getSubmiterNameList(n2));
            submiter.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        n2 = this.getVerifierCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Verifier verifier = this.getVerifier(i2);
            xMLPrintWriter.startTAG("Verifier").attr("class", verifier.getClass().getName()).attr("name", this.getVerifierNameList(i2));
            verifier.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        int n2;
        ReportWriteAttr reportWriteAttr = (ReportWriteAttr)super.clone();
        if (this.submiterList != null) {
            reportWriteAttr.submiterList = new ArrayList();
            for (n2 = 0; n2 < this.submiterList.size(); ++n2) {
                reportWriteAttr.submiterList.add(((Submiter)this.submiterList.get(n2)).clone());
            }
        }
        if (this.submiterNameList != null) {
            reportWriteAttr.submiterNameList = new ArrayList();
            reportWriteAttr.submiterNameList.addAll(this.submiterNameList);
        }
        if (this.verifierList != null) {
            reportWriteAttr.verifierList = new ArrayList();
            for (n2 = 0; n2 < this.verifierList.size(); ++n2) {
                reportWriteAttr.verifierList.add(((Verifier)this.verifierList.get(n2)).clone());
            }
        }
        if (this.verifierNameList != null) {
            reportWriteAttr.verifierNameList = new ArrayList();
            reportWriteAttr.verifierNameList.addAll(this.verifierNameList);
        }
        return reportWriteAttr;
    }
}

