/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.worksheet;

import com.fr.base.DynamicUnitList;
import com.fr.base.ResultFormula;
import com.fr.cache.list.IntList;
import com.fr.data.TableDataSource;
import com.fr.general.ComparatorUtils;
import com.fr.main.FineBook;
import com.fr.main.workbook.AnalyRWorkBook;
import com.fr.report.ReportHelper;
import com.fr.report.cell.AnalyCellCaseCreator;
import com.fr.report.cell.AnalyCellElement;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.CellElementCaseCreator;
import com.fr.report.cell.DefaultViewCellElement;
import com.fr.report.cell.ResultCellElement;
import com.fr.report.core.A.H;
import com.fr.report.core.A.J;
import com.fr.report.core.A.M;
import com.fr.report.core.A.h;
import com.fr.report.core.box.BoxElementBox;
import com.fr.report.core.utils.RFRC;
import com.fr.report.core.utils.ScriptUtils;
import com.fr.report.report.AnalyECReport;
import com.fr.report.report.Report;
import com.fr.report.worksheet.CalculatableResWorkSheet;
import com.fr.report.worksheet.FilterInfo;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.html.Tag;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNIT;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.HTMLWriter;
import com.fr.web.core.TreeHTMLWriter;
import com.fr.web.core.chwriter.CellHtmlWriter;
import com.fr.web.core.reportcase.WebElementReportCase;
import com.fr.web.core.utils.ReportHTMLWriterUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnalysisRWorkSheet
extends CalculatableResWorkSheet
implements AnalyECReport {
    private static final Map INIT_NULL = new HashMap(0);
    private BoxElementBox[][] bebArray;
    private int[] rowFilterMarks = null;
    private int[] columnFilterMarks = null;
    private Map filterInfoMap;
    private Map relation_map = INIT_NULL;
    private int minSize = 5;

    public AnalysisRWorkSheet() {
        this(null);
    }

    public AnalysisRWorkSheet(BoxElementBox[][] boxElementBoxArray) {
        this(boxElementBoxArray, INIT_NULL);
    }

    public AnalysisRWorkSheet(BoxElementBox[][] boxElementBoxArray, Map map) {
        this.bebArray = boxElementBoxArray;
        this.relation_map = map;
    }

    protected Map getRelationMap() {
        if (this.relation_map == INIT_NULL) {
            this.relation_map = new HashMap();
            Iterator iterator = this.cellIterator();
            Calculator calculator = Calculator.createCalculator();
            CalculatableResWorkSheet.RecalRelationNameSpace recalRelationNameSpace = new CalculatableResWorkSheet.RecalRelationNameSpace(this, this.getCurrentSheetIndex());
            calculator.pushNameSpace(recalRelationNameSpace);
            while (iterator.hasNext()) {
                CellElement cellElement = (CellElement)iterator.next();
                Object object = cellElement.getValue();
                if (!(object instanceof ResultFormula)) continue;
                recalRelationNameSpace.setCurCR(ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()));
                recalRelationNameSpace.setCurCE(cellElement);
                try {
                    calculator.eval(((ResultFormula)object).getTransferContent());
                }
                catch (UtilEvalError utilEvalError) {
                    throw new RuntimeException("Creating relationship for calcualte failed!", utilEvalError);
                }
            }
        }
        return this.relation_map;
    }

    protected void dealWithValue4Recal(CellElement cellElement) {
    }

    protected int getCurrentSheetIndex() {
        return ((AnalyRWorkBook)this.getResultWorkBook()).getReportIndex(this);
    }

    protected int getReportIndexBySheetName(String string) {
        FineBook fineBook = this.getBook();
        int n2 = fineBook.getReportCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!ComparatorUtils.equals(fineBook.getReportName(i2), string)) continue;
            return i2;
        }
        return -1;
    }

    protected CellElementCaseCreator getDefaultCellElementCaseCreator() {
        return AnalyCellCaseCreator.getInstance();
    }

    public void addCellElement(AnalyCellElement analyCellElement) {
        super.addCellElement(analyCellElement);
    }

    public void addCellElement(AnalyCellElement analyCellElement, boolean bl) {
        super.addCellElement(analyCellElement, bl);
    }

    public boolean removeCellElement(AnalyCellElement analyCellElement) {
        return super.removeCellElement(analyCellElement);
    }

    public AnalyCellElement getAnalyCellElement(int n2, int n3) {
        return (AnalyCellElement)super.getCellElement(n2, n3);
    }

    public AnalyCellElement removeAnalyCellElement(int n2, int n3) {
        return (AnalyCellElement)super.removeCellElement(n2, n3);
    }

    public FilterInfo getFilterInfo(ColumnRow columnRow) {
        return this.filterInfoMap == null ? null : (FilterInfo)this.filterInfoMap.get(columnRow);
    }

    public void addFilterInfo(ColumnRow columnRow, FilterInfo filterInfo) {
        if (this.filterInfoMap == null) {
            this.filterInfoMap = new HashMap(8);
        }
        this.filterInfoMap.put(columnRow, filterInfo);
    }

    public BoxElementBox getBEB(int n2, int n3) {
        return this.bebArray[n3][n2];
    }

    public int[] getRowFilterMarks() {
        return this.rowFilterMarks;
    }

    public void setRowFilterMarks(int[] nArray) {
        this.rowFilterMarks = nArray;
    }

    public int[] getColumnFilterMarks() {
        return this.columnFilterMarks;
    }

    public void setColumnFilterMarks(int[] nArray) {
        this.columnFilterMarks = nArray;
    }

    public FU getRowHeight(int n2) {
        if (this.rowFilterMarks != null && this.rowFilterMarks.length > n2 && this.rowFilterMarks[n2] > 0) {
            return UNIT.ZERO;
        }
        return super.getRowHeight(n2);
    }

    public UNIT getRealRowHeight(int n2) {
        return super.getRowHeight(n2);
    }

    public FU getColumnWidth(int n2) {
        if (this.columnFilterMarks != null && this.columnFilterMarks.length > n2 && this.columnFilterMarks[n2] > 0) {
            return UNIT.ZERO;
        }
        return super.getColumnWidth(n2);
    }

    public UNIT getRealColumnWidth(int n2) {
        return super.getColumnWidth(n2);
    }

    protected void executeCellElementResultFormula(Calculator calculator, ResultFormula resultFormula, Report report, TableDataSource tableDataSource, ResultCellElement resultCellElement) {
        if (((AnalyCellElement)resultCellElement).getFlState() > 0) {
            resultFormula.setResult(Primitive.NULL);
            List list = (List)calculator.getAttribute(ScriptUtils.RES_FM_LIST);
            if (list != null) {
                list.add(new RFRC(resultFormula, report, resultCellElement));
            }
        } else {
            ScriptUtils.executeCellElementResultFormula(calculator, resultFormula, report, tableDataSource, resultCellElement, true);
        }
    }

    public void recalculateSpecialCells(Map map, Iterator iterator) {
        this.recalculate(this, Calculator.createCalculator(), map, iterator);
    }

    public IntList recalculate4Filter(Map map, AnalyECReport analyECReport) {
        Iterator iterator = this.cellIterator();
        Calculator calculator = Calculator.createCalculator();
        this.recalculate(this, calculator, map, iterator);
        List list = (List)calculator.getAttribute(ScriptUtils.RES_FM_LIST);
        IntList intList = new IntList();
        int[] nArray = new int[analyECReport.getBook().getReportCount()];
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                RFRC rFRC = (RFRC)list.get(i2);
                Report report = rFRC.getCurrentReport();
                CellElement cellElement = rFRC.getCe();
                int n3 = nArray.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (report != analyECReport.getBook().getReport(i3)) continue;
                    nArray[i3] = 1;
                    J j2 = ((CalculatableResWorkSheet)((Object)analyECReport)).getFormulaRelation(ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()));
                    this.markRelation(j2, nArray, analyECReport);
                }
            }
        }
        for (int i4 = 0; i4 < nArray.length; ++i4) {
            if (nArray[i4] != 1) continue;
            intList.add(i4);
        }
        return intList;
    }

    private void markRelation(J j2, int[] nArray, AnalyECReport analyECReport) {
        if (j2 == null) {
            return;
        }
        Set set = j2.B();
        if (set != null) {
            for (M m2 : set) {
                CellElement cellElement = m2.B();
                nArray[m2.A()] = 1;
                CalculatableResWorkSheet calculatableResWorkSheet = (CalculatableResWorkSheet)analyECReport.getBook().getReport(m2.A());
                J j3 = calculatableResWorkSheet.getFormulaRelation(ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()));
                if (j3 == null) continue;
                this.markRelation(j3, nArray, analyECReport);
            }
        }
    }

    public void writeHtml(Tag tag, HTMLWriter hTMLWriter, CellHtmlWriter cellHtmlWriter, int n2, Repository repository) {
        Tag tag2 = hTMLWriter.writeReportToHtml(new WebElementReportCase(this, repository), n2, cellHtmlWriter, repository);
        DynamicUnitList dynamicUnitList = ReportHelper.getColumnWidthList(this);
        DynamicUnitList dynamicUnitList2 = ReportHelper.getRowHeightList(this);
        int n3 = 0;
        int n4 = 0;
        try {
            n3 = Integer.parseInt(tag2.getCss(TreeHTMLWriter.HIDDEN_WIDTH_TAG));
            n4 = Integer.parseInt(tag2.getCss(TreeHTMLWriter.HIDDEN_HEIGHT_TAG));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n5 = Math.max(dynamicUnitList.getRangeValueFromZero(this.getColumnCount()).toPixI(repository.getResolution()), 1);
        int n6 = Math.max(dynamicUnitList2.getRangeValueFromZero(this.getRowCount()).toPixI(repository.getResolution()), 1);
        Tag tag3 = new Tag("div");
        tag3.sub(tag2);
        tag.sub(tag3);
        Iterator iterator = this.floatIterator();
        int[] nArray = ReportHTMLWriterUtils.writeFloatElement(iterator, n5, n6, tag3, 0, 0, repository);
        n5 = nArray[0];
        n6 = nArray[1];
        tag3.css("width", n5 - n3 + this.minSize + "px").css("height", n6 - n4 + this.minSize + "px");
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        String string = "";
        if (xMLableReader.isChildNode()) {
            String string2 = xMLableReader.getTagName();
            if ("BEBARRAY".equals(string2)) {
                this.bebArray = new BoxElementBox[xMLableReader.getAttrAsInt("rc", 0)][xMLableReader.getAttrAsInt("cc", 0)];
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && "BEBE".equals(xMLableReader.getTagName())) {
                            h h2 = new h(xMLableReader.getAttrAsInt("row", 0), xMLableReader.getAttrAsInt("col", 0));
                            xMLableReader.readXMLObject(h2);
                            ((AnalysisRWorkSheet)AnalysisRWorkSheet.this).bebArray[h2.getRowIndex()][h2.getColumnIndex()] = h2;
                        }
                    }
                });
            } else if ("FIMAP".equals(string2)) {
                this.filterInfoMap = new HashMap(xMLableReader.getAttrAsInt("size", 8));
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && "ITEM".equals(xMLableReader.getTagName())) {
                            ColumnRow columnRow = ColumnRow.valueOf(xMLableReader.getAttrAsInt("col", 0), xMLableReader.getAttrAsInt("row", 0));
                            FilterInfo filterInfo = new FilterInfo();
                            xMLableReader.readXMLObject(filterInfo);
                            AnalysisRWorkSheet.this.filterInfoMap.put(columnRow, filterInfo);
                        }
                    }
                });
            } else if ("RFMS".equals(string2)) {
                this.readRFMS(xMLableReader, string);
            } else if ("CFMS".equals(string2)) {
                this.readCFMS(xMLableReader, string);
            }
        }
    }

    private void readRFMS(XMLableReader xMLableReader, String string) {
        string = xMLableReader.getElementValue();
        if (string != null) {
            String[] stringArray = StableUtils.splitString(string, ',');
            this.rowFilterMarks = new int[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!StringUtils.isNotBlank(stringArray[i2])) continue;
                this.rowFilterMarks[i2] = Integer.parseInt(stringArray[i2]);
            }
        }
    }

    private void readCFMS(XMLableReader xMLableReader, String string) {
        string = xMLableReader.getElementValue();
        if (string != null) {
            String[] stringArray = StableUtils.splitString(string, ',');
            this.columnFilterMarks = new int[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!StringUtils.isNotBlank(stringArray[i2])) continue;
                this.columnFilterMarks[i2] = Integer.parseInt(stringArray[i2]);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (!ArrayUtils.isEmpty(this.bebArray)) {
            xMLPrintWriter.startTAG("BEBARRAY").attr("rc", this.bebArray.length).attr("cc", this.bebArray[0].length);
            int n2 = this.bebArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = this.bebArray[i2].length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (this.bebArray[i2][i3] == null) continue;
                    xMLPrintWriter.startTAG("BEBE").attr("col", i3).attr("row", i2);
                    this.bebArray[i2][i3].writeXML(xMLPrintWriter);
                    xMLPrintWriter.end();
                }
            }
            xMLPrintWriter.end();
        }
        if (this.filterInfoMap != null && this.filterInfoMap.size() > 0) {
            xMLPrintWriter.startTAG("FIMAP").attr("size", this.filterInfoMap.size());
            Set set = this.filterInfoMap.keySet();
            for (ColumnRow columnRow : set) {
                xMLPrintWriter.startTAG("ITEM").attr("col", columnRow.getColumn()).attr("row", columnRow.getRow());
                FilterInfo filterInfo = (FilterInfo)this.filterInfoMap.get(columnRow);
                if (filterInfo != null) {
                    filterInfo.writeXML(xMLPrintWriter);
                }
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
        if (!ArrayUtils.isEmpty(this.rowFilterMarks)) {
            this.writeRFMS(xMLPrintWriter);
        }
        if (!ArrayUtils.isEmpty(this.columnFilterMarks)) {
            this.writeCFMS(xMLPrintWriter);
        }
    }

    private void writeRFMS(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("RFMS");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.rowFilterMarks.length; ++i2) {
            if (i2 != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.rowFilterMarks[i2]);
        }
        xMLPrintWriter.textNode(stringBuffer.toString());
        xMLPrintWriter.end();
    }

    private void writeCFMS(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("CFMS");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.columnFilterMarks.length; ++i2) {
            if (i2 != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.columnFilterMarks[i2]);
        }
        xMLPrintWriter.textNode(stringBuffer.toString());
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        AnalysisRWorkSheet analysisRWorkSheet = (AnalysisRWorkSheet)super.clone();
        analysisRWorkSheet.bebArray = new BoxElementBox[this.bebArray.length][];
        for (int i2 = 0; i2 < this.bebArray.length; ++i2) {
            analysisRWorkSheet.bebArray[i2] = new BoxElementBox[this.bebArray[i2].length];
            for (int i3 = 0; i3 < this.bebArray[i2].length; ++i3) {
                analysisRWorkSheet.bebArray[i2][i3] = this.bebArray[i2][i3] == null ? null : (BoxElementBox)this.bebArray[i2][i3].clone();
            }
        }
        if (this.rowFilterMarks != null) {
            analysisRWorkSheet.rowFilterMarks = (int[])this.rowFilterMarks.clone();
        }
        if (this.columnFilterMarks != null) {
            analysisRWorkSheet.columnFilterMarks = (int[])this.columnFilterMarks.clone();
        }
        if (this.filterInfoMap != null) {
            Set set = this.filterInfoMap.keySet();
            Iterator iterator = set.iterator();
            analysisRWorkSheet.filterInfoMap = new HashMap();
            while (iterator.hasNext()) {
                ColumnRow columnRow = (ColumnRow)iterator.next();
                analysisRWorkSheet.filterInfoMap.put(columnRow.clone(), ((FilterInfo)this.filterInfoMap.get(columnRow)).clone());
            }
        }
        return analysisRWorkSheet;
    }

    public TableDataSource getTableDataSource() {
        return null;
    }

    public H getSE() {
        return null;
    }

    protected CellElement createDefaultCellElementCase() {
        return new DefaultViewCellElement();
    }
}

