/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core.sheet;

import com.fr.base.Utils;
import com.fr.main.impl.WorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.report.core.namespace.SimpleCellValueNameSpace;
import com.fr.report.elementcase.ResultElementCase;
import com.fr.report.report.Report;
import com.fr.report.report.ResultReport;
import com.fr.report.report.TemplateReport;
import com.fr.script.Calculator;
import com.fr.stable.Actor;
import com.fr.stable.ListMap;
import com.fr.stable.UtilEvalError;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class WorkBookExecuter {
    protected List reslist;
    protected ListMap nameListMap = null;
    protected WorkBook workBook;
    protected Map parameterMap;

    public WorkBookExecuter(WorkBook workBook, Map map) {
        this.init(workBook, map);
    }

    public abstract ResultReport execute(int var1, TemplateReport var2);

    public abstract ResultWorkBook execute();

    public abstract ResultWorkBook result();

    public void executeReportName(ResultWorkBook resultWorkBook) {
        int n2 = resultWorkBook.getReportCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Report report = resultWorkBook.getReport(i2);
            Calculator calculator = Calculator.createCalculator();
            calculator.setAttribute(Report.class, report);
            String string = resultWorkBook.getReportName(i2);
            if (!string.startsWith("=")) continue;
            try {
                calculator.setAttribute(Report.class, report);
                calculator.pushNameSpace(SimpleCellValueNameSpace.getInstance());
                Object object = calculator.eval(string);
                string = Utils.objectToString(object);
                resultWorkBook.setReportName(i2, string);
                continue;
            }
            catch (UtilEvalError utilEvalError) {
                // empty catch block
            }
        }
    }

    public abstract Actor getExeType();

    void init(WorkBook workBook, Map map) {
        this.workBook = workBook;
        this.parameterMap = map;
        int n2 = workBook.getReportCount();
        this.nameListMap = new ListMap(n2);
        this.reslist = new ArrayList(n2);
        int n3 = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.reslist.add(null);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            TemplateReport templateReport = workBook.getTemplateReport(n3);
            this.nameListMap.put(workBook.getReportName(n3), templateReport);
        }
    }

    public void addResult(int n2, ResultReport resultReport) {
        this.reslist.set(n2, resultReport);
    }

    protected void dealWithExecutedAttr(ResultWorkBook resultWorkBook) {
        if (resultWorkBook == null) {
            return;
        }
        Iterator iterator = this.workBook.getTableDataNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            resultWorkBook.putTableData(string, this.workBook.getTableData(string));
        }
        if (this.workBook.getReportWebAttr() != null) {
            resultWorkBook.setReportWebAttr(this.workBook.getReportWebAttr());
        }
        if (this.workBook.getReportExportAttr() != null) {
            resultWorkBook.setReportExportAttr(this.workBook.getReportExportAttr());
        }
        if (this.workBook.getXmlVersion() != null) {
            resultWorkBook.setXMLVersion(this.workBook.getXmlVersion());
        }
    }

    public ResultElementCase getResultByIndex(int n2) {
        return (ResultElementCase)this.reslist.get(n2);
    }
}

