/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import com.fr.base.FRContext;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.PT;
import com.fr.stable.unit.UNIT;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JEditorPane;

public class Html2ImageUtils {
    public static UNIT getHtmlHeight(String string, UNIT uNIT) {
        double d2 = uNIT.toPixD(96);
        StringBuffer stringBuffer = new StringBuffer("<div style='width:").append(d2).append("px;height:100%;'>");
        Dimension dimension = Html2ImageUtils.getHtmlContentDimension(string, stringBuffer);
        double d3 = d2 / dimension.getWidth();
        int n2 = (int)(dimension.getHeight() * d3);
        return FU.valueOfPix(n2, 96);
    }

    public static UNIT getHtmlWidth(String string, UNIT uNIT) {
        double d2 = uNIT.toPixD(96);
        StringBuffer stringBuffer = new StringBuffer("<div style='height:").append(d2).append("px;width:100%;'>");
        Dimension dimension = Html2ImageUtils.getHtmlContentDimension(string, stringBuffer);
        double d3 = d2 / dimension.getHeight();
        double d4 = (int)(dimension.getWidth() * d3);
        return FU.valueOfPix((int)d4, 96);
    }

    private static Dimension getHtmlContentDimension(String string, StringBuffer stringBuffer) {
        string = Html2ImageUtils.convertPt2Px(string);
        string = stringBuffer.append(string).append("</div>").toString();
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setText(string);
        return jEditorPane.getPreferredSize();
    }

    private static String convertPt2Px(String string) {
        try {
            int n2;
            while (string != null && (n2 = string.indexOf("pt")) != -1) {
                int n3 = 0;
                for (int i2 = 0; i2 < 10 && ((n3 = n2 - i2) <= 0 || string.charAt(n3) != ' ' && string.charAt(n3) != ':'); ++i2) {
                }
                if (n3 == 0) continue;
                String string2 = string.substring(n3, n2).replaceAll(":", "").trim();
                double d2 = Double.parseDouble(string2);
                string = string.replaceAll(string2 + "pt", PT.pt2pix(d2, 96) + "px");
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return string;
    }

    public static BufferedImage createHTMLContentBufferedImage(String string, Rectangle rectangle, int n2, int n3) {
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(rectangle.width, rectangle.height, 6);
        if (rectangle.width == 0) {
            return bufferedImage;
        }
        StringBuffer stringBuffer = new StringBuffer("<div style='width:").append(rectangle.width).append("px;height:100%;'>");
        string = Html2ImageUtils.convertPt2Px(string);
        string = stringBuffer.append(string).append("</div>").toString();
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setText(string);
        Dimension dimension = jEditorPane.getPreferredSize();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.translate(n2, n3);
        graphics2D.setPaint(Color.WHITE);
        double d2 = (double)rectangle.width / ((double)dimension.width * 1.0);
        graphics2D.scale(d2, d2);
        jEditorPane.setSize(dimension);
        jEditorPane.paint(graphics2D);
        bufferedImage.flush();
        bufferedImage.flush();
        graphics2D.translate(-n2, -n3);
        graphics2D.dispose();
        return bufferedImage;
    }
}

