/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.painter.barcode.core;

import com.fr.report.cell.cellattr.BarcodeAttr;
import com.fr.report.cell.painter.BarcodePainter;
import com.fr.report.cell.painter.barcode.BarcodeException;
import com.fr.report.cell.painter.barcode.BarcodeImpl;
import com.fr.report.cell.painter.barcode.core.BarcodeFactory;
import com.fr.report.cell.painter.barcode.line.code128.Code128Barcode;
import java.io.Serializable;

public class BarCodeUtils
implements Cloneable,
Serializable {
    private static final int SUPPORTBARCODECOUNT = 19;

    private BarCodeUtils() {
    }

    public static BarcodeImpl getBarcodeImpl(BarcodePainter barcodePainter) throws BarcodeException {
        return BarCodeUtils.getBarcodeImpl(barcodePainter.getBarcodeAttr(), barcodePainter.getText());
    }

    public static BarcodeImpl getBarcodeImpl(BarcodeAttr barcodeAttr, String string) throws BarcodeException {
        int n2 = barcodeAttr.getType();
        if (string == null) {
            string = "123456789";
        }
        BarcodeImpl barcodeImpl = null;
        switch (n2) {
            case 0: {
                barcodeImpl = BarcodeFactory.createCode39(string, false);
                break;
            }
            case 1: {
                barcodeImpl = BarcodeFactory.createCode39(string, true);
                break;
            }
            case 2: {
                barcodeImpl = BarcodeFactory.createCodabar(string);
                break;
            }
            case 3: {
                barcodeImpl = new Code128Barcode(string, 3);
                break;
            }
            case 4: {
                barcodeImpl = new Code128Barcode(string, 0);
                break;
            }
            case 5: {
                barcodeImpl = new Code128Barcode(string, 1);
                break;
            }
            case 6: {
                barcodeImpl = new Code128Barcode(string, 2);
                break;
            }
            case 7: {
                barcodeImpl = BarcodeFactory.createEAN128(string);
                break;
            }
            case 8: {
                barcodeImpl = BarcodeFactory.createUSPS(string);
                break;
            }
            case 9: {
                barcodeImpl = BarcodeFactory.createShipmentIdentificationNumber(string);
                break;
            }
            case 10: {
                barcodeImpl = BarcodeFactory.createSSCC18(string);
                break;
            }
            case 11: {
                barcodeImpl = BarcodeFactory.createSCC14ShippingCode(string);
                break;
            }
            case 12: {
                barcodeImpl = BarcodeFactory.createGlobalTradeItemNumber(string);
                break;
            }
            case 13: {
                barcodeImpl = BarcodeFactory.createPDF417(string);
                break;
            }
            case 14: {
                barcodeImpl = BarcodeFactory.createUSD4(string);
                break;
            }
            case 15: {
                barcodeImpl = BarcodeFactory.createNW7(string);
                break;
            }
            case 16: {
                barcodeImpl = BarcodeFactory.createQRcode(string);
                barcodeImpl.setRCodeVersion(barcodeAttr.getRCodeVersion());
                barcodeImpl.setRCodeErrorCorrect(barcodeAttr.getRCodeErrorCorrect());
                barcodeImpl.setRcodeDrawPix(barcodeAttr.getRcodeDrawPix());
                break;
            }
            case 17: {
                barcodeImpl = BarcodeFactory.createITF25(string, barcodeAttr.getBarHeight(), barcodeAttr.getBarWidth(), barcodeAttr.isDrawingText());
                break;
            }
            case 18: {
                barcodeImpl = BarcodeFactory.createEAN13(string);
            }
        }
        if (barcodeImpl == null) {
            barcodeImpl = BarcodeFactory.createCode39(string, false);
        }
        barcodeImpl.setBarWidth(barcodeAttr.getBarWidth());
        barcodeImpl.setBarHeight(barcodeAttr.getBarHeight());
        barcodeImpl.setDrawingText(barcodeAttr.isDrawingText());
        return barcodeImpl;
    }

    public static String getBarCodeTypeName(int n2) {
        switch (n2) {
            case 0: {
                return "CODE39";
            }
            case 1: {
                return "CODE39CHECK";
            }
            case 2: {
                return "CODABAR";
            }
            case 3: {
                return "CODE128";
            }
            case 4: {
                return "CODE128A";
            }
            case 5: {
                return "CODE128B";
            }
            case 6: {
                return "CODE128C";
            }
            case 7: {
                return "EAN128";
            }
            case 8: {
                return "USPS";
            }
            case 9: {
                return "SHIPMENT_ID";
            }
            case 10: {
                return "SSCC-18";
            }
            case 11: {
                return "SCC-14";
            }
            case 12: {
                return "GTIN";
            }
            case 13: {
                return "PDF417";
            }
            case 14: {
                return "USD-4";
            }
            case 15: {
                return "NW-7";
            }
            case 16: {
                return "QRcode";
            }
            case 17: {
                return "ITF25";
            }
            case 18: {
                return "EAN13";
            }
        }
        return "CODE39";
    }

    public static Integer[] getAllSupportedBarCodeTypeArray() {
        Integer[] integerArray = new Integer[19];
        for (int i2 = 0; i2 < 19; ++i2) {
            integerArray[i2] = new Integer(i2);
        }
        return integerArray;
    }

    public static String getTestTextByBarCode(int n2) {
        if (n2 == 3 || n2 == 4 || n2 == 5 || n2 == 6 || n2 == 7 || n2 == 8 || n2 == 9 || n2 == 10 || n2 == 11 || n2 == 12 || n2 == 13 || n2 == 17) {
            return "123_ab";
        }
        if (n2 == 16) {
            return "123_ab_FR";
        }
        if (n2 == 18) {
            return "123456789012";
        }
        return "12345";
    }
}

