/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.cellattr.highlight;

import com.fr.base.FRContext;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.cellattr.highlight.AbstractHighlightAction;
import com.fr.report.elementcase.ElementCase;
import com.fr.script.Calculator;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.OLDPIX;
import com.fr.stable.unit.UNIT;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class RowHeightHighlightAction
extends AbstractHighlightAction {
    private UNIT rowHeight = UNIT.ZERO;

    public RowHeightHighlightAction() {
    }

    public RowHeightHighlightAction(UNIT uNIT) {
        this.rowHeight = uNIT;
    }

    public UNIT getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(UNIT uNIT) {
        this.rowHeight = uNIT;
    }

    public void action(CellElement cellElement, Calculator calculator) {
        int n2;
        if (cellElement == null || calculator == null) {
            return;
        }
        ElementCase elementCase = (ElementCase)calculator.getAttribute(ElementCase.class);
        if (elementCase == null) {
            FRContext.getLogger().error(Inter.getLocText("NS_LayerReport_RowCol"));
            return;
        }
        int n3 = n2 + cellElement.getRowSpan();
        for (n2 = cellElement.getRow(); n2 < n3; ++n2) {
            elementCase.setRowHeight(n2, this.rowHeight);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && "RowHeight".equals(xMLableReader.getTagName())) {
            if (xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR65_4_XML_VERSION()) {
                this.setRowHeight(FU.getInstance(xMLableReader.getAttrAsLong("i", 0L)));
            } else {
                this.setRowHeight(new OLDPIX((float)xMLableReader.getAttrAsInt("i", 0)));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.rowHeight.more_than_zero()) {
            xMLPrintWriter.startTAG("RowHeight").attr("i", this.rowHeight.toFU()).end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof RowHeightHighlightAction && super.equals(object) && ComparatorUtils.equals(this.rowHeight, ((RowHeightHighlightAction)object).rowHeight);
    }
}

