/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.cellattr.highlight;

import com.fr.data.condition.ListCondition;
import com.fr.data.condition.ObjectCondition;
import com.fr.data.core.Compare;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.Condition;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.cellattr.highlight.Highlight;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.StringUtils;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ExTool;
import com.fr.stable.xml.XMLObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public abstract class AbstractHighlight
implements Highlight {
    private static final long serialVersionUID = -2453532958147936705L;
    private Condition condition;
    private String name;

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean eval(CellElement cellElement, Calculator calculator) {
        if (cellElement == null) {
            return true;
        }
        calculator.setAttribute(ColumnRow.class, ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()));
        return this.condition.eval(cellElement.getValue(), calculator);
    }

    public void analyzeCorrelative(CalculatorProvider calculatorProvider, ExTool exTool, ColumnRow columnRow) {
        if (this.condition != null) {
            this.condition.analyzeCorrelative(calculatorProvider, exTool, columnRow);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractHighlight abstractHighlight = (AbstractHighlight)super.clone();
        if (this.condition != null) {
            abstractHighlight.setCondition((Condition)this.condition.clone());
        }
        return abstractHighlight;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Name")) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    this.name = string2;
                }
            } else if (string.equals("JoinCondition")) {
                int n2 = xMLableReader.getAttrAsInt("join", 0);
                xMLableReader.readXMLObject(new XMLObject(new Integer(n2)){

                    public void readXML(XMLableReader xMLableReader) {
                        String string;
                        if (xMLableReader.isChildNode() && ("Compare".equals(string = xMLableReader.getTagName()) || string.equals("Condition"))) {
                            Compare compare = new Compare(0, "");
                            xMLableReader.readXMLObject(compare);
                            if (AbstractHighlight.this.condition instanceof ListCondition) {
                                AbstractHighlight.this.condition = new ListCondition();
                            }
                            ((ListCondition)AbstractHighlight.this.condition).addJoinCondition((Integer)this.obj, new ObjectCondition(compare));
                        }
                    }
                });
            } else if ("Condition".equals(string)) {
                this.condition = DataCoreXmlUtils.readXMLCondition(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank(this.name)) {
            xMLPrintWriter.startTAG("Name").textNode(this.name).end();
        }
        DataCoreXmlUtils.writeXMLCondition(xMLPrintWriter, this.condition);
    }

    public boolean equals(Object object) {
        return object instanceof AbstractHighlight && ComparatorUtils.equals(this.name, ((AbstractHighlight)object).name) && ComparatorUtils.equals(this.condition, ((AbstractHighlight)object).condition);
    }
}

