/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.cellattr;

import com.fr.base.BaseUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.stable.ColumnRow;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

public class CellExpandAttr
implements XMLable {
    public static final byte Both_EXTENDABLE = 0;
    public static final byte Vertical_EXTENDABLE = 1;
    public static final byte Horizontal_EXTENDABLE = 2;
    public static final byte None_EXTENDABLE = 3;
    private byte direction = (byte)2;
    private byte extendable = 0;
    private boolean extendIsCover = false;
    private int extendMultipleNumber = -1;
    private boolean leftParentDefault = true;
    private boolean upParentDefault = true;
    private ColumnRow leftParentColumnRow = null;
    private ColumnRow upParentColumnRow = null;
    private int order = 0;
    private String sortFormula = null;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n2) {
        this.order = n2;
    }

    public String getSortFormula() {
        return this.sortFormula;
    }

    public void setSortFormula(String string) {
        this.sortFormula = string;
    }

    public byte getDirection() {
        return this.direction;
    }

    public void setDirection(byte by) {
        this.direction = by;
    }

    public byte getExtendable() {
        return this.extendable;
    }

    public void setExtendable(byte by) {
        this.extendable = by;
    }

    public void setExtendIsCover(boolean bl) {
        this.extendIsCover = bl;
    }

    public int getMultipleNumber() {
        return this.extendMultipleNumber;
    }

    public void setMultipleNumber(int n2) {
        this.extendMultipleNumber = n2;
    }

    public ColumnRow getLeftParentColumnRow() {
        return this.leftParentColumnRow;
    }

    public void setLeftParentColumnRow(ColumnRow columnRow) {
        this.leftParentColumnRow = columnRow;
    }

    public ColumnRow getUpParentColumnRow() {
        return this.upParentColumnRow;
    }

    public void setUpParentColumnRow(ColumnRow columnRow) {
        this.upParentColumnRow = columnRow;
    }

    public boolean isLeftParentDefault() {
        return this.leftParentDefault;
    }

    public void setLeftParentDefault(boolean bl) {
        this.leftParentDefault = bl;
    }

    public boolean isUpParentDefault() {
        return this.upParentDefault;
    }

    public void setUpParentDefault(boolean bl) {
        this.upParentDefault = bl;
    }

    public void modColumnRow(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        this.setLeftParentColumnRow(mOD_COLUMN_ROW.mod_columnrow(this.getLeftParentColumnRow()));
        this.setUpParentColumnRow(mOD_COLUMN_ROW.mod_columnrow(this.getUpParentColumnRow()));
        if (this.getOrder() != 0 && StringUtils.isNotEmpty(this.sortFormula)) {
            if (this.sortFormula.startsWith("=")) {
                this.sortFormula = this.sortFormula.substring(1);
            }
            this.setSortFormula(mOD_COLUMN_ROW.mod_fm_statement(this.sortFormula));
        }
    }

    public String toString() {
        return new StringBuffer().append("UP:").append(this.upParentColumnRow).append(';').append("LEFT:").append(this.leftParentColumnRow).toString();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.setDirection(xMLableReader.getAttrAsByte("dir", (byte)2));
            this.setExtendable(xMLableReader.getAttrAsByte("extendable", (byte)0));
            this.setExtendIsCover(xMLableReader.getAttrAsBoolean("isCover", false));
            this.setMultipleNumber(xMLableReader.getAttrAsInt("multiNumber", -1));
            this.setOrder(xMLableReader.getAttrAsInt("order", 0));
            this.setLeftParentDefault(xMLableReader.getAttrAsBoolean("leftParentDefault", true));
            String string = xMLableReader.getAttrAsString("left", null);
            if (string != null) {
                this.leftParentColumnRow = BaseUtils.convertCellStringToColumnRow(string);
                this.leftParentDefault = false;
            }
            this.setUpParentDefault(xMLableReader.getAttrAsBoolean("upParentDefault", true));
            string = xMLableReader.getAttrAsString("up", null);
            if (string != null) {
                this.upParentColumnRow = BaseUtils.convertCellStringToColumnRow(string);
                this.upParentDefault = false;
            }
        } else if (xMLableReader.isChildNode() && "SortFormula".equals(xMLableReader.getTagName())) {
            this.sortFormula = xMLableReader.getElementValue();
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Expand");
        if (this.direction != 2) {
            xMLPrintWriter.attr("dir", this.direction);
        }
        if (this.extendable != 0) {
            xMLPrintWriter.attr("extendable", this.extendable);
        }
        if (this.extendIsCover) {
            xMLPrintWriter.attr("isCover", this.extendIsCover);
        }
        if (this.extendMultipleNumber != -1) {
            xMLPrintWriter.attr("multiNumber", this.extendMultipleNumber);
        }
        if (!this.isLeftParentDefault()) {
            xMLPrintWriter.attr("leftParentDefault", "false");
            if (this.leftParentColumnRow != null) {
                xMLPrintWriter.attr("left", this.leftParentColumnRow.toString());
            }
        }
        if (!this.isUpParentDefault()) {
            xMLPrintWriter.attr("upParentDefault", "false");
            if (this.upParentColumnRow != null) {
                xMLPrintWriter.attr("up", this.upParentColumnRow.toString());
            }
        }
        if (this.getOrder() != 0) {
            xMLPrintWriter.attr("order", this.getOrder());
        }
        if (this.sortFormula != null && this.sortFormula.length() > 0) {
            xMLPrintWriter.startTAG("SortFormula").textNode(this.sortFormula).end();
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static boolean horizontalExtendable(int n2) {
        return n2 == 0 || n2 == 2;
    }

    public static boolean verticalExtendable(int n2) {
        return n2 == 0 || n2 == 1;
    }

    public boolean equals(Object object) {
        return object instanceof CellExpandAttr && this.direction == ((CellExpandAttr)object).direction && this.extendable == ((CellExpandAttr)object).extendable && this.extendIsCover == ((CellExpandAttr)object).extendIsCover && this.extendMultipleNumber == ((CellExpandAttr)object).extendMultipleNumber && this.leftParentDefault == ((CellExpandAttr)object).leftParentDefault && this.upParentDefault == ((CellExpandAttr)object).upParentDefault && ComparatorUtils.equals(this.leftParentColumnRow, ((CellExpandAttr)object).leftParentColumnRow) && ComparatorUtils.equals(this.upParentColumnRow, ((CellExpandAttr)object).upParentColumnRow);
    }
}

