/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell;

import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.base.Painter;
import com.fr.base.Style;
import com.fr.base.background.ColorBackground;
import com.fr.base.background.ImageSerializable;
import com.fr.base.chart.BaseChartPainter;
import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.js.JavaScriptXMLUtils;
import com.fr.js.NameJavaScriptGroup;
import com.fr.privilege.finegrain.FloatPrivilegeControl;
import com.fr.report.cell.Elem;
import com.fr.report.cellcase.CellElementCaseGetter;
import com.fr.report.core.PaintUtils;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.html.Tag;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.OLDPIX;
import com.fr.stable.unit.PT;
import com.fr.stable.unit.UNIT;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.utils.ReportHTMLWriterUtils;
import com.fr.xml.ReportXMLUtils;
import com.fr.xml.SynchronizedStyleList;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;

public class FloatElement
implements Elem,
XMLReadable,
Cloneable,
Serializable {
    private static int index = 0;
    private String name = "";
    private FU leftDistance = FU.ZERO;
    private FU topDistance = FU.ZERO;
    private FU leftDistance_inClippedPage = FU.ZERO;
    private FU topDistance_inClippedPage = FU.ZERO;
    private FU width = FU.getInstance(3810000L);
    private FU height = FU.getInstance(3810000L);
    private transient Object value = null;
    private Style style = null;
    private NameJavaScriptGroup nameHyperlinkGroup = null;
    private FloatPrivilegeControl floatPrivilegeControl;

    public FloatElement() {
        this("");
    }

    public FloatElement(Object object) {
        this(FU.getInstance(0L), FU.getInstance(0L), new OLDPIX(100.0f), new OLDPIX(100.0f), object);
    }

    public FloatElement(UNIT uNIT, UNIT uNIT2, UNIT uNIT3, UNIT uNIT4, Object object) {
        this.name = "Float" + index++;
        this.setLeftDistance(uNIT);
        this.setTopDistance(uNIT2);
        this.setWidth(uNIT3);
        this.setHeight(uNIT4);
        this.setValue(object);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public FU getLeftDistance() {
        return this.leftDistance;
    }

    public void setLeftDistance(UNIT uNIT) {
        if (uNIT == null) {
            throw new NullPointerException("leftDistance can not be null!");
        }
        this.leftDistance = FU.getInstance(uNIT.toFU());
    }

    public void setLeftDistance(FU fU) {
        if (fU == null) {
            throw new NullPointerException("leftDistance can not be null!");
        }
        this.leftDistance = fU;
    }

    public FU getTopDistance() {
        return this.topDistance;
    }

    public void setTopDistance(UNIT uNIT) {
        if (uNIT == null) {
            throw new NullPointerException("topDistance can not be null!");
        }
        this.topDistance = FU.getInstance(uNIT.toFU());
    }

    public void setTopDistance(FU fU) {
        if (fU == null) {
            throw new NullPointerException("topDistance can not be null!");
        }
        this.topDistance = fU;
    }

    public FU getLeftDistance_inClippedPage() {
        return this.leftDistance_inClippedPage.toFU() == 0L ? this.leftDistance : this.leftDistance_inClippedPage;
    }

    public void setLeftDistance_inClippedPage(FU fU) {
        this.leftDistance_inClippedPage = fU;
    }

    public FU getTopDistance_inClippedPage() {
        return this.topDistance_inClippedPage.toFU() == 0L ? this.topDistance : this.topDistance_inClippedPage;
    }

    public void setTopDistance_inClippedPage(FU fU) {
        this.topDistance_inClippedPage = fU;
    }

    public FU getWidth() {
        return this.width;
    }

    public void setWidth(UNIT uNIT) {
        if (uNIT == null) {
            throw new NullPointerException("width can not be null!");
        }
        this.width = FU.getInstance(uNIT.toFU());
    }

    public void setWidth(FU fU) {
        if (fU == null) {
            throw new NullPointerException("width can not be null!");
        }
        this.width = fU;
    }

    public FU getHeight() {
        return this.height;
    }

    public void setHeight(UNIT uNIT) {
        if (uNIT == null) {
            throw new NullPointerException("height can not be null!");
        }
        this.height = FU.getInstance(uNIT.toFU());
    }

    public void setHeight(FU fU) {
        if (fU == null) {
            throw new NullPointerException("height can not be null!");
        }
        this.height = fU;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public Style getStyle() {
        if (this.style == null) {
            this.style = Style.getInstance();
            this.style = this.style.deriveBackground(ColorBackground.getInstance(Color.WHITE));
        }
        return this.style;
    }

    public FloatPrivilegeControl getFloatPrivilegeControl() {
        if (this.floatPrivilegeControl == null) {
            this.floatPrivilegeControl = new FloatPrivilegeControl();
        }
        return this.floatPrivilegeControl;
    }

    public void setFloatPrivilegeControl(FloatPrivilegeControl floatPrivilegeControl) {
        this.floatPrivilegeControl = floatPrivilegeControl;
    }

    public boolean isDoneAuthority(String string) {
        if (string == null) {
            return false;
        }
        return this.getFloatPrivilegeControl().checkInvisible(string);
    }

    public boolean isDoneNewvalueAuthority(String string) {
        return false;
    }

    public void changeAuthorityState(String string, boolean bl) {
        if (string == null) {
            return;
        }
        if (bl) {
            this.getFloatPrivilegeControl().removeInvisibleRole(string);
        } else {
            this.getFloatPrivilegeControl().addInvisibleRole(string);
        }
    }

    public void changeNewValueAuthorityState(String string, boolean bl, Object object) {
    }

    public void cleanAuthority(String string) {
        if (string == null) {
            return;
        }
        if (this.getFloatPrivilegeControl().checkInvisible(string)) {
            this.getFloatPrivilegeControl().removeInvisibleRole(string);
        }
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public NameJavaScriptGroup getNameHyperlinkGroup() {
        return this.nameHyperlinkGroup;
    }

    public void setNameHyperlinkGroup(NameJavaScriptGroup nameJavaScriptGroup) {
        this.nameHyperlinkGroup = nameJavaScriptGroup;
    }

    public Tag toTag(Repository repository) {
        int n2 = this.getWidth().toPixI(repository.getResolution());
        int n3 = this.getHeight().toPixI(repository.getResolution());
        Tag tag = null;
        if (this.getValue() instanceof BaseChartPainter) {
            Tag tag2 = new Tag("td");
            tag = new Tag("table").cls("x-float-chart-table").sub(new Tag("tr").sub(tag2));
            PaintUtils.paintTag((BaseChartPainter)this.getValue(), repository, n2, n3, this.style, tag2);
            ReportHTMLWriterUtils.writeTagBackground(tag, this.paint4FloatBackBorder(n2, n3, repository.getResolution()), repository);
        } else {
            BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n2, n3, 6);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setPaint(Color.white);
            Style.paintBackground(graphics2D, this.getStyle(), n2, n3);
            PaintUtils.paintFloatElement(graphics2D, this, n2 - 1, n3 - 1, repository.getResolution());
            Style.paintBorder(graphics2D, this.getStyle(), n2, n3);
            bufferedImage.flush();
            graphics2D.dispose();
            tag = new Tag("div").css("width", n2 + "px").css("height", n3 + "px").css("border", "0").sub(" ");
            ReportHTMLWriterUtils.writeTagBackground(tag, bufferedImage, repository);
        }
        return tag;
    }

    public Tag toFrozenTag(Repository repository) {
        int n2 = this.getWidth().toPixI(repository.getResolution());
        int n3 = this.getHeight().toPixI(repository.getResolution());
        Tag tag = null;
        if (this.getValue() instanceof BaseChartPainter) {
            Tag tag2 = new Tag("td");
            tag = new Tag("table").cls("x-float-chart-table").sub(new Tag("tr").sub(tag2));
            PaintUtils.paintTag((BaseChartPainter)this.getValue(), repository, n2, n3, this.style, tag2);
            ReportHTMLWriterUtils.writeTagBackground(tag, this.paint4FloatBackBorder(n2, n3, repository.getResolution()), repository);
        } else {
            BufferedImage bufferedImage = (BufferedImage)this.getValue();
            tag = new Tag("div").css("width", n2 + "px").css("height", n3 + "px").css("border", "0").sub(" ");
            ReportHTMLWriterUtils.writeTagBackground(tag, bufferedImage, repository);
        }
        return tag;
    }

    private Image paint4FloatBackBorder(int n2, int n3, int n4) {
        Style style = this.getStyle();
        double d2 = PT.pt2pix(GraphHelper.getLineStyleSize(style.getBorderLeft()), n4);
        double d3 = PT.pt2pix(GraphHelper.getLineStyleSize(style.getBorderRight()), n4);
        double d4 = PT.pt2pix(GraphHelper.getLineStyleSize(style.getBorderTop()), n4);
        double d5 = PT.pt2pix(GraphHelper.getLineStyleSize(style.getBorderBottom()), n4);
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage((int)((double)n2 + d2 + d3), n3, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        Style.paintBackground(graphics2D, this.getStyle(), n2, n3);
        if (style.getBorderTop() != 0) {
            graphics2D.setPaint(style.getBorderTopColor());
            GraphHelper.drawLine(graphics2D, 0.0, 0.0 + d4 / 2.0, (double)n2 + d3, 0.0 + d4 / 2.0, style.getBorderTop());
        }
        if (style.getBorderLeft() != 0) {
            graphics2D.setPaint(style.getBorderLeftColor());
            GraphHelper.drawLine(graphics2D, 0.0 + d2 / 2.0, 0.0 + d2, 0.0 + d2 / 2.0, (double)n3 + d5, style.getBorderLeft());
        }
        if (style.getBorderBottom() != 0) {
            graphics2D.setPaint(style.getBorderBottomColor());
            GraphHelper.drawLine(graphics2D, 0.0 + d5, (double)n3 - d5 / 2.0, (double)n2 + d3, (double)n3 - d5 / 2.0, style.getBorderBottom());
        }
        if (style.getBorderRight() != 0) {
            graphics2D.setPaint(style.getBorderRightColor());
            GraphHelper.drawLine(graphics2D, (double)n2 - d3 / 2.0, 0.0 + d3, (double)n2 - d3 / 2.0, n3, style.getBorderRight());
        }
        graphics2D.dispose();
        bufferedImage.flush();
        return bufferedImage;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("FloatElementName".equals(string)) {
                this.setName(xMLableReader.getAttrAsString("name", "Float" + index++));
            } else if ("PrivilegeControl".equals(string)) {
                FloatPrivilegeControl floatPrivilegeControl = new FloatPrivilegeControl();
                xMLableReader.readXMLObject(floatPrivilegeControl);
                this.setFloatPrivilegeControl(floatPrivilegeControl);
            } else if ("Location".equals(string)) {
                if (!xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR65_4_XML_VERSION()) {
                    this.setLeftDistance(new OLDPIX((float)xMLableReader.getAttrAsInt("leftDistance", 0)));
                    this.setTopDistance(new OLDPIX((float)xMLableReader.getAttrAsInt("topDistance", 0)));
                    this.setWidth(new OLDPIX((float)xMLableReader.getAttrAsInt("width", 0)));
                    this.setHeight(new OLDPIX((float)xMLableReader.getAttrAsInt("height", 0)));
                } else {
                    this.setLeftDistance(FU.getInstance(xMLableReader.getAttrAsLong("leftDistance", 0L)));
                    this.setTopDistance(FU.getInstance(xMLableReader.getAttrAsLong("topDistance", 0L)));
                    this.setWidth(FU.getInstance(xMLableReader.getAttrAsLong("width", 0L)));
                    this.setHeight(FU.getInstance(xMLableReader.getAttrAsLong("height", 0L)));
                }
                if (!xMLableReader.getXMLVersion().isAfterREMOVE_COLUMN_ROW_FROM_FLOATELEMENT()) {
                    this.comb655FloatRowColumnValue(xMLableReader);
                }
            } else if (string.equals("Style")) {
                String string2 = xMLableReader.getAttrAsString("index", null);
                if (string2 != null) {
                    SynchronizedStyleList.getSynchronizedStyleList().put(Integer.parseInt(string2), this);
                }
            } else if (this.isNameJavaScript(string)) {
                NameJavaScriptGroup nameJavaScriptGroup = new NameJavaScriptGroup();
                xMLableReader.readXMLObject(nameJavaScriptGroup);
                this.setNameHyperlinkGroup(nameJavaScriptGroup);
            } else if ("O".equals(string) || "Object".equals(string)) {
                this.setValue(GeneralXMLTools.readObject(xMLableReader, true));
            } else if ("Hyperlink".equals(string)) {
                this.setNameHyperlinkGroup(new NameJavaScriptGroup(JavaScriptXMLUtils.readJavaScript(xMLableReader)));
            }
        }
    }

    private boolean isNameJavaScript(String string) {
        return ComparatorUtils.equals("NameJavaScriptGroup", string) || ComparatorUtils.equals("NameHyperlinks", string) || ComparatorUtils.equals("HyperlinkMap", string);
    }

    private void comb655FloatRowColumnValue(XMLableReader xMLableReader) {
        int n2 = xMLableReader.getAttrAsInt("column", 0);
        int n3 = xMLableReader.getAttrAsInt("row", 0);
        CellElementCaseGetter cellElementCaseGetter = (CellElementCaseGetter)xMLableReader.getContextAttribute(CellElementCaseGetter.class);
        if (cellElementCaseGetter != null) {
            int n4;
            FU fU = FU.ZERO;
            FU fU2 = FU.ZERO;
            for (n4 = 0; n4 < n2; ++n4) {
                fU = fU.add(cellElementCaseGetter.getColumnWidth(n4));
            }
            for (n4 = 0; n4 < n3; ++n4) {
                fU2 = fU2.add(cellElementCaseGetter.getRowHeight(n4));
            }
            this.setLeftDistance(this.getLeftDistance().add(fU));
            this.setTopDistance(this.getTopDistance().add(fU2));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("FloatElementName").attr("name", this.getName()).end();
        FloatPrivilegeControl floatPrivilegeControl = this.getFloatPrivilegeControl();
        if (floatPrivilegeControl != null) {
            floatPrivilegeControl.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.startTAG("Location").attr("leftDistance", this.getLeftDistance().toFU()).attr("topDistance", this.getTopDistance().toFU()).attr("width", this.getWidth().toFU()).attr("height", this.getHeight().toFU()).end();
        GeneralXMLTools.writeObject(xMLPrintWriter, this.getValue());
        if (this.style != null && !ComparatorUtils.equals(this.style, Style.DEFAULT_STYLE)) {
            ReportXMLUtils.writeIndexStyle(xMLPrintWriter, this.style);
        }
        if (this.getNameHyperlinkGroup() != null) {
            this.getNameHyperlinkGroup().writeXML(xMLPrintWriter);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object != null) {
            this.value = object instanceof ImageSerializable ? ((ImageSerializable)object).getImage() : object;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.value != null && this.value instanceof Image) {
            ImageSerializable imageSerializable = new ImageSerializable((Image)this.value);
            objectOutputStream.writeObject(imageSerializable);
        } else {
            objectOutputStream.writeObject(this.value);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FloatElement floatElement = (FloatElement)super.clone();
        floatElement.name = this.name;
        if (this.getValue() != null) {
            if (this.getValue() instanceof Formula) {
                floatElement.setValue(((Formula)this.getValue()).clone());
            } else if (this.getValue() instanceof Painter) {
                floatElement.setValue(((Painter)this.getValue()).clone());
            }
        }
        floatElement.setLeftDistance((FU)this.leftDistance.clone());
        floatElement.setTopDistance((FU)this.topDistance.clone());
        floatElement.setWidth((FU)this.width.clone());
        floatElement.setHeight((FU)this.height.clone());
        if (this.getNameHyperlinkGroup() != null) {
            floatElement.setNameHyperlinkGroup((NameJavaScriptGroup)this.getNameHyperlinkGroup().clone());
        }
        if (this.style != null) {
            floatElement.setStyle((Style)this.style.clone());
        }
        floatElement.setFloatPrivilegeControl((FloatPrivilegeControl)this.getFloatPrivilegeControl().clone());
        return floatElement;
    }

    private HashSet cloneHashSet(HashSet hashSet) {
        HashSet hashSet2 = new HashSet();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            hashSet2.add(iterator.next());
        }
        return hashSet2;
    }

    public FloatElement deriveFloatElement(UNIT uNIT, UNIT uNIT2, UNIT uNIT3, UNIT uNIT4) throws CloneNotSupportedException {
        FloatElement floatElement = (FloatElement)super.clone();
        floatElement.setLeftDistance(uNIT);
        floatElement.setTopDistance(uNIT2);
        floatElement.setWidth(uNIT3);
        floatElement.setHeight(uNIT4);
        return floatElement;
    }
}

