/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report;

import com.fr.base.DynamicUnitList;
import com.fr.base.Formula;
import com.fr.base.Margin;
import com.fr.base.PaperSize;
import com.fr.base.Utils;
import com.fr.main.FineBook;
import com.fr.page.ClippedPageProvider;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportPageProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.block.Block;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.FloatElement;
import com.fr.report.cellcase.CellElementCaseGetter;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.poly.AbstractPolyReport;
import com.fr.report.report.Report;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNIT;
import com.fr.stable.unit.UNITConstants;
import com.fr.stable.unit.UNITDimension;
import com.fr.stable.unit.UnitRectangle;
import java.awt.Point;
import java.util.Iterator;

public class ReportHelper {
    private ReportHelper() {
    }

    public static UNITDimension calculateOccupiedArea(AbstractPolyReport abstractPolyReport) {
        UNITDimension uNITDimension = new UNITDimension();
        int n2 = abstractPolyReport.getBlockCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Block block = abstractPolyReport.getBlock(i2);
            UnitRectangle unitRectangle = block.getBounds();
            FU fU = unitRectangle.x.add(unitRectangle.width);
            FU fU2 = unitRectangle.y.add(unitRectangle.height);
            uNITDimension.width = UNIT.max(uNITDimension.width, fU);
            uNITDimension.height = UNIT.max(uNITDimension.height, fU2);
        }
        return uNITDimension;
    }

    public static UNIT[] getReportPageContentSize(ReportPageProvider reportPageProvider) {
        ClippedPageProvider[] clippedPageProviderArray = reportPageProvider.getPages();
        UNIT uNIT = UNIT.ZERO;
        UNIT uNIT2 = UNIT.ZERO;
        for (int i2 = 0; i2 < clippedPageProviderArray.length; ++i2) {
            ClippedPageProvider clippedPageProvider = clippedPageProviderArray[i2];
            UNIT uNIT3 = clippedPageProvider.getOffsetX();
            if ((uNIT3 = uNIT3.add(clippedPageProvider.getActualWidth())).subtract(uNIT).more_than_zero()) {
                uNIT = uNIT3;
            }
            UNIT uNIT4 = clippedPageProvider.getOffsetY();
            if (!(uNIT4 = uNIT4.add(clippedPageProvider.getActualHeight())).subtract(uNIT2).more_than_zero()) continue;
            uNIT2 = uNIT4;
        }
        return new UNIT[]{uNIT, uNIT2};
    }

    public static Object[] calculateLastColumnAndRowOfFloatElement(ElementCase elementCase, FloatElement floatElement) {
        long l2 = floatElement.getLeftDistance().toFU();
        long l3 = floatElement.getTopDistance().toFU();
        DynamicUnitList dynamicUnitList = ReportHelper.getColumnWidthList(elementCase);
        DynamicUnitList dynamicUnitList2 = ReportHelper.getRowHeightList(elementCase);
        int n2 = 0;
        int n3 = 0;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = -l2;
        int n4 = 0;
        while (true) {
            if ((l6 += dynamicUnitList.get(n4).toFU()) >= floatElement.getWidth().toFU()) break;
            ++n4;
        }
        n2 = n4;
        l4 = floatElement.getWidth().toFU() - (l6 - dynamicUnitList.get(n4).toFU());
        l6 = -l3;
        n4 = 0;
        while (true) {
            if ((l6 += dynamicUnitList2.get(n4).toFU()) >= floatElement.getHeight().toFU()) break;
            ++n4;
        }
        n3 = n4;
        l5 = floatElement.getHeight().toFU() - (l6 - dynamicUnitList2.get(n4).toFU());
        return new Object[]{new Point(n2, n3), FU.getInstance(l4), FU.getInstance(l5)};
    }

    public static Point calculateStartColumnAndRowOfFloatElement(ElementCase elementCase, FloatElement floatElement) {
        DynamicUnitList dynamicUnitList = ReportHelper.getColumnWidthList(elementCase);
        DynamicUnitList dynamicUnitList2 = ReportHelper.getRowHeightList(elementCase);
        return ReportHelper.calculateStartColumnAndRowOfFloatElement(dynamicUnitList, dynamicUnitList2, floatElement);
    }

    public static Point calculateStartColumnAndRowOfFloatElement(DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, FloatElement floatElement) {
        long l2 = floatElement.getLeftDistance().toFU();
        long l3 = floatElement.getTopDistance().toFU();
        int n2 = 0;
        int n3 = 0;
        long l4 = 0L;
        int n4 = 0;
        while (true) {
            if ((l4 += dynamicUnitList.get(n4).toFU()) >= l2) break;
            ++n4;
        }
        n2 = n4;
        l4 = 0L;
        n4 = 0;
        while (true) {
            if ((l4 += dynamicUnitList2.get(n4).toFU()) >= l3) break;
            ++n4;
        }
        n3 = n4;
        return new Point(n2, n3);
    }

    public static UNIT getTotalColumnWidth(ElementCase elementCase) {
        if (elementCase == null) {
            return UNIT.ZERO;
        }
        int n2 = elementCase.getColumnCount();
        elementCase.getRowCount();
        FU fU = UNIT.ZERO;
        for (int i2 = 0; i2 < n2; ++i2) {
            fU = fU.add(elementCase.getColumnWidth(i2));
        }
        return fU;
    }

    public static UNIT getTotalRowHeight(ElementCase elementCase) {
        if (elementCase == null) {
            return UNIT.ZERO;
        }
        int n2 = elementCase.getRowCount();
        FU fU = UNIT.ZERO;
        for (int i2 = 0; i2 < n2; ++i2) {
            fU = fU.add(elementCase.getRowHeight(i2));
        }
        return fU;
    }

    public static DynamicUnitList getRowHeightList(ElementCase elementCase) {
        if (elementCase == null) {
            return new DynamicUnitList(UNITConstants.DEFAULT_ROW_HEIGHT);
        }
        return elementCase.getRowHeightList_DEC();
    }

    public static DynamicUnitList createRowHeightList(CellElementCaseGetter cellElementCaseGetter) {
        int n2 = cellElementCaseGetter.getRowCount();
        DynamicUnitList dynamicUnitList = new DynamicUnitList(UNITConstants.DEFAULT_ROW_HEIGHT, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            dynamicUnitList.set(i2, cellElementCaseGetter.getRowHeight(i2));
        }
        return dynamicUnitList;
    }

    public static DynamicUnitList getColumnWidthList(ElementCase elementCase) {
        if (elementCase == null) {
            return new DynamicUnitList(UNITConstants.DEFAULT_ROW_HEIGHT);
        }
        return elementCase.getColumnWidthList_DEC();
    }

    public static DynamicUnitList createColumnWidthList(CellElementCaseGetter cellElementCaseGetter) {
        int n2 = cellElementCaseGetter.getColumnCount();
        DynamicUnitList dynamicUnitList = new DynamicUnitList(UNITConstants.DEFAULT_COL_WIDTH, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            dynamicUnitList.set(i2, cellElementCaseGetter.getColumnWidth(i2));
        }
        return dynamicUnitList;
    }

    public static void clearFormulaResult(FineBook fineBook) {
        int n2 = fineBook.getReportCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Report report = fineBook.getReport(i2);
            Iterator iterator = report.iteratorOfElementCase();
            while (iterator.hasNext()) {
                ElementCase elementCase = (ElementCase)iterator.next();
                ReportHelper.clearFormulaResult(elementCase);
            }
        }
    }

    public static void clearFormulaResult(ElementCase elementCase) {
        Iterator iterator = elementCase.cellIterator();
        while (iterator.hasNext()) {
            CellElement cellElement = (CellElement)iterator.next();
            if (!(cellElement.getValue() instanceof Formula)) continue;
            ((Formula)cellElement.getValue()).setResult(null);
        }
    }

    public static Object convertGeneralStringAccordingToExcel(Object object) {
        if (object != null && object instanceof String) {
            String string = (String)object;
            if (string.startsWith("=")) {
                if (string.matches("^\\=[\\=]+$")) {
                    return string;
                }
                return new Formula(string);
            }
            if (string.length() > 0) {
                Number number;
                if (string.matches("\\(\\d+(\\.\\d+)*\\)")) {
                    string = "-" + string.substring(1, string.length() - 1);
                }
                if ((number = Utils.string2Number(string)) != null) {
                    return number;
                }
            }
        }
        return object;
    }

    public static UNIT[] getPaperPaintWidthAndHeight(PaperSettingProvider paperSettingProvider, ReportSettingsProvider reportSettingsProvider) {
        long l2;
        long l3;
        if (paperSettingProvider == null) {
            l3 = Integer.MAX_VALUE;
            l2 = Integer.MAX_VALUE;
        } else {
            PaperSize paperSize = paperSettingProvider.getPaperSize();
            Margin margin = paperSettingProvider.getMargin();
            UNIT uNIT = paperSize.getWidth();
            UNIT uNIT2 = paperSize.getHeight();
            if (paperSettingProvider.getOrientation() == 1) {
                uNIT = paperSize.getHeight();
                uNIT2 = paperSize.getWidth();
            }
            l3 = uNIT.toFU() - margin.getLeft().toFU() - margin.getRight().toFU();
            l2 = uNIT2.toFU() - margin.getTop().toFU() - margin.getBottom().toFU() - reportSettingsProvider.getHeaderHeight().toFU() - reportSettingsProvider.getFooterHeight().toFU();
        }
        return new UNIT[]{FU.getInstance(l3), FU.getInstance(l2)};
    }
}

