/*
 * Decompiled with CFR 0.152.
 */
package com.fr.process.pdl.task;

import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.process.engine.exception.NoBranchException;
import com.fr.process.engine.processexecutor.ProcessDefineCache;
import com.fr.process.engine.processexecutor.ProcessExecutor;
import com.fr.process.pdl.XmlJSONTransform;
import com.fr.process.pdl.io.ProcessIOUtils;
import com.fr.process.pdl.processdefine.ProcessOB;
import com.fr.process.pdl.task.AbstractTask;
import com.fr.process.pdl.task.FormTask;
import com.fr.process.pdl.task.Task;
import com.fr.process.pdl.transition.ConditionTransition;
import com.fr.process.pdl.transition.TransitionImpl;
import com.fr.process.pdl.transition.TriggerTransition;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class SubProTask
extends AbstractTask {
    private String subname;
    private String parentname;
    private ConditionTransition[] conditionTransition;

    public String getSubname() {
        return this.subname;
    }

    public void setSubname(String string) {
        this.subname = string;
    }

    public String getParentname() {
        return this.parentname;
    }

    public void setParentname(String string) {
        this.parentname = string;
    }

    public void behavior(ProcessExecutor processExecutor, TransitionImpl transitionImpl) {
        this.executeIn(processExecutor, transitionImpl);
        this.execute(processExecutor);
    }

    public String getReportName() throws Exception {
        Task task;
        Iterator iterator;
        TransitionImpl transitionImpl;
        ProcessOB processOB = ProcessDefineCache.getInstance().getProcess(this.subname);
        Task task2 = processOB.getTask((transitionImpl = (TransitionImpl)(iterator = (task = processOB.getStart()).getOutTransitions().iterator()).next()).getToTaskName());
        if (task2 instanceof FormTask) {
            return ((FormTask)task2).getReportName();
        }
        if (task2 instanceof SubProTask) {
            return ((SubProTask)task2).getReportName();
        }
        return null;
    }

    protected void execute(ProcessExecutor processExecutor) {
        if (this.isExecuted()) {
            return;
        }
        processExecutor.addParentTaskId(processExecutor.getProcessDefine().getId());
        processExecutor.setProcessname(this.subname);
        try {
            processExecutor.start();
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage());
        }
        this.setExecuted(true);
    }

    public void continueTask(ProcessExecutor processExecutor, Parameter[] parameterArray) {
        this.executeOut(processExecutor, parameterArray);
    }

    public Set getOutTransitions(Parameter[] parameterArray) {
        if (parameterArray == null || parameterArray.length < 1 || this.conditionTransition == null || this.conditionTransition.length == 0) {
            return this.getOutTransitions();
        }
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = this.conditionTransition.length;
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            XmlJSONTransform xmlJSONTransform = this.conditionTransition[i2];
            int n3 = parameterArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!ComparatorUtils.equals(parameterArray[i2].getName(), ((ConditionTransition)xmlJSONTransform).getParaName())) continue;
                String string = ((TriggerTransition)xmlJSONTransform).execute(parameterArray[i2]);
                if (string == null) continue block0;
                hashSet.add(string);
                continue block0;
            }
        }
        HashSet<XmlJSONTransform> hashSet2 = new HashSet<XmlJSONTransform>();
        for (XmlJSONTransform xmlJSONTransform : this.getOutTransitions()) {
            if (!hashSet.contains(((TransitionImpl)xmlJSONTransform).getName())) continue;
            hashSet2.add(xmlJSONTransform);
        }
        return hashSet2;
    }

    protected void executeOut(ProcessExecutor processExecutor, Parameter[] parameterArray) {
        Set set = this.getOutTransitions(parameterArray);
        int n2 = set.size();
        int n3 = 0;
        if (n2 == 0) {
            throw new NoBranchException();
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ++n3;
            TransitionImpl transitionImpl = (TransitionImpl)iterator.next();
            if (this.getExecutedOutTransitions().contains(transitionImpl.getName())) continue;
            if (this.addExecutedOutTransition(transitionImpl.getName())) {
                this.saveOrUpdate();
            }
            if (n3 == n2) {
                processExecutor.removeTask(this);
                this.remove();
            }
            processExecutor.executeTransition(transitionImpl);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Task").attr("class", this.getClass().getName());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Subname").textNode(this.subname).end();
        xMLPrintWriter.startTAG("Parentname").textNode(this.parentname).end();
        ProcessIOUtils.writeTriggerTransitions(this.conditionTransition, xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Subname")) {
                this.setSubname(xMLableReader.getElementValue());
            } else if (string.equals("TriggerTransitions")) {
                this.conditionTransition = ProcessIOUtils.readTriggerTransitions(xMLableReader);
            } else if (string.equalsIgnoreCase("Parentname")) {
                this.setParentname(xMLableReader.getElementValue());
            }
        }
    }

    public void parseJSON(JSONObject jSONObject) {
        try {
            super.parseJSON(jSONObject);
            if (jSONObject.has("subname")) {
                this.setSubname(jSONObject.getString("subname"));
            }
            if (jSONObject.has("parentname")) {
                this.setParentname(jSONObject.getString("parentname"));
            }
            if (jSONObject.has("conditiontransitions")) {
                JSONArray jSONArray = jSONObject.getJSONArray("conditiontransitions");
                HashSet<ConditionTransition> hashSet = new HashSet<ConditionTransition>();
                int n2 = jSONArray.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    ConditionTransition conditionTransition = new ConditionTransition();
                    conditionTransition.parseJSON(jSONArray.getJSONObject(i2));
                    hashSet.add(conditionTransition);
                }
                this.conditionTransition = hashSet.toArray(new ConditionTransition[hashSet.size()]);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage());
        }
    }

    public JSONObject createJSON() {
        JSONObject jSONObject = super.createJSON();
        try {
            jSONObject.put("subname", this.getSubname());
            jSONObject.put("parentname", this.getParentname());
            if (this.conditionTransition != null && this.conditionTransition.length > 0) {
                JSONArray jSONArray = new JSONArray();
                int n2 = this.conditionTransition.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    jSONArray.put(this.conditionTransition[i2].createJSON());
                }
                jSONObject.put("conditiontransitions", jSONArray);
            }
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof SubProTask)) {
            return false;
        }
        if (!ComparatorUtils.equals(this.subname, ((SubProTask)object).subname)) {
            return false;
        }
        return ComparatorUtils.equals(this.parentname, ((SubProTask)object).parentname);
    }
}

