/*
 * Decompiled with CFR 0.152.
 */
package com.fr.process.pdl.task;

import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.fs.FSConfig;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.systemmanager.SystemManagerFavoriteAndADHOC;
import com.fr.fs.dao.TaskInfo;
import com.fr.fs.dao.TaskInfoUser;
import com.fr.fs.web.FSReportlet;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.process.engine.exception.NoUserException;
import com.fr.process.engine.processexecutor.ProcessExecutor;
import com.fr.process.engine.processservice.ProceedInfo;
import com.fr.process.pdl.task.HumanTask;
import com.fr.process.pdl.transition.TransitionImpl;
import com.fr.process.pdl.user.FormulaUtils;
import com.fr.stable.ActorFactory;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.web.Weblet;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.A.H;
import com.fr.web.platform.TransmitParameters;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FormTask
extends HumanTask {
    private String reportName;
    private String oldBookName;

    public String getOldBookName() {
        return this.oldBookName;
    }

    public void setOldBookName(String string) {
        this.oldBookName = string;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String string) {
        this.reportName = string;
    }

    public void createTaskInfo(ProcessExecutor processExecutor, boolean bl) {
        if (this.getTaskUsers() == null) {
            return;
        }
        long[] lArray = new long[]{};
        long l2 = -1L;
        if (processExecutor.getVariableValue("processStarter") != null) {
            l2 = (Long)processExecutor.getVariableValue("processStarter");
        }
        try {
            lArray = bl && processExecutor.getParentTaskLength() < 1 ? new long[]{l2} : this.getTaskUsers().executeUserID(processExecutor);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        Date date = new Date(System.currentTimeMillis());
        TransmitParameters transmitParameters = new TransmitParameters(processExecutor.getNoUserParameters());
        TaskInfo taskInfo = new TaskInfo(this.getName(), date, processExecutor.getId(), processExecutor.getProcessname(), transmitParameters, l2);
        taskInfo.save();
        long l3 = taskInfo.getId();
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            TaskInfoUser taskInfoUser = new TaskInfoUser(lArray[i2], l3);
            if (lArray[i2] == UserControl.getInstance().getSuperManagerID()) {
                try {
                    SystemManagerFavoriteAndADHOC.getInstance().saveTaskNode(taskInfoUser);
                    return;
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
            }
            taskInfoUser.save();
        }
    }

    public boolean checkUser(ProcessExecutor processExecutor) {
        long[] lArray = new long[]{};
        try {
            lArray = this.getTaskUsers().executeUserID(processExecutor);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            return false;
        }
        if (lArray == null || lArray.length < 1) {
            return false;
        }
        boolean bl = false;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                if (UserControl.getInstance().getUser(lArray[i2]) == null) continue;
                bl = true;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public void generateFineBook(ProcessExecutor processExecutor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        if (StringUtils.isEmpty(this.reportName)) {
            return;
        }
        FormulaUtils.embFormula();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("processExecutorID", new Long(processExecutor.getId()));
        hashMap.put("FR_SYSTEM_ID", new Long(processExecutor.getId()));
        hashMap.put("taskName", this.getName());
        hashMap.put("currentUser", new Long(ServiceUtils.getCurrentUserID(httpServletRequest)));
        httpServletRequest.setAttribute("taskName", (Object)this.getName());
        Iterator iterator = processExecutor.getVariableNames();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            hashMap.put((String)object, processExecutor.getVariableValue((String)object));
        }
        object = null;
        if (this.reportName.endsWith("cpt")) {
            String string = this.reportName;
            String string2 = string;
            if (string2.indexOf(File.separator) > -1) {
                String[] stringArray = this.reportName.split(File.separator);
                string2 = stringArray[stringArray.length - 1];
            }
            object = new FSReportlet(string, string2, hashMap, ActorFactory.getActor("write"));
        } else {
            object = StableFactory.createWeblet("ProcessFormlet", this.reportName, hashMap);
        }
        H.A(httpServletRequest, httpServletResponse, (Weblet)object, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueTask(ProcessExecutor processExecutor, long l2, ProceedInfo proceedInfo) throws Exception {
        FormTask formTask = this;
        synchronized (formTask) {
            if (!processExecutor.isActive(this.getName())) {
                return;
            }
            if (!this.checkBranches(proceedInfo)) {
                return;
            }
            int n2 = proceedInfo.getParaLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                Parameter parameter = proceedInfo.getPara(i2);
                Object object = parameter.getValue();
                processExecutor.addVariable(parameter.getName(), object);
            }
            if (!this.checkNextTaskUser(proceedInfo, processExecutor)) {
                throw new NoUserException();
            }
            this.finishTaskInfo(processExecutor.getId(), l2);
            this.executeOut(proceedInfo, processExecutor);
        }
    }

    private boolean checkBranches(ProceedInfo proceedInfo) throws Exception {
        if (proceedInfo.getTransitionNameLength() < 1) {
            return false;
        }
        boolean bl = false;
        int n2 = proceedInfo.getTransitionNameLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = proceedInfo.getTransitionName(i2);
            if (this.getOutTransition(string) == null) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void finishTaskInfo(long l2, long l3) {
        Date date = new Date(System.currentTimeMillis());
        TaskInfo taskInfo = this.getTaskInfo(l2);
        if (taskInfo == null) {
            return;
        }
        taskInfo.setEndTime(date);
        taskInfo.setProcessexecutorid(-1L);
        taskInfo.update();
        List list = FSConfig.getInstance().getControl().getTaskInfoUserDAO().findByTaskId(new Long(taskInfo.getId()));
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TaskInfoUser taskInfoUser = (TaskInfoUser)list.get(i2);
            if (taskInfoUser.getUserID() == l3) continue;
            taskInfoUser.remove();
        }
    }

    private TaskInfo getTaskInfo(long l2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", this.getName());
        hashMap.put("processexecutorid", new Long(l2));
        List list = TaskInfo.getDaoAccess().findByMap(hashMap);
        return !list.isEmpty() ? (TaskInfo)list.get(0) : null;
    }

    public boolean checkNextTaskUser(ProceedInfo proceedInfo, ProcessExecutor processExecutor) {
        int n2 = proceedInfo.getTransitionNameLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            TransitionImpl transitionImpl;
            String string = proceedInfo.getTransitionName(i2);
            if (this.getExecutedOutTransitions().contains(string) || (transitionImpl = this.getOutTransition(string)) == null || processExecutor.checkTaskUser(transitionImpl)) continue;
            return false;
        }
        return true;
    }

    protected void executeOut(ProceedInfo proceedInfo, ProcessExecutor processExecutor) {
        int n2 = proceedInfo.getTransitionNameLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            TransitionImpl transitionImpl;
            String string = proceedInfo.getTransitionName(i2);
            if (this.getExecutedOutTransitions().contains(string) || (transitionImpl = this.getOutTransition(string)) == null) continue;
            if (transitionImpl.isBack()) {
                processExecutor.removeTask(this);
                this.remove();
                processExecutor.executeTransition(transitionImpl);
                return;
            }
            if (this.addExecutedOutTransition(string)) {
                this.saveOrUpdate();
            }
            if (i2 == n2 - 1) {
                processExecutor.removeTask(this);
                this.remove();
            }
            processExecutor.executeTransition(transitionImpl);
        }
    }

    private TransitionImpl getOutTransition(String string) {
        Set set = this.getOutTransitions();
        for (TransitionImpl transitionImpl : set) {
            if (!ComparatorUtils.equals(transitionImpl.getName(), string)) continue;
            return transitionImpl;
        }
        return null;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("ReportName")) {
            this.setReportName(xMLableReader.getElementValue());
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Task").attr("class", this.getClass().getName());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("ReportName").textNode(this.getReportName()).end();
        xMLPrintWriter.end();
    }

    public void parseJSON(JSONObject jSONObject) {
        super.parseJSON(jSONObject);
        try {
            if (jSONObject.has("form")) {
                this.setReportName(jSONObject.getString("form"));
            }
            if (jSONObject.has("oldform")) {
                this.setOldBookName(jSONObject.getString("oldform"));
            }
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
        }
    }

    public JSONObject createJSON() {
        JSONObject jSONObject = super.createJSON();
        try {
            jSONObject.put("form", this.getReportName());
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        return object instanceof FormTask && super.equals(object) && ComparatorUtils.equals(this.reportName, ((FormTask)object).reportName);
    }

    public void continueTask() {
    }
}

