/*
 * Decompiled with CFR 0.152.
 */
package com.fr.process.pdl.processdefine;

import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.fs.dao.DaoAccess;
import com.fr.fs.dao.DaoObject;
import com.fr.json.JSONObject;
import com.fr.process.pdl.XmlJSONTransform;
import com.fr.process.pdl.io.ProcessIOUtils;
import com.fr.process.pdl.processdefine.SystemOfProcessTableMapper;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class SystemOfProcesses
extends DaoObject
implements XmlJSONTransform {
    public static final String XML_TAG = "SystemOfProcesses";
    public static final String PREFIX = "System";
    public static final String AUTOINCPARANAME = "FR_SYSTEM_ID";
    private static DaoAccess daoAccess = null;
    private static ObjectTableMapper tableMapper = null;
    private Parameter autoIncreasePara = new Parameter("FR_SYSTEM_ID", new Integer(1));
    private Set parameters = new HashSet();
    private Set processes = new HashSet();
    private String name;

    public SystemOfProcesses() {
    }

    public SystemOfProcesses(String string) {
        this.name = string;
    }

    public int getParametersLength() {
        return this.getParameters().size();
    }

    public Parameter getParameter(int n2) {
        if (n2 < 0 || n2 > this.getParameters().size() - 1) {
            return null;
        }
        Iterator iterator = this.getParameters().iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (n2 == n3) {
                return parameter;
            }
            ++n3;
        }
        return null;
    }

    public void addParameter(Parameter parameter) {
        this.getParameters().add(parameter);
    }

    public void removeParameter(Parameter parameter) {
        this.getParameters().remove(parameter);
    }

    public void addProcess(String string) {
        this.processes.add(string);
    }

    public void removeProcess(String string) {
        this.processes.remove(string);
    }

    public int getProcessesLength() {
        return this.processes.size();
    }

    public String getProcess(int n2) {
        if (n2 < 0 || n2 > this.processes.size() - 1) {
            return null;
        }
        Iterator iterator = this.processes.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (n2 == n3) {
                return string;
            }
            ++n3;
        }
        return "";
    }

    private String setToString(Set set) {
        if (set.size() < 1) {
            return "";
        }
        Iterator iterator = set.iterator();
        String string = "";
        while (iterator.hasNext()) {
            string = string + iterator.next().toString() + ",";
        }
        if (string.endsWith(",")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.setSystemName(xMLableReader.getAttrAsString("name", PREFIX));
            this.autoIncreasePara.setValue(new Integer(xMLableReader.getAttrAsInt("id", 1)));
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("processes")) {
                String string2 = xMLableReader.getElementValue();
                String[] stringArray = string2.trim().split(",");
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.addProcess(stringArray[i2]);
                }
            } else if (string.equals("Parameters")) {
                this.setParameters(ProcessIOUtils.readSetParameters(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("name", this.getSystemName()).attr("id", this.getIDNum());
        if (this.processes.size() >= 1) {
            xMLPrintWriter.startTAG("processes").textNode(this.setToString(this.processes)).end();
        }
        ProcessIOUtils.writeSetParameters(this.getParameters(), xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public void parseJSON(JSONObject jSONObject) {
    }

    public JSONObject createJSON() {
        return null;
    }

    public String getSystemName() {
        return this.name;
    }

    private int getIDNum() {
        return Integer.parseInt(this.autoIncreasePara.getValue().toString());
    }

    public void setSystemName(String string) {
        this.name = string;
    }

    public static ObjectTableMapper getObjectTableMapper() {
        if (tableMapper == null) {
            tableMapper = new SystemOfProcessTableMapper();
        }
        return tableMapper;
    }

    public static DaoAccess getDaoAccess() {
        if (daoAccess == null) {
            daoAccess = new DaoAccess(SystemOfProcesses.class);
        }
        return daoAccess;
    }

    public void save() {
        this.setId(SystemOfProcesses.getDaoAccess().save(this));
    }

    public void update() {
        if (this.getId() < 0L) {
            FRContext.getLogger().log(Level.INFO, "Need ID to update!");
            return;
        }
        SystemOfProcesses.getDaoAccess().update(this);
    }

    public void remove() {
        SystemOfProcesses.getDaoAccess().removeByID(this.getId());
    }

    protected int hashCode4Properties() {
        return this.getSystemName().hashCode();
    }

    public boolean equals4Properties(Object object) {
        return false;
    }

    public Set getParameters() {
        this.parameters.remove(this.autoIncreasePara);
        return this.parameters;
    }

    public void setParameters(Set set) {
        this.parameters = set;
        set.add(this.getAutoIncreasePara());
    }

    public Parameter getAutoIncreasePara() {
        return this.autoIncreasePara;
    }

    public void setAutoIncreasePara(Parameter parameter) {
        this.autoIncreasePara = parameter;
    }
}

