/*
 * Decompiled with CFR 0.152.
 */
package com.fr.process.pdl.processdefine;

import com.fr.base.FRContext;
import com.fr.base.MultiFieldParameter;
import com.fr.base.Parameter;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.fs.dao.DaoAccess;
import com.fr.fs.dao.DaoObject;
import com.fr.fs.dao.TaskInfo;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.fs.schedule.trigger.ITrigger;
import com.fr.fs.schedule.trigger.TriggerFactory;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.process.dao.ProcessExecutorCache;
import com.fr.process.engine.exception.NoStartTaskException;
import com.fr.process.engine.processexecutor.ProcessDefineCache;
import com.fr.process.engine.processexecutor.ProcessExecutor;
import com.fr.process.engine.processexecutor.SystemCache;
import com.fr.process.pdl.XmlJSONTransform;
import com.fr.process.pdl.io.ProcessIOUtils;
import com.fr.process.pdl.json.JSONUtils;
import com.fr.process.pdl.processdefine.ProcessJob;
import com.fr.process.pdl.processdefine.ProcessOBTableMapper;
import com.fr.process.pdl.processdefine.SystemOfProcesses;
import com.fr.process.pdl.task.AbstractTask;
import com.fr.process.pdl.task.FormTask;
import com.fr.process.pdl.task.StartTask;
import com.fr.process.pdl.task.Task;
import com.fr.process.pdl.task.Task4Database;
import com.fr.process.pdl.transition.TransitionImpl;
import com.fr.process.pdl.user.ParameterUsers;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.third.org.quartz.JobDetail;
import com.fr.third.org.quartz.Scheduler;
import com.fr.third.org.quartz.SchedulerException;
import com.fr.third.org.quartz.Trigger;
import com.fr.web.platform.TransmitParameters;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class ProcessOB
extends DaoObject
implements XmlJSONTransform {
    public static final String XML_TAG = "ProcessOB";
    private static DaoAccess daoAccess = null;
    private static ObjectTableMapper tableMapper = null;
    private int width = 1600;
    private int height = 1600;
    private ITrigger trigger;
    private String triggerId;
    private String name;
    private String descript;
    private String imageData;
    private Set tasks = new LinkedHashSet();
    private String shareProcessName;
    private String systemName;
    private SystemOfProcesses system;

    public ProcessOB() {
    }

    public ProcessOB(long l2) {
        this.setId(l2);
    }

    public ProcessOB(String string) {
        this.setName(string);
    }

    public String getDescript() {
        return this.descript;
    }

    public void setDescript(String string) {
        this.descript = string;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n2) {
        this.height = n2;
    }

    public ITrigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(ITrigger iTrigger) {
        this.trigger = iTrigger;
    }

    public void addTask(Task task) {
        this.tasks.add(task);
    }

    public int getParametersLength() {
        return this.getSystem().getParametersLength();
    }

    public Parameter getParameter(int n2) {
        if (n2 < 0 || n2 > this.getParametersLength() - 1) {
            return null;
        }
        Iterator iterator = this.getSystem().getParameters().iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (n2 == n3) {
                return parameter;
            }
            ++n3;
        }
        return null;
    }

    public Parameter getParameterByName(String string) {
        for (Parameter parameter : this.getSystem().getParameters()) {
            if (!ComparatorUtils.equals(parameter.getName(), string)) continue;
            return parameter;
        }
        return null;
    }

    public void addParameter(Parameter parameter) {
        this.getSystem().addParameter(parameter);
    }

    public Set getAllMultiFieldPara() {
        HashSet<Parameter> hashSet = new HashSet<Parameter>();
        for (Parameter parameter : this.getSystem().getParameters()) {
            if (!(parameter instanceof MultiFieldParameter)) continue;
            hashSet.add(parameter);
            ((MultiFieldParameter)parameter).setProcessName(this.systemName);
        }
        return hashSet;
    }

    public Set getAllMultiFieldParaName() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Parameter parameter : this.getSystem().getParameters()) {
            if (!(parameter instanceof MultiFieldParameter)) continue;
            hashSet.add(((MultiFieldParameter)parameter).getName());
        }
        return hashSet;
    }

    public void removeTask(Task task) {
        this.tasks.remove(task);
    }

    public ObjectTableMapper getTableMapperFromParas(HashMap hashMap) {
        ObjectTableMapper objectTableMapper = new ObjectTableMapper();
        objectTableMapper.setObjectClass(Parameter.class);
        objectTableMapper.setTable(this.createTable());
        objectTableMapper.setFieldColumnMappers(this.generateFieldColumnMapper(hashMap));
        return objectTableMapper;
    }

    private Table createTable() {
        return new Table("FR_T_" + this.getSystem().getSystemName());
    }

    private FieldColumnMapper[] generateFieldColumnMapper(HashMap hashMap) {
        FieldColumnMapper[] fieldColumnMapperArray = new FieldColumnMapper[hashMap.size() + 2];
        fieldColumnMapperArray[0] = new PrimaryKeyFCMapper("FR_SYSTEM_ID", 4, new ColumnSize(20), false, false);
        int n2 = 1;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            fieldColumnMapperArray[n2] = new CommonFieldColumnMapper(string, Integer.parseInt(hashMap.get(string).toString()), new ColumnSize(10000), true);
            ++n2;
        }
        fieldColumnMapperArray[n2] = new CommonFieldColumnMapper("nextTask", 12, new ColumnSize(255), true);
        return fieldColumnMapperArray;
    }

    public void generateScheduleTask() {
        if (this.trigger == null) {
            return;
        }
        if (this.trigger.getId() < 0L) {
            this.trigger.setId(ScheduleContext.createDAOSession().save(this.getTrigger()));
        }
        JobDetail jobDetail = new JobDetail(this.getName(), this.getName(), ProcessJob.class);
        jobDetail.getJobDataMap().put("ProcessName", this.getName());
        Trigger trigger = this.trigger.createTrigger();
        trigger.setJobName(jobDetail.getName());
        trigger.setJobGroup(jobDetail.getGroup());
        try {
            Scheduler scheduler = ScheduleContext.getScheduler();
            Trigger[] triggerArray = scheduler.getTriggersOfJob(jobDetail.getName(), jobDetail.getGroup());
            if (triggerArray.length > 0) {
                scheduler.rescheduleJob(jobDetail.getName(), jobDetail.getGroup(), trigger);
            } else {
                scheduler.scheduleJob(jobDetail, trigger);
            }
        }
        catch (SchedulerException schedulerException) {
            FRContext.getLogger().error(schedulerException.getMessage(), schedulerException);
        }
    }

    public void removeScheduleTask() {
        Scheduler scheduler = ScheduleContext.getScheduler();
        try {
            scheduler.deleteJob(this.getName(), this.getName());
        }
        catch (SchedulerException schedulerException) {
            FRContext.getLogger().error(schedulerException.getMessage(), schedulerException);
        }
    }

    public void remove() {
        this.removeTriggerAndFile();
        ProcessOB.getDaoAccess().removeByID(this.getId());
    }

    public void removeTriggerAndFile() {
        if (this.trigger != null || StringUtils.isNotEmpty(this.triggerId)) {
            this.removeScheduleTask();
            this.removeTrigger();
        }
        try {
            ProcessDefineCache.getInstance().removeProcess(this.getName());
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
    }

    private void removeTrigger() {
        Class<?> clazz = null;
        ITrigger iTrigger = null;
        long l2 = -1L;
        if (StringUtils.isNotEmpty(this.triggerId)) {
            int n2 = new Integer(this.triggerId.substring(0, 1));
            iTrigger = TriggerFactory.createTrigger(n2);
            l2 = new Long(this.triggerId.substring(1));
            clazz = iTrigger.getClass();
        } else {
            clazz = this.trigger.getClass();
            l2 = this.trigger.getId();
        }
        ScheduleContext.createDAOSession().deleteByPrimaryKey(clazz, l2);
    }

    public void save() {
        this.setId(ProcessOB.getDaoAccess().save(this));
    }

    public void update() {
        if (this.getId() < 0L) {
            FRContext.getLogger().log(Level.INFO, "Need ID to update!");
            return;
        }
        ProcessOB.getDaoAccess().update(this);
    }

    public static DaoAccess getDaoAccess() {
        if (daoAccess == null) {
            daoAccess = new DaoAccess(ProcessOB.class);
        }
        return daoAccess;
    }

    public static ObjectTableMapper getObjectTableMapper() {
        if (tableMapper == null) {
            tableMapper = new ProcessOBTableMapper();
        }
        return tableMapper;
    }

    public Task getTask(String string) {
        for (Task task : this.tasks) {
            if (!ComparatorUtils.equals(task.getName(), string)) continue;
            return task;
        }
        return null;
    }

    public Set getInTransitions(Task task) {
        String string = task.getName();
        HashSet<TransitionImpl> hashSet = new HashSet<TransitionImpl>();
        for (Task task2 : this.tasks) {
            Set set = task2.getOutTransitions();
            for (TransitionImpl transitionImpl : set) {
                if (!ComparatorUtils.equals(string, transitionImpl.getToTaskName())) continue;
                hashSet.add(transitionImpl);
            }
        }
        return hashSet;
    }

    public String getToTaskName(String string) {
        for (Task task : this.tasks) {
            Set set = task.getOutTransitions();
            for (TransitionImpl transitionImpl : set) {
                if (!ComparatorUtils.equals(string, transitionImpl.getName())) continue;
                return transitionImpl.getToTaskName();
            }
        }
        return null;
    }

    private void calBack() {
        this.calculatorBackTransition(this.getStart());
    }

    private void calculatorBackTransition(Task task) {
        Set set = task.getOutTransitions();
        for (TransitionImpl transitionImpl : set) {
            Task task2 = this.getTask(transitionImpl.getToTaskName());
            if (this.isAncestor(task, task2)) {
                transitionImpl.setBack(true);
                continue;
            }
            task2.setParent(task);
            this.calculatorBackTransition(task2);
        }
    }

    public SystemOfProcesses getSystem() {
        if (this.system != null) {
            return this.system;
        }
        if (StringUtils.isNotEmpty(this.shareProcessName)) {
            this.systemName = SystemCache.getOrCreateSystemName(this.shareProcessName);
            this.system = SystemCache.getSystem(this.systemName);
        } else {
            this.systemName = SystemCache.getOrCreateSystemName(this.getName());
            this.system = SystemCache.getSystem(this.systemName);
        }
        if (this.system == null) {
            this.system = new SystemOfProcesses(this.systemName);
            this.system.addProcess(this.name);
            try {
                SystemCache.addSystemOfProcesses(this.system);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
        }
        return this.system;
    }

    public void resetSystem() {
        this.system = null;
    }

    private boolean isAncestor(Task task, Task task2) {
        for (Task task3 = task.getParent(); task3 != null; task3 = task3.getParent()) {
            if (task2 != task3) continue;
            return true;
        }
        return false;
    }

    public Task getStart() {
        for (Task task : this.tasks) {
            if (!(task instanceof StartTask)) continue;
            return task;
        }
        throw new NoStartTaskException();
    }

    public Task getFirstTaskWithoutStart() {
        for (Task task : this.tasks) {
            Set set;
            Iterator iterator;
            if (!(task instanceof StartTask) || !(iterator = (set = task.getOutTransitions()).iterator()).hasNext()) continue;
            TransitionImpl transitionImpl = (TransitionImpl)iterator.next();
            return this.getTask(transitionImpl.getToTaskName());
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Set getUserParameterNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Task task : this.tasks) {
            if (!(task instanceof FormTask) || !(((FormTask)task).getTaskUsers() instanceof ParameterUsers)) continue;
            hashSet.add(((ParameterUsers)((FormTask)task).getTaskUsers()).getParaname());
        }
        return hashSet;
    }

    public Set getTransitionNames(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Task task : this.tasks) {
            if (!(task instanceof FormTask) || !ComparatorUtils.equals(((FormTask)task).getReportName(), string)) continue;
            Set set = task.getOutTransitions();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                hashSet.add(((TransitionImpl)iterator.next()).getName());
            }
        }
        return hashSet;
    }

    public boolean hasBook(String string) {
        for (Task task : this.tasks) {
            if (!(task instanceof FormTask) || !ComparatorUtils.equals(((FormTask)task).getReportName(), string)) continue;
            return true;
        }
        return false;
    }

    public Set getParaNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Parameter parameter : this.getSystem().getParameters()) {
            String string = parameter.getName();
            if (ComparatorUtils.equals("FR_SYSTEM_ID", string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public Set getAllParaNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Parameter parameter : this.getSystem().getParameters()) {
            String string;
            if (parameter instanceof MultiFieldParameter) {
                hashSet.addAll(((MultiFieldParameter)parameter).getAllFiledName());
            }
            if (ComparatorUtils.equals("FR_SYSTEM_ID", string = parameter.getName())) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public Iterator getTaskIterator() {
        return this.tasks.iterator();
    }

    public long deployment() throws Exception {
        this.calBack();
        ProcessDefineCache.getInstance().addProcessOB(this);
        if (this.getId() > -1L) {
            this.update();
        } else {
            this.save();
        }
        this.generateScheduleTask();
        return this.getId();
    }

    public ProcessExecutor startInstance(long l2) throws Exception {
        ProcessExecutor processExecutor = new ProcessExecutor(this.getName());
        processExecutor.userStart(l2);
        return processExecutor;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("name", this.getName()).attr("descript", this.getDescript()).attr("width", this.width).attr("height", this.height);
        if (this.trigger != null) {
            this.triggerId = new StringBuffer().append(this.trigger.getITriggerIdPrefix()).append(this.trigger.getId()).toString();
            xMLPrintWriter.startTAG("TriggerID").textNode(this.triggerId).end();
        }
        if (StringUtils.isNotEmpty(this.imageData)) {
            xMLPrintWriter.startTAG("ImageData").textNode(this.imageData).end();
        }
        if (StringUtils.isNotEmpty(this.getShareProcessName())) {
            xMLPrintWriter.startTAG("processName").textNode(this.getShareProcessName()).end();
            xMLPrintWriter.startTAG("systemName").textNode(SystemCache.getOrCreateSystemName(this.getShareProcessName())).end();
        } else {
            xMLPrintWriter.startTAG("systemName").textNode(SystemCache.getOrCreateSystemName(this.getName())).end();
        }
        ProcessIOUtils.writeSetTasks(this.tasks, xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.setName(xMLableReader.getAttrAsString("name", "Process"));
            this.setDescript(xMLableReader.getAttrAsString("descript", null));
            this.setHeight(xMLableReader.getAttrAsInt("height", 600));
            this.setWidth(xMLableReader.getAttrAsInt("width", 800));
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals(string, "TriggerID")) {
                this.triggerId = xMLableReader.getElementValue();
            } else if (ComparatorUtils.equals(string, "Tasks")) {
                this.tasks = ProcessIOUtils.readSetTasks(xMLableReader);
            } else if (ComparatorUtils.equals(string, "processName")) {
                this.setShareProcessName(xMLableReader.getElementValue());
            } else if (ComparatorUtils.equals(string, "systemName")) {
                this.setSystemName(xMLableReader.getElementValue());
            } else if (ComparatorUtils.equals(string, "ImageData")) {
                this.setImageData(xMLableReader.getElementValue());
            }
        }
    }

    public void parseJSON(JSONObject jSONObject) {
        try {
            Object object;
            if (jSONObject.has("id")) {
                this.setId(jSONObject.getLong("id"));
            }
            if (jSONObject.has("name")) {
                this.setName(jSONObject.getString("name"));
            }
            if (jSONObject.has("descript")) {
                this.setDescript(jSONObject.getString("descript"));
            }
            if (jSONObject.has("width")) {
                this.setWidth(jSONObject.getInt("width"));
            }
            if (jSONObject.has("height")) {
                this.setHeight(jSONObject.getInt("height"));
            }
            if (jSONObject.has("trigger")) {
                this.trigger = this.parseITrigger(jSONObject.getJSONObject("trigger"));
            }
            if (jSONObject.has("tasks")) {
                object = jSONObject.getJSONArray("tasks");
                int n2 = ((JSONArray)object).length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Task task = JSONUtils.parseTask(((JSONArray)object).getJSONObject(i2));
                    this.tasks.add(task);
                }
            }
            if (jSONObject.has("shareProcessName")) {
                this.setShareProcessName(jSONObject.getString("shareProcessName"));
            }
            if (jSONObject.has("parameters")) {
                object = TransmitParameters.parseJSON(jSONObject.getJSONArray("parameters"));
                this.getSystem().setParameters(new HashSet<Parameter>(Arrays.asList(((TransmitParameters)object).toArray())));
            }
            if (jSONObject.has("imageData")) {
                this.setImageData(jSONObject.getString("imageData"));
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
    }

    private ITrigger parseITrigger(JSONObject jSONObject) {
        ITrigger iTrigger = null;
        try {
            String string = jSONObject.getString("recurrenceType");
            iTrigger = TriggerFactory.createTriggerByName(string).analyzeJSON(jSONObject);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
        return iTrigger;
    }

    private void removeAllTrigger() {
        this.removeScheduleTask();
        this.removeTrigger();
        this.trigger = null;
        this.triggerId = null;
    }

    private void createTrigger() {
        if (StringUtils.isEmpty(this.triggerId)) {
            return;
        }
        int n2 = Integer.parseInt(this.triggerId.substring(0, 1));
        long l2 = Long.parseLong(this.triggerId.substring(1));
        ITrigger iTrigger = TriggerFactory.createTrigger(n2);
        this.trigger = (ITrigger)ScheduleContext.createDAOSession().load(iTrigger.getClass(), l2);
    }

    public JSONObject createJSON() {
        JSONObject jSONObject = new JSONObject();
        try {
            Object object;
            if (this.getId() > 0L) {
                jSONObject.put("id", this.getId());
            }
            jSONObject.put("name", this.getName());
            jSONObject.put("width", this.getWidth());
            jSONObject.put("height", this.getHeight());
            if (StringUtils.isNotEmpty(this.descript)) {
                jSONObject.put("descript", this.descript);
            }
            if (StringUtils.isNotEmpty(this.triggerId) && this.trigger == null) {
                this.createTrigger();
            }
            if (this.trigger != null) {
                jSONObject.put("trigger", this.trigger.createJSONConfig());
            }
            if (StringUtils.isNotEmpty(this.imageData)) {
                jSONObject.put("imageData", this.imageData);
            }
            if (this.getParametersLength() > 0) {
                object = new TransmitParameters(this.getSystem().getParameters().toArray(new Parameter[this.getParametersLength()]));
                jSONObject.put("parameters", ((TransmitParameters)object).createJSON());
            }
            if (this.tasks.size() > 0) {
                object = new JSONArray();
                for (Task task : this.tasks) {
                    try {
                        ((JSONArray)object).put(task.createJSON());
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().error(exception.getMessage(), exception);
                    }
                }
                jSONObject.put("tasks", object);
            }
            if (StringUtils.isNotEmpty(this.getShareProcessName())) {
                jSONObject.put("shareProcessName", this.getShareProcessName());
            }
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof ProcessOB && this.width == ((ProcessOB)object).width && this.height == ((ProcessOB)object).height && ComparatorUtils.equals(this.name, ((ProcessOB)object).name) && ComparatorUtils.equals(this.trigger, ((ProcessOB)object).trigger) && ComparatorUtils.equals(this.getSystemName(), ((ProcessOB)object).getSystemName()) && ComparatorUtils.equals(this.tasks, ((ProcessOB)object).tasks);
    }

    public boolean equalsMainProper(Object object) {
        if (this.tasks.size() > 0) {
            Iterator iterator = this.tasks.iterator();
            Iterator iterator2 = ((ProcessOB)object).tasks.iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                if (((Task)iterator.next()).equalsMainProper(iterator2.next())) continue;
                return false;
            }
        }
        return object != null && object instanceof ProcessOB && ComparatorUtils.equals(this.name, ((ProcessOB)object).name) && ComparatorUtils.equals(this.trigger, ((ProcessOB)object).trigger) && this.tasks.size() == ((ProcessOB)object).tasks.size();
    }

    public void updateProperties(ProcessOB processOB) throws Exception {
        if (this.equalsMainProper(processOB)) {
            ProcessDefineCache.getInstance().addProcessOB(processOB);
            return;
        }
        ProcessDefineCache.getInstance().removeProcess(this.name);
        ProcessDefineCache.getInstance().addProcessOB(processOB);
        boolean bl = false;
        if (!ComparatorUtils.equals(this.trigger, processOB.trigger)) {
            this.removeAllTrigger();
            processOB.generateScheduleTask();
            bl = true;
        }
        List list = null;
        if (!ComparatorUtils.equals(this.name, processOB.getName())) {
            list = ProcessExecutorCache.getInstance().getProcessExecutorByName(this.name);
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ProcessExecutor processExecutor = (ProcessExecutor)list.get(i2);
                processExecutor.setProcessname(processOB.getName());
                processExecutor.update();
                ProcessExecutorCache.getInstance().addProcessExecutor(processExecutor);
                List list2 = TaskInfo.getDaoAccess().findByKey("processexecutorid", new Long(processExecutor.getId()));
                int n3 = list2.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    TaskInfo taskInfo = (TaskInfo)list2.get(i3);
                    taskInfo.setProcessName(processOB.getName());
                    taskInfo.update();
                }
            }
            if (!bl) {
                this.removeAllTrigger();
                processOB.generateScheduleTask();
            }
        }
        if (this.tasks.size() == 0 || processOB.tasks.size() == 0) {
            return;
        }
        if (this.tasks.size() > 0) {
            this.dealWithTask(processOB, list);
        }
    }

    private void dealWithTask(ProcessOB processOB, List list) {
        for (AbstractTask abstractTask : processOB.tasks) {
            String string = abstractTask.getOldName();
            if (!StringUtils.isNotEmpty(string)) continue;
            if (list == null) {
                list = ProcessExecutorCache.getInstance().getProcessExecutorByName(processOB.getName());
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", string);
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ProcessExecutor processExecutor = (ProcessExecutor)list.get(i2);
                hashMap.put("processexecutorid", new Long(processExecutor.getId()));
                List list2 = TaskInfo.getDaoAccess().findByMap(hashMap);
                int n3 = list2.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    TaskInfo taskInfo = (TaskInfo)list2.get(i3);
                    taskInfo.setName(abstractTask.getName());
                    taskInfo.update();
                }
                if (processExecutor.getActiveTask(string) == null) continue;
                AbstractTask abstractTask2 = (AbstractTask)processExecutor.getActiveTask(string);
                abstractTask2.setName(abstractTask.getName());
                Task4Database task4Database = abstractTask2.getTask4Database();
                task4Database.setName(abstractTask.getName());
                task4Database.update();
            }
        }
    }

    protected int hashCode4Properties() {
        return this.getName().hashCode();
    }

    public boolean equals4Properties(Object object) {
        return ComparatorUtils.equals(this.getName(), ((ProcessOB)object).getName());
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String string) {
        this.systemName = string;
    }

    public String getShareProcessName() {
        return this.shareProcessName;
    }

    public void setShareProcessName(String string) {
        this.shareProcessName = string;
    }

    public String getImageData() {
        return this.imageData;
    }

    public void setImageData(String string) {
        this.imageData = string;
    }
}

