/*
 * Decompiled with CFR 0.152.
 */
package com.fr.process.pdl.io;

import com.fr.base.FRContext;
import com.fr.base.io.XMLReadHelper;
import com.fr.process.pdl.processdefine.SystemOfProcesses;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class SystemIOUtils {
    public static final String SYSTEM = "system";
    public static final String TYPE = ".xml";

    public static SystemOfProcesses readSystem(String string) throws Exception {
        InputStream inputStream = SystemIOUtils.getSystemStream(string);
        XMLableReader xMLableReader = XMLReadHelper.createXMLableReader(SystemIOUtils.getSystemStream(string), "UTF-8");
        String string2 = xMLableReader.getTagName();
        if (!string2.equals("SystemOfProcesses")) {
            throw new Exception("Process XML Wrong!");
        }
        SystemOfProcesses systemOfProcesses = new SystemOfProcesses();
        xMLableReader.readXMLObject(systemOfProcesses);
        inputStream.close();
        return systemOfProcesses;
    }

    public static void writeSystem(SystemOfProcesses systemOfProcesses) throws Exception {
        String string = systemOfProcesses.getSystemName();
        OutputStream outputStream = SystemIOUtils.getOutputStream(string);
        XMLPrintWriter xMLPrintWriter = XMLPrintWriter.create(outputStream);
        systemOfProcesses.writeXML(xMLPrintWriter);
        xMLPrintWriter.flush();
        xMLPrintWriter.close();
        outputStream.flush();
        outputStream.close();
    }

    public static void removeSystemFile(String string) throws Exception {
        File file = new File(SystemIOUtils.generatePath(string));
        if (file.exists()) {
            file.delete();
        }
    }

    private static OutputStream getOutputStream(String string) throws Exception {
        File file = new File(SystemIOUtils.generatePath(string));
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        return new FileOutputStream(file);
    }

    private static InputStream getSystemStream(String string) throws Exception {
        File file = new File(SystemIOUtils.generatePath(string));
        return new FileInputStream(file);
    }

    private static String generatePath(String string) {
        return FRContext.getCurrentEnv().getPath() + File.separator + "process" + File.separator + SYSTEM + File.separator + string + TYPE;
    }
}

