/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.providers.ldap;

import com.fr.general.Inter;
import com.fr.privilege.Authentication;
import com.fr.privilege.Authority;
import com.fr.privilege.providers.AbstractAuthenticationProvider;
import com.fr.privilege.providers.ldap.LDAPUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class LDAPAuthenticationProvider
extends AbstractAuthenticationProvider {
    private static final long serialVersionUID = 9074755359875747439L;
    private static final String SUN_CONNECTION_POOLING_PROPERTY = "com.sun.jndi.ldap.connect.pool";
    private static final String SUN_DEFAULT_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    public static final String AUTH_SIMPLE = "simple";
    public static final String AUTH_NONE = "none";
    public static final String AUTH_STRONG = "strong";
    public static final String REFERRAL_FOLLOW = "follow";
    public static final String REFERRAL_IGNORE = "ignore";
    public static final String REFERRAL_THROW = "throw";
    private String url = "ldap://ip:389";
    private String searchBase = "";
    private String principalSuffix = "";
    private String systemUsername = null;
    private String systemPassword = null;
    private String authentication = "simple";
    private String contextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private String referral = "follow";
    private boolean usePool = true;
    private String roleAttribute = "memberOf";

    public int uType() {
        return 1;
    }

    public boolean authenticate(Authentication authentication) throws Exception {
        super.isRootManager(authentication);
        if (authentication == null) {
            throw new Exception(Inter.getLocText("Privilege-The_Authentication_Can_Not_Be_Null") + ".");
        }
        if (authentication.isAuthenticated()) {
            return true;
        }
        String string = authentication.getPrincipal().toString();
        LdapContext ldapContext = null;
        try {
            ldapContext = this.getLdapContext(string, authentication.getCredentials().toString());
        }
        catch (Exception exception) {
            throw new Exception(Inter.getLocText("Privilege-Invalid_User_Or_Password") + ".");
        }
        Authority[] authorityArray = LDAPUtils.retrievalAuthority(string, this, ldapContext);
        ldapContext.close();
        authentication.setAuthenticated(true);
        authentication.setAuthorities(authorityArray);
        return true;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getPrincipalSuffix() {
        return this.principalSuffix;
    }

    public void setPrincipalSuffix(String string) {
        this.principalSuffix = string;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String string) {
        this.authentication = string;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(String string) {
        this.contextFactory = string;
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public void setSearchBase(String string) {
        this.searchBase = string;
    }

    public String getReferral() {
        return this.referral;
    }

    public void setReferral(String string) {
        this.referral = string;
    }

    public String getSystemUsername() {
        return this.systemUsername;
    }

    public void setSystemUsername(String string) {
        this.systemUsername = string;
    }

    public String getSystemPassword() {
        return this.systemPassword;
    }

    public void setSystemPassword(String string) {
        this.systemPassword = string;
    }

    public boolean isUsePool() {
        return this.usePool;
    }

    public void setUsePool(boolean bl) {
        this.usePool = bl;
    }

    public String getRoleAttribute() {
        return this.roleAttribute;
    }

    public void setRoleAttribute(String string) {
        this.roleAttribute = string;
    }

    private LdapContext getLdapContext(String string, String string2) throws NamingException {
        if (StringUtils.isBlank(this.url)) {
            throw new IllegalStateException(Inter.getLocText("Privilege-The_Url_Must_Be_Specified") + ".");
        }
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", this.contextFactory);
        properties.put("java.naming.provider.url", this.url);
        if (this.usePool && !StringUtils.isBlank(string) && string.equals(this.systemUsername)) {
            properties.put(SUN_CONNECTION_POOLING_PROPERTY, "true");
        }
        if (!StringUtils.isBlank(string) && !StringUtils.isBlank(this.principalSuffix)) {
            string = string + this.principalSuffix;
        }
        if (!StringUtils.isBlank(string)) {
            properties.put("java.naming.security.principal", string);
        }
        if (StringUtils.isBlank(string2)) {
            throw new IllegalStateException(Inter.getLocText("Privilege-The_Password_Cannot_Be_Blank") + ".");
        }
        properties.put("java.naming.security.credentials", string2);
        properties.put("java.naming.security.authentication", this.authentication);
        properties.put("java.naming.referral", this.referral);
        return new InitialLdapContext(properties, null);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("LUSAttr")) {
            String string2 = null;
            string2 = xMLableReader.getAttrAsString("url", null);
            if (string2 != null) {
                this.url = string2;
            }
            if ((string2 = xMLableReader.getAttrAsString("searchBase", null)) != null) {
                this.searchBase = string2;
            }
            if ((string2 = xMLableReader.getAttrAsString("principalSuffix", null)) != null) {
                this.principalSuffix = string2;
            }
            if ((string2 = xMLableReader.getAttrAsString("systemUsername", null)) != null) {
                this.systemUsername = string2;
            }
            if ((string2 = xMLableReader.getAttrAsString("systemPassword", null)) != null) {
                this.systemPassword = string2;
            }
            if ((string2 = xMLableReader.getAttrAsString("authentication", null)) != null) {
                this.authentication = string2;
            }
            if ((string2 = xMLableReader.getAttrAsString("contextFactory", null)) != null) {
                this.contextFactory = string2;
            }
            if ((string2 = xMLableReader.getAttrAsString("referral", null)) != null) {
                this.referral = string2;
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("LUSAttr");
        if (StringUtils.isNotBlank(this.url)) {
            xMLPrintWriter.attr("url", this.url);
        }
        if (StringUtils.isNotBlank(this.searchBase)) {
            xMLPrintWriter.attr("searchBase", this.searchBase);
        }
        if (StringUtils.isNotBlank(this.principalSuffix)) {
            xMLPrintWriter.attr("principalSuffix", this.principalSuffix);
        }
        if (StringUtils.isNotBlank(this.systemUsername)) {
            xMLPrintWriter.attr("systemUsername", this.systemUsername);
        }
        if (StringUtils.isNotBlank(this.systemPassword)) {
            xMLPrintWriter.attr("systemPassword", this.systemPassword);
        }
        if (StringUtils.isNotBlank(this.authentication)) {
            xMLPrintWriter.attr("authentication", this.authentication);
        }
        if (StringUtils.isNotBlank(this.contextFactory)) {
            xMLPrintWriter.attr("contextFactory", this.contextFactory);
        }
        if (StringUtils.isNotBlank(this.referral)) {
            xMLPrintWriter.attr("referral", this.referral);
        }
        xMLPrintWriter.end();
    }
}

