/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.filter.core;

import com.fr.base.TemplateUtils;
import com.fr.data.DataUtils;
import com.fr.file.ExtraClassManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.ManagerFactory;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.base.PrivilegeVote;
import com.fr.privilege.ui.EmbeddedLogin;
import com.fr.privilege.ui.LoginUI;
import com.fr.stable.fun.NoPrivilegeDirector;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PrivilegeVoteImpls {
    public static final PrivilegeVote SUCCESS = new PrivilegeVote(){

        public boolean isPermitted() {
            return true;
        }

        public void action(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        }

        public String toString() {
            return "VOTE:SUCCESS";
        }
    };
    public static final PrivilegeVote MP_ROLE_ERROR = new PrivilegeVote(){

        public boolean isPermitted() {
            return false;
        }

        public void action(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("charset", ManagerFactory.getConfigProvider().getServerCharset());
            hashMap.put("title", Inter.getLocText("HasNoPrivilegeToVisit"));
            DataUtils.writeOutTemplate("/com/fr/fs/privilege/html/noPri.html", httpServletResponse, hashMap);
        }

        public String toString() {
            return "VOTE:MP_ROLE_ERROR";
        }
    };
    public static final PrivilegeVote MP_AUTH_ERROR = new PrivilegeVote(){

        public boolean isPermitted() {
            return false;
        }

        public void action(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
            HttpSession httpSession = httpServletRequest.getSession(true);
            httpSession.setAttribute("fr_template_originalUrl", (Object)DataUtils.getOriginalURL(httpServletRequest));
            Cookie cookie = new Cookie("isDefaultUser", ComparatorUtils.equals(PrivilegeManager.getInstance().getRootManagerName(), "admin") && ComparatorUtils.equals(PrivilegeManager.getInstance().getRootManagerPassword(), "123456") ? "true" : "false");
            httpServletResponse.addCookie(cookie);
            NoPrivilegeDirector noPrivilegeDirector = ExtraClassManager.getInstance().getNoPrivilegeDirector();
            if (noPrivilegeDirector != null) {
                String string = noPrivilegeDirector.getDirection();
                httpServletResponse.sendRedirect(string);
            } else {
                PrivilegeVoteImpls.jumpToLoginPage(httpServletRequest, httpServletResponse);
            }
        }

        public String toString() {
            return "VOTE:MP_AUTH_ERROR";
        }
    };
    public static final PrivilegeVote MP_AUTH_TIMEOUT = new PrivilegeVote(){

        public boolean isPermitted() {
            return false;
        }

        public void action(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
            HashMap hashMap = new HashMap();
            DataUtils.writeOutTemplate("/com/fr/web/platform/html/authtimeout.html", httpServletResponse, hashMap);
        }

        public String toString() {
            return "VOTE:MP_AUTH_TIMEOUT";
        }
    };
    public static final PrivilegeVote MP_AUTH_PLATFORM_ERROR = new PrivilegeVote(){

        public boolean isPermitted() {
            return false;
        }

        public void action(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
            HttpSession httpSession = httpServletRequest.getSession(true);
            httpSession.setAttribute("fr_from", (Object)DataUtils.getOriginalURL(httpServletRequest));
            httpServletResponse.sendRedirect(TemplateUtils.render("${servletURL}?op=fr_auth&cmd=ah_logout&_=" + System.currentTimeMillis()));
        }

        public String toString() {
            return "VOTE:MP_AUTH_PLATFORM_ERROR";
        }
    };

    private static void jumpToLoginPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrivilegeManager privilegeManager = PrivilegeManager.getInstance();
        LoginUI loginUI = privilegeManager.getUi();
        if (loginUI == null) {
            loginUI = new EmbeddedLogin();
        }
        loginUI.redirect2LoginUI(httpServletRequest, httpServletResponse);
    }
}

