/*
 * Decompiled with CFR 0.152.
 */
package com.fr.page;

import com.fr.base.BaseUtils;
import com.fr.base.BaseXMLUtils;
import com.fr.base.DynamicNumberList;
import com.fr.base.DynamicPixList;
import com.fr.base.DynamicUnitList;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.Style;
import com.fr.base.background.ColorBackground;
import com.fr.cache.list.IntList;
import com.fr.data.DataUtils;
import com.fr.data.TableDataSource;
import com.fr.general.Background;
import com.fr.general.FArray;
import com.fr.general.PageCalObj;
import com.fr.js.JavaScript;
import com.fr.js.NameJavaScript;
import com.fr.js.NameJavaScriptGroup;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.page.ClippedPage;
import com.fr.page.HtmlWriteContent;
import com.fr.page.JSONWriteContent;
import com.fr.page.PagePainterProvider;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportPageAttrProvider;
import com.fr.page.stable.ReportPageAttr;
import com.fr.parser.ColumnRowRangeInPage;
import com.fr.report.ReportHelper;
import com.fr.report.cell.Cell;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.FloatElement;
import com.fr.report.cell.cellattr.BrokenCellInfo;
import com.fr.report.cell.cellattr.CellPageAttr;
import com.fr.report.cell.cellattr.PageExportCellElement;
import com.fr.report.cell.cellattr.core.CellUtils;
import com.fr.report.cell.cellattr.core.ResultSubReport;
import com.fr.report.cellcase.CellCase;
import com.fr.report.cellcase.DefaultCellCase;
import com.fr.report.core.A.d;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.ReportUtils;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.elementcase.ElementGetter;
import com.fr.report.elementcase.ResultElementCase;
import com.fr.report.report.Report;
import com.fr.report.report.ResultReport;
import com.fr.script.Calculator;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.DeathCycleException;
import com.fr.stable.FCloneable;
import com.fr.stable.FT;
import com.fr.stable.ParameterProvider;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.html.Tag;
import com.fr.stable.script.AbstractNameSpace;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ColumnRowRange;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNIT;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.FRFile;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import com.fr.xml.ReportXMLUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.imageio.ImageIO;

public class ClippedECPage
extends ClippedPage
implements ElementGetter,
Serializable,
FCloneable {
    protected static final String XML_TAG = "ClippedPage";
    protected ResultReport source_report;
    protected ResultElementCase source_element_case;
    private FT[] column_line_array;
    private FT[] row_line_array;
    private IntList row_height_index_list = null;
    private IntList column_width_index_list = null;
    private DynamicPixList columnWidthList;
    private DynamicPixList rowHeightList;
    private PaperSettingProvider paperSetting;
    private static Iterator emptyIterator = new Iterator(){

        public void remove() {
        }

        public Object next() {
            return null;
        }

        public boolean hasNext() {
            return false;
        }
    };

    public ClippedECPage() {
        super(UNIT.ZERO, UNIT.ZERO, 0, 0);
    }

    public ClippedECPage(ResultReport resultReport, ResultElementCase resultElementCase, int n2, PaperSettingProvider paperSettingProvider, FT[] fTArray, FT[] fTArray2, int n3, int n4) {
        this(resultReport, resultElementCase, n2, paperSettingProvider, fTArray, fTArray2, UNIT.ZERO, UNIT.ZERO, n3, n4);
    }

    public ClippedECPage(ResultReport resultReport, ResultElementCase resultElementCase, int n2, PaperSettingProvider paperSettingProvider, FT[] fTArray, FT[] fTArray2, UNIT uNIT, UNIT uNIT2, int n3, int n4) {
        super(uNIT, uNIT2, n3, n4);
        this.source_report = resultReport;
        this.source_element_case = resultElementCase;
        this.totalPageNumber = n2;
        this.row_line_array = fTArray;
        this.column_line_array = fTArray2;
        this.paperSetting = paperSettingProvider;
        this.columnWidthList = ReportHelper.getColumnWidthList(this.source_element_case).toDynamicPixList();
        this.rowHeightList = ReportHelper.getRowHeightList(this.source_element_case).toDynamicPixList();
        this.initRowHeightArray();
        this.initColumnWidthArray();
    }

    public UNIT getActualWidth() {
        FU fU = UNIT.ZERO;
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            fU = fU.add(this.getColumnWidth(i2));
        }
        return fU;
    }

    public UNIT getActualHeight() {
        FU fU = UNIT.ZERO;
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            fU = fU.add(this.getRowHeight(i2));
        }
        return fU;
    }

    private void initColumnWidthArray() {
        if (this.column_width_index_list == null) {
            this.column_width_index_list = new IntList();
            for (int i2 = 0; i2 < this.column_line_array.length; ++i2) {
                FT fT = this.column_line_array[i2];
                for (int i3 = fT.from; i3 < fT.to; ++i3) {
                    this.column_width_index_list.add(i3);
                }
            }
        }
    }

    private void initRowHeightArray() {
        if (this.row_height_index_list == null) {
            this.row_height_index_list = new IntList();
            for (int i2 = 0; i2 < this.row_line_array.length; ++i2) {
                FT fT = this.row_line_array[i2];
                for (int i3 = fT.from; i3 < fT.to; ++i3) {
                    this.row_height_index_list.add(i3);
                }
            }
        }
    }

    private Iterator cellIterator(Rectangle rectangle) {
        return this.source_element_case.intersect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void paintPage(PagePainterProvider pagePainterProvider, Graphics2D graphics2D, int n2) {
        DynamicNumberList dynamicNumberList = this.getColumnWidthDynamicPixList();
        DynamicNumberList dynamicNumberList2 = this.getRowHeightDynamicPixList();
        int n3 = this.getOffsetX().toPixI(n2);
        int n4 = this.getOffsetY().toPixI(n2);
        pagePainterProvider.prepareCell(this, dynamicNumberList, dynamicNumberList2, n3, n4);
        pagePainterProvider.prepareFloat(this, dynamicNumberList, dynamicNumberList2, n3, n4);
    }

    public void writeHTML(HtmlWriteContent htmlWriteContent, Tag tag, Rectangle2D rectangle2D, Repository repository) {
        htmlWriteContent.writeContent(tag, this, repository);
    }

    public void writeJSON(JSONWriteContent jSONWriteContent, JSONObject jSONObject, Repository repository) throws JSONException {
        jSONWriteContent.writeContent(jSONObject, this, repository);
    }

    public ReportPageAttrProvider getReportPageAttr() {
        return this.source_element_case.getReportPageAttr();
    }

    public FU getColumnWidth(int n2) {
        return this.source_element_case.getColumnWidth(this.column_width_index_list.get(n2));
    }

    public FU getRowHeight(int n2) {
        return this.source_element_case.getRowHeight(this.row_height_index_list.get(n2));
    }

    public DynamicNumberList getColumnWidthDynamicPixList(int n2) {
        this.resolution = n2;
        return this.getColumnWidthDynamicPixList();
    }

    public DynamicNumberList getColumnWidthDynamicPixList() {
        int n2 = this.column_width_index_list.size();
        DynamicNumberList dynamicNumberList = new DynamicNumberList(0, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            dynamicNumberList.set(i2, this.columnWidthList.get(this.column_width_index_list.get(i2), this.resolution));
        }
        return dynamicNumberList;
    }

    public void setColumnWidthDynamicPixList(DynamicPixList dynamicPixList) {
        this.columnWidthList = dynamicPixList;
    }

    public DynamicNumberList getRowHeightDynamicPixList(int n2) {
        this.resolution = n2;
        return this.getRowHeightDynamicPixList();
    }

    public DynamicNumberList getRowHeightDynamicPixList() {
        if (this.row_height_index_list == null) {
            this.initRowHeightArray();
        }
        int n2 = this.row_height_index_list.size();
        DynamicNumberList dynamicNumberList = new DynamicNumberList(0, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.rowHeightList == null) continue;
            int n3 = this.rowHeightList.get(this.row_height_index_list.get(i2), this.resolution);
            dynamicNumberList.set(i2, n3);
        }
        return dynamicNumberList;
    }

    public void setRowHeightDynamicPixList(DynamicPixList dynamicPixList) {
        this.rowHeightList = dynamicPixList;
    }

    public Iterator cellIterator() {
        return new PageCellIterator();
    }

    public int getColumnCount() {
        return this.column_width_index_list.size();
    }

    public Iterator getRow(int n2) {
        return new PageRowIterator(n2);
    }

    public int getRowCount() {
        return this.row_height_index_list.size();
    }

    public Iterator floatIterator() {
        return new PageFloatIterator();
    }

    public int getWebPageWidth() {
        if (this.paperSetting != null) {
            return ReportUtils.getPaperWidth(this.paperSetting).toPixI(this.resolution);
        }
        return this.getContentWidth();
    }

    public int getContentWidth() {
        DynamicUnitList dynamicUnitList = ReportHelper.createColumnWidthList(this);
        int n2 = Math.max(dynamicUnitList.getRangeValueFromZero(this.getColumnCount()).toPixI(96), 1);
        Iterator iterator = this.floatIterator();
        while (iterator.hasNext()) {
            FloatElement floatElement = (FloatElement)iterator.next();
            float f2 = floatElement.getLeftDistance_inClippedPage().toPixF(96);
            float f3 = floatElement.getWidth().toPixF(96) + 1.0f;
            n2 = Math.max(n2, (int)(f2 + f3));
        }
        return n2;
    }

    public int getWebPageHeight() {
        if (this.paperSetting != null) {
            return ReportUtils.getPaperHeight(this.paperSetting).toPixI(this.resolution);
        }
        return this.getContentHeight();
    }

    public int getContentHeight() {
        DynamicUnitList dynamicUnitList = ReportHelper.createRowHeightList(this);
        int n2 = Math.max(dynamicUnitList.getRangeValueFromZero(this.getRowCount()).toPixI(96), 1);
        Iterator iterator = this.floatIterator();
        while (iterator.hasNext()) {
            FloatElement floatElement = (FloatElement)iterator.next();
            float f2 = floatElement.getTopDistance_inClippedPage().toPixF(96);
            float f3 = floatElement.getHeight().toPixF(96) + 1.0f;
            n2 = Math.max(n2, (int)(f2 + f3));
        }
        return n2;
    }

    public UNIT getMarginTop() {
        if (this.paperSetting != null) {
            return this.paperSetting.getMargin().getTop();
        }
        return UNIT.ZERO;
    }

    public UNIT getMarginLeft() {
        if (this.paperSetting != null) {
            return this.paperSetting.getMargin().getLeft();
        }
        return UNIT.ZERO;
    }

    public UNIT getMarginBottom() {
        if (this.paperSetting != null) {
            return this.paperSetting.getMargin().getBottom();
        }
        return UNIT.ZERO;
    }

    public UNIT getMarginRight() {
        if (this.paperSetting != null) {
            return this.paperSetting.getMargin().getRight();
        }
        return UNIT.ZERO;
    }

    protected PageExportCellElement createPageExportCellElement(CellElement cellElement, int n2, int n3, int n4, int n5) {
        return new PageExportCellElement(cellElement, n2, n3, n4, n5);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        Object object;
        Object object2;
        xMLPrintWriter.startTAG("CellElementList");
        Iterator iterator = this.cellIterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (!(object2 instanceof CellElement)) continue;
            ReportXMLUtils.writeReportPageCellElement(xMLPrintWriter, (PageExportCellElement)object2);
        }
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("FloatElementList");
        object2 = this.floatIterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!(object instanceof FloatElement)) continue;
            FloatElement floatElement = (FloatElement)object;
            ReportXMLUtils.writeFloatElement(xMLPrintWriter, floatElement);
        }
        xMLPrintWriter.end();
        object = new long[this.getColumnCount()];
        for (int i2 = 0; i2 < ((E)object).length; ++i2) {
            object[i2] = this.getColumnWidth(i2).toFU();
        }
        xMLPrintWriter.startTAG("WIDTH").textNode(BaseUtils.toLongArrayString(object, ',')).end();
        long[] lArray = new long[this.getRowCount()];
        for (int i3 = 0; i3 < lArray.length; ++i3) {
            lArray[i3] = this.getRowHeight(i3).toFU();
        }
        xMLPrintWriter.startTAG("HEIGHT").textNode(BaseUtils.toLongArrayString(lArray, ',')).end();
        xMLPrintWriter.startTAG("PixWidth");
        BaseXMLUtils.writeDynamicNumberList(xMLPrintWriter, this.getColumnWidthDynamicPixList(96));
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("PixHeight");
        BaseXMLUtils.writeDynamicNumberList(xMLPrintWriter, this.getRowHeightDynamicPixList(96));
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static class EmptyClippedReportPage
    extends ClippedECPage {
        public ReportPageAttrProvider getReportPageAttr() {
            return new ReportPageAttr();
        }

        public DynamicNumberList getColumnWidthDynamicPixList() {
            return new DynamicNumberList(0, 0);
        }

        public DynamicNumberList getRowHeightDynamicPixList() {
            return new DynamicNumberList(0, 0);
        }

        public Iterator cellIterator() {
            return emptyIterator;
        }

        public int getColumnCount() {
            return 0;
        }

        public FU getColumnWidth(int n2) {
            return UNIT.ZERO;
        }

        public Iterator getRow(int n2) {
            return emptyIterator;
        }

        public int getRowCount() {
            return 0;
        }

        public FU getRowHeight(int n2) {
            return UNIT.ZERO;
        }

        public Iterator floatIterator() {
            return emptyIterator;
        }
    }

    public static class XMLClippedReportPage
    extends ClippedECPage
    implements XMLReadable {
        private CellCase cellCase = new DefaultCellCase();
        private List floatElementList = new ArrayList();
        private long[] columnWidthArray;
        private long[] rowHeightArray;
        private DynamicNumberList colPixList;
        private DynamicNumberList rowPixList;

        public Iterator cellIterator() {
            return this.cellCase.cellIterator();
        }

        public int getColumnCount() {
            return this.cellCase.getColumnCount();
        }

        public FU getColumnWidth(int n2) {
            return FU.getInstance(this.columnWidthArray[n2]);
        }

        public Iterator getRow(int n2) {
            return this.cellCase.getRow(n2);
        }

        public DynamicNumberList getColumnWidthDynamicPixList() {
            return this.colPixList;
        }

        public DynamicNumberList getRowHeightDynamicPixList() {
            return this.rowPixList;
        }

        public int getRowCount() {
            return this.cellCase.getRowCount();
        }

        public FU getRowHeight(int n2) {
            return FU.getInstance(this.rowHeightArray[n2]);
        }

        public Iterator floatIterator() {
            return this.floatElementList.iterator();
        }

        public void readXML(XMLableReader xMLableReader) {
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode()) {
                        String string = xMLableReader.getTagName();
                        if ("CellElementList".equals(string)) {
                            xMLableReader.readXMLObject(new XMLReadable(){

                                public void readXML(XMLableReader xMLableReader) {
                                    if (xMLableReader.isChildNode()) {
                                        PageExportCellElement pageExportCellElement = new PageExportCellElement();
                                        xMLableReader.readXMLObject(pageExportCellElement);
                                        XMLClippedReportPage.this.cellCase.add(pageExportCellElement, true);
                                    }
                                }
                            });
                        } else if ("FloatElementList".equals(string)) {
                            ReportXMLUtils.readFloatElementList(xMLableReader, XMLClippedReportPage.this.floatElementList, XMLClippedReportPage.this);
                        } else if ("WIDTH".equals(string)) {
                            XMLClippedReportPage.access$1102(XMLClippedReportPage.this, BaseUtils.toLongArrayFromStr(xMLableReader.getElementValue(), ','));
                        } else if ("HEIGHT".equals(string)) {
                            XMLClippedReportPage.access$1202(XMLClippedReportPage.this, BaseUtils.toLongArrayFromStr(xMLableReader.getElementValue(), ','));
                        } else if ("PixWidth".equals(string)) {
                            XMLClippedReportPage.this.colPixList = BaseXMLUtils.readDynamicNumberList(xMLableReader);
                        } else if ("PixHeight".equals(string)) {
                            XMLClippedReportPage.this.rowPixList = BaseXMLUtils.readDynamicNumberList(xMLableReader);
                        } else if ("ClippedAttr".equals(string)) {
                            XMLClippedReportPage.this.offsetX = FU.getInstance(xMLableReader.getAttrAsLong("x", 0L));
                            XMLClippedReportPage.this.offsetY = FU.getInstance(xMLableReader.getAttrAsLong("y", 0L));
                        }
                    }
                }
            });
        }

        static /* synthetic */ long[] access$1102(XMLClippedReportPage xMLClippedReportPage, long[] lArray) {
            xMLClippedReportPage.columnWidthArray = lArray;
            return lArray;
        }

        static /* synthetic */ long[] access$1202(XMLClippedReportPage xMLClippedReportPage, long[] lArray) {
            xMLClippedReportPage.rowHeightArray = lArray;
            return lArray;
        }
    }

    private class PageFloatIterator
    implements Iterator {
        private Iterator current_it;
        private FloatElement next = null;
        private int resolution;

        private PageFloatIterator() {
            this.resolution = ClippedECPage.this.resolution;
            this.current_it = ClippedECPage.this.source_element_case.floatIterator();
            this.findNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            FloatElement floatElement = this.next;
            this.findNext();
            return floatElement;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            while (this.current_it.hasNext()) {
                Point point = new Point(0, 0);
                FloatElement floatElement = (FloatElement)this.current_it.next();
                for (int i2 = 0; i2 < ClippedECPage.this.column_line_array.length; ++i2) {
                    FT fT = ClippedECPage.this.column_line_array[i2];
                    for (int i3 = 0; i3 < ClippedECPage.this.row_line_array.length; ++i3) {
                        FT fT2 = ClippedECPage.this.row_line_array[i3];
                        Rectangle rectangle = new Rectangle(fT.from, fT2.from, fT.to - fT.from, fT2.to - fT2.from);
                        Rectangle rectangle2 = new Rectangle(ClippedECPage.this.columnWidthList.getRangeValueFromZero(rectangle.x, this.resolution), ClippedECPage.this.rowHeightList.getRangeValueFromZero(rectangle.y, this.resolution), ClippedECPage.this.columnWidthList.getRangeValue(rectangle.x, rectangle.x + rectangle.width, this.resolution), ClippedECPage.this.rowHeightList.getRangeValue(rectangle.y, rectangle.y + rectangle.height, this.resolution));
                        FloatElement floatElement2 = this.intersectFloatElement(floatElement, rectangle, rectangle2, point, ClippedECPage.this.columnWidthList, ClippedECPage.this.rowHeightList);
                        if (floatElement2 != null) {
                            this.next = floatElement2;
                            return;
                        }
                        point.y += fT2.to - fT2.from;
                    }
                    point.y = 0;
                    point.x += fT.to - fT.from;
                }
            }
            this.next = null;
        }

        private FloatElement intersectFloatElement(FloatElement floatElement, Rectangle rectangle, Rectangle rectangle2, Point point, DynamicPixList dynamicPixList, DynamicPixList dynamicPixList2) {
            Rectangle rectangle3 = new Rectangle(floatElement.getLeftDistance().toPixI(this.resolution), floatElement.getTopDistance().toPixI(this.resolution), floatElement.getWidth().toPixI(this.resolution), floatElement.getHeight().toPixI(this.resolution));
            Rectangle rectangle4 = rectangle2.intersection(rectangle3);
            if (rectangle4.width > 0 && rectangle4.height > 0) {
                try {
                    floatElement = floatElement.deriveFloatElement(FU.valueOfPix(rectangle4.x, this.resolution), FU.valueOfPix(rectangle4.y, this.resolution), FU.valueOfPix(rectangle4.width, this.resolution), FU.valueOfPix(rectangle4.height, this.resolution));
                    if (rectangle3.y < rectangle2.y && rectangle3.y + rectangle3.height > rectangle2.y) {
                        floatElement.setTopDistance_inClippedPage(FU.getInstance(1L));
                    }
                    if (rectangle3.x < rectangle2.x && rectangle3.x + rectangle3.width > rectangle2.x) {
                        floatElement.setLeftDistance_inClippedPage(FU.getInstance(1L));
                    }
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    FRContext.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
                    floatElement.setLeftDistance(FU.valueOfPix(rectangle4.x, this.resolution));
                    floatElement.setTopDistance(FU.valueOfPix(rectangle4.y, this.resolution));
                    floatElement.setWidth(FU.valueOfPix(rectangle4.width, this.resolution));
                    floatElement.setHeight(FU.valueOfPix(rectangle4.height, this.resolution));
                }
                return floatElement;
            }
            return null;
        }
    }

    private class PageRowIterator
    extends RPCellIterator {
        private int current_ri;
        private int row_offset;

        private PageRowIterator(int n2) {
            this.current_ri = -1;
            this.row_offset = -1;
            this.offsetColumnRow = new Point(0, this.initial_row_of_offset_columnrow(n2));
            this.findNext();
        }

        protected int initial_row_of_offset_columnrow(int n2) {
            int n3 = n2;
            for (int i2 = 0; i2 < ClippedECPage.this.row_line_array.length; ++i2) {
                FT fT = ClippedECPage.this.row_line_array[i2];
                int n4 = fT.to - fT.from;
                if (n4 > n3) {
                    this.current_ri = i2;
                    this.row_offset = n3;
                    break;
                }
                n3 -= n4;
            }
            return n2 - n3;
        }

        protected void findNext() {
            if (this.current_ri == -1) {
                return;
            }
            FT fT = ClippedECPage.this.row_line_array[this.current_ri];
            if (this.iterate_columns_by_row(fT, this.row_offset)) {
                return;
            }
            this.next = null;
        }

        protected boolean isCellBelongToThisColumnArea(int n2) {
            return this.current_ci <= n2;
        }

        protected boolean isCellBelongToThisRowArea(int n2) {
            return this.current_ri <= n2;
        }
    }

    private class PageCellIterator
    extends RPCellIterator {
        private int current_ri;
        private int current_row;

        private PageCellIterator() {
            this.current_ri = 0;
            this.current_row = 0;
            this.offsetColumnRow = new Point(0, 0);
            this.findNext();
        }

        protected void findNext() {
            for (int i2 = this.current_ri; i2 < ClippedECPage.this.row_line_array.length; ++i2) {
                FT fT = ClippedECPage.this.row_line_array[i2];
                this.current_ri = i2;
                for (int i3 = this.current_row; i3 < fT.to - fT.from; ++i3) {
                    this.current_row = i3;
                    if (this.iterate_columns_by_row(fT, i3)) {
                        return;
                    }
                    this.current_ci = 0;
                    this.offsetColumnRow.x = 0;
                }
                this.current_row = 0;
                this.offsetColumnRow.y += fT.to - fT.from;
            }
            this.next = null;
        }

        protected boolean isCellBelongToThisColumnArea(int n2) {
            return true;
        }

        protected boolean isCellBelongToThisRowArea(int n2) {
            return true;
        }
    }

    private abstract class RPCellIterator
    implements Iterator {
        private Set executing_cr_set = null;
        private Map executed_statement_map = null;
        private Calculator calculator = Calculator.createCalculator();
        private Iterator current_it;
        protected int current_ci = 0;
        protected Cell next = null;
        protected Point offsetColumnRow;
        private List mergedCellList;

        public RPCellIterator() {
            this.calculator.pushNameSpace(ParameterMapNameSpace.create(ClippedECPage.this.source_report.getResultWorkBook().getExecuteParameters()));
            this.calculator.pushNameSpace(new PageCalNameSpace());
            this.calculator.setAttribute(Report.class, ClippedECPage.this.source_report);
            this.calculator.setAttribute(ElementCase.class, ClippedECPage.this.source_element_case);
            this.calculator.setAttribute(TableDataSource.class, ClippedECPage.this.source_report.getTableDataSource());
            this.mergedCellList = new ArrayList();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            Cell cell = this.next;
            this.findNext();
            return cell;
        }

        protected abstract void findNext();

        protected boolean iterate_columns_by_row(FT fT, int n2) {
            for (int i2 = this.current_ci; i2 < ClippedECPage.this.column_line_array.length; ++i2) {
                Cloneable cloneable;
                this.current_ci = i2;
                FT fT2 = ClippedECPage.this.column_line_array[i2];
                Rectangle rectangle = new Rectangle(fT2.from, fT.from, fT2.to - fT2.from, fT.to - fT.from);
                if (this.current_it == null) {
                    cloneable = new Rectangle(fT2.from, fT.from + n2, fT2.to - fT2.from, 1);
                    this.current_it = ClippedECPage.this.cellIterator((Rectangle)cloneable);
                }
                while (this.current_it.hasNext()) {
                    PageExportCellElement pageExportCellElement;
                    cloneable = (CellElement)this.current_it.next();
                    if (n2 > 0 && cloneable.getRow() < fT.from + n2 || (pageExportCellElement = this.intersectCell((CellElement)cloneable, rectangle, this.offsetColumnRow, ClippedECPage.this.column_line_array, ClippedECPage.this.row_line_array, ClippedECPage.this.columnWidthList, ClippedECPage.this.rowHeightList)) == null) continue;
                    this.next = pageExportCellElement;
                    return true;
                }
                this.current_it = null;
                this.offsetColumnRow.x += fT2.to - fT2.from;
            }
            return false;
        }

        protected PageExportCellElement intersectCell(CellElement cellElement, Rectangle rectangle, Point point, FT[] fTArray, FT[] fTArray2, DynamicPixList dynamicPixList, DynamicPixList dynamicPixList2) {
            Rectangle rectangle2 = new Rectangle(cellElement.getColumn(), cellElement.getRow(), cellElement.getColumnSpan(), cellElement.getRowSpan());
            Rectangle rectangle3 = rectangle2.intersection(rectangle);
            PageExportCellElement pageExportCellElement = null;
            CellPageAttr cellPageAttr = cellElement.getCellPageAttr();
            if (cellPageAttr == null) {
                cellPageAttr = CellPageAttr.DEFAULT_CELLPAGEATTR;
            }
            boolean bl = cellPageAttr.isRepeat() && !(cellElement.getValue() instanceof ResultSubReport);
            Rectangle rectangle4 = null;
            Rectangle rectangle5 = null;
            if (!rectangle3.equals(rectangle2)) {
                FT fT;
                int n2;
                int n3;
                if (!bl) {
                    n3 = ClippedECPage.this.resolution;
                    rectangle4 = new Rectangle(dynamicPixList.getRangeValue(rectangle3.x, rectangle2.x, n3), dynamicPixList2.getRangeValue(rectangle3.y, rectangle2.y, n3), dynamicPixList.getRangeValue(rectangle2.x, rectangle2.x + rectangle2.width, n3), dynamicPixList2.getRangeValue(rectangle2.y, rectangle2.y + rectangle2.height, n3));
                    rectangle5 = new Rectangle(-rectangle4.x, -rectangle4.y, dynamicPixList.getRangeValue(rectangle3.x, rectangle3.x + rectangle3.width, n3), dynamicPixList2.getRangeValue(rectangle3.y, rectangle3.y + rectangle3.height, n3));
                }
                if (this.mergedCellList.contains(cellElement)) {
                    return null;
                }
                n3 = 0;
                int n4 = 0;
                int n5 = 0;
                for (n2 = 0; n2 < fTArray.length; ++n2) {
                    fT = fTArray[n2];
                    if (rectangle2.x >= fT.to || fT.from >= rectangle2.x + rectangle2.width) continue;
                    if (!this.isCellBelongToThisColumnArea(n2)) {
                        return null;
                    }
                    ++n3;
                    n4 += Math.min(fT.to, rectangle2.x + rectangle2.width) - Math.max(rectangle2.x, fT.from);
                }
                for (n2 = 0; n2 < fTArray2.length; ++n2) {
                    fT = fTArray2[n2];
                    if (rectangle2.y >= fT.to || fT.from >= rectangle2.y + rectangle2.height) continue;
                    if (!this.isCellBelongToThisRowArea(n2)) {
                        return null;
                    }
                    ++n3;
                    n5 += Math.min(fT.to, rectangle2.y + rectangle2.height) - Math.max(rectangle2.y, fT.from);
                }
                if (n3 > 1) {
                    this.mergedCellList.add(cellElement);
                    if (n4 == 0) {
                        n4 = rectangle3.width;
                    }
                    if (n5 == 0) {
                        n5 = rectangle3.height;
                    }
                    pageExportCellElement = ClippedECPage.this.createPageExportCellElement(cellElement, point.x + rectangle3.x - rectangle.x, point.y + rectangle3.y - rectangle.y, n4, n5);
                }
            }
            if (pageExportCellElement == null) {
                pageExportCellElement = ClippedECPage.this.createPageExportCellElement(cellElement, point.x + rectangle3.x - rectangle.x, point.y + rectangle3.y - rectangle.y, rectangle3.width, rectangle3.height);
            }
            if (rectangle4 != null) {
                pageExportCellElement.setBrokenCellInfo(new BrokenCellInfo(rectangle4, rectangle5, cellElement.getValue()));
            }
            this.checkCellElementValue(pageExportCellElement, cellElement, rectangle3, rectangle2, rectangle4, rectangle5);
            return pageExportCellElement;
        }

        protected abstract boolean isCellBelongToThisRowArea(int var1);

        protected abstract boolean isCellBelongToThisColumnArea(int var1);

        private void checkCellElementValue(CellElement cellElement, CellElement cellElement2, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4) {
            Object object;
            Object object2;
            XMLReadable xMLReadable;
            Object object3 = cellElement.getValue();
            if (cellElement2.getShowValue() != object3) {
                cellElement.setValue(cellElement2.getShowValue());
                object3 = cellElement.getValue();
            }
            if (object3 instanceof Formula) {
                xMLReadable = (Formula)object3;
                object3 = xMLReadable.getResult();
                cellElement.setValue(object3);
            }
            if (object3 instanceof PageCalObj) {
                object3 = this.resolvePageCalObj(cellElement2, (PageCalObj)object3);
                cellElement.setValue(object3);
            }
            if ((xMLReadable = cellElement2.getNameHyperlinkGroup()) != null) {
                this.dealWithNameJSGroup((NameJavaScriptGroup)xMLReadable);
            }
            int n2 = ClippedECPage.this.resolution;
            if (object3 instanceof FRFile) {
                object2 = (FRFile)object3;
                if ("image".equals(((FRFile)object2).getType())) {
                    try {
                        cellElement.setValue(ImageIO.read(new ByteArrayInputStream(((FRFile)object2).getBytes())));
                    }
                    catch (IOException iOException) {
                        FRContext.getLogger().error(iOException.getMessage(), iOException);
                    }
                }
            } else if (object3 instanceof ResultSubReport) {
                object2 = new Rectangle(ClippedECPage.this.columnWidthList.getRangeValue(rectangle.x, rectangle2.x, n2), ClippedECPage.this.rowHeightList.getRangeValue(rectangle.y, rectangle2.y, n2), ClippedECPage.this.columnWidthList.getRangeValue(cellElement2.getColumn(), cellElement2.getColumn() + cellElement2.getColumnSpan(), n2), ClippedECPage.this.rowHeightList.getRangeValue(cellElement2.getRow(), cellElement2.getRow() + cellElement2.getRowSpan(), n2));
                object = new Rectangle(ClippedECPage.this.columnWidthList.getRangeValue(rectangle2.x, rectangle.x, n2), ClippedECPage.this.rowHeightList.getRangeValue(rectangle2.y, rectangle.y, n2), ClippedECPage.this.columnWidthList.getRangeValue(rectangle.x, rectangle.x + rectangle.width, n2), ClippedECPage.this.rowHeightList.getRangeValue(rectangle.y, rectangle.y + rectangle.height, n2));
                cellElement.setValue(CellUtils.value2Image(object3, n2, cellElement.getStyle(), (Rectangle)object2, (Rectangle)object));
            }
            object3 = cellElement.getValue();
            if (rectangle3 != null && (object3 instanceof String || object3 instanceof Clob)) {
                if (object3 instanceof Clob) {
                    object3 = DataUtils.clob2String((Clob)object3);
                }
                if (rectangle3.width == rectangle4.width && !(object3 instanceof Image)) {
                    object2 = PaintUtils.clipBlockValue(object3, cellElement.getStyle(), rectangle3, rectangle4, n2);
                    cellElement.setValue(object2);
                } else {
                    boolean bl = cellElement2.getCellGUIAttr() != null && cellElement2.getCellGUIAttr().isShowAsHTML();
                    object = CoreGraphHelper.createBufferedImage(rectangle4.width, rectangle4.height, 2);
                    Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
                    graphics2D.setPaint(Color.white);
                    Background background = cellElement2.getStyle().getBackground();
                    if (background == null) {
                        background = ColorBackground.getInstance(Color.white);
                    }
                    background.paint(graphics2D, new Rectangle2D.Double(0.0, 0.0, rectangle4.width, rectangle4.height));
                    if (bl) {
                        PaintUtils.paintHTMLContent(graphics2D, (String)object3, n2, cellElement2.getStyle(), rectangle3, rectangle4);
                    } else {
                        Style.paintContent(graphics2D, object3, n2, cellElement2.getStyle(), rectangle3, rectangle4);
                    }
                    ((Image)object).flush();
                    graphics2D.dispose();
                    cellElement.setValue(object);
                }
            }
        }

        private void dealWithNameJSGroup(NameJavaScriptGroup nameJavaScriptGroup) {
            for (int i2 = 0; i2 < nameJavaScriptGroup.size(); ++i2) {
                NameJavaScript nameJavaScript = nameJavaScriptGroup.getNameHyperlink(i2);
                if (nameJavaScript == null || nameJavaScript.getJavaScript() == null) continue;
                JavaScript javaScript = nameJavaScript.getJavaScript();
                ParameterProvider[] parameterProviderArray = javaScript.getParameters();
                for (int i3 = 0; i3 < parameterProviderArray.length; ++i3) {
                    Object object;
                    if (!(parameterProviderArray[i3].getValue() instanceof Formula) || (object = ((Formula)parameterProviderArray[i3].getValue()).getResult()) != PageCalObj.MARK) continue;
                    PageCalObj pageCalObj = new PageCalObj(((Formula)parameterProviderArray[i3].getValue()).getContent());
                    try {
                        parameterProviderArray[i3].setValue(pageCalObj.resolve(this.calculator));
                        continue;
                    }
                    catch (UtilEvalError utilEvalError) {
                        FRContext.getLogger().error(utilEvalError.getMessage());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object resolvePageCalObj(CellElement cellElement, PageCalObj pageCalObj) {
            if (pageCalObj == null || StringUtils.isBlank(pageCalObj.getContent())) {
                return null;
            }
            ClippedECPage clippedECPage = ClippedECPage.this;
            synchronized (clippedECPage) {
                Object object;
                String string = pageCalObj.getContent();
                if (this.executed_statement_map == null) {
                    this.executed_statement_map = new HashMap(4);
                }
                if (this.executed_statement_map.containsKey(string)) {
                    return this.executed_statement_map.get(string);
                }
                if (this.executing_cr_set == null) {
                    this.executing_cr_set = new HashSet(8);
                }
                if (this.executing_cr_set.contains(cellElement)) {
                    throw new DeathCycleException("Death cycle exists: " + this.executing_cr_set);
                }
                this.executing_cr_set.add(cellElement);
                try {
                    object = pageCalObj.resolve(this.calculator);
                }
                catch (UtilEvalError utilEvalError) {
                    String string2 = "error happens at calculating formula\ncell is " + cellElement + "\nformula expression is " + pageCalObj.getContent() + "\nerror message is " + utilEvalError.getMessage();
                    FRContext.getLogger().error(string2);
                    object = null;
                }
                this.executing_cr_set.remove(cellElement);
                this.executed_statement_map.put(string, object);
                return object;
            }
        }

        private class PageCalNameSpace
        extends AbstractNameSpace {
            PageCalNameSpace() {
            }

            public Object getVariable(Object object, CalculatorProvider calculatorProvider) {
                if (object instanceof ColumnRowRangeInPage) {
                    if ((object = ((ColumnRowRangeInPage)object).getAtom()) instanceof ColumnRowRange) {
                        int[] nArray = d.A((ColumnRowRange)object);
                        if (nArray[0] == Integer.MAX_VALUE) {
                            return Primitive.NULL;
                        }
                        return this.resolveColumnRowInPageIntersect(calculatorProvider, nArray[0], nArray[1], nArray[2], nArray[3]);
                    }
                    return null;
                }
                if ("$$totalPage_number".equals(object)) {
                    return new Integer(ClippedECPage.this.getTotalPageNumber() + ClippedECPage.this.getFirstPageNumber() - 1);
                }
                if ("$$page_number".equals(object)) {
                    return new Integer(ClippedECPage.this.getCurrentPageNumber() + ClippedECPage.this.getFirstPageNumber() - 1);
                }
                if (object instanceof ColumnRowRange) {
                    int[] nArray = d.A((ColumnRowRange)object);
                    if (nArray[0] == Integer.MAX_VALUE) {
                        return Primitive.NULL;
                    }
                    return this.resolveColumnRowIntersect(calculatorProvider, nArray[0], nArray[1], nArray[2], nArray[3]);
                }
                return null;
            }

            private Object dealWithCellElemenetValue(CellElement cellElement) {
                Object object = cellElement.getValue();
                if (object instanceof Formula) {
                    Formula formula = (Formula)object;
                    object = formula.getResult();
                }
                if (object instanceof PageCalObj) {
                    object = RPCellIterator.this.resolvePageCalObj(cellElement, (PageCalObj)object);
                }
                return object;
            }

            private Object resolveColumnRowInPageIntersect(CalculatorProvider calculatorProvider, int n2, int n3, int n4, int n5) {
                int n6;
                FT fT;
                int n7;
                int n8;
                int[] nArray = ClippedECPage.this.source_element_case.getRowMappingArray();
                int[] nArray2 = ClippedECPage.this.source_element_case.getColumnMappingArray();
                if (nArray == null || nArray2 == null) {
                    return Primitive.NULL;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                IntList intList = new IntList(ClippedECPage.this.getRowCount());
                IntList intList2 = new IntList(ClippedECPage.this.getColumnCount());
                for (n8 = n3; n8 < n3 + n5; ++n8) {
                    for (n7 = 0; n7 < ClippedECPage.this.row_line_array.length; ++n7) {
                        fT = ClippedECPage.this.row_line_array[n7];
                        for (n6 = fT.from; n6 < fT.to; ++n6) {
                            if (nArray[n6] != n8) continue;
                            intList.add(n6);
                        }
                    }
                }
                for (n8 = n2; n8 < n2 + n4; ++n8) {
                    for (n7 = 0; n7 < ClippedECPage.this.column_line_array.length; ++n7) {
                        fT = ClippedECPage.this.column_line_array[n7];
                        for (n6 = fT.from; n6 < fT.to; ++n6) {
                            if (nArray2[n6] != n8) continue;
                            intList2.add(n6);
                        }
                    }
                }
                HashSet<Integer> hashSet = new HashSet<Integer>();
                for (n7 = 0; n7 < intList.size(); ++n7) {
                    int n9 = intList.get(n7);
                    for (n6 = 0; n6 < intList2.size(); ++n6) {
                        CellElement cellElement = ClippedECPage.this.source_element_case.getCellElement(intList2.get(n6), intList.get(n7));
                        if (!cellElement.isExist() || hashSet.contains(n9)) continue;
                        int n10 = cellElement.getRowSpan();
                        if (n10 > 1) {
                            hashSet.add(n9 + n10 - 1);
                        }
                        arrayList.add(this.dealWithCellElemenetValue(cellElement));
                    }
                }
                Object object = null;
                object = arrayList.size() == 0 ? Primitive.NULL : (arrayList.size() == 1 ? arrayList.get(0) : new FArray(arrayList));
                return object == null ? Primitive.NULL : object;
            }

            protected Object resolveColumnRowIntersect(CalculatorProvider calculatorProvider, int n2, int n3, int n4, int n5) {
                Object object;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Iterator iterator = ClippedECPage.this.source_element_case.intersect(n2, n3, n4, n5);
                while (iterator.hasNext()) {
                    object = (CellElement)iterator.next();
                    if (!object.isExist()) continue;
                    arrayList.add(this.dealWithCellElemenetValue((CellElement)object));
                }
                object = null;
                object = arrayList.size() == 0 ? Primitive.NULL : (arrayList.size() == 1 ? arrayList.get(0) : new FArray(arrayList));
                return object == null ? Primitive.NULL : object;
            }
        }
    }
}

