/*
 * Decompiled with CFR 0.152.
 */
package com.fr.mobile.service;

import com.fr.base.Base64;
import com.fr.base.FRContext;
import com.fr.cache.Attachment;
import com.fr.cache.AttachmentSource;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.mobile.FMobileConfig;
import com.fr.privilege.Authentication;
import com.fr.privilege.authentication.AuthenticationFactory;
import com.fr.report.cell.painter.barcode.qrcode.QRCode;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSMobileQRCodeAction
extends ActionNoSessionCMD {
    private final char ERRORCORRENTLEVEL = (char)76;
    private final char ENCODEMODE = (char)66;
    private final int VERSION = 5;
    private final int MODULESIZE = 3;
    private final int BASICIMGSIZE = 21;
    private final int INCREASEDNUMOFMODULESBYADDVERSION = 4;
    private BufferedImage bufImg;
    private int imgSize;

    public String getCMD() {
        return "qrcode";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "serverName");
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "serverUrl");
        if (StringUtils.isNotEmpty(string2) && string2.indexOf("?") > 0) {
            string2 = string2.substring(0, string2.indexOf("?"));
        }
        String string3 = this.encodeServerName(string) + "," + this.encodeServerUrl(string2);
        Authentication authentication = AuthenticationFactory.exAuth4CommonAccess(httpServletRequest);
        long l2 = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!(authentication != null && authentication.isRoot() || ModuleControl.getInstance().hasMobileManagerPrivilege(l2))) {
            throw new NoPrivilegeException();
        }
        byte[] byArray = string3.getBytes("GBK");
        boolean[][] blArray = this.getCodeOut(byArray, 5);
        this.imgSize = 3 * this.getModuleNum();
        this.bufImg = new BufferedImage(this.imgSize, this.imgSize, 1);
        Graphics2D graphics2D = this.createGraphics();
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            for (int i3 = 0; i3 < blArray.length; ++i3) {
                if (!blArray[i3][i2]) continue;
                graphics2D.fillRect(i3 * 3, i2 * 3, 3, 3);
            }
        }
        String string4 = this.uploadQRImg(string, string2);
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(string4);
        printWriter.flush();
        printWriter.close();
    }

    private boolean[][] getCodeOut(byte[] byArray, int n2) throws UnsupportedEncodingException {
        boolean[][] blArray;
        QRCode qRCode = this.createQRCode(n2);
        try {
            blArray = qRCode.calQrcode(byArray);
        }
        catch (Exception exception) {
            blArray = this.getCodeOut(byArray, ++n2);
        }
        return blArray;
    }

    private int getModuleNum() {
        return 37;
    }

    private QRCode createQRCode(int n2) {
        QRCode qRCode = new QRCode();
        qRCode.setQrcodeErrorCorrect('L');
        qRCode.setQrcodeEncodeMode('B');
        qRCode.setQrcodeVersion(n2);
        return qRCode;
    }

    private Graphics2D createGraphics() {
        Graphics2D graphics2D = this.bufImg.createGraphics();
        graphics2D.setBackground(Color.WHITE);
        graphics2D.clearRect(0, 0, this.imgSize, this.imgSize);
        graphics2D.setColor(Color.BLACK);
        return graphics2D;
    }

    private String uploadQRImg(String string, String string2) throws Exception {
        String string3 = StableFactory.getAttachmentIDCreator().createID();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)this.bufImg, "png", byteArrayOutputStream);
        Attachment attachment = new Attachment(string3, "image", "crcode", byteArrayOutputStream.toByteArray());
        AttachmentSource.putAttachment(string3, attachment);
        FMobileConfig fMobileConfig = FMobileConfig.getInstance();
        fMobileConfig.setQrcodeImageID4FS(string3);
        fMobileConfig.setQrcodeServerName(string);
        fMobileConfig.setQrcodeServerUrl(string2);
        FRContext.getCurrentEnv().writeResource(fMobileConfig);
        return string3;
    }

    private String encodeServerName(String string) {
        try {
            return Base64.encode(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private String encodeServerUrl(String string) {
        String string2 = "";
        for (int i2 = 0; i2 < string.length(); ++i2) {
            Character c2 = Character.valueOf(string.charAt(i2));
            if (i2 % 2 == 0) {
                c2 = Character.valueOf((char)(c2.charValue() + '\u0001'));
                string2 = string2.concat(String.valueOf(c2));
                continue;
            }
            c2 = Character.valueOf((char)(c2.charValue() - '\u0001'));
            string2 = string2.concat(String.valueOf(c2));
        }
        return string2;
    }
}

