/*
 * Decompiled with CFR 0.152.
 */
package com.fr.mobile;

import com.fr.cache.Attachment;
import com.fr.cache.AttachmentSource;
import com.fr.file.XMLFileManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class FMobileConfig
extends XMLFileManager {
    private static final String XML_TAG = "fmobileconfig";
    private static FMobileConfig MC = null;
    private String qrcodeImageID4FS;
    private String qrcodeServerName;
    private String qrcodeServerUrl;
    private String phoneLaunchImageID;
    private String padLaunchImageID;

    public static FMobileConfig getInstance() {
        if (MC != null) {
            return MC;
        }
        FMobileConfig.refreshFMobileConfig();
        return MC;
    }

    public String fileName() {
        return "fmobileconfig.xml";
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        this.writeQRCodeImageXML(xMLPrintWriter);
        this.writePhoneLaunchImageXML(xMLPrintWriter);
        this.writePadLaunchImageXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.readAttr(xMLableReader);
        }
        if (xMLableReader.isChildNode()) {
            this.readChild(xMLableReader);
        }
    }

    public String getQrcodeImageID4FS() {
        return this.qrcodeImageID4FS;
    }

    public void setQrcodeImageID4FS(String string) {
        this.qrcodeImageID4FS = string;
    }

    public String getQrcodeServerName() {
        return this.qrcodeServerName;
    }

    public void setQrcodeServerName(String string) {
        this.qrcodeServerName = string;
    }

    public String getQrcodeServerUrl() {
        return this.qrcodeServerUrl;
    }

    public void setQrcodeServerUrl(String string) {
        this.qrcodeServerUrl = string;
    }

    public String getPhoneLaunchImageID() {
        return this.phoneLaunchImageID;
    }

    public void setPhoneLaunchImageID(String string) {
        this.phoneLaunchImageID = string;
    }

    public String getPadLaunchImageID() {
        return this.padLaunchImageID;
    }

    public void setPadLaunchImageID(String string) {
        this.padLaunchImageID = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshFMobileConfig() {
        Class<FMobileConfig> clazz = FMobileConfig.class;
        synchronized (FMobileConfig.class) {
            if (MC == null) {
                MC = new FMobileConfig();
            }
            MC.readXMLFile();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private void readAttr(XMLableReader xMLableReader) {
    }

    private void readChild(XMLableReader xMLableReader) {
        String string;
        String string2 = xMLableReader.getTagName();
        if (ComparatorUtils.equals("qrcodeImage", string2)) {
            String string3 = xMLableReader.getAttrAsString("id", null);
            String string4 = xMLableReader.getAttrAsString("name", null);
            String string5 = xMLableReader.getAttrAsString("url", null);
            if (StringUtils.isNotBlank(string3)) {
                this.setQrcodeImageID4FS(string3);
                this.setQrcodeServerName(string4);
                this.setQrcodeServerUrl(string5);
                this.readImageXML(xMLableReader);
            }
        } else if (ComparatorUtils.equals("phoneLaunchImage", string2)) {
            String string6 = xMLableReader.getAttrAsString("id", null);
            if (StringUtils.isNotBlank(string6)) {
                this.setPhoneLaunchImageID(string6);
                this.readImageXML(xMLableReader);
            }
        } else if (ComparatorUtils.equals("padLaunchImage", string2) && StringUtils.isNotBlank(string = xMLableReader.getAttrAsString("id", null))) {
            this.setPadLaunchImageID(string);
            this.readImageXML(xMLableReader);
        }
    }

    private void readImageXML(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("id", null);
        byte[] byArray = GeneralXMLTools.readByteArray(xMLableReader);
        if (StringUtils.isNotBlank(string) && byArray != null) {
            AttachmentSource.putAttachment(string, new Attachment(string, "image", string, byArray));
        }
    }

    private void writeQRCodeImageXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank(this.getQrcodeImageID4FS())) {
            xMLPrintWriter.startTAG("qrcodeImage");
            xMLPrintWriter.attr("id", this.getQrcodeImageID4FS()).attr("name", this.getQrcodeServerName()).attr("url", this.getQrcodeServerUrl());
            GeneralXMLTools.writeByteArray(xMLPrintWriter, AttachmentSource.getAttachment(this.getQrcodeImageID4FS()).getBytes());
            xMLPrintWriter.end();
        }
    }

    private void writePhoneLaunchImageXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank(this.getPhoneLaunchImageID())) {
            xMLPrintWriter.startTAG("phoneLaunchImage");
            xMLPrintWriter.attr("id", this.getPhoneLaunchImageID());
            GeneralXMLTools.writeByteArray(xMLPrintWriter, AttachmentSource.getAttachment(this.getPhoneLaunchImageID()).getBytes());
            xMLPrintWriter.end();
        }
    }

    private void writePadLaunchImageXML(XMLPrintWriter xMLPrintWriter) {
        if (StringUtils.isNotBlank(this.getPadLaunchImageID())) {
            xMLPrintWriter.startTAG("padLaunchImage");
            xMLPrintWriter.attr("id", this.getPadLaunchImageID());
            GeneralXMLTools.writeByteArray(xMLPrintWriter, AttachmentSource.getAttachment(this.getPadLaunchImageID()).getBytes());
            xMLPrintWriter.end();
        }
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                MC = null;
            }
        });
    }
}

