/*
 * Decompiled with CFR 0.152.
 */
package com.fr.log;

import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.general.DeclareRecordType;
import com.fr.general.FRLogManager;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.general.LogDuaration;
import com.fr.io.exporter.AppExporter;
import com.fr.io.exporter.CPTExporter;
import com.fr.io.exporter.Excel2007Exporter;
import com.fr.io.exporter.ExcelExporter;
import com.fr.io.exporter.HTMLExporter;
import com.fr.io.exporter.PDFExporter;
import com.fr.io.exporter.WordExporter;
import com.fr.json.JSONArray;
import com.fr.main.TemplateWorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.PageSetProvider;
import com.fr.stable.Actor;
import com.fr.web.RepositoryHelper;
import com.fr.web.core.ReportRepositoryDeal;
import com.fr.web.core.ReportSessionIDInfor;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.utils.WebUtils;
import com.fr.write.WriteHTMLExporterProvider;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;

public class LogUtils {
    public static ResultWorkBook executeAndLogRecord(TemplateWorkBook templateWorkBook, String string, Map map, Actor actor) {
        if (templateWorkBook == null) {
            return null;
        }
        String string2 = FRLogger.createParamString(map);
        FRLogManager.declareExecuteStart(string, string2, actor.getRecordType());
        try {
            long l2 = System.currentTimeMillis();
            ResultWorkBook resultWorkBook = templateWorkBook.execute(map, actor);
            long l3 = System.currentTimeMillis();
            LogUtils.recordExecuteInfoWithCondition(string, string2, l3 - l2, actor, FRLogManager.getDeclareSQLContent());
            ResultWorkBook resultWorkBook2 = resultWorkBook;
            return resultWorkBook2;
        }
        catch (Exception exception) {
            throw FRLogManager.createLogPackedException(exception);
        }
        finally {
            FRLogManager.declareExecuteEnd();
        }
    }

    public static void recordExecuteInfoWithCondition(String string, String string2, long l2, Actor actor, String string3) {
        if (!actor.shouldRecord()) {
            return;
        }
        LogUtils.recordExecuteInfo(string, actor.getRecordType(), string2, l2, string3);
    }

    public static void exportAndLogRecord(AppExporter appExporter, OutputStream outputStream, ReportRepositoryDeal reportRepositoryDeal, DeclareRecordType declareRecordType) throws Exception {
        ReportSessionIDInfor reportSessionIDInfor = (ReportSessionIDInfor)RepositoryHelper.getSessionIDInfor(reportRepositoryDeal);
        if (appExporter == null || reportSessionIDInfor == null || outputStream == null) {
            return;
        }
        LogUtils.exportAndLogRecord(appExporter, outputStream, reportRepositoryDeal, declareRecordType, reportSessionIDInfor, reportSessionIDInfor.getBookPath(), reportSessionIDInfor.getWorkBook2Show(), reportSessionIDInfor.getPrintPreviewPageSet4Traversing());
    }

    public static void exportAndLogRecord(AppExporter appExporter, OutputStream outputStream, ReportRepositoryDeal reportRepositoryDeal, DeclareRecordType declareRecordType, LogDuaration logDuaration, String string, ResultWorkBook resultWorkBook, PageSetProvider pageSetProvider) throws Exception {
        FRLogManager.setSession(logDuaration);
        String string2 = FRLogger.createParamString(((SessionIDInfor)logDuaration).getParameterMap4Execute4Consisent());
        FRLogManager.declareExportStart(string, string2, declareRecordType);
        String string3 = WebUtils.getHTTPRequestParameter(reportRepositoryDeal.getHttpServletReques(), "sheets");
        int[] nArray = null;
        if (string3 != null) {
            JSONArray jSONArray = new JSONArray(string3);
            nArray = new int[jSONArray.length()];
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                nArray[i2] = jSONArray.getInt(i2);
            }
        }
        try {
            long l2 = System.currentTimeMillis();
            if (appExporter instanceof ExcelExporter) {
                ((ExcelExporter)appExporter).export(outputStream, resultWorkBook, true, nArray);
            } else if (appExporter instanceof Excel2007Exporter) {
                ((Excel2007Exporter)appExporter).export(outputStream, resultWorkBook, true);
            } else if (appExporter instanceof HTMLExporter) {
                ((HTMLExporter)appExporter).export(outputStream, reportRepositoryDeal);
            } else if (appExporter instanceof WriteHTMLExporterProvider) {
                ((WriteHTMLExporterProvider)((Object)appExporter)).export(outputStream, reportRepositoryDeal);
            } else if (appExporter instanceof CPTExporter) {
                appExporter.export(outputStream, resultWorkBook);
            } else if (appExporter instanceof PDFExporter) {
                if (((PDFExporter)appExporter).isPrint()) {
                    appExporter.export(outputStream, pageSetProvider);
                } else {
                    appExporter.export(outputStream, resultWorkBook);
                }
            } else if (appExporter instanceof WordExporter) {
                appExporter.export(outputStream, resultWorkBook);
            } else {
                appExporter.export(outputStream, pageSetProvider);
            }
            long l3 = System.currentTimeMillis();
            long l4 = l3 - l2;
            FRContext.getLogger().info(Inter.getLocText(new String[]{"Finish_Export", "INFO-Time_Taken", "Milliseconds"}, new String[]{"\t", ":" + (l3 - l2)}));
            if (ConfigManager.getInstance().getLogConfig().isRecordExp()) {
                LogUtils.recordExportInfo(string, string2, declareRecordType, l4, FRLogManager.getDeclareSQLContent());
            }
        }
        catch (Exception exception) {
            throw FRLogManager.createLogPackedException(exception);
        }
        finally {
            FRLogManager.declareExportEnd();
        }
    }

    private static void recordExecuteInfo(String string, DeclareRecordType declareRecordType, String string2, long l2, String string3) {
        try {
            FRContext.getLogger().getRecordManager().recordExecuteInfo(string, declareRecordType, string2, l2, string3);
        }
        catch (Throwable throwable) {
            FRContext.getLogger().log(Level.WARNING, throwable.getMessage(), throwable);
            FRContext.getLogger().log(Level.WARNING, "RecordManager error. Record is close.");
        }
    }

    public static void recordAccessNoExecuteInfo(String string, DeclareRecordType declareRecordType, String string2, String string3) {
        if (!ConfigManager.getInstance().getLogConfig().isRecordExe4page()) {
            return;
        }
        try {
            FRContext.getLogger().getRecordManager().recordAccessNoExecuteInfo(string, declareRecordType, string2, string3);
        }
        catch (Throwable throwable) {
            FRContext.getLogger().log(Level.WARNING, throwable.getMessage(), throwable);
            FRContext.getLogger().log(Level.WARNING, "RecordManager error. Record is close.");
        }
    }

    public static void recordExportInfo(String string, String string2, DeclareRecordType declareRecordType, long l2, String string3) {
        try {
            FRContext.getLogger().getRecordManager().recordExportInfo(string, string2, declareRecordType, l2, string3);
        }
        catch (Throwable throwable) {
            FRContext.getLogger().log(Level.WARNING, throwable.getMessage(), throwable);
            FRContext.getLogger().log(Level.WARNING, "RecordManager error. Record is close.");
        }
    }

    public static void recordPrintInfo(String string, Map map, DeclareRecordType declareRecordType, ReportSessionIDInfor reportSessionIDInfor, String string2) {
        if (!ConfigManager.getInstance().getLogConfig().isRecordPrt()) {
            return;
        }
        try {
            FRLogManager.setSession(reportSessionIDInfor);
            FRContext.getLogger().getRecordManager().recordPrintInfo(string, FRLogger.createParamString(map), declareRecordType, string2);
        }
        catch (Throwable throwable) {
            FRContext.getLogger().log(Level.WARNING, throwable.getMessage(), throwable);
            FRContext.getLogger().log(Level.WARNING, "RecordManager error. Record is close.");
        }
    }
}

