/*
 * Decompiled with CFR 0.152.
 */
package com.fr.json;

import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;

public class JSONTokener {
    private int myIndex = 0;
    private String mySource;

    public JSONTokener(String string) {
        this.mySource = string;
    }

    public void back() {
        if (this.myIndex > 0) {
            --this.myIndex;
        }
    }

    public static int dehexchar(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 55;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 87;
        }
        return -1;
    }

    public boolean more() {
        return this.myIndex < this.mySource.length();
    }

    public char next() {
        if (this.more()) {
            char c2 = this.mySource.charAt(this.myIndex);
            ++this.myIndex;
            return c2;
        }
        return '\u0000';
    }

    public char next(char c2) throws JSONException {
        char c3 = this.next();
        if (c3 != c2) {
            throw this.syntaxError("Expected '" + c2 + "' and instead saw '" + c3 + "'");
        }
        return c3;
    }

    public String next(int n2) throws JSONException {
        int n3 = this.myIndex;
        int n4 = n3 + n2;
        if (n4 >= this.mySource.length()) {
            throw this.syntaxError("Substring bounds error");
        }
        this.myIndex += n2;
        return this.mySource.substring(n3, n4);
    }

    public char nextClean() throws JSONException {
        char c2;
        block4: while (true) {
            if ((c2 = this.next()) == '/') {
                switch (this.next()) {
                    case '/': {
                        while ((c2 = this.next()) != '\n' && c2 != '\r' && c2 != '\u0000') {
                        }
                        continue block4;
                    }
                    case '*': {
                        while (true) {
                            if ((c2 = this.next()) == '\u0000') {
                                throw this.syntaxError("Unclosed comment");
                            }
                            if (c2 != '*') continue;
                            if (this.next() == '/') continue block4;
                            this.back();
                        }
                    }
                    default: {
                        this.back();
                        return '/';
                    }
                }
            }
            if (c2 == '#') {
                while ((c2 = this.next()) != '\n' && c2 != '\r' && c2 != '\u0000') {
                }
                continue;
            }
            if (c2 == '\u0000' || c2 > ' ') break;
        }
        return c2;
    }

    public String nextString(char c2) throws JSONException {
        StringBuffer stringBuffer = new StringBuffer();
        block15: while (true) {
            char c3 = this.next();
            switch (c3) {
                case '\u0000': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block15;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block15;
                }
                case '\\': {
                    c3 = this.next();
                    switch (c3) {
                        case 'b': {
                            stringBuffer.append('\b');
                            continue block15;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            continue block15;
                        }
                        case 'n': {
                            stringBuffer.append('\n');
                            continue block15;
                        }
                        case 'f': {
                            stringBuffer.append('\f');
                            continue block15;
                        }
                        case 'r': {
                            stringBuffer.append('\r');
                            continue block15;
                        }
                        case 'u': {
                            stringBuffer.append((char)Integer.parseInt(this.next(4), 16));
                            continue block15;
                        }
                        case 'x': {
                            stringBuffer.append((char)Integer.parseInt(this.next(2), 16));
                            continue block15;
                        }
                    }
                    stringBuffer.append(c3);
                    continue block15;
                }
            }
            if (c3 == c2) {
                return stringBuffer.toString();
            }
            stringBuffer.append(c3);
        }
    }

    public String nextTo(char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            char c3;
            if ((c3 = this.next()) == c2 || c3 == '\u0000' || c3 == '\n' || c3 == '\r') {
                if (c3 != '\u0000') {
                    this.back();
                }
                return stringBuffer.toString().trim();
            }
            stringBuffer.append(c3);
        }
    }

    public String nextTo(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            char c2;
            if (string.indexOf(c2 = this.next()) >= 0 || c2 == '\u0000' || c2 == '\n' || c2 == '\r') {
                if (c2 != '\u0000') {
                    this.back();
                }
                return stringBuffer.toString().trim();
            }
            stringBuffer.append(c2);
        }
    }

    public Object nextValue() throws JSONException {
        char c2 = this.nextClean();
        switch (c2) {
            case '\"': 
            case '\'': {
                return this.nextString(c2);
            }
            case '{': {
                this.back();
                return new JSONObject(this);
            }
            case '[': {
                this.back();
                return new JSONArray(this);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c3 = c2;
        while (c2 >= ' ' && ",:]}/\\\"[{;=#".indexOf(c2) < 0) {
            stringBuffer.append(c2);
            c2 = this.next();
        }
        this.back();
        String string = stringBuffer.toString().trim();
        if (string.equals("")) {
            throw this.syntaxError("Missing value");
        }
        if (string.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("null")) {
            return JSONObject.NULL;
        }
        if (c3 >= '0' && c3 <= '9' || c3 == '.' || c3 == '-' || c3 == '+') {
            if (c3 == '0') {
                if (string.length() > 2 && (string.charAt(1) == 'x' || string.charAt(1) == 'X')) {
                    try {
                        return new Integer(Integer.parseInt(string.substring(2), 16));
                    }
                    catch (Exception exception) {
                    }
                } else {
                    try {
                        return new Integer(Integer.parseInt(string, 8));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                return new Integer(string);
            }
            catch (Exception exception) {
                try {
                    return new Long(string);
                }
                catch (Exception exception2) {
                    try {
                        return new Double(string);
                    }
                    catch (Exception exception3) {
                        return string;
                    }
                }
            }
        }
        return string;
    }

    public char skipTo(char c2) {
        char c3;
        int n2 = this.myIndex;
        do {
            if ((c3 = this.next()) != '\u0000') continue;
            this.myIndex = n2;
            return c3;
        } while (c3 != c2);
        this.back();
        return c3;
    }

    public boolean skipPast(String string) {
        this.myIndex = this.mySource.indexOf(string, this.myIndex);
        if (this.myIndex < 0) {
            this.myIndex = this.mySource.length();
            return false;
        }
        this.myIndex += string.length();
        return true;
    }

    public JSONException syntaxError(String string) {
        return new JSONException(string + this.toString());
    }

    public String toString() {
        return " at character " + this.myIndex + " of " + this.mySource;
    }
}

