/*
 * Decompiled with CFR 0.152.
 */
package com.fr.js;

import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.base.TemplateUtils;
import com.fr.general.ComparatorUtils;
import com.fr.js.Hyperlink;
import com.fr.json.JSONObject;
import com.fr.stable.CodeUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class WebHyperlink
extends Hyperlink {
    private String url = "";
    private boolean useCJK = true;
    private boolean extendParameters = false;

    public WebHyperlink() {
    }

    public WebHyperlink(String string) {
        this(string, "");
    }

    public WebHyperlink(String string, String string2) {
        this.setURL(string);
        this.setTargetFrame(string2);
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public boolean isUseCJK() {
        return this.useCJK;
    }

    public void setUseCJK(boolean bl) {
        this.useCJK = bl;
    }

    public void setExtendParameters(boolean bl) {
        this.extendParameters = bl;
    }

    public boolean isExtendParameters() {
        return this.extendParameters;
    }

    public String actionJS(Repository repository) {
        try {
            return this.createWebPath(repository);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
            return "";
        }
    }

    private String createWebPath(Repository repository) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FR.doHyperlinkByGet");
        stringBuffer.append("(\"");
        stringBuffer.append(this.createPrefixURL(repository));
        stringBuffer.append("\", ");
        stringBuffer.append(this.createParaPath(repository));
        stringBuffer.append(", \"");
        stringBuffer.append(this.getTargetFrame());
        stringBuffer.append("\", \"");
        stringBuffer.append(this.features4NewWindow());
        stringBuffer.append("\")");
        return stringBuffer.toString();
    }

    public String createPrefixURL(Repository repository) throws Exception {
        String string = TemplateUtils.render(this.getURL());
        return CodeUtils.encodeURIComponent(CodeUtils.cjkEncode(string));
    }

    private JSONObject createParaPath(Repository repository) throws Exception {
        JSONObject jSONObject = new JSONObject();
        for (int i2 = 0; i2 < this.parameters.length; ++i2) {
            Parameter parameter = (Parameter)this.parameters[i2];
            Object object = parameter.getValue();
            if (object == null) continue;
            jSONObject.put(this.useCJK ? CodeUtils.cjkEncode(parameter.getName()) : parameter.getName(), this.useCJK ? CodeUtils.cjkEncode(parameter.valueToString()) : parameter.valueToString());
        }
        if (this.isExtendParameters()) {
            this.putExtendParameters(repository, jSONObject, this.useCJK);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("URL")) {
                String string2 = null;
                string2 = xMLableReader.getElementValue();
                if (StringUtils.isNotBlank(string2)) {
                    this.setURL(string2);
                }
            } else if (string.equals("CJK")) {
                String string3 = null;
                string3 = xMLableReader.getElementValue();
                if (StringUtils.isNotBlank(string3)) {
                    this.setUseCJK(Boolean.valueOf(string3));
                }
            } else if (string.equals("extendParameters")) {
                String string4 = null;
                string4 = xMLableReader.getElementValue();
                if (StringUtils.isNotBlank(string4)) {
                    this.setExtendParameters(Boolean.valueOf(string4));
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("JavaScript").attr("class", this.getClass().getName());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("URL").textNode(this.getURL()).end();
        if (!this.isUseCJK()) {
            xMLPrintWriter.startTAG("CJK").textNode(String.valueOf(this.isUseCJK())).end();
        }
        if (this.isExtendParameters()) {
            xMLPrintWriter.startTAG("extendParameters").textNode(String.valueOf(this.isExtendParameters())).end();
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof WebHyperlink)) {
            return false;
        }
        return super.equals(object) && this.useCJK == ((WebHyperlink)object).useCJK && ComparatorUtils.equals(this.url, ((WebHyperlink)object).url) && this.extendParameters == ((WebHyperlink)object).extendParameters;
    }

    protected boolean isPost() {
        return false;
    }
}

