/*
 * Decompiled with CFR 0.152.
 */
package com.fr.js;

import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.Parameter;
import com.fr.base.ParameterMapNameSpace;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.js.AbstractJavaScript;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.js.WidgetName;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.utils.WebUtils;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class ProcessJSImpl
extends AbstractJavaScript {
    private String[] transitionNames;
    private static final String SEPRATOR = ",";

    public void setTransitionNames(String[] stringArray) {
        this.transitionNames = stringArray;
    }

    public String[] getTransitionNames() {
        return this.transitionNames;
    }

    public int getNamesLength() {
        return this.transitionNames == null ? 0 : this.transitionNames.length;
    }

    public String getTransitionName(int n2) {
        return this.transitionNames[n2];
    }

    protected String actionJS(Repository repository) {
        HttpServletRequest httpServletRequest = repository.getHttpServletReques();
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "FR_SYSTEM_ID");
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "taskName");
        FRLogger.getLogger().info("req" + httpServletRequest + ";\u6309\u94ae\u7684processid:" + string + ";\u6309\u94ae\u7684taskName\uff1a" + string2);
        String string3 = this.generateNames();
        String string4 = this.generateVariables();
        String string5 = new StringBuffer().append(this.generateVariables()).append("FR.activeBranches(").append(string3 + SEPRATOR).append(StringUtils.isNotBlank(string4) ? this.generateParameters() : "'[]'").append(StringUtils.isNotBlank(string) && StringUtils.isNotBlank(string2) ? SEPRATOR + string + SEPRATOR + "'" + string2 + "'" : "").append(");").toString();
        return string5;
    }

    private String generateVariables() {
        return this.getParameters().length < 1 ? "" : "var container=null;if(this.options){container=this.options.form?this.options.form:this.options.write}";
    }

    private String generateNames() {
        if (this.transitionNames == null) {
            return null;
        }
        JSONArray jSONArray = null;
        try {
            jSONArray = new JSONArray(this.transitionNames);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
        }
        return jSONArray.toString();
    }

    private String generateParameters() {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        ParameterProvider[] parameterProviderArray = this.getParameters();
        Calculator calculator = Calculator.createCalculator();
        if (!this.paraMap.isEmpty()) {
            calculator.pushNameSpace(ParameterMapNameSpace.create(this.paraMap));
        }
        int n2 = parameterProviderArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Parameter parameter = new Parameter();
            parameter.setName(parameterProviderArray[i2].getName());
            Object object = parameterProviderArray[i2].getValue();
            if (object instanceof Formula) {
                try {
                    parameter.setValue(calculator.eval((Formula)object));
                }
                catch (UtilEvalError utilEvalError) {
                    FRContext.getLogger().error(utilEvalError.getMessage(), utilEvalError);
                }
            } else if (object instanceof WidgetName) {
                parameter.setValue("eval(_g()." + ((WidgetName)object).toFormula() + ")");
            } else {
                parameter.setValue(object);
            }
            arrayList.add(parameter);
        }
        if (arrayList.size() < 1) {
            return "";
        }
        try {
            return Parameter.parameters2JSONString(arrayList.toArray(new Parameter[arrayList.size()])).toString();
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
            return null;
        }
    }

    private void setContent(String string) {
        if (StringUtils.isNotBlank(string)) {
            this.transitionNames = string.split(SEPRATOR);
        }
    }

    private String getContent() {
        if (this.transitionNames != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = this.transitionNames.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append(this.transitionNames[i2]);
                if (i2 == n2 - 1) continue;
                stringBuffer.append(SEPRATOR);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Content")) {
            String string2 = null;
            string2 = xMLableReader.getElementValue();
            if (string2 != null) {
                this.setContent(string2);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotEmpty(this.getContent())) {
            xMLPrintWriter.startTAG("Content").textNode(this.getContent()).end();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProcessJSImpl) || !super.equals(object)) {
            return false;
        }
        return ComparatorUtils.equals(this.transitionNames, ((ProcessJSImpl)object).transitionNames);
    }

    public Object clone() throws CloneNotSupportedException {
        ProcessJSImpl processJSImpl = (ProcessJSImpl)super.clone();
        if (this.transitionNames != null) {
            String[] stringArray = new String[this.getNamesLength()];
            int n2 = this.getNamesLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = this.getTransitionName(i2);
            }
            processJSImpl.transitionNames = stringArray;
        }
        return processJSImpl;
    }
}

