/*
 * Decompiled with CFR 0.152.
 */
package com.fr.js;

import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.js.ChartHyperXMLCom;
import com.fr.js.JavaScript;
import com.fr.js.ReportletHyperlink;
import com.fr.js.WebHyperlink;
import com.fr.stable.Consts;
import com.fr.stable.xml.XMLableReader;

public class JavaScriptXMLUtils {
    private JavaScriptXMLUtils() {
    }

    public static JavaScript readJavaScript(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("class", null);
        if (string == null) {
            return null;
        }
        if (xMLableReader.getXMLVersion().getVersion() <= Double.parseDouble(Consts.VERSION)) {
            if (string.startsWith("com.fr.report.js")) {
                string = string.replaceAll("com.fr.report.js", "com.fr.js");
            } else if (string.startsWith("com.fr.base.js")) {
                string = string.replaceAll("com.fr.base.js", "com.fr.js");
            }
        }
        if (string.endsWith(".WebHyperlink")) {
            WebHyperlink webHyperlink = new WebHyperlink();
            xMLableReader.readXMLObject(webHyperlink);
            return webHyperlink;
        }
        if (string.endsWith(".ReportletHyperlink")) {
            ReportletHyperlink reportletHyperlink = new ReportletHyperlink();
            xMLableReader.readXMLObject(reportletHyperlink);
            return reportletHyperlink;
        }
        if (string.endsWith(".ChartHyperlink") || string.indexOf("ChartHyper") != -1) {
            ChartHyperXMLCom chartHyperXMLCom = new ChartHyperXMLCom();
            xMLableReader.readXMLObject(chartHyperXMLCom);
            return chartHyperXMLCom.getResultChartHyper();
        }
        return JavaScriptXMLUtils.readerJavaScriptInClassName(string, xMLableReader);
    }

    private static JavaScript readerJavaScriptInClassName(String string, XMLableReader xMLableReader) {
        JavaScript javaScript = null;
        try {
            javaScript = (JavaScript)GeneralUtils.classForName(string).newInstance();
            xMLableReader.readXMLObject(javaScript);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        return javaScript;
    }
}

