/*
 * Decompiled with CFR 0.152.
 */
package com.fr.js;

import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.TemplateUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.js.AbstractJavaScript;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.CodeUtils;
import com.fr.stable.ParameterProvider;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.NameSpace;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class JavaScriptImpl
extends AbstractJavaScript {
    private List jsImportList = null;
    private String content;
    private String defaultPara;

    public JavaScriptImpl() {
    }

    public void setDefaultPara(String string) {
        this.defaultPara = string;
    }

    public JavaScriptImpl(String string) {
        this.content = string;
    }

    public String actionJS(Repository repository) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.putAll(this.paraMap);
        ParameterProvider[] parameterProviderArray = this.getParameters();
        int n2 = parameterProviderArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = parameterProviderArray[i2].getValue();
            if (object instanceof Formula) {
                object = ((Formula)object).getResult() != null ? ((Formula)object).getResult() : object;
            }
            hashMap.put(parameterProviderArray[i2].getName(), object);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = this.getJSImportSize();
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append("FR.$import(\"" + CodeUtils.javascriptEncode(this.getJSImport(n2)) + "\"" + ", 'js'); ");
        }
        if (StringUtils.isNotBlank(this.content)) {
            stringBuffer.append(this.createContentFunction(repository));
        }
        String string = stringBuffer.toString();
        try {
            return TemplateUtils.renderParameter4Tpl(string, hashMap);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
            return string;
        }
    }

    private String createContentFunction(Repository repository) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(function(");
        ParameterProvider[] parameterProviderArray = this.getParameters();
        int n2 = parameterProviderArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(parameterProviderArray[i2].getName());
        }
        if (this.defaultPara != null) {
            stringBuffer.append((n2 > 0 ? "," : "") + this.defaultPara);
        }
        stringBuffer.append("){try{" + (this.content == null ? "" : this.content + "\n") + "}catch(ex){FR.Msg" + ".toast(FR" + ".i18nText('Custom')+'JS'+FR.i18nText('Error')+' : '+ex.message);}})");
        stringBuffer.append(".createDelegate(this, [");
        this.dealWithParameter(repository, stringBuffer, n2);
        stringBuffer.append("], 0).apply(this, arguments)");
        return ";return eval(" + this.quoteFrObject(stringBuffer.toString()) + ");";
    }

    private void dealWithParameter(Repository repository, StringBuffer stringBuffer, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            if (i2 != 0) {
                stringBuffer.append(',');
            }
            if ((object = this.parameters[i2].getValue()) instanceof Formula) {
                Object object2;
                Calculator calculator = Calculator.createCalculator();
                if (repository != null) {
                    object2 = ParameterMapNameSpace.create(repository.getReportParameterMap());
                    calculator.pushNameSpace((NameSpace)object2);
                }
                if (!this.paraMap.isEmpty()) {
                    calculator.pushNameSpace(ParameterMapNameSpace.create(this.paraMap));
                }
                if ((object2 = ((Formula)object).getResult()) == null) {
                    try {
                        ((Formula)object).setResult(calculator.evalValue((Formula)object));
                    }
                    catch (UtilEvalError utilEvalError) {
                        FRContext.getLogger().error(utilEvalError.getMessage(), utilEvalError);
                    }
                }
                Object object3 = this.quoteFrObject(((Formula)object).getResult());
                object = "(FR.formulaEvaluator(" + this.quoteFrObject(((Formula)object).getContent()) + ", " + (object3 == null ? JSONObject.quote("null") : object3) + "," + (this.shouldRecalculate() ? "true" : "false") + "))()";
            } else {
                object = this.quoteFrObject(object);
            }
            stringBuffer.append(object);
        }
    }

    public int getJSImportSize() {
        return this.jsImportList == null ? 0 : this.jsImportList.size();
    }

    public String getJSImport(int n2) {
        return this.jsImportList == null ? "" : (String)this.jsImportList.get(n2);
    }

    public void addJSImort(String string) {
        if (this.jsImportList == null) {
            this.jsImportList = new ArrayList();
        }
        this.jsImportList.add(string);
    }

    public void clearJSImports() {
        if (this.jsImportList != null) {
            this.jsImportList.clear();
            this.jsImportList = null;
        }
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }

    private Object quoteFrObject(Object object) {
        if (object instanceof String) {
            return JSONObject.quote((String)object);
        }
        if (object instanceof FArray) {
            FArray fArray = (FArray)object;
            FArray fArray2 = new FArray();
            for (int i2 = 0; i2 < fArray.length(); ++i2) {
                fArray2.add(this.quoteFrObject(fArray.elementAt(i2)));
            }
            return "[" + fArray2 + "]";
        }
        if (object instanceof Date) {
            object = '\"' + object.toString() + '\"';
        }
        if (object instanceof Primitive || ComparatorUtils.equals("", object.toString())) {
            object = null;
        }
        return object;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isAttr()) {
            this.clearJSImports();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Content")) {
                String string2 = null;
                string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    this.setContent(string2);
                }
            } else if (string.equals("JSImport")) {
                String string3 = null;
                string3 = xMLableReader.getElementValue();
                if (string3 != null) {
                    this.addJSImort(string3);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        int n2 = this.getJSImportSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            xMLPrintWriter.startTAG("JSImport").textNode(this.getJSImport(i2)).end();
        }
        xMLPrintWriter.startTAG("Content").textNode(this.getContent()).end();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JavaScriptImpl) || !super.equals(object)) {
            return false;
        }
        return ComparatorUtils.equals(this.getContent(), ((JavaScriptImpl)object).getContent()) && ComparatorUtils.equals(this.jsImportList, ((JavaScriptImpl)object).jsImportList);
    }

    public Object clone() throws CloneNotSupportedException {
        JavaScriptImpl javaScriptImpl = (JavaScriptImpl)super.clone();
        if (this.jsImportList != null) {
            javaScriptImpl.jsImportList = new ArrayList();
            javaScriptImpl.jsImportList.addAll(this.jsImportList);
        }
        return javaScriptImpl;
    }
}

