/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.base.FRCoreContext;
import com.fr.base.background.ColorBackground;
import com.fr.io.exporter.AbstractAppExporter;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.PagePainterProvider;
import com.fr.page.PageSetProvider;
import com.fr.page.ReportPageProvider;
import com.fr.report.core.ReportUtils;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.unit.INCH;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterJob;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.print.attribute.standard.MediaPrintableArea;
import org.freehep.graphicsio.swf.SWFGraphics2D;

public class SWFExporter
extends AbstractAppExporter {
    private static final int DEFAULT_IMAGE_EXPORT_RESOLUTION = 144;
    private boolean isPrintAsImage;

    public SWFExporter() {
        this(false);
    }

    public SWFExporter(boolean bl) {
        this.isPrintAsImage = bl;
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        PageSetProvider pageSetProvider = resultWorkBook.generateReportPageSet(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook)).traverse4Export();
        this.export(outputStream, pageSetProvider);
        pageSetProvider.release();
    }

    public void export(OutputStream outputStream, PageSetProvider pageSetProvider) throws Exception {
        Object object;
        Object object2;
        if (outputStream == null || pageSetProvider == null) {
            return;
        }
        int n2 = 0;
        float f2 = 0.0f;
        int n3 = this.isPrintAsImage ? 144 : 96;
        double d2 = 72.0 / (double)n3;
        ArrayList<ReportPageProvider> arrayList = new ArrayList<ReportPageProvider>();
        FRCoreContext.TMAP.set(Boolean.TRUE);
        boolean bl = false;
        for (int i2 = 0; i2 < pageSetProvider.size() && (object2 = pageSetProvider.getPage(i2)) != null; ++i2) {
            n2 = Math.max(n2, object2.getPaperWidth().toPixI(n3));
            f2 += object2.getPaperHeight().toPixF(n3);
            object = object2.getPaperSetting();
            bl = object != null && object.getOrientation() == 1;
            arrayList.add((ReportPageProvider)object2);
        }
        SWFGraphics2D sWFGraphics2D = new SWFGraphics2D(outputStream, new Dimension(n2, (int)f2));
        sWFGraphics2D.startExport();
        ColorBackground.getInstance(Color.white).paint((Graphics)sWFGraphics2D, new Rectangle2D.Double(0.0, 0.0, n2, f2));
        sWFGraphics2D.scale(d2, d2);
        try {
            object2 = PrinterJob.getPrinterJob().getPrintService();
            if (object2 != null) {
                object = (MediaPrintableArea)object2.getDefaultAttributeValue(MediaPrintableArea.class);
                int n4 = new INCH(((MediaPrintableArea)object).getX(25400)).toPixI(96);
                int n5 = new INCH(((MediaPrintableArea)object).getY(25400)).toPixI(96);
                sWFGraphics2D.translate(-n4, -n5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            sWFGraphics2D.rotate(Math.toRadians(90.0));
            sWFGraphics2D.translate(0.0, (double)(-f2));
        }
        if (this.isPrintAsImage) {
            object2 = CoreGraphHelper.createBufferedImage(n2, (int)f2, 1);
            object = ((BufferedImage)object2).createGraphics();
            this.drawPage((Graphics2D)object, d2, n3, arrayList);
            sWFGraphics2D.drawImage((Image)object2, 0, 0, n2, (int)f2, null);
        } else {
            this.drawPage((Graphics2D)sWFGraphics2D, d2, n3, arrayList);
        }
        FRCoreContext.TMAP.set(null);
        sWFGraphics2D.endExport();
    }

    private void drawPage(Graphics2D graphics2D, double d2, int n2, List list) {
        float f2 = 0.0f;
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            ReportPageProvider reportPageProvider = (ReportPageProvider)list.get(i2);
            graphics2D.translate(0, (int)f2);
            HashMap<String, Class> hashMap = new HashMap<String, Class>();
            hashMap.put("0", ReportPageProvider.class);
            hashMap.put("1", Graphics2D.class);
            PagePainterProvider pagePainterProvider = (PagePainterProvider)StableFactory.createNewObject("PagePainter", new Object[]{reportPageProvider, graphics2D, Integer.valueOf(String.valueOf(n2)), false}, hashMap);
            pagePainterProvider.convert();
            graphics2D.translate(0, (int)(-f2));
            f2 += reportPageProvider.getPaperHeight().toPixF(n2);
        }
    }
}

