/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.base.ConfigManager;
import com.fr.base.DynamicUnitList;
import com.fr.base.ExcelUtils;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.base.Painter;
import com.fr.base.ResultFormula;
import com.fr.base.Style;
import com.fr.base.TextFormat;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.base.background.PatternBackground;
import com.fr.base.chart.BaseChartPainter;
import com.fr.cache.list.IntList;
import com.fr.file.ExtraClassManager;
import com.fr.general.Background;
import com.fr.general.DateUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.general.PageCalObj;
import com.fr.io.attr.ExcelExportAttr;
import com.fr.io.attr.ReportExportAttr;
import com.fr.io.core.ExcelExporterReport;
import com.fr.io.exporter.AbstractExcelExporter;
import com.fr.io.exporter.AppExporter;
import com.fr.io.exporter.Excel2007Exporter;
import com.fr.io.exporter.POIPictureLocation;
import com.fr.io.exporter.POIWrapper.HssfCellStyleWrapper;
import com.fr.io.exporter.POIWrapper.HssfCellWrapper;
import com.fr.io.exporter.POIWrapper.HssfClientAnchorWrapper;
import com.fr.io.exporter.POIWrapper.HssfFontWrapper;
import com.fr.io.exporter.POIWrapper.HssfFooterWrapper;
import com.fr.io.exporter.POIWrapper.HssfHeaderWrapper;
import com.fr.io.exporter.POIWrapper.HssfPatriarchWrapper;
import com.fr.io.exporter.POIWrapper.HssfPrintSetupWrapper1;
import com.fr.io.exporter.POIWrapper.HssfSheetWrapper;
import com.fr.io.exporter.POIWrapper.HssfWorkbookWrapper;
import com.fr.io.exporter.POIWrapper.POIFontAction;
import com.fr.io.exporter.POIWrapper.POIHeaderFooterAction;
import com.fr.io.exporter.POIWrapper.POIWorkbookAction;
import com.fr.io.exporter.POIWrapper.PaperSettingWrapper;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.ReportHelper;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.FloatElement;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.cell.cellattr.core.CellUtils;
import com.fr.report.cell.painter.shape.LineShapePainter;
import com.fr.report.cell.painter.shape.OvalShapePainter;
import com.fr.report.cell.painter.shape.ShapePainter;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.ReportUtils;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.report.Report;
import com.fr.report.report.ResultECReport;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.ExportConstants;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.third.com.lowagie.text.Chunk;
import com.fr.third.com.lowagie.text.Font;
import com.fr.third.com.lowagie.text.Paragraph;
import com.fr.third.com.lowagie.text.html.simpleparser.HTMLWorker;
import com.fr.third.com.lowagie.text.html.simpleparser.StyleSheet;
import com.fr.third.org.apache.poi.hssf.usermodel.EscherGraphics;
import com.fr.third.org.apache.poi.hssf.usermodel.EscherGraphics2d;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFAnchor;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCell;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFComment;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFDataFormat;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFFont;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPalette;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPatriarch;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRow;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFShapeGroup;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFTextbox;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.HSSFColor;
import com.fr.third.org.apache.poi.hssf.util.Region;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelExporter
extends AbstractExcelExporter {
    private static final short COLOR_INDEX = 8;
    private short colorIndex = (short)8;
    private HSSFCellStyle defaultHSSFCellStyle = null;
    private HSSFDataFormat format = null;

    public ExcelExporter() {
        this(null);
    }

    public ExcelExporter(List list) {
        this.paperSettingList = list;
    }

    @Override
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        this.export(outputStream, resultWorkBook, false);
    }

    protected AppExporter getExporterFor2007(List<PaperSettingProvider> list) throws ClassNotFoundException {
        return new Excel2007Exporter(list);
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook, boolean bl) throws Exception {
        this.export(outputStream, resultWorkBook, bl, null);
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook, boolean bl, int[] nArray) throws Exception {
        if (resultWorkBook == null) {
            throw new Exception("Report can not be null!");
        }
        ResultWorkBook resultWorkBook2 = resultWorkBook;
        if (nArray != null && nArray.length < resultWorkBook.getReportCount()) {
            try {
                resultWorkBook2 = (ResultWorkBook)resultWorkBook.clone();
                int n2 = resultWorkBook.getReportCount();
                for (int i2 = n2 - 1; i2 > 0; --i2) {
                    if (ArrayUtils.contains(nArray, i2)) continue;
                    resultWorkBook2.removeReport(i2);
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().info(exception.getMessage());
            }
        }
        if (this.checkExcelExportVersion()) {
            this.exportFor2007(outputStream, resultWorkBook2);
            return;
        }
        this.exportFor2003(outputStream, resultWorkBook2, bl);
    }

    protected void exportFor2007(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        this.getExporterFor2007(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook)).export(outputStream, resultWorkBook);
    }

    protected void exportFor2003(OutputStream outputStream, ResultWorkBook resultWorkBook, boolean bl) throws Exception {
        ArrayList<Report> arrayList = new ArrayList<Report>();
        this.defaultHSSFCellStyle = null;
        this.hssfFontHash.clear();
        this.hssfCellStyleHash.clear();
        this.format = null;
        this.colorIndex = (short)8;
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook();
        this.setDefaultFont(new HssfWorkbookWrapper(hSSFWorkbook));
        ArrayList arrayList2 = new ArrayList();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        this.exportBook(resultWorkBook, new HssfWorkbookWrapper(hSSFWorkbook), arrayList2, arrayList3, arrayList, bl);
        this.dealWithFormula(arrayList2, arrayList3);
        String string = this.getPassword(resultWorkBook);
        if (StringUtils.isNotBlank(string)) {
            hSSFWorkbook.setFilePassword(string);
        }
        hSSFWorkbook.write(outputStream);
        outputStream.flush();
    }

    private void dealWithFormula(List list, List list2) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            HSSFCell hSSFCell = (HSSFCell)list.get(i2);
            this.dealWithFormula(new HssfCellWrapper(hSSFCell), (String)list2.get(i2));
        }
    }

    protected boolean checkExcelExportVersion() {
        return ExcelUtils.checkPOIJarExist();
    }

    @Override
    protected void innerExportReports(ResultECReport resultECReport, ResultWorkBook resultWorkBook, POIWorkbookAction pOIWorkbookAction, List list, List<String> list2, List<Report> list3, int n2) {
        Point point = new Point(0, 0);
        int n3 = resultECReport.getColumnCount();
        int n4 = resultECReport.getRowCount();
        int n5 = 1;
        while (point.x < n3) {
            point.y = 0;
            while (point.y < n4) {
                try {
                    this.innerExportReport(new ExcelExporterReport(resultECReport, point.x, point.y, Math.min(n3 - point.x, ExportConstants.MAX_COLS), Math.min(n4 - point.y, ExportConstants.MAX_ROWS)), resultWorkBook.getReportExportAttr(), resultWorkBook.getReportName(n2) + (n5 == 1 ? "" : "_" + n5), (HSSFWorkbook)pOIWorkbookAction.getWorkbook(), list, list2, n2);
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage());
                }
                point.y += ExportConstants.MAX_ROWS;
                ++n5;
            }
            point.x += ExportConstants.MAX_COLS;
        }
    }

    protected void innerExportReport(Report report, ReportExportAttr reportExportAttr, String string, HSSFWorkbook hSSFWorkbook, List list, List<String> list2, int n2) throws Exception {
        ExcelExportAttr excelExportAttr = reportExportAttr == null ? null : reportExportAttr.getExcelExportAttr();
        HSSFSheet hSSFSheet = hSSFWorkbook.createSheet();
        if (excelExportAttr != null && StringUtils.isNotEmpty(excelExportAttr.getProtectedWord())) {
            hSSFSheet.protectSheet(excelExportAttr.getProtectedWord());
        }
        this.setSheetName(new HssfWorkbookWrapper(hSSFWorkbook), string);
        this.iterateReport((ElementCase)((Object)report), hSSFSheet, hSSFWorkbook, list, list2, excelExportAttr, n2);
    }

    protected void dealECReportAndBlockPageSetting(ElementCase elementCase, HSSFSheet hSSFSheet, int n2) {
        this.dealWithPageSetting((Report)((Object)elementCase), hSSFSheet, n2);
    }

    private void iterateReport(ElementCase elementCase, HSSFSheet hSSFSheet, HSSFWorkbook hSSFWorkbook, List list, List list2, ExcelExportAttr excelExportAttr, int n2) throws Exception {
        int n3;
        int n4;
        boolean bl;
        this.dealECReportAndBlockPageSetting(elementCase, hSSFSheet, n2);
        hSSFSheet.setDefaultColumnWidth((short)9);
        Iterator iterator = elementCase.cellIterator();
        DynamicUnitList dynamicUnitList = ReportHelper.getRowHeightList(elementCase);
        DynamicUnitList dynamicUnitList2 = ReportHelper.getColumnWidthList(elementCase);
        IntList intList = new IntList();
        IntList intList2 = new IntList();
        boolean bl2 = excelExportAttr == null ? false : excelExportAttr.isExportHidedRow();
        boolean bl3 = bl = excelExportAttr == null ? false : excelExportAttr.isExportHidedColumn();
        if (!bl2) {
            for (n4 = dynamicUnitList.size() - 1; n4 >= 0; --n4) {
                if (!dynamicUnitList.get(n4).equal_zero()) continue;
                intList.add(n4);
                dynamicUnitList.remove(n4);
            }
        }
        if (!bl) {
            for (n4 = dynamicUnitList2.size() - 1; n4 >= 0; --n4) {
                if (!dynamicUnitList2.get(n4).equal_zero()) continue;
                intList2.add(n4);
                dynamicUnitList2.remove(n4);
            }
        }
        if (elementCase.getReportPageAttr() != null && elementCase.getReportPageAttr().getFreezeColumnRow() != null) {
            int n5;
            ColumnRow columnRow = elementCase.getReportPageAttr().getFreezeColumnRow();
            n3 = columnRow.getColumn();
            int n6 = columnRow.getRow();
            for (n5 = 0; n5 < columnRow.getColumn(); ++n5) {
                if (!intList2.contain(n5)) continue;
                --n3;
            }
            for (n5 = 0; n5 < columnRow.getRow(); ++n5) {
                if (!intList.contain(n5)) continue;
                --n6;
            }
            hSSFSheet.createFreezePane(n3, n6);
        }
        int n7 = -1;
        n3 = -1;
        HSSFRow hSSFRow = null;
        HSSFPatriarch hSSFPatriarch = hSSFSheet.createDrawingPatriarch();
        HSSFPatriarch hSSFPatriarch2 = null;
        if (this.columnRowPostileMaps != null && this.columnRowPostileMaps[n2] != null) {
            hSSFPatriarch2 = hSSFSheet.createDrawingPatriarch();
        }
        Calculator calculator = Calculator.createCalculator();
        this.setAttr4ECReportSIL(calculator, intList, intList2, elementCase);
        while (iterator.hasNext()) {
            int n8;
            int n9;
            CellElement cellElement = (CellElement)iterator.next();
            int n10 = cellElement.getColumn();
            int n11 = cellElement.getRow();
            int n12 = cellElement.getColumnSpan();
            int n13 = cellElement.getRowSpan();
            int[] nArray = this.dealWithHiddenCR(n11, n13, intList);
            n11 = nArray[0];
            n13 = nArray[1];
            nArray = this.dealWithHiddenCR(n10, n12, intList2);
            n10 = nArray[0];
            n12 = nArray[1];
            if (n13 <= 0 || n12 <= 0) continue;
            int n14 = n10 + n12 - 1;
            int n15 = n11 + n13 - 1;
            if (n7 < n14) {
                for (n9 = Math.max(0, n7); n9 <= n14; ++n9) {
                    if (dynamicUnitList2.get(n9).toFU() <= 0L) {
                        hSSFSheet.setColumnHidden((short)n9, bl);
                        continue;
                    }
                    hSSFSheet.setColumnWidth((short)n9, (short)(dynamicUnitList2.get(n9).toPixD(96) * ConfigManager.getInstance().getExcelAdjustWidth()));
                }
                n7 = n14;
            }
            if (n3 < n15) {
                for (n9 = Math.max(0, n3); n9 <= n15; ++n9) {
                    HSSFRow hSSFRow2 = hSSFSheet.createRow(n9);
                    if (dynamicUnitList.get(n9).toFU() <= 0L) {
                        hSSFRow2.setZeroHeight(bl2);
                        continue;
                    }
                    hSSFRow2.setHeight((short)(dynamicUnitList.get(n9).toPTValue4Scale2() * ConfigManager.getInstance().getExcelAdjustHeight()));
                }
                n3 = n15;
            }
            this.setColumnRowBreak(cellElement, new HssfSheetWrapper(hSSFSheet), n12, n13, n14, n15);
            CellGUIAttr cellGUIAttr = cellElement.getCellGUIAttr();
            if (cellGUIAttr == null) {
                cellGUIAttr = CellGUIAttr.DEFAULT_CELLGUIATTR;
            }
            if (!cellGUIAttr.isPrintContent() && !cellGUIAttr.isPrintBackground()) continue;
            int n16 = n10 + n12;
            for (int i2 = n8 = n10; i2 < n16; ++i2) {
                int n17;
                int n18 = n11 + n13;
                for (int i3 = n17 = n11; i3 < n18; ++i3) {
                    HSSFCell hSSFCell = this.createHSSFCell(hSSFRow, hSSFSheet, i3, i2, n14, n11, n2, elementCase, hSSFPatriarch2);
                    if (i2 != n8 || i3 != n17 || !cellGUIAttr.isPrintContent() && cellGUIAttr.isPrintBackground()) {
                        hSSFCell.setCellStyle(this.createHSSFCellStyle(hSSFWorkbook, cellElement.getStyle()));
                        continue;
                    }
                    this.dealWithValue(cellElement, list, hSSFCell, excelExportAttr, calculator, list2, cellGUIAttr, hSSFWorkbook, dynamicUnitList, dynamicUnitList2, n10, n11, n12, n13, hSSFPatriarch);
                }
            }
            if (n13 <= 1 && n12 <= 1) continue;
            Region region = new Region(n11, (short)n10, n11 + n13 - 1, (short)(n10 + n12 - 1));
            hSSFSheet.addMergedRegion(region);
        }
        this.dealWithFloatElement(elementCase, hSSFPatriarch, dynamicUnitList, dynamicUnitList2, n7, n3, hSSFSheet, hSSFWorkbook);
    }

    private HSSFCell createHSSFCell(HSSFRow hSSFRow, HSSFSheet hSSFSheet, int n2, int n3, int n4, int n5, int n6, ElementCase elementCase, HSSFPatriarch hSSFPatriarch) {
        String string;
        if (hSSFRow == null || hSSFRow.getRowNum() != n2) {
            hSSFRow = hSSFSheet.getRow(n2);
        }
        HSSFCell hSSFCell = hSSFRow.createCell((short)n3);
        if (n2 == n5 && n3 == n4 && this.columnRowPostileMaps != null && this.columnRowPostileMaps[n6] != null && (string = (String)this.columnRowPostileMaps[n6].get(ColumnRow.valueOf(n4, n5))) != null) {
            int n7;
            int n8 = n5;
            long l2 = 0L;
            long l3 = 0L;
            for (n7 = n4; n7 < elementCase.getColumnCount(); ++n7) {
                if ((l3 += elementCase.getColumnWidth(n7).getLen()) <= 3048000L) continue;
                ++n7;
                break;
            }
            while (n8 < elementCase.getRowCount()) {
                if ((l2 += elementCase.getRowHeight(n8).getLen()) > 4572000L) {
                    ++n8;
                    break;
                }
                ++n8;
            }
            HSSFClientAnchor hSSFClientAnchor = new HSSFClientAnchor(0, 0, 0, 0, (short)n4, n5, (short)n7, n8);
            HSSFComment hSSFComment = hSSFPatriarch.createComment((HSSFAnchor)hSSFClientAnchor);
            hSSFComment.setString(new HSSFRichTextString(string));
            hSSFComment.setAuthor("FineReport");
            hSSFCell.setCellComment(hSSFComment);
        }
        hSSFCell.setEncoding((short)1);
        return hSSFCell;
    }

    protected void dealWithPageSetting(Report report, HSSFSheet hSSFSheet, int n2) {
        POIHeaderFooterAction pOIHeaderFooterAction;
        ReportSettingsProvider reportSettingsProvider = ReportUtils.getReportSettings(report);
        PaperSettingWrapper paperSettingWrapper = new PaperSettingWrapper(this.paperSettingList, n2, reportSettingsProvider);
        HssfSheetWrapper hssfSheetWrapper = new HssfSheetWrapper(hSSFSheet);
        this.dealWithAlignAndMargin(hssfSheetWrapper, reportSettingsProvider, paperSettingWrapper.getMargin());
        HssfPrintSetupWrapper1 hssfPrintSetupWrapper1 = new HssfPrintSetupWrapper1(hSSFSheet.getPrintSetup());
        this.dealWithPrintSetUp(hssfPrintSetupWrapper1, paperSettingWrapper.getPaperSize(), paperSettingWrapper.getOrientation(), reportSettingsProvider);
        if (reportSettingsProvider.getHeaderHeight().more_than_zero()) {
            pOIHeaderFooterAction = new HssfHeaderWrapper(hSSFSheet.getHeader());
            this.applyReportHFHeader(report.getHeader(0), pOIHeaderFooterAction);
        }
        if (reportSettingsProvider.getFooterHeight().more_than_zero()) {
            pOIHeaderFooterAction = new HssfFooterWrapper(hSSFSheet.getFooter());
            this.applyReportHFFooter(report.getFooter(0), pOIHeaderFooterAction);
        }
    }

    private void dealWithFloatElement(ElementCase elementCase, HSSFPatriarch hSSFPatriarch, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, int n2, int n3, HSSFSheet hSSFSheet, HSSFWorkbook hSSFWorkbook) {
        Iterator iterator = elementCase.floatIterator();
        while (iterator.hasNext()) {
            BufferedImage bufferedImage;
            FloatElement floatElement = (FloatElement)iterator.next();
            Object object = floatElement.getValue();
            POIPictureLocation pOIPictureLocation = this.locateFloatElementInExcel(floatElement, dynamicUnitList, dynamicUnitList2, elementCase, object);
            HSSFClientAnchor hSSFClientAnchor = new HSSFClientAnchor(pOIPictureLocation.getFirst_cell_x(), pOIPictureLocation.getFirst_cell_y(), pOIPictureLocation.getSecond_cell_x(), pOIPictureLocation.getSecond_cell_y(), pOIPictureLocation.getFirst_cell_col(), pOIPictureLocation.getFirst_cell_row(), pOIPictureLocation.getSecond_cell_col(), pOIPictureLocation.getSecond_cell_row());
            Style style = floatElement.getStyle();
            if (style == null) {
                style = Style.DEFAULT_STYLE;
            }
            int n4 = floatElement.getWidth().toPixI(96);
            int n5 = floatElement.getHeight().toPixI(96);
            if (object instanceof ShapePainter) {
                this.dealWithShapePainter(object, hSSFPatriarch, hSSFClientAnchor, hSSFSheet, hSSFWorkbook, style);
                continue;
            }
            if (object instanceof String || object instanceof Number) {
                this.dealWithTextBox(object, hSSFPatriarch, hSSFClientAnchor, hSSFWorkbook, style);
                continue;
            }
            if (object instanceof Image) {
                bufferedImage = GraphHelper.createBufferedImageFromImageWithLayout((Image)object, n4, n5, style);
                this.dealWithBufferImage(object, hSSFClientAnchor, hSSFPatriarch, hSSFWorkbook, style, n4, n5, bufferedImage);
                continue;
            }
            if (!(object instanceof BaseChartPainter)) continue;
            bufferedImage = ((BaseChartPainter)object).toFloatImage(n4, n5, 96);
            this.dealWithBufferImage(object, hSSFClientAnchor, hSSFPatriarch, hSSFWorkbook, style, n4, n5, bufferedImage);
        }
    }

    @Override
    protected int getFloatLeftMax(double d2) {
        return 1023;
    }

    @Override
    protected int getFloatTopMax(double d2) {
        return 255;
    }

    private void dealWithBufferImage(Object object, HSSFClientAnchor hSSFClientAnchor, HSSFPatriarch hSSFPatriarch, HSSFWorkbook hSSFWorkbook, Style style, int n2, int n3, BufferedImage bufferedImage) {
        this.dealWithBufferImage(object, new HssfClientAnchorWrapper(hSSFClientAnchor), new HssfPatriarchWrapper(hSSFPatriarch), style, n2, n3, bufferedImage, new HssfWorkbookWrapper(hSSFWorkbook));
    }

    private void dealWithTextBox(Object object, HSSFPatriarch hSSFPatriarch, HSSFClientAnchor hSSFClientAnchor, HSSFWorkbook hSSFWorkbook, Style style) {
        String string = object.toString();
        HSSFTextbox hSSFTextbox = hSSFPatriarch.createTextbox(hSSFClientAnchor);
        Color color = Color.white;
        Background background = style.getBackground();
        if (background != null && background instanceof ColorBackground) {
            color = ((ColorBackground)background).getColor();
        }
        if (color != null) {
            hSSFTextbox.setFillColor(color.getRed(), color.getGreen(), color.getBlue());
        }
        hSSFTextbox.setVerticalAlignment(this.changeAlignment(style.getVerticalAlignment()));
        hSSFTextbox.setHorizontalAlignment(this.changeAlignment(style.getHorizontalAlignment()));
        HSSFRichTextString hSSFRichTextString = new HSSFRichTextString(string);
        hSSFRichTextString.applyFont(this.createFont(hSSFWorkbook, (java.awt.Font)style.getFRFont()));
        hSSFTextbox.setString(hSSFRichTextString);
    }

    private void dealWithShapePainter(Object object, HSSFPatriarch hSSFPatriarch, HSSFClientAnchor hSSFClientAnchor, HSSFSheet hSSFSheet, HSSFWorkbook hSSFWorkbook, Style style) {
        ShapePainter shapePainter = (ShapePainter)object;
        HSSFShapeGroup hSSFShapeGroup = hSSFPatriarch.createGroup(hSSFClientAnchor);
        float f2 = hSSFClientAnchor.getAnchorHeightInPoints(hSSFSheet) / (float)Math.abs(hSSFShapeGroup.getY2() - hSSFShapeGroup.getY1());
        EscherGraphics escherGraphics = new EscherGraphics(hSSFShapeGroup, hSSFWorkbook, Color.black, f2);
        EscherGraphics2d escherGraphics2d = new EscherGraphics2d(escherGraphics);
        escherGraphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (shapePainter instanceof LineShapePainter) {
            LineShapePainter lineShapePainter = (LineShapePainter)shapePainter;
            escherGraphics2d.setPaint((Paint)style.getFRFont().getForeground());
            if (lineShapePainter.isPositiveArrow()) {
                escherGraphics2d.drawLine(hSSFShapeGroup.getX1(), hSSFShapeGroup.getY2(), hSSFShapeGroup.getX2(), hSSFShapeGroup.getY1());
            } else {
                escherGraphics2d.drawLine(hSSFShapeGroup.getX1(), hSSFShapeGroup.getY1(), hSSFShapeGroup.getX2(), hSSFShapeGroup.getY2());
            }
        } else if (shapePainter instanceof OvalShapePainter) {
            this.applyBackgroundToGraphic2d(escherGraphics2d, style.getBackground());
            escherGraphics2d.fillOval(hSSFShapeGroup.getX1(), hSSFShapeGroup.getY1(), hSSFShapeGroup.getX2() - hSSFShapeGroup.getX1(), hSSFShapeGroup.getY2() - hSSFShapeGroup.getY1());
            escherGraphics2d.setPaint((Paint)style.getFRFont().getForeground());
            escherGraphics2d.drawOval(hSSFShapeGroup.getX1(), hSSFShapeGroup.getY1(), hSSFShapeGroup.getX2() - hSSFShapeGroup.getX1(), hSSFShapeGroup.getY2() - hSSFShapeGroup.getY1());
        } else {
            this.applyBackgroundToGraphic2d(escherGraphics2d, style.getBackground());
            escherGraphics2d.fillRect(hSSFShapeGroup.getX1(), hSSFShapeGroup.getY1(), hSSFShapeGroup.getX2() - hSSFShapeGroup.getX1(), hSSFShapeGroup.getY2() - hSSFShapeGroup.getY1());
            escherGraphics2d.setPaint((Paint)style.getFRFont().getForeground());
            escherGraphics2d.drawRect(hSSFShapeGroup.getX1(), hSSFShapeGroup.getY1(), hSSFShapeGroup.getX2() - hSSFShapeGroup.getX1(), hSSFShapeGroup.getY2() - hSSFShapeGroup.getY1());
        }
        escherGraphics2d.dispose();
    }

    private short changeAlignment(int n2) {
        if (n2 == 0) {
            return 2;
        }
        if (n2 == 3 || n2 == 4) {
            return 3;
        }
        return 1;
    }

    private void dealWithValue(CellElement cellElement, List list, HSSFCell hSSFCell, ExcelExportAttr excelExportAttr, Calculator calculator, List list2, CellGUIAttr cellGUIAttr, HSSFWorkbook hSSFWorkbook, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, int n2, int n3, int n4, int n5, HSSFPatriarch hSSFPatriarch) {
        Object object;
        int n6;
        Object object2;
        boolean bl;
        Object object3 = cellElement.getShowValue();
        Style style = cellElement.getStyle();
        if (object3 == null) {
            object3 = "";
        }
        boolean bl2 = excelExportAttr == null ? false : excelExportAttr.isExportHidedRow();
        boolean bl3 = bl = excelExportAttr == null ? false : excelExportAttr.isExportHidedColumn();
        if (object3 instanceof Formula) {
            object2 = (Formula)object3;
            if (((Formula)object2).isReserveInResult() && object2 instanceof ResultFormula) {
                String string = ((Formula)object2).getContent();
                n6 = !bl2 || !bl ? 1 : 0;
                if ((string = this.dealWithSumFormula(string, object3, (Formula)object2, n6 != 0)) != null) {
                    if (string.startsWith("=")) {
                        string = string.substring(1);
                    }
                    list.add(hSSFCell);
                    if (n6 != 0 && StringUtils.isNotBlank(string)) {
                        try {
                            object = calculator.exStatement(null, string);
                            list2.add(object == null ? FORMULA_ERROR : object);
                        }
                        catch (Exception exception) {
                            list2.add(FORMULA_ERROR);
                        }
                    } else {
                        list2.add(string);
                    }
                }
            } else {
                object3 = ((Formula)object2).getResult();
            }
        } else if (object3 instanceof PageCalObj) {
            object3 = cellElement.getValue();
        } else {
            int n7 = style.getTextStyle();
            object3 = Utils.resolveOtherValue(object3, cellGUIAttr.isShowAsImage());
            if (this.isShowAsImage(n7, cellGUIAttr) && !ConfigManager.getInstance().isExportFullImg4Excel()) {
                int n8 = dynamicUnitList2.getRangeValue(n2, n2 + n4).toPixI(96);
                n6 = dynamicUnitList.getRangeValue(n3, n3 + n5).toPixI(96);
                object3 = CellUtils.value2ImageWithBackground(object3, 96, style, n8, n6);
            }
        }
        if (object3 instanceof String && StringUtils.isNotEmpty((String)object3)) {
            if (cellGUIAttr.isShowAsHTML()) {
                object2 = null;
                try {
                    object2 = this.html2HSSFRichTextString(hSSFWorkbook, (String)object3, style);
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(Inter.getLocText("NS_export_excelHtml"));
                }
                if (object2 != null && StringUtils.isNotEmpty(object2.getString())) {
                    object3 = object2;
                } else {
                    int n9 = dynamicUnitList2.getRangeValue(n2, n2 + n4).toPixI(96);
                    n6 = dynamicUnitList.getRangeValue(n3, n3 + n5).toPixI(96);
                    object3 = PaintUtils.createHTMLContentBufferedImage(object3.toString(), new Rectangle(n9, n6), 1, 1);
                }
            } else if (style.getVerticalText() == 1) {
                object3 = this.checkValueVertical(n3, n5, n2, n4, Utils.objectToString(object3), style, dynamicUnitList, dynamicUnitList2);
            }
        }
        if ((object2 = ExtraClassManager.getInstance().getExportCellValueProvider()) != null) {
            object3 = object2.getCellValue(cellElement, object3, calculator);
        }
        Format format = style.getFormat();
        HSSFCellStyle hSSFCellStyle = this.createHSSFCellStyle(hSSFWorkbook, style);
        if ((object3 = this.checkNumberFormat(format, object3)) instanceof Formula) {
            this.dealDateFormula(hSSFCell, object3, hSSFWorkbook, hSSFCellStyle, style);
        } else if (object3 instanceof Number) {
            object = StableUtils.checkInfinity(object3);
            if (StringUtils.isNotEmpty((String)object)) {
                hSSFCell.setCellType(1);
                hSSFCell.setCellValue((String)object);
            } else {
                hSSFCell.setCellType(0);
                hSSFCell.setCellValue(((Number)object3).doubleValue());
            }
        } else if (object3 instanceof Boolean) {
            hSSFCell.setCellType(4);
            hSSFCell.setCellValue(((Boolean)object3).booleanValue());
        } else if (object3 instanceof Painter || object3 instanceof Image) {
            object = new HSSFClientAnchor(0, 0, 0, 0, (short)n2, n3, (short)(n2 + n4), n3 + n5);
            if (object3 != null) {
                int n10;
                object.setAnchorType(2);
                BufferedImage bufferedImage = null;
                if (ConfigManager.getInstance().isExportFullImg4Excel() && object3 instanceof BufferedImage) {
                    bufferedImage = (BufferedImage)object3;
                } else {
                    n10 = dynamicUnitList2.getRangeValue(n2, n2 + n4).toPixI(96);
                    int n11 = dynamicUnitList.getRangeValue(n3, n3 + n5).toPixI(96);
                    bufferedImage = CoreGraphHelper.createBufferedImage(n10 + 1, n11 + 1, 2);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.translate(style.getBorderLeftWidth(), style.getBorderTopWidth());
                    Style.paintContent(graphics2D, object3, style, n10 - style.getBorderLeftWidth(), n11 - style.getBorderTopWidth(), 96);
                    bufferedImage.flush();
                    graphics2D.dispose();
                }
                try {
                    n10 = this.loadPicture(bufferedImage, new HssfWorkbookWrapper(hSSFWorkbook));
                    hSSFPatriarch.createPicture((HSSFClientAnchor)object, n10);
                }
                catch (IOException iOException) {
                    FRContext.getLogger().error(iOException.getMessage());
                }
            }
        } else if (object3 instanceof HSSFRichTextString) {
            hSSFCell.setCellType(1);
            hSSFCell.setCellValue((HSSFRichTextString)object3);
        } else if (object3 instanceof Date) {
            hSSFCell.setCellValue((Date)object3);
            object = style.getFormat() == null ? DateUtils.DATEFORMAT2 : style.getFormat();
            HSSFCellStyle hSSFCellStyle2 = this.createHSSFCellStyle(hSSFWorkbook, style.deriveFormat((Format)object));
            hSSFCell.setCellStyle(hSSFCellStyle2);
        } else {
            object = Style.valueToText(object3, format);
            if (object != null) {
                if (((String)object).startsWith("=")) {
                    String string = ((String)object).substring(1);
                    list.add(hSSFCell);
                    if (!(bl2 && bl || !StringUtils.isNotBlank(string))) {
                        try {
                            String string2 = calculator.exStatement(null, string);
                            list2.add(string2 == null ? FORMULA_ERROR : string2);
                        }
                        catch (Exception exception) {
                            list2.add(FORMULA_ERROR);
                        }
                    } else {
                        list2.add(string);
                    }
                } else if (((String)object).length() > 0) {
                    object = this.replaceNewLineChar((String)object);
                    if (format instanceof NumberFormat) {
                        try {
                            hSSFCell.setCellValue(Double.parseDouble((String)object));
                            hSSFCell.setCellType(0);
                        }
                        catch (NumberFormatException numberFormatException) {
                            hSSFCell.setCellType(1);
                            hSSFCell.setCellValue((String)object);
                        }
                    } else {
                        hSSFCell.setCellType(1);
                        hSSFCell.setCellValue((String)object);
                    }
                }
            }
        }
        if (hSSFCell.getCellType() == 1 && hSSFCell.getStringCellValue().startsWith("--")) {
            style.deriveFormat(TextFormat.getInstance());
        }
        if (!cellGUIAttr.isPrintBackground()) {
            object = style.deriveBackground(null);
            hSSFCell.setCellStyle(this.createHSSFCellStyle(hSSFWorkbook, (Style)object));
        } else if (!(object3 instanceof Date) && !(object3 instanceof Formula)) {
            hSSFCell.setCellStyle(hSSFCellStyle);
        }
    }

    private void executeHSSFCellStyle(HSSFWorkbook hSSFWorkbook, HSSFCellStyle hSSFCellStyle, Style style) {
        this.executeCellStyle(new HssfWorkbookWrapper(hSSFWorkbook), new HssfCellStyleWrapper(hSSFCellStyle), style);
        hSSFCellStyle.setTopBorderColor(this.getNearestColor(hSSFWorkbook, style.getBorderTopColor()));
        hSSFCellStyle.setLeftBorderColor(this.getNearestColor(hSSFWorkbook, style.getBorderLeftColor()));
        hSSFCellStyle.setBottomBorderColor(this.getNearestColor(hSSFWorkbook, style.getBorderBottomColor()));
        hSSFCellStyle.setRightBorderColor(this.getNearestColor(hSSFWorkbook, style.getBorderRightColor()));
        Background background = style.getBackground();
        if (background != null) {
            if (background instanceof ColorBackground) {
                ColorBackground colorBackground = (ColorBackground)background;
                hSSFCellStyle.setFillPattern((short)1);
                hSSFCellStyle.setFillForegroundColor(this.getNearestColor(hSSFWorkbook, colorBackground.getColor()));
                hSSFCellStyle.setFillBackgroundColor(this.getNearestColor(hSSFWorkbook, colorBackground.getColor()));
            } else if (background instanceof PatternBackground) {
                PatternBackground patternBackground = (PatternBackground)background;
                hSSFCellStyle.setFillPattern((short)16);
                hSSFCellStyle.setFillBackgroundColor(this.getNearestColor(hSSFWorkbook, patternBackground.getBackground()));
                hSSFCellStyle.setFillForegroundColor(this.getNearestColor(hSSFWorkbook, patternBackground.getForeground()));
            } else {
                FRContext.getLogger().error(Inter.getLocText("NS_export_excelCellBg"));
            }
        }
    }

    private void dealDateFormula(HSSFCell hSSFCell, Object object, HSSFWorkbook hSSFWorkbook, HSSFCellStyle hSSFCellStyle, Style style) {
        hSSFCell.setCellType(2);
        String string = ((Formula)object).getContent();
        if (string.equalsIgnoreCase("=now()")) {
            hSSFCell.setCellFormula("now()");
            HSSFCellStyle hSSFCellStyle2 = this.createHSSFCellStyle(hSSFWorkbook, style.deriveFormat(DateUtils.DATETIMEFORMAT2));
            hSSFCell.setCellStyle(hSSFCellStyle2);
        } else if (string.equalsIgnoreCase("=today()")) {
            hSSFCell.setCellFormula("today()");
            HSSFCellStyle hSSFCellStyle3 = this.createHSSFCellStyle(hSSFWorkbook, style.deriveFormat(DateUtils.DATEFORMAT2));
            hSSFCell.setCellStyle(hSSFCellStyle3);
        } else {
            hSSFCell.setCellStyle(hSSFCellStyle);
        }
    }

    private short getNearestColor(HSSFWorkbook hSSFWorkbook, Color color) {
        HSSFPalette hSSFPalette;
        HSSFColor hSSFColor;
        if (color == null) {
            color = Color.WHITE;
        }
        if ((hSSFColor = (hSSFPalette = hSSFWorkbook.getCustomPalette()).findColor((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue())) == null || hSSFColor.getIndex() > this.colorIndex) {
            this.colorIndex = (short)(this.colorIndex + 1);
            hSSFPalette.setColorAtIndex(this.colorIndex, (byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
            hSSFColor = hSSFPalette.findColor((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        }
        return hSSFColor.getIndex();
    }

    private HSSFCellStyle createHSSFCellStyle(HSSFWorkbook hSSFWorkbook, Style style) {
        if (style == null) {
            if (this.defaultHSSFCellStyle == null) {
                this.defaultHSSFCellStyle = hSSFWorkbook.createCellStyle();
                this.executeHSSFCellStyle(hSSFWorkbook, this.defaultHSSFCellStyle, Style.DEFAULT_STYLE);
            }
            return this.defaultHSSFCellStyle;
        }
        style = this.adjustProperFontSize(style);
        HSSFCellStyle hSSFCellStyle = null;
        Enumeration enumeration = this.hssfCellStyleHash.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            if (!style.equals(k2)) continue;
            hSSFCellStyle = (HSSFCellStyle)this.hssfCellStyleHash.get(k2);
            break;
        }
        if (hSSFCellStyle == null) {
            hSSFCellStyle = hSSFWorkbook.createCellStyle();
            this.executeHSSFCellStyle(hSSFWorkbook, hSSFCellStyle, style);
            this.hssfCellStyleHash.put(style, hSSFCellStyle);
        }
        if (style.getHorizontalAlignment() == 4) {
            int n2 = style.getPaddingRight() <= 2 ? 0 : style.getPaddingRight() / 27;
            hSSFCellStyle.setIndention((short)n2);
        } else {
            int n3 = style.getPaddingLeft() <= 2 ? 0 : style.getPaddingLeft() / 27;
            hSSFCellStyle.setIndention((short)n3);
        }
        return hSSFCellStyle;
    }

    @Override
    protected short getRotation(Style style) {
        int n2 = style.getRotation();
        if (n2 > 90 || n2 < -90) {
            n2 = 0;
        }
        return (short)n2;
    }

    @Override
    protected POIFontAction createFont(POIWorkbookAction pOIWorkbookAction, java.awt.Font font) {
        return new HssfFontWrapper(this.createFont((HSSFWorkbook)pOIWorkbookAction.getWorkbook(), font));
    }

    private HSSFFont createFont(HSSFWorkbook hSSFWorkbook, java.awt.Font font) {
        if (font == null) {
            return null;
        }
        HSSFFont hSSFFont = this.createSimpleHSSFFont(hSSFWorkbook, new AbstractExcelExporter.JavaFontAdapter(font), font.getName());
        if (font instanceof FRFont) {
            FRFont fRFont = (FRFont)font;
            Color color = fRFont.getForeground();
            hSSFFont.setColor(this.getNearestColor(hSSFWorkbook, color));
            this.createComplexFont4FR(fRFont, new HssfFontWrapper(hSSFFont));
        }
        return hSSFFont;
    }

    private HSSFDataFormat getHSSFDataFormat(HSSFWorkbook hSSFWorkbook) {
        return this.format == null ? hSSFWorkbook.createDataFormat() : this.format;
    }

    @Override
    protected short getFormat(POIWorkbookAction pOIWorkbookAction, String string) {
        return this.getHSSFDataFormat((HSSFWorkbook)pOIWorkbookAction.getWorkbook()).getFormat(string);
    }

    private void applyBackgroundToGraphic2d(EscherGraphics2d escherGraphics2d, Background background) {
        if (background == null) {
            escherGraphics2d.setPaint(null);
        } else if (background instanceof ColorBackground) {
            ColorBackground colorBackground = (ColorBackground)background;
            escherGraphics2d.setPaint((Paint)colorBackground.getColor());
        } else {
            escherGraphics2d.setPaint((Paint)Color.white);
        }
    }

    private HSSFRichTextString html2HSSFRichTextString(HSSFWorkbook hSSFWorkbook, String string, Style style) throws Exception {
        Object object;
        if (StringUtils.isNotEmpty(string) && string.indexOf("<li>") != -1) {
            FRContext.getLogger().error(Inter.getLocText("NS_export_excelHtml"));
            return new HSSFRichTextString(this.splitAndFilterString(string));
        }
        string = this.convertPx2Pt(string);
        ArrayList arrayList = HTMLWorker.parseToList((Reader)new StringReader(string), (StyleSheet)new StyleSheet());
        ArrayList<Paragraph> arrayList2 = new ArrayList<Paragraph>();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Paragraph paragraph;
            if (arrayList.get(i2) instanceof Paragraph) {
                paragraph = (Paragraph)arrayList.get(i2);
                paragraph.getContent();
                object = paragraph.getChunks();
                arrayList2.addAll((Collection<Paragraph>)object);
                continue;
            }
            if (!(arrayList.get(i2) instanceof Chunk)) continue;
            paragraph = (Chunk)arrayList.get(i2);
            arrayList2.add(paragraph);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
            object = (Chunk)arrayList2.get(i3);
            stringBuffer.append(object.getContent());
        }
        HSSFRichTextString hSSFRichTextString = new HSSFRichTextString(stringBuffer.toString());
        int n2 = 0;
        int n3 = 0;
        for (int i4 = 0; i4 < arrayList2.size(); ++i4) {
            Chunk chunk = (Chunk)arrayList2.get(i4);
            Font font = chunk.getFont();
            HSSFFont hSSFFont = this.iTextFont2HSSFFont(hSSFWorkbook, font, chunk.getAttributes(), style);
            hSSFRichTextString.applyFont(n2, n3 += chunk.getContent().length(), hSSFFont);
            n2 = n3;
        }
        return hSSFRichTextString;
    }

    private String convertPx2Pt(String string) {
        try {
            int n2;
            while ((n2 = string.indexOf("px")) != -1) {
                double d2;
                int n3 = 0;
                for (int i2 = 0; i2 < 10 && ((n3 = n2 - i2) <= 0 || string.charAt(n3) != ' ' && string.charAt(n3) != ':'); ++i2) {
                }
                n3 = n3 == 0 ? n2 - 2 : n3;
                String string2 = string.substring(n3, n2).replaceAll(":", "").trim();
                try {
                    d2 = Double.parseDouble(string2);
                }
                catch (Exception exception) {
                    d2 = 0.0;
                }
                string = string.replaceAll(string2 + "px", d2 * 72.0 / 96.0 + "pt");
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return string;
    }

    private HSSFFont createSimpleHSSFFont(HSSFWorkbook hSSFWorkbook, AbstractExcelExporter.FontAdapter fontAdapter, String string) {
        return (HSSFFont)this.createSimpleFont(new HssfWorkbookWrapper(hSSFWorkbook), fontAdapter, new HssfFontWrapper(), string).getFont();
    }

    private HSSFFont iTextFont2HSSFFont(HSSFWorkbook hSSFWorkbook, Font font, Map map, Style style) {
        if (font == null) {
            return null;
        }
        HSSFFont hSSFFont = this.createSimpleHSSFFont(hSSFWorkbook, new AbstractExcelExporter.TextFontAdapter(font), style.getFRFont().getName());
        Color color = font.getColor();
        color = color != null ? color : style.getFRFont().getForeground();
        hSSFFont.setColor(this.getNearestColor(hSSFWorkbook, color));
        this.createComplexFont4Itext(font, map, new HssfFontWrapper(hSSFFont));
        return hSSFFont;
    }
}

