/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general.jsqlparser.util.deparser;

import com.fr.general.jsqlparser.expression.Expression;
import com.fr.general.jsqlparser.expression.ExpressionVisitor;
import com.fr.general.jsqlparser.schema.Column;
import com.fr.general.jsqlparser.schema.Table;
import com.fr.general.jsqlparser.statement.select.AllColumns;
import com.fr.general.jsqlparser.statement.select.AllTableColumns;
import com.fr.general.jsqlparser.statement.select.FromItem;
import com.fr.general.jsqlparser.statement.select.FromItemVisitor;
import com.fr.general.jsqlparser.statement.select.Join;
import com.fr.general.jsqlparser.statement.select.Limit;
import com.fr.general.jsqlparser.statement.select.OrderByElement;
import com.fr.general.jsqlparser.statement.select.OrderByVisitor;
import com.fr.general.jsqlparser.statement.select.PlainSelect;
import com.fr.general.jsqlparser.statement.select.SelectExpressionItem;
import com.fr.general.jsqlparser.statement.select.SelectItem;
import com.fr.general.jsqlparser.statement.select.SelectItemVisitor;
import com.fr.general.jsqlparser.statement.select.SelectVisitor;
import com.fr.general.jsqlparser.statement.select.SubJoin;
import com.fr.general.jsqlparser.statement.select.SubSelect;
import com.fr.general.jsqlparser.statement.select.Top;
import com.fr.general.jsqlparser.statement.select.Union;
import java.util.Iterator;
import java.util.List;

public class SelectDeParser
implements SelectVisitor,
OrderByVisitor,
SelectItemVisitor,
FromItemVisitor {
    protected StringBuffer buffer;
    protected ExpressionVisitor expressionVisitor;

    public SelectDeParser() {
    }

    public SelectDeParser(ExpressionVisitor expressionVisitor, StringBuffer stringBuffer) {
        this.buffer = stringBuffer;
        this.expressionVisitor = expressionVisitor;
    }

    public void visit(PlainSelect plainSelect) {
        Object object2;
        Iterator iterator;
        this.buffer.append("SELECT ");
        Top top = plainSelect.getTop();
        if (top != null) {
            top.toString();
        }
        if (plainSelect.getDistinct() != null) {
            this.buffer.append("DISTINCT ");
            if (plainSelect.getDistinct().getOnSelectItems() != null) {
                this.buffer.append("ON (");
                iterator = plainSelect.getDistinct().getOnSelectItems().iterator();
                while (iterator.hasNext()) {
                    object2 = (SelectItem)iterator.next();
                    object2.accept(this);
                    if (!iterator.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(") ");
            }
        }
        iterator = plainSelect.getSelectItems().iterator();
        while (iterator.hasNext()) {
            object2 = (SelectItem)iterator.next();
            object2.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(" ");
        if (plainSelect.getFromItem() != null) {
            this.buffer.append("FROM ");
            plainSelect.getFromItem().accept(this);
        }
        if (plainSelect.getJoins() != null) {
            for (Object object2 : plainSelect.getJoins()) {
                this.deparseJoin((Join)object2);
            }
        }
        if (plainSelect.getWhere() != null) {
            this.buffer.append(" WHERE ");
            plainSelect.getWhere().accept(this.expressionVisitor);
        }
        if (plainSelect.getGroupByColumnReferences() != null) {
            this.buffer.append(" GROUP BY ");
            iterator = plainSelect.getGroupByColumnReferences().iterator();
            while (iterator.hasNext()) {
                object2 = (Expression)iterator.next();
                object2.accept(this.expressionVisitor);
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
        if (plainSelect.getHaving() != null) {
            this.buffer.append(" HAVING ");
            plainSelect.getHaving().accept(this.expressionVisitor);
        }
        if (plainSelect.getOrderByElements() != null) {
            this.deparseOrderBy(plainSelect.getOrderByElements());
        }
        if (plainSelect.getLimit() != null) {
            this.deparseLimit(plainSelect.getLimit());
        }
    }

    public void visit(Union union) {
        Iterator iterator = union.getPlainSelects().iterator();
        while (iterator.hasNext()) {
            this.buffer.append("(");
            PlainSelect plainSelect = (PlainSelect)iterator.next();
            plainSelect.accept(this);
            this.buffer.append(")");
            if (!iterator.hasNext()) continue;
            this.buffer.append(" UNION ");
        }
        if (union.getOrderByElements() != null) {
            this.deparseOrderBy(union.getOrderByElements());
        }
        if (union.getLimit() != null) {
            this.deparseLimit(union.getLimit());
        }
    }

    public void visit(OrderByElement orderByElement) {
        orderByElement.getExpression().accept(this.expressionVisitor);
        if (orderByElement.isAsc()) {
            this.buffer.append(" ASC");
        } else {
            this.buffer.append(" DESC");
        }
    }

    public void visit(Column column) {
        this.buffer.append(column.getWholeColumnName());
    }

    public void visit(AllColumns allColumns) {
        this.buffer.append("*");
    }

    public void visit(AllTableColumns allTableColumns) {
        this.buffer.append(allTableColumns.getTable().getWholeTableName() + ".*");
    }

    public void visit(SelectExpressionItem selectExpressionItem) {
        selectExpressionItem.getExpression().accept(this.expressionVisitor);
        if (selectExpressionItem.getAlias() != null) {
            this.buffer.append(" AS " + selectExpressionItem.getAlias());
        }
    }

    public void visit(SubSelect subSelect) {
        this.buffer.append("(");
        subSelect.getSelectBody().accept(this);
        this.buffer.append(")");
    }

    public void visit(Table table) {
        this.buffer.append(table.getWholeTableName());
        String string = table.getAlias();
        if (string != null && string.length() != 0) {
            this.buffer.append(" AS " + string);
        }
    }

    public void deparseOrderBy(List list) {
        this.buffer.append(" ORDER BY ");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            OrderByElement orderByElement = (OrderByElement)iterator.next();
            orderByElement.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
    }

    public void deparseLimit(Limit limit) {
        this.buffer.append(" LIMIT ");
        if (limit.isRowCountJdbcParameter()) {
            this.buffer.append("?");
        } else if (limit.getRowCount() != 0L) {
            this.buffer.append(limit.getRowCount());
        } else {
            this.buffer.append("18446744073709551615");
        }
        if (limit.isOffsetJdbcParameter()) {
            this.buffer.append(" OFFSET ?");
        } else if (limit.getOffset() != 0L) {
            this.buffer.append(" OFFSET " + limit.getOffset());
        }
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer stringBuffer) {
        this.buffer = stringBuffer;
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    public void visit(SubJoin subJoin) {
        this.buffer.append("(");
        subJoin.getLeft().accept(this);
        this.buffer.append(" ");
        this.deparseJoin(subJoin.getJoin());
        this.buffer.append(")");
    }

    public void deparseJoin(Join join) {
        if (join.isSimple()) {
            this.buffer.append(", ");
        } else {
            if (join.isRight()) {
                this.buffer.append("RIGHT ");
            } else if (join.isNatural()) {
                this.buffer.append("NATURAL ");
            } else if (join.isFull()) {
                this.buffer.append("FULL ");
            } else if (join.isLeft()) {
                this.buffer.append("LEFT ");
            }
            if (join.isOuter()) {
                this.buffer.append("OUTER ");
            } else if (join.isInner()) {
                this.buffer.append("INNER ");
            }
            this.buffer.append("JOIN ");
        }
        FromItem fromItem = join.getRightItem();
        fromItem.accept(this);
        if (join.getOnExpression() != null) {
            this.buffer.append(" ON ");
            join.getOnExpression().accept(this.expressionVisitor);
        }
        if (join.getUsingColumns() != null) {
            this.buffer.append(" USING ( ");
            Iterator iterator = join.getUsingColumns().iterator();
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                this.buffer.append(column.getWholeColumnName());
                if (!iterator.hasNext()) continue;
                this.buffer.append(" ,");
            }
            this.buffer.append(")");
        }
    }
}

