/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.EnvProvider;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StringUtils;
import com.fr.stable.core.LocaleProvider;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;

public class Inter
implements LocaleProvider {
    private static Map<Locale, ResourceBundle> predefinedMap = new HashMap<Locale, ResourceBundle>();
    private static Map<Locale, ResourceBundle> customMap = new HashMap<Locale, ResourceBundle>();
    private static Map<Locale, Set<String>> keysMap = new HashMap<Locale, Set<String>>();

    private static void loadLanguage() {
        Inter.loadLanguageInProject(GeneralContext.getLocale());
    }

    private static void loadLanguageInProject(Locale locale) {
        if (predefinedMap.containsKey(locale)) {
            return;
        }
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com/fr/general/locale/fr", locale, Inter.class.getClassLoader());
            predefinedMap.put(locale, resourceBundle);
        }
        catch (Throwable throwable) {
            FRLogger.getLogger().error(throwable.getMessage(), throwable);
        }
    }

    private static void loadLanguageFromEnv() {
        Inter.loadLanguageFromEnv(GeneralContext.getLocale());
    }

    private static void loadLanguageFromEnv(Locale locale) {
        if (customMap.containsKey(locale)) {
            return;
        }
        EnvProvider envProvider = GeneralContext.getEnvProvider();
        if (envProvider == null) {
            return;
        }
        try {
            InputStream inputStream = envProvider.readBean("fr_" + locale.toString() + ".properties", "locale");
            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(inputStream);
            customMap.put(locale, propertyResourceBundle);
            HashSet<String> hashSet = new HashSet<String>();
            keysMap.put(locale, hashSet);
            Enumeration<String> enumeration = ((ResourceBundle)propertyResourceBundle).getKeys();
            while (enumeration.hasMoreElements()) {
                hashSet.add(enumeration.nextElement());
            }
        }
        catch (Exception exception) {
            customMap.put(locale, null);
        }
    }

    public static String getLocText(String string) {
        Locale locale = GeneralContext.getLocale();
        return Inter.getLocText(string, locale);
    }

    public static String getLocText(String[] stringArray) {
        return Inter.getLocText(stringArray, null);
    }

    public static String getLocText(String[] stringArray, String[] stringArray2) {
        String string = "";
        String string2 = Locale.US.equals(GeneralContext.getLocale()) ? " " : "";
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + (i2 == 0 ? "" : string2) + Inter.getLocText(stringArray[i2]);
            if (stringArray2 == null || stringArray2.length <= i2) continue;
            string = string + string2 + stringArray2[i2];
        }
        return string;
    }

    public static String getLocText(String string, Locale locale) {
        return Inter.getLocText(string, locale, Locale.SIMPLIFIED_CHINESE);
    }

    public static String getLocText(String string, Locale locale, Locale locale2) {
        Object object;
        if (GeneralContext.isShouldForceEnglish()) {
            locale = Locale.US;
        }
        if (locale == null) {
            locale = locale2;
        }
        if (StringUtils.isEmpty(locale.getCountry())) {
            object = locale.getLanguage();
            locale = "zh".equals(object) ? Locale.SIMPLIFIED_CHINESE : ("ja".equals(object) ? Locale.JAPAN : Locale.US);
        }
        if (!customMap.containsKey(locale)) {
            Inter.loadLanguageFromEnv(locale);
        }
        if (!predefinedMap.containsKey(locale)) {
            Inter.loadLanguageInProject(locale);
        }
        object = customMap.get(locale);
        Set<String> set = keysMap.get(locale);
        if (object != null && set.contains(string)) {
            return ((ResourceBundle)object).getString(string);
        }
        ResourceBundle resourceBundle = predefinedMap.get(locale);
        if (resourceBundle == null) {
            resourceBundle = predefinedMap.get(locale2);
        }
        return resourceBundle.getString(string);
    }

    static {
        Inter.loadLanguage();
        Inter.loadLanguageFromEnv();
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                Inter.loadLanguageFromEnv();
            }
        });
    }
}

