/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.core.FontProvider;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.InvalidObjectException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class FRFont
extends Font
implements FontProvider,
Cloneable {
    private static final long serialVersionUID = -4341538101804628719L;
    public static final String DEFAULT_FONTNAME = "SimSun";
    public static final int SCALE_TO_FRSIZE = 8;
    private static final double ADJUST = 1.0E-6;
    private static Map initializeFRFont = new WeakHashMap();
    private int frsize;
    private static Map ptToFrSizeMap = new WeakHashMap();
    private Color foreground = Color.black;
    private byte underline = 0;
    private boolean strikethrough = false;
    private boolean shadow = false;
    private boolean superscript = false;
    private boolean subscript = false;

    public static FRFont getInstance() {
        return FRFont.getInstance(DEFAULT_FONTNAME, 0, 9.0f);
    }

    public static FRFont getInstance(Font font) {
        return FRFont.getInstance(font.getName(), font.getStyle(), font.getSize());
    }

    public static FRFont getInstance(String string, int n2, float f2) {
        return FRFont.getInstance(string, n2, f2, Color.black, 0, false, false, false, false);
    }

    public static FRFont getInstanceFromFRSize(String string, int n2, int n3) {
        return FRFont.getFontInstance(string, n2, n3, Color.black, 0, false, false, false, false);
    }

    public static FRFont getInstance(String string, int n2, float f2, Color color) {
        return FRFont.getInstance(string, n2, f2, color, 0, false, false, false, false);
    }

    public static FRFont getInstance(String string, int n2, float f2, Color color, int n3) {
        return FRFont.getInstance(string, n2, f2, color, n3, false, false, false, false);
    }

    public static FRFont getInstance(String string, int n2, float f2, Color color, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n4 = FRFont.convertPtToFrSize(f2);
        return FRFont.getFontInstance(string, n2, n4, color, n3, bl, bl2, bl3, bl4);
    }

    private static int convertPtToFrSize(float f2) {
        return (int)((double)(f2 * 8.0f) + 1.0E-6);
    }

    private static FRFont getFontInstance(String string, int n2, int n3, Color color, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        FK fK = new FK(string, n2, n3 = n3 / 4 * 4, color, n4, bl, bl2, bl3, bl4);
        Object v2 = initializeFRFont.get(fK);
        if (v2 != null) {
            return (FRFont)v2;
        }
        FRFont fRFont = FRFont.createFRFont(string, n2, n3, color, n4, bl, bl2, bl3, bl4);
        initializeFRFont.put(fK, fRFont);
        return fRFont;
    }

    private static FRFont createFRFont(String string, int n2, int n3, Color color, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        float f2 = (float)(n3 * 10 / 8) / 10.0f;
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>(4);
        hashMap.put(TextAttribute.FAMILY, string);
        hashMap.put(TextAttribute.SIZE, new Float(f2));
        if ((n2 & 1) != 0) {
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if ((n2 & 2) != 0) {
            hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        return new FRFont(hashMap, n3, color, n4, bl, bl2, bl3, bl4);
    }

    private FRFont(Map map, int n2, Color color, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(map);
        this.frsize = n2;
        this.foreground = color;
        this.underline = (byte)n3;
        this.strikethrough = bl;
        this.shadow = bl2;
        this.superscript = bl3;
        this.subscript = bl4;
    }

    public int getFRSize() {
        return this.frsize;
    }

    public int getSize() {
        return this.size;
    }

    public int getShowSize(int n2) {
        return (int)((double)this.getShowSize2D(n2) + 0.5 + 1.0E-6);
    }

    private float getShowSize2D(int n2) {
        return (float)((int)((double)(this.pointSize * 10.0f) + 1.0E-6) * n2 / 72) / 10.0f;
    }

    public Font applyResolutionNP(int n2) {
        int n3 = FRFont.convertPtToFrSize(this.getShowSize(n2));
        return FRFont.createFRFont(this.name, this.style, n3, this.foreground, this.underline, this.strikethrough, this.shadow, this.superscript, this.subscript);
    }

    public static float convResolution(float f2, int n2) {
        return (float)((int)((double)(f2 * 10.0f) + 1.0E-6) * 72 / n2) / 10.0f;
    }

    public String getStyleName() {
        int n2 = this.getStyle();
        if (n2 == 1) {
            return Inter.getLocText("FRFont-bold");
        }
        if (n2 == 2) {
            return Inter.getLocText("FRFont-italic");
        }
        if (n2 == 3) {
            return Inter.getLocText("FRFont-bolditalic");
        }
        return Inter.getLocText("FRFont-plain");
    }

    public FRFont applyName(String string) {
        return FRFont.getInstance(string, this.style, this.pointSize, this.foreground, this.underline, this.strikethrough, this.shadow, this.superscript, this.subscript);
    }

    public FRFont applyStyle(int n2) {
        return FRFont.getInstance(this.name, n2, this.pointSize, this.foreground, this.underline, this.strikethrough, this.shadow, this.superscript, this.subscript);
    }

    public FRFont applySize(float f2) {
        return FRFont.getInstance(this.name, this.style, f2, this.foreground, this.underline, this.strikethrough, this.shadow, this.superscript, this.subscript);
    }

    public FRFont applyForeground(Color color) {
        return FRFont.getInstance(this.name, this.style, this.pointSize, color, this.underline, this.strikethrough, this.shadow, this.superscript, this.subscript);
    }

    public FRFont applyUnderline(int n2) {
        return FRFont.getInstance(this.name, this.style, this.pointSize, this.foreground, n2, this.strikethrough, this.shadow, this.superscript, this.subscript);
    }

    public FRFont applyStrikethrough(boolean bl) {
        return FRFont.getInstance(this.name, this.style, this.pointSize, this.foreground, this.underline, bl, this.shadow, this.superscript, this.subscript);
    }

    public FRFont applyShadow(boolean bl) {
        return FRFont.getInstance(this.name, this.style, this.pointSize, this.foreground, this.underline, this.strikethrough, bl, this.superscript, this.subscript);
    }

    public FRFont applySuperscript(boolean bl) {
        return FRFont.getInstance(this.name, this.style, this.pointSize, this.foreground, this.underline, this.strikethrough, this.shadow, bl, this.subscript);
    }

    public FRFont applySubscript(boolean bl) {
        return FRFont.getInstance(this.name, this.style, this.pointSize, this.foreground, this.underline, this.strikethrough, this.shadow, this.superscript, bl);
    }

    public Color getForeground() {
        return this.foreground;
    }

    public int getUnderline() {
        return this.underline;
    }

    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public boolean isSuperscript() {
        return this.superscript;
    }

    public boolean isSubscript() {
        return this.subscript;
    }

    public int hashCode() {
        int n2 = super.hashCode();
        if (this.foreground != null) {
            n2 += this.foreground.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof FRFont)) {
            return false;
        }
        FRFont fRFont = (FRFont)object;
        return super.equals(object) && ComparatorUtils.equals(fRFont.getForeground(), this.getForeground()) && fRFont.getUnderline() == this.getUnderline() && fRFont.isStrikethrough() == this.isStrikethrough() && fRFont.isShadow() == this.isShadow() && fRFont.isSuperscript() == this.isSuperscript() && fRFont.isSubscript() == this.isSubscript();
    }

    public Object clone() throws CloneNotSupportedException {
        return this;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("color", StableUtils.javaColorToCSSColor(this.getForeground()));
        jSONObject.put("size", (double)(this.getSize() * 4) / 3.0);
        jSONObject.put("fontName", this.getName());
        jSONObject.put("style", FRFont.fontStyle2JS(this.getStyle()));
        return jSONObject;
    }

    private static String fontStyle2JS(int n2) {
        String string = "";
        if (n2 == 0) {
            string = "";
        } else if (n2 == 1) {
            string = "bold";
        } else if (n2 == 2) {
            string = "italic";
        } else if (n2 == 3) {
            string = "bold italic";
        }
        return string;
    }

    protected Object readResolve() throws InvalidObjectException {
        if (this.getClass() != FRFont.class) {
            throw new InvalidObjectException("subclass didn't correctly implement readResolve");
        }
        FK fK = new FK(this);
        Object object = initializeFRFont.get(fK);
        if (object == null) {
            object = this;
            initializeFRFont.put(fK, object);
        }
        return object;
    }

    private static class FK {
        String name;
        int style;
        int frsize;
        Color foreground;
        int underline;
        boolean strikethrough;
        boolean shadow;
        boolean superscript;
        boolean subscript;

        FK(FRFont fRFont) {
            this(fRFont.name, fRFont.style, fRFont.frsize, fRFont.foreground, fRFont.underline, fRFont.strikethrough, fRFont.shadow, fRFont.superscript, fRFont.subscript);
        }

        FK(String string, int n2, int n3, Color color, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.name = string;
            this.style = n2;
            this.frsize = n3;
            this.foreground = color;
            this.underline = n4;
            this.strikethrough = bl;
            this.shadow = bl2;
            this.superscript = bl3;
            this.subscript = bl4;
        }

        public int hashCode() {
            return (this.name != null ? this.name.hashCode() : 0) ^ this.style ^ this.frsize ^ (this.foreground != null ? this.foreground.hashCode() : 0);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof FK)) {
                return false;
            }
            FK fK = (FK)object;
            if (this.name == null && fK.name != null || fK.name == null && this.name != null) {
                return false;
            }
            return this.name.equals(fK.name) && this.style == fK.style && this.frsize == fK.frsize && ComparatorUtils.equals(this.foreground, fK.foreground) && this.underline == fK.underline && this.strikethrough == fK.strikethrough && this.shadow == fK.shadow && this.superscript == fK.superscript && this.subscript == fK.subscript;
        }
    }
}

