/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.FRLogger;
import java.math.BigInteger;

public class Decrypt {
    private String originalPassword;
    private String pwd;

    public String getOriginalPassword() {
        return this.originalPassword;
    }

    public void setOriginalPassword(String string) {
        this.originalPassword = string;
    }

    public String getPwd() {
        return this.pwd;
    }

    public void setPwd(String string) {
        this.pwd = string;
    }

    public Decrypt(String string, String string2) {
        this.originalPassword = string;
        this.pwd = string2;
    }

    public static String decrypt(String string) {
        return Decrypt.decrypt(string, null);
    }

    public static String decrypt(String string, String string2) {
        int n2;
        if (string.equals("")) {
            return "";
        }
        if (string2 == null || string2.equals("")) {
            string2 = "655";
        }
        string2 = Decrypt.escape(string2);
        if (string == null || string.length() < 8) {
            FRLogger.getLogger().error("A salt value could not be extracted from the encrypted message because it's length is too short. The message cannot be decrypted.");
            return "";
        }
        if (string2 == null || string2.length() <= 0) {
            FRLogger.getLogger().error("Please enter a password with which to decrypt the message.");
            return "";
        }
        String string3 = "";
        for (n2 = 0; n2 < string2.length(); ++n2) {
            string3 = string3 + string2.charAt(n2);
        }
        n2 = (int)Math.floor(string3.length() / 5);
        String string4 = "" + string3.charAt(n2) + string3.charAt(n2 * 2) + string3.charAt(n2 * 3) + string3.charAt(n2 * 4);
        if (n2 * 5 < string3.length()) {
            string4 = string4 + string3.charAt(n2 * 5);
        }
        int n3 = (int)Math.round((double)string2.length() / 2.0);
        BigInteger bigInteger = new BigInteger((long)(Math.pow(2.0, 31.0) - 1.0) + "");
        int n4 = Integer.parseInt(string.substring(string.length() - 8, string.length()), 16);
        string = string.substring(0, string.length() - 8);
        string3 = string3 + n4;
        while (string3.length() > 10) {
            string3 = new BigInteger(string3.substring(0, 10)).add(new BigInteger(string3.substring(10, string3.length()))).toString();
        }
        string3 = new BigInteger(string4).multiply(new BigInteger(string3)).add(new BigInteger(n3 + "")).mod(bigInteger).toString();
        String string5 = "";
        String string6 = "";
        for (int i2 = 0; i2 < string.length(); i2 += 2) {
            string5 = "" + (Integer.parseInt(string.substring(i2, i2 + 2), 16) ^ (int)Math.floor(Double.parseDouble(string3) / bigInteger.doubleValue() * 255.0));
            char c2 = (char)Integer.parseInt(string5);
            string6 = string6 + c2;
            string3 = new BigInteger(string4).multiply(new BigInteger(string3)).add(new BigInteger(n3 + "")).mod(bigInteger).toString();
        }
        return Decrypt.unescape(string6);
    }

    private static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(string.length() * 6);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isDigit(c2) || Character.isLowerCase(c2) || Character.isUpperCase(c2)) {
                stringBuffer.append(c2);
                continue;
            }
            if (c2 < '\u0100') {
                stringBuffer.append("%");
                if (c2 < '\u0010') {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toString(c2, 16));
                continue;
            }
            stringBuffer.append("%u");
            stringBuffer.append(Integer.toString(c2, 16));
        }
        return stringBuffer.toString();
    }

    private static String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(string.length());
        int n2 = 0;
        int n3 = 0;
        while (n2 < string.length()) {
            n3 = string.indexOf("%", n2);
            if (n3 == n2) {
                char c2;
                if (string.charAt(n3 + 1) == 'u') {
                    c2 = (char)Integer.parseInt(string.substring(n3 + 2, n3 + 6), 16);
                    stringBuffer.append(c2);
                    n2 = n3 + 6;
                    continue;
                }
                c2 = (char)Integer.parseInt(string.substring(n3 + 1, n3 + 3), 16);
                stringBuffer.append(c2);
                n2 = n3 + 3;
                continue;
            }
            if (n3 == -1) {
                stringBuffer.append(string.substring(n2));
                n2 = string.length();
                continue;
            }
            stringBuffer.append(string.substring(n2, n3));
            n2 = n3;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println(Decrypt.decrypt("cbc51c8f29eb03b08675", "655"));
    }
}

